﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace NT2chView
{
    /// <summary>
    /// NTMoviePanel.xaml の相互作用ロジック
    /// </summary>
    public partial class NTMoviePanel : UserControl
    {

        public void NavigateYoutube(string id)
        {

            if (id == null || id.Length != 11)
                return;

            mEdtId.Text = id;
            mEdtCation.Text = "Untitled";

            showYoutube(id);
        }

        private void showYoutube(string id)
        {
            //Version v = mWebBrowser.Version;


             //StringBuilder sb = new StringBuilder();
             //sb.Append(
#if false
@"<!DOCTYPE html>
<html>
  <body>
    <!-- 1. The <iframe> (and video player) will replace this <div> tag. -->
    <div id=""player""></div>

    <script>
      // 2. This code loads the IFrame Player API code asynchronously.
      var tag = document.createElement('script');

      tag.src = ""https://www.youtube.com/iframe_api"";
      var firstScriptTag = document.getElementsByTagName('script')[0];
      firstScriptTag.parentNode.insertBefore(tag, firstScriptTag);

      // 3. This function creates an <iframe> (and YouTube player)
      //    after the API code downloads.
      var player;
      function onYouTubeIframeAPIReady() {
        player = new YT.Player('player', {
          height: 315,
          width: 420,
          videoId: 'M7lc1UVf-dVE',
          events: {
            onReady: onPlayerReady,
            onStateChange: onPlayerStateChange
          }
        });
      }

      // 4. The API will call this function when the video player is ready.
      function onPlayerReady(event) {
        event.target.playVideo();
      }

      // 5. The API calls this function when the player's state changes.
      //    The function indicates that when playing a video (state=1),
      //    the player should play for six seconds and then stop.
      var done = false;
      function onPlayerStateChange(event) {
        if (event.data == YT.PlayerState.PLAYING && !done) {
          setTimeout(stopVideo, 6000);
          done = true;
        }
      }
      function stopVideo() {
        player.stopVideo();
      }
    </script>
  </body>
</html>");

<iframe width="560" height="315" src="http://www.youtube.com/embed/28CHlz6DhJQ" frameborder="0" allowfullscreen></iframe>


"<!DOCTYPE html><html><head><meta charset=\"UTF-8\">" +
"<title>２ぃとちゃん on Web --- login --- </title>" +
"</head><body><iframe height=315 width=420 src=\"http://www.youtube.com/embed/");
             sb.Append(id);
             sb.Append(/*fxvsUEmKPFo*/

 "\"  frameborder=0 allowfullscreen>" +
 "</iframe></body></html>");
#endif
             //mWebBrowser.NavigateToString(sb.ToString());

            //mWebBrowser.DocumentText = sb.ToString();

            string url = "http://www.youtube.com/embed/" + id;
            mWebBrowser.Navigate(url);

        }

        public NTMoviePanel()
        {
            InitializeComponent();
        }

        public void Init()
        {
            NTMovieHistory.Load();
            mLstMovies.ItemsSource = NTMovieHistory.GetList();

        }

        private void btnAddYoutubeIdOnHistory_Click(object sender, RoutedEventArgs e)
        {
            string id = mEdtId.Text;
            string caption = mEdtCation.Text;
            if (id == null || id.Length != 11 ||
                caption == null || caption.Length == 0)
                return;

            NTMovie movie = new NTMovie(id);
            movie.Caption = caption;
            movie.LastAccessDate = DateTime.Now;
            NTMovieHistory.AddMovie(movie);
            NTMovieHistory.Save();

        }

        private void lstItem_MouseLeftButtonDown(object sender, MouseButtonEventArgs e)
        {
            TextBlock tb = sender as TextBlock;
            if (tb == null)
                return;
            NTMovie movie = tb.Tag as NTMovie;
            if (movie == null)
                return;

            movie.LastAccessDate = DateTime.Now;

            NTMovieHistory.AddMovie(movie);
            NTMovieHistory.Save();

            mEdtId.Text = movie.ID;
            mEdtCation.Text = movie.Caption;
            
            showYoutube(movie.ID);



        }
        private void lstItem_MouseRightButtonDown(object sender, MouseButtonEventArgs e)
        {

            //e.Handled = true;
        }
        private void lstItem_MouseRightButtonUp(object sender, MouseButtonEventArgs e)
        {
            TextBlock tb = sender as TextBlock;
            if (tb == null)
                return;
            NTMovie movie = tb.Tag as NTMovie;
            if (movie == null)
                return;

            NTMovieHistoryPopup popup = new NTMovieHistoryPopup(movie);
            popup.show();
            e.Handled = true;
        }
    }
}
