﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Controls;
using System.Windows.Controls.Primitives;
using System.Windows.Documents;
using System.Windows.Media;

namespace NT2chView
{
    class NTFavoriteThreadTagPopupMenu : Popup
    {
        public delegate void DelegateMsgOnNotifiDeleteFavoriteThreadTag(
            NTFavoriteThreadTag threadTag, bool delWithItem);
        public event DelegateMsgOnNotifiDeleteFavoriteThreadTag OnNotifiDeleteFavoriteThreadTag;
        public delegate void DelegateMsgOnNotifiChangeFavoriteThreadTagName(
            NTFavoriteThreadTag threadTag);
        public event DelegateMsgOnNotifiChangeFavoriteThreadTagName OnNotifiChangeFavoriteThreadTagName;

        NTFavoriteThreadTag mFavoriteThreadTag;

        public void show()
        {
            IsOpen = true;
            Placement = PlacementMode.Mouse;
            Focus();
        }

        public NTFavoriteThreadTagPopupMenu(NTFavoriteThreadTag tag)
            : base()
        {

            mFavoriteThreadTag = tag;
 
            this.StaysOpen = false;
            //this.MouseLeave += NTResPopupMenu_MouseLeave;
            //this.LostFocus += NTResPopupMenu_LostFocus;
            
            

            StackPanel sp = new StackPanel();
            sp.Orientation = Orientation.Horizontal;


            StackPanel panel = new StackPanel();
            Border border = new Border();
            border.BorderThickness = new System.Windows.Thickness(1);
            border.BorderBrush = new SolidColorBrush(Colors.DarkGray);
           

            ListBoxItem item1 = new ListBoxItem();

            sp = new StackPanel();
            //sp.MouseLeftButtonDown += threadTitle_MouseLeftButtonDown;
            sp.Children.Add(new TextBlock(new Run(tag.getTagName())));
            //sp.Tag = tt;
            item1.Content = sp;
            item1.Padding = new System.Windows.Thickness(10, 2, 10, 2);
            //item1.Tag = tt;
            //item1.MouseEnter += item1_MouseEnter;
            //item1.MouseLeave += item1_MouseLeave;
            panel.Children.Add(item1);

            sp = new StackPanel();
            sp.Children.Add(new Separator());
            item1 = new ListBoxItem();
            item1.BorderBrush = new SolidColorBrush(Colors.LightGray);
            item1.BorderThickness = new System.Windows.Thickness(1);
            item1.Height = 1;
            item1.Content = sp;
            panel.Children.Add(item1);
            panel.Background = new SolidColorBrush(Colors.White);


            sp = new StackPanel();
            sp.Children.Add(new TextBlock(new Run("フォルダーをアイテムごと削除")));
            sp.MouseLeftButtonDown += itemDeleteWithItem_MouseLeftButtonDown;
            sp.Tag = tag;
            item1 = new ListBoxItem();
            item1.Padding = new System.Windows.Thickness(10, 2, 10, 2);
            item1.Content = sp;
            panel.Children.Add(item1);

            sp = new StackPanel();
            sp.Children.Add(new TextBlock(new Run("フォルダーだけを削除")));
            sp.MouseLeftButtonDown += itemDeleteWithoutItem_MouseLeftButtonDown;
            sp.Tag = tag;
            item1 = new ListBoxItem();
            item1.Padding = new System.Windows.Thickness(10, 2, 10, 2);
            item1.Content = sp;
            panel.Children.Add(item1);

            sp = new StackPanel();
            sp.Children.Add(new TextBlock(new Run("名前の変更")));
            sp.MouseLeftButtonDown += itemChangeName_MouseLeftButtonDown;
            sp.Tag = tag;
            item1 = new ListBoxItem();
            item1.Padding = new System.Windows.Thickness(10, 2, 10, 2);
            item1.Content = sp;
            panel.Children.Add(item1);


            sp = new StackPanel();
            sp.Children.Add(new TextBlock(new Run("閉じる")));
            sp.MouseLeftButtonDown += itemClose_MouseLeftButtonDown;
            item1 = new ListBoxItem();
            item1.Padding = new System.Windows.Thickness(10, 2, 10, 2);
            item1.Content = sp;
            panel.Children.Add(item1);
            //this.Child = panel;
            border.Child = panel; 
            this.Child = border;

        }

        void itemDeleteWithItem_MouseLeftButtonDown(object sender, System.Windows.Input.MouseButtonEventArgs e)
        {
            IsOpen = false;

            if (OnNotifiDeleteFavoriteThreadTag != null)
            {
                OnNotifiDeleteFavoriteThreadTag(mFavoriteThreadTag, true);
            }
        }
        void itemDeleteWithoutItem_MouseLeftButtonDown(object sender, System.Windows.Input.MouseButtonEventArgs e)
        {
            IsOpen = false;

            if (OnNotifiDeleteFavoriteThreadTag != null)
            {
                OnNotifiDeleteFavoriteThreadTag(mFavoriteThreadTag, false);
            }
        }
        void itemChangeName_MouseLeftButtonDown(object sender, System.Windows.Input.MouseButtonEventArgs e)
        {
            IsOpen = false;

            NTFavoriteTagEditWindow wnd = new NTFavoriteTagEditWindow();
            wnd.setText(mFavoriteThreadTag.getTagName());
            bool? result = wnd.ShowDialog();
            if (!result.HasValue)
                return;
            if (!(bool)result)
                return;
            string newName = wnd.getText();
            if (newName == null || newName.Length == 0)
                return;

            mFavoriteThreadTag.setTagName(newName);
            if (OnNotifiChangeFavoriteThreadTagName != null)
            {
                OnNotifiChangeFavoriteThreadTagName(mFavoriteThreadTag);
            }
        }

        void itemClose_MouseLeftButtonDown(object sender, System.Windows.Input.MouseButtonEventArgs e)
        {
            IsOpen = false;
            //mMainWnd.NgEdit_setResSection(mRes);
        }

    }
}
