﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Media;
using System.Windows.Documents;

using NT2chView.NtNet;
using NT2chView.NtFile;
using NT2chView.NtHtml;
using System.Threading;
using System.Windows.Threading;
using System.Windows.Controls.Primitives;
using System.Diagnostics;
using System.Collections.ObjectModel;
using System.Windows.Media.Imaging;
using System.IO;
using System.Windows.Input;
using NT2chCtrl;
using NT2chObject;


namespace NT2chView
{
    public partial class MainWindow : Window
    {
        //List<string> mFavoriteBoardList = new List<string>();
        //List<string> mFavoriteThreadList = new List<string>();

        public void AddGraphic(string path)
        {
            tabCtrlMain.SelectedItem = tabItemGraphics;
            mGraphicsPanel.AddGraphic(path);
        }

        public void OpenMoviePanel(string id)
        {
            tabCtrlMain.SelectedItem = tabItemMovie;
            mMoviePanel.NavigateYoutube(id);

        }
        void constructNgTabItem(TabItem ti)
        {
            NTNgItems ngItem = NTNgItems.getContext();
            List<string> list;// = ngItem.getNgWords();
            int idx = cmbNgEditKind.SelectedIndex;
            switch (idx)
            {
                case 0://word
                    list = ngItem.getNgWords();
                    break;
                case 1: // name
                    list = ngItem.getNgNames();
                    break;
                case 2: // id
                    list = ngItem.getNgIds();
                    break;
                default:
                    return;
            }
    
            StringBuilder sb = new StringBuilder(64);
            foreach (string s in list)
                sb.Append(s).Append('\n');

            if(txtNgEdit != null)
                txtNgEdit.Text = sb.ToString();

        }

        /*void removeFavoriteThread(string description)
        {
            if (description.Trim().Length == 0)
                return;
            int len = mFavoriteThreadList.Count;
            int idx = 0;
            for (; idx < len; idx++)
            {
                if (mFavoriteThreadList[idx].Equals(description))
                    break;
            }
            if (idx == len)
                return;

            mFavoriteThreadList.RemoveAt(idx);
            

        }
        void removeFavoriteBoard(string description)
        {
            if (description.Trim().Length == 0)
                return;
            int len = mFavoriteBoardList.Count;
            int idx = 0;
            for (; idx < len; idx++)
            {
                if (mFavoriteBoardList[idx].Equals(description))
                    break;
            }
            if (idx == len)
                return;

            mFavoriteBoardList.RemoveAt(idx);

        }*/



        public void addFavoriteBoard(string description)
        {
            if (description.Trim().Length == 0)
                return;

            /*foreach (string s in mFavoriteBoardList)
                if (s.Equals(description))
                    return;

            //ListBoxItem item = new ListBoxItem();
            //item.Tag = description;
            //item.Content = description;
            mFavoriteBoardList.Add(description);*/
            //NTFileAccess.addFavoriteBoardToFile(description);
            NTFavoriteBoard fb = mFavoriteData.addBoardByDescription(description, false);
            mFavoritePanel.addBoard(fb);

        }

        public void addFavoriteThread(NTThreadTitle thread)
        {
            string description = thread.mDat + NTTextUtiles.YEN_VALUE[0]
                + thread.mBoard.mName + NTTextUtiles.YEN_VALUE[0]
                + thread.Title;

            if (description.Trim().Length == 0)
                return;

            string[] values = description.Split(NTTextUtiles.YEN_VALUE);
            if (values.Length < 3)
                return;

            NTFavoriteThread ft = mFavoriteData.addThreadByDescription(description, false, true);
            if(ft == null)
                return;

            mFavoritePanel.addThread(ft);


            /*foreach (string s in mFavoriteThreadList)
                if (s.Equals(description))
                    return;

            mFavoriteThreadList.Add(description);*/

        }


        public void removeFavoriteThread(NTThreadTitle thread)
        {
            string description = thread.mDat + NTTextUtiles.YEN_VALUE[0]
                + thread.mBoard.mName + NTTextUtiles.YEN_VALUE[0]
                + thread.Title;

            if (description.Trim().Length == 0)
                return;

            string[] values = description.Split(NTTextUtiles.YEN_VALUE);
            if (values.Length < 3)
                return;

            int idx = mFavoriteData.findThread(thread.getBoard().getName(), thread.getDatName(), thread.getTitle());
            if (idx < 0)
                return;

            NTFavoriteThread ft = mFavoriteData.getThreadList()[idx];
            if (ft == null)
                return;

            mFavoritePanel.removeThread(ft);


            if (!mFavoriteData.removeThreadByDescription(description, true))
                return;

            /*foreach (string s in mFavoriteThreadList)
                if (s.Equals(description))
                    return;

            mFavoriteThreadList.Remove(description);*/

        }

        public void appendBoardToExternalCategoryTree(NTBoard board)
        {
            NTCategory exCate = NTDataRoot.getExternalBoards();
            mCategoryPanel.addExternalCategory(exCate);
            if (mCategoryPanel.isExternalCategorySelected())
            {
                mBoardPanel.BoardTable = exCate.mBoardList;
            }

        }

        public void removeBoardFromExternalCategoryTree(string boardName)
        {
            if (mCategoryPanel.isExternalCategorySelected())
            {
                NTCategory exCate = NTDataRoot.getExternalBoards();
                mBoardPanel.BoardTable = exCate.mBoardList;
            }


        }

        //static readonly string[] LIST_COLUMN_HEADERS =
       // { " No.　", "スレッドタイトル", "レス数 ", " 既読 "," 未読 ", "最終取得日", "最終書込日" };
       // static readonly string[] LIST_COLUMN_HEADERS_PNAME = 
       // { "SeqNo", "Title", "ResCnt", "ReadCnt", "RemainCnt","LastMod", "LastWrite" };
#if false    
        TabItem  constructResViewTabItem(NTThreadTitle thread)
        {
            int idx;
            if (0 <= (idx = searchThreadFromTabItems(thread)))
            {
                return tabCtrlDat.Items[idx] as TabItem;
            }

            StackPanel sp = new StackPanel();
            sp.Orientation = Orientation.Horizontal;
            sp.MaxWidth = 250;
            sp.Tag = thread;
            sp.Margin = new Thickness(0);
            ContextMenu cm = new System.Windows.Controls.ContextMenu();
            sp.ContextMenu = cm;
            setThreadTabHeaderContextMenu(thread, sp.ContextMenu);

            
            sp.MouseLeftButtonDown += new System.Windows.Input.MouseButtonEventHandler(threadTab_MouseLeftButtonDown);
            sp.MouseEnter += sp_MouseEnter;
            sp.MouseLeave += sp_MouseLeave;
            TextBlock tb = new TextBlock();
            string title = thread.Title.Trim();
            if (title.Length > 20)
                tb.Text = title.Substring(0, 20);
            else
                tb.Text = title;

            tb.Tag = tb.Text;

            tb.ContextMenu = cm;
            sp.Children.Add(tb);
            tb = new TextBlock();
            tb.Text = "×";
            tb.VerticalAlignment = System.Windows.VerticalAlignment.Center;
            tb.FontSize = 8;
            Button btn = new Button();
            btn.Content = tb;
            btn.Tag = thread;
            btn.Click += new RoutedEventHandler(btnDatTabItemClose_Click);
            //btn.MouseEnter += btn_MouseEnter;

            
            sp.Children.Add(btn);
            btn.Width = 0;
            btn.Height = 0;

            TabItem tabItem = new TabItem();
            tabItem.Header = sp;
            tabItem.Tag = thread;

            tabItem.GotFocus += new RoutedEventHandler(tabItem_GotFocus);
            tabCtrlDat.Items.Add(tabItem);

            return tabItem;
        }
#endif
        void sp_MouseLeave(object sender, System.Windows.Input.MouseEventArgs e)
        {
            StackPanel sp = sender as StackPanel;
            if (sp == null)
                return;
            if (sp.Children.Count < 2)
                return;
            TextBlock tb = sp.Children[0] as TextBlock;
            if (tb == null)
                return;
            Button btn = sp.Children[1] as Button;
            if (null == btn)
                return;

            string s = tb.Tag as string;
            if (s != null)
            {
                //if (s.Length > 20)
                //    s.Substring(0, 20);
                 tb.Text = s;
            }

            btn.Width = 0;
            btn.Height = 0;
        }

        void sp_MouseEnter(object sender, System.Windows.Input.MouseEventArgs e)
        {
            StackPanel sp = sender as StackPanel;
            if (sp == null)
                return;
            if(sp.Children.Count < 2)
                return;
            TextBlock tb = sp.Children[0] as TextBlock;
            if (tb == null)
                return;
            Button btn = sp.Children[1] as Button;
            if (null == btn)
                return;

            string s = tb.Tag as string;
            if (s != null)
            {
                //if (s.Length > 20)
               //     s.Substring(0, 20);

                int len = s.Length;
                //len = (len < 4) ? 2 : len - 1;
                s = s.Substring(0, --len);
                tb.Text = s;

            }

            btn.Width = 12;
            btn.Height = 12;
        }

       /* void btn_MouseEnter(object sender, System.Windows.Input.MouseEventArgs e)
        {
            Button btn = sender as Button;
            if (btn == null)
                return;

            ContextMenu cm = btn.ContextMenu;
            if (null == cm)
                return;

            //throw new NotImplementedException();
        }*/

        DateTime mMouseMovetime = DateTime.Now;

        void document_MouseMove(object sender, MouseEventArgs e)
        {
            //NTDebug.l("+++ AAA +++");
            DateTime dt = DateTime.Now;
            TimeSpan ts = dt.Subtract(mMouseMovetime);
            if(2 < ((int)(ts.TotalSeconds))){
                //NTDebug.l("+++ BBB +++");
                mMouseMovetime = DateTime.Now;
            }
            //throw new NotImplementedException();
        }

        void UpdateThread(NTThreadTitle thread)
        {
            NTBoard board = thread.mBoard;
            //int oldReadCnt = thread.mResCnt;

            if (board.mMachiBBS)
            {
                //updateResViewTabItemMachiBBS(thread);
                return;
            }

            //int idx;
            //if (0 > (idx = searchThreadFromTabItems(thread)))
            //{
            //    return;
            //}



            thread.mPrevReadCnt = thread.ReadCnt;


            if (!NTHttpAccess.getDat(board.mAddress, board.mName, thread.mDat, thread.Title))
            {
                NTDebug.l("getting the dat data failed.");
                return;
            }

            string strDat = NTFileAccess.retrieveDatFromFile(board.mName, thread.mDat);
            if (null == strDat)
            {
                return;
            }


            thread.parseDat(strDat);
            thread.updateReadCntOnCloud();

            int numRead;// = thread.ReadCnt;
            int[] writes;
            int[] bookmarkes;
            string lastWrite;
            NTFileAccess.retrieveDatAttrToFile(board.mName, thread.mDat,
                out numRead, out writes, out bookmarkes, out lastWrite);


            if (thread.ReadCnt > thread.mPrevReadCnt)
            {
                int wroteNo = thread.findWroteMsg(thread.mPrevReadCnt + 1);
                if (wroteNo >= 0)
                {
                    thread.addWriteTag(wroteNo);
                    thread.addBookmark(wroteNo);
                    writes = thread.mWriteNoList.ToArray();
                    bookmarkes = thread.mBookmarkList.ToArray();
                    NTRes res = thread.findRes(wroteNo);
                    if (res != null)
                    {
                        res.mWroteMsg = true;
                        res.mBookmark = true;
                    }

                }
            }


            NTFileAccess.storeDatAttrToFile(board.mName, thread.mDat, thread.ResCnt, writes, bookmarkes);
            thread.LastMod = DateTime.Now.ToString();


            /*bool readNew;
            if (numRead > 0 && thread.mPrevReadCnt == numRead)
                readNew = false;
            else
                readNew = true;*/


            thread.mPrevReadCnt = numRead;

            mResPanel.OpenThread(thread);

            if (numRead < thread.ResCnt)
            {
                Thread th = new Thread(ResTabUpdate);
                th.Start();
            }

            mFavoritePanel.OnNotifyBoardUpdate(board);


        }
        public void ResTabUpdate()
        {
            Thread.Sleep(1000);

            this.Dispatcher.BeginInvoke(DispatcherPriority.Normal,
                (ThreadStart)delegate()
            {
                mResPanel.JumpToNew();
                IThread ithread = mResPanel.getCurrentThread();
                NTThreadTitle thread = ithread as NTThreadTitle;
                if (thread != null)
                {
                    thread.mPrevReadCnt = thread.ReadCnt;
                    NTBoard board = thread.mBoard;
                    if(board != null)
                        mFavoritePanel.OnNotifyBoardUpdate(board);

                }

            });


        }

        public void NgEdit_setResSection(NTRes res)
        {
            tabItemNgEdit.IsSelected = true;

            string name = res.mName;
            string id = res.mId;
            string msg = res.mMsg;

            txtNgNameEdit.Text = name;
            txtNgIdEdit.Text = id;
            txtNgWordEdit.Text = NTTextFormat.removeTag(msg);// parseResMsgForNgWord(msg);

        }
        void lv_MouseRightButtonDown(object sender, System.Windows.Input.MouseButtonEventArgs e)
        {
            NTDebug.l("R-Button Down on LIstView.");
            //throw new NotImplementedException();
        }


        void SubjectListHeader_MouseLeftButtonDown(object sender, System.Windows.Input.MouseButtonEventArgs e)
        {
            TextBlock tb = sender as TextBlock;
            if (tb == null)
                return;

            ListView lv = tb.Tag as ListView;
            if (lv == null)
                return;

            NTBoard board = lv.Tag as NTBoard;
            if (board == null)
                return;

            ObservableCollection<NTThreadTitle> list = lv.ItemsSource as ObservableCollection<NTThreadTitle>;
            if (list == null)
                return;

            List<NTThreadTitle> sortList = new List<NTThreadTitle>();
            foreach (NTThreadTitle tt in list)
                sortList.Add(tt);


            list.Clear();

            //board.mThreadListSortStack;
            foreach (string s in board.mThreadListSortStack)
            {
                if (s.Equals(tb.Text))
                {
                    board.mThreadListSortStack.Remove(s);
                    break;
                }
            }
            //board.mThreadListSortStack.Add(tb.Text);

            //foreach (string s in board.mThreadListSortStack)
            //{

                switch (tb.Text)
                {
                    case " No.　":
                        sortList.Sort(SubjectListSortBySeqNo);
                        break;
                    case "スレッドタイトル":
                        sortList.Sort(SubjectListSortByTitle);
                        break;
                    case "レス数 ":
                        sortList.Sort(SubjectListSortByResCnt);
                        break;
                    case " 既読 ":
                        sortList.Sort(SubjectListSortByReadCnt);
                        break;
                    case " 未読 ":
                        sortList.Sort(SubjectListSortByRemainCnt);
                        break;
                    case "最終取得日":
                        sortList.Sort(SubjectListSortByLastMod);
                        break;
                    case "最終書込日":
                        sortList.Sort(SubjectListSortByLastWrite);
                        break;
                }
            //}

            foreach (NTThreadTitle tt in sortList)
                list.Add(tt);
        }

        static int SubjectListSortBySeqNo(NTThreadTitle thread1, NTThreadTitle thread2)
        {
            return thread1.SeqNo - thread2.SeqNo;
        }

        static int SubjectListSortByTitle(NTThreadTitle thread1, NTThreadTitle thread2)
        {
            return thread2.Title.CompareTo(thread1.Title);
        }
        static int SubjectListSortByResCnt(NTThreadTitle thread1, NTThreadTitle thread2)
        {
            return thread2.ResCnt - thread1.ResCnt;
        }
        static int SubjectListSortByReadCnt(NTThreadTitle thread1, NTThreadTitle thread2)
        {
            return thread2.ReadCnt - thread1.ReadCnt;
         }
        static int SubjectListSortByRemainCnt(NTThreadTitle thread1, NTThreadTitle thread2)
        {
            return thread2.RemainCnt - thread1.RemainCnt;
        }
        static int SubjectListSortByLastMod(NTThreadTitle thread1, NTThreadTitle thread2)
        {
            DateTime dt1 = DateTime.MinValue;
            DateTime dt2 = DateTime.MinValue;
            try
            {
                dt1 = DateTime.Parse(thread1.LastMod);
            }
            catch { }
            try
            {
                dt2 = DateTime.Parse(thread2.LastMod);
            }
            catch { }

            return dt2.CompareTo(dt1);
        }

        static int SubjectListSortByLastWrite(NTThreadTitle thread1, NTThreadTitle thread2)
        {
            DateTime dt1 = DateTime.MinValue;
            DateTime dt2 = DateTime.MinValue;
            try
            {
                dt1 = DateTime.Parse(thread1.LastWrite);
            }
            catch { }
            try
            {
                dt2 = DateTime.Parse(thread2.LastWrite);
            }
            catch { }

            return dt2.CompareTo(dt1);
        }



        void lv_SelectionChanged(object sender, SelectionChangedEventArgs e)
        {
            //NTDebug.l("TEST");
            ListView lv;
            //lv.SelectionMode = SelectionMode.Single;
            //lv.
            if (!(sender is ListView))
                return;

            lv = (ListView)sender;
            object o = lv.SelectedItem;
            if (!(o is NTThreadTitle))
                return;

            NTThreadTitle tt = (NTThreadTitle)o;

            OpenNewThread(tt);
        }


        public bool OpenNewBoard(NTBoard board)
        {
            string strSubject = null;
            if (!board.mDataInit)
            {

                if (!NTFileAccess.isSubjectExsists(board.mName))
                    if (!NTHttpAccess.getSubject(board.mAddress, board.mName))
                        return false;

                strSubject = NTFileAccess.retrieveSubjectDataFromFile(board.mName);
                if (strSubject == null)
                    return false;

                if (!board.parseSubjectData(strSubject, mFavoriteData))
                    return false;
            }
            return true;
        }

        public void OpenNewThread(NTThreadTitle thread)
        {
            if (thread == null)
                return;

            bool bRet = false;
            string strDat;
            string strDatName = thread.mDat;

            NTBoard board = thread.mBoard;

            if (board.mMachiBBS)
            {
                bRet = NTHttpAccess.getMachiBBSDat(board.mAddress, board.mName, thread.mDat, thread.Title);
                strDatName = NTHttpUtils.ridSuffixFromCgiName(thread.mDat);
                strDat = NTFileAccess.retrieveDatFromFile(board.mName, strDatName);
                if (null == strDat)
                    return;
            }
            else
            {
                if (!thread.mLocalDat)
                {
                    bRet = NTHttpAccess.getDat(board.mAddress, board.mName, thread.mDat, thread.Title);
                }
                else if (NTUserPreference.MaruIsEnabled)
                {
                    string sid = NTMaru.getSessionId();
                    bRet = NTHttpAccess.getDatFromKako(board.mAddress, board.mName,
                        thread.mDat, thread.Title, sid);
                }
                strDat = NTFileAccess.retrieveDatFromFile(board.mName, thread.mDat);
                if (null == strDat)
                    return;
            }

            if (thread.Title.Length == 0)
            {
                string strTitle = NTFileAccess.retrieveTitleFromDat(strDat);
                if (strTitle != null)
                {
                    thread.Title = strTitle;
                    NTFileAccess.storeDatTitle(board.mName, strDatName/*thread.mDat*/, strTitle);
                }
            }
            bool cloudData = false;
            if (NTUserPreference.NTCloudIsEnabled)
            {
                string strThreadAttr ;
                if (NTUserPreference.NTUserCloudIsEnabled)
                {
                    strThreadAttr = NTHttpAccess.UserCloudQueryAttrValue(board.mName, thread.mDat);
                }
                else
                {
                    strThreadAttr = NTHttpAccess.ntQueryAttrValue(board.mName, thread.mDat);
                }
                if (strThreadAttr != null)
                {
                    cloudData = true;
                    thread.parseAttr(strThreadAttr);
                }
            }


            thread.mPrevReadCnt = thread.ReadCnt;

            thread.parseDat(strDat);


            if (bRet)
                thread.updateReadCntOnCloud();

            int numRead = -1;
            int[] writes;
            int[] bookmarkes;
            string lastWrite;
            NTFileAccess.retrieveDatAttrToFile(board.mName, strDatName,//thread.mDat,
                out numRead, out writes, out bookmarkes, out lastWrite);
            if (cloudData)
            {
                writes = thread.mWriteNoList.ToArray();
                bookmarkes = thread.mBookmarkList.ToArray();
            }
            else
            {
                thread.mWriteNoList.Clear();
                thread.mWriteNoList.AddRange(writes);
                thread.mBookmarkList.Clear();
                thread.mBookmarkList.AddRange(bookmarkes);

            }
            thread.setupBookmark();
            thread.setupWriteTag();
            if (numRead < thread.ResCnt || cloudData)
            {
                NTFileAccess.storeDatAttrToFile(board.mName, strDatName/*thread.mDat*/, thread.ResCnt, writes, bookmarkes);
                thread.LastMod = DateTime.Now.ToString();
            }
            else
            {
                thread.LastMod = lastWrite;
            }
            thread.mPrevReadCnt = (thread.mPrevReadCnt < numRead) ? numRead : thread.mPrevReadCnt;

            
            mResPanel.OpenThread(thread);

            if (numRead < thread.ResCnt)
            {
                Thread th = new Thread(ResTabUpdate);
                th.Start();
            }

#if false
            TabItem item = constructResViewTabItem(tt/*, true*/);
            if (item != null)
            {
                if (item.Content == null || tt.ResCnt > tt.ReadCnt)
                {
                    string savedTitle = tt.Title;
                    constructResContent(item);
                    if (savedTitle.Length == 0 && tt.Title.Length > 0)
                    {
                        StackPanel sp = item.Header as StackPanel;
                        if (sp != null)
                        {
                            if(sp.Children.Count > 0)
                            {
                                TextBlock tb = sp.Children[0] as TextBlock;
                                if (tb != null)
                                {
                                    if (tt.Title.Length > 20)
                                        tb.Text = tt.Title.Substring(0, 20);
                                    else
                                        tb.Text = tt.Title;
                                    tb.Tag = tb.Text;
                                }
                            }
                        }
                    }
                }
                tabCtrlDat.SelectedItem = item;
            }
 #endif
        }

       
#if false
        void UpdateBoardTabItem(NTBoard board)
        {

            int idx;
            if (0 > (idx = searchBoardFromTabItemIndex(board)))
            {
                MessageBox.Show("開かれた板が見つかりません。");
                return;
            }
            
            TabItem ti = (TabItem)tabCtrlSubject.Items[idx];

            constructBoardTabItemContent(board, ti);

            //ti.Tag = board;



        }
#endif
#if false
        void constructBoardTabItem(NTBoard board /*, bool fromWeb*/)
        {
            int idx;
            if (0 <= (idx = searchBoardFromTabItemIndex(board)))
            {
                tabCtrlSubject.SelectedIndex = idx;
                return;
            }
            /*if (fromWeb)
            {
                if (!NTHttpAccess.getSubject(board.mAddress, board.mName))
                    return;
            }
            
            string strSubject = NTFileAccess.retrieveSubjectDataFromFile(board.mName);

            if (null == strSubject)
                return;
            
            if (!board.parseSubjectData(strSubject))
                return;
            */

            TabItem tabItem = new TabItem();
            StackPanel sp = new StackPanel();
            sp.Orientation = Orientation.Horizontal;
            sp.MaxWidth = 200;
            ContextMenu cm = new System.Windows.Controls.ContextMenu();
            sp.ContextMenu = cm;
            setBoardTabHeaderContextMenu(board, cm);
            sp.MouseLeftButtonDown += new System.Windows.Input.MouseButtonEventHandler(boardTab_MouseLeftButtonDown);
            //sp.MouseLeftButtonUp += new System.Windows.Input.MouseButtonEventHandler(sp_MouseLeftButtonUp);
            sp.MouseEnter +=sp_MouseEnter;
            sp.MouseLeave +=sp_MouseLeave;
            sp.Tag = board;
            sp.Margin = new Thickness(0);

            TextBlock tb = new TextBlock();
            string boardName = board.mName;
            if(boardName.Length < 3)
                boardName = " " + boardName + " ";
            else if(boardName.Length == 3)
                boardName = boardName + " ";
            tb.Text = boardName;
            tb.Tag = boardName;
            sp.Children.Add(tb);
            tb = new TextBlock();
            tb.Text = "×";
            tb.VerticalAlignment = System.Windows.VerticalAlignment.Center;
            tb.FontSize = 8;
            tb.Tag = board;
            Button btn = new Button();
            btn.Content = tb;
            btn.Tag = board;
            btn.Width = 0;
            btn.Height = 0;
            btn.Click += new RoutedEventHandler(btnSubjectTabItemClose_Click);
            sp.Children.Add(btn);

            tabItem.Header = sp;
            tabItem.Tag = board;
            tabCtrlSubject.Items.Add(tabItem);
            tabCtrlSubject.SelectionChanged += tabCtrlSubject_SelectionChanged;
        }
#endif
        //NTThreadTitle mSelectedThreadTitle = null;
        //NTBoard mSelectedBoard = null;

#if false
        private int mDoubleCickTime = System.Windows.Forms.SystemInformation.DoubleClickTime;
        private int mFirstClickTime = 0;
        void boardTab_MouseLeftButtonDown(object sender, System.Windows.Input.MouseButtonEventArgs e)
        {
            NTDebug.l("Enterinf MouseDown");

            if (mSelectedBoard == null)
            {
                if (sender is StackPanel)
                {
                    StackPanel sp = (StackPanel)sender;
                    if (sp.Tag is NTBoard)
                    {
                        mSelectedBoard = (NTBoard)sp.Tag;
                        DateTime dt = DateTime.Now;
                        mFirstClickTime = dt.Second*1000 + dt.Millisecond;
                    }
                }
            }
            else
            {
                DateTime dt = DateTime.Now;
                int clickTime =  dt.Second*1000 + dt.Millisecond;
                clickTime -= mFirstClickTime;
                if (clickTime <= mDoubleCickTime)
                {
                    if (sender is StackPanel)
                    {
                        StackPanel sp = (StackPanel)sender;
                        if (sp.Tag is NTBoard)
                        {
                            if (mSelectedBoard.Equals(sp.Tag))
                            {
                                NTDebug.l("Dbl Clicked!");
                                UpdateBoardTabItem(mSelectedBoard);
                            }
                        }
                    }
                    mSelectedBoard = null;
                    mFirstClickTime = 0;
                }
                else
                {
                    if (sender is StackPanel)
                    {
                        StackPanel sp = (StackPanel)sender;
                        if (sp.Tag is NTBoard)
                        {
                            mSelectedBoard = (NTBoard)sp.Tag;
                            mFirstClickTime = dt.Second * 1000 + dt.Millisecond;
                        }
                    }
                }
            }
        }

        void threadTab_MouseLeftButtonDown(object sender, System.Windows.Input.MouseButtonEventArgs e)
        {
            NTDebug.l("Entering MouseDown");
            if (mSelectedThreadTitle == null)
            {
                if (sender is StackPanel)
                {
                    StackPanel sp = (StackPanel)sender;
                    if (sp.Tag is NTThreadTitle)
                    {
                        mSelectedThreadTitle = (NTThreadTitle)sp.Tag;
                        DateTime dt = DateTime.Now;
                        mFirstClickTime = dt.Second * 1000 + dt.Millisecond;
                    }
                }
            }
            else
            {
                DateTime dt = DateTime.Now;
                int clickTime = dt.Second * 1000 + dt.Millisecond;
                clickTime -= mFirstClickTime;
                if (clickTime <= mDoubleCickTime)
                {
                    if (sender is StackPanel)
                    {
                        StackPanel sp = (StackPanel)sender;
                        if (sp.Tag is NTThreadTitle)
                        {
                            if (mSelectedThreadTitle.Equals(sp.Tag))
                            {
                                NTDebug.l("Dbl Clicked!");
                                //UpdateBoardTabItem(mSelectedBoard);
                                //updateResViewTabItem(mSelectedThreadTitle);
                            }
                        }
                    }
                    mSelectedThreadTitle = null;
                    mFirstClickTime = 0;
                }
                else
                {
                    if (sender is StackPanel)
                    {
                        StackPanel sp = (StackPanel)sender;
                        if (sp.Tag is NTThreadTitle)
                        {
                            mSelectedThreadTitle = (NTThreadTitle)sp.Tag;
                            mFirstClickTime = dt.Second * 1000 + dt.Millisecond;
                        }
                    }
                }
            }
        }

        public NTThreadTitle findSelectedThreadTitle()
        {
            object o = tabCtrlDat.SelectedItem;
            TabItem item = o as TabItem;
            if(item == null)
                return null;

            NTDebug.l(item.Header.ToString());
            object o2 = item.Tag;
            NTThreadTitle thread = o2 as NTThreadTitle;
            return thread;

        }
#endif


        void storeOpenedBoardList()
        {
            List<IBoard> boardList = mSubjectPanel.QueryOpenedBoardList();
            if (boardList == null)
                return;
            int cnt = boardList.Count;
            string[] list = new string[cnt];
            for (int i = 0; i < cnt; i++)
            {
                list[i] = boardList[i].getName();
            }
            
            /*int cnt = tabCtrlSubject.Items.Count;
            string[] list = new string[cnt];
            for (int i = 0; i < cnt; i++)
            {
                object o = tabCtrlSubject.Items[i];

                if (!(o is TabItem))
                    return;
                if (!((((TabItem)o).Tag) is NTBoard))
                    return;

                NTBoard b = (NTBoard)(((TabItem)o).Tag);
                list[i] = b.mName;

            }*/
            NTPersistentFileAccess.storeOpenedBoards(list);

        }
#if false
        void storeOpenedThreadList()
        {

            int cnt = tabCtrlDat.Items.Count;
            string[] list = new string[cnt];
            for (int i = 0; i < cnt; i++)
            {
                object o = tabCtrlDat.Items[i];

                if (!(o is TabItem))
                    return;
                if (!((((TabItem)o).Tag) is NTThreadTitle))
                    return;

                NTThreadTitle tt = (NTThreadTitle)(((TabItem)o).Tag);
                list[i] =tt.mDat + "," + tt.mBoard.mName;

            }
            NTPersistentFileAccess.storeOpenedThreads(list);

        }


        int searchBoardFromTabItemIndex(NTBoard board)
        {
            for (int i = 0; i < tabCtrlSubject.Items.Count; i++)
            {
                object o = tabCtrlSubject.Items[i];

                if (!(o is TabItem))
                    continue;
                if (!((((TabItem)o).Tag) is NTBoard))
                    continue;

                NTBoard b = (NTBoard)(((TabItem)o).Tag);

                if (board.mName.Equals(b.mName))
                    return i;
            }
            return -1;
        }

        int searchTabItemIndexFromTabCtrl(TabControl ctrl, TabItem item)
        {
            for (int i = 0; i < ctrl.Items.Count; i++)
            {
                if (item.Equals(tabCtrlDat.Items[i]))
                    return i;
            }
            return -1;
        }

        TabItem searchBoardFromTabItem(NTBoard board)
        {
            int idex = searchBoardFromTabItemIndex(board);
            if (idex < 0)
                return null;

            return  tabCtrlSubject.Items[idex] as TabItem;
        }
#endif

        int searchThreadFromTabItems(NTThreadTitle thread)
        {
#if false
            for (int i = 0; i < tabCtrlDat.Items.Count; i++)
            {
                object o = tabCtrlDat.Items[i];

                if (!(o is TabItem))
                    continue;
                if (!((((TabItem)o).Tag) is NTThreadTitle))
                    continue;

                NTThreadTitle tt = (NTThreadTitle)(((TabItem)o).Tag);

                if (thread.Title.Equals(tt.Title))
                    return i;
            }
#endif
            return -1;
        }
#if false
        public void removeThreadFromTabCtrl(NTThreadTitle tt)
        {

            int idx = searchThreadFromTabItems(tt);
            if (idx < 0)
                return;

            tabCtrlDat.Items.RemoveAt(idx);

            int cnt = tabCtrlDat.Items.Count;
            if (cnt > 0)
            {
                if (tabCtrlDat.SelectedIndex < 0)
                {
                    tabCtrlDat.SelectedIndex = cnt - 1;
                }
                else
                {
                    TabItem item = tabCtrlDat.SelectedItem as TabItem;
                    if (item == null)
                        return;

                    if (item.Content == null)
                        constructResContent(item);


                }
            }

        }
#endif
        public static ScrollViewer findScrollViewer(FlowDocumentScrollViewer flowDocumentScrollViewer)
        {
            if (VisualTreeHelper.GetChildrenCount(flowDocumentScrollViewer) == 0)
            {
                return null;
            }

            // Border is the first child of first child of a ScrolldocumentViewer 
            DependencyObject firstChild = VisualTreeHelper.GetChild(flowDocumentScrollViewer, 0);
            if (firstChild == null)
            {
                return null;
            }

            Decorator border = VisualTreeHelper.GetChild(firstChild, 0) as Decorator;

            if (border == null)
            {
                return null;
            }

            return border.Child as ScrollViewer;
        } 
    }
}
