﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Threading;
using NT2chCtrl;
using NT2chView.NtFile;
using NT2chView.NtNet;
using NT2chObject;

namespace NT2chView
{
    public partial class MainWindow : Window
    {
        private void btnJumpToBottom_Click(object sender, RoutedEventArgs e)
        {
            IResViewJump jump = mResPanel as IResViewJump;
            jump.JumpToBottom();
        }

        private void btnJumpToTop_Click(object sender, RoutedEventArgs e)
        {
            IResViewJump jump = mResPanel as IResViewJump;
            jump.JumpToTop();
        }


        private void btnJumpToNew_Click(object sender, RoutedEventArgs e)
        {
            IResViewJump jump = mResPanel as IResViewJump;
            jump.JumpToNew();
        }

        private void btnJumpNextBookmark_Click(object sender, RoutedEventArgs e)
        {
            IResViewJump jump = mResPanel as IResViewJump;
            jump.JumpToNextBookmark();
        }


        private void btnCreateThread_Click(object sender, RoutedEventArgs e)
        {
           // string errMsg = null;
            NTBoard board = mSubjectPanel.GetCurrentBoard() as NTBoard;
            if (board == null)
            {
                MessageBox.Show("板が見つかりません。");
                return;
            }
            /*try
            {
                TabItem item = tabCtrlSubject.SelectedItem as TabItem;
                if (item == null)
                    throw new Exception("板が見つかりません。");

                board = item.Tag as NTBoard;
            if (board == null)
                throw new Exception("板が見つかりません。");



            }
            catch(Exception ex)
            {
                MessageBox.Show(ex.Message);
                return;
            }*/
            NTCreateThreadWindow wnd = new NTCreateThreadWindow(board, null);
            wnd.ShowDialog();
        }

        private void btnThreadTitleSearch_Click(object sender, RoutedEventArgs e)
        {
            tabItemSearch.IsSelected = true;
            Thread th = new Thread(btnThreadTitleSearch_Worker);
            th.Start(this);

        }

        static void btnThreadTitleSearch_Worker(object o)
        {
            MainWindow wnd = o as MainWindow;
            if (wnd == null)
                return;

            wnd.Dispatcher.BeginInvoke(DispatcherPriority.Normal,
                    (ThreadStart)delegate()
            {
                Thread.Sleep(500);
                wnd.txtTitleSearch.Focus();
  
            });
        }


        private void btnResSearch_Click(object sender, RoutedEventArgs e)
        {
            tabItemSearch.IsSelected = true;
            txtMsgSearch.Focus();
        }
        private void btnMsgSearchNext_Click(object sender, RoutedEventArgs e)
        {
            string sWord = txtMsgSearch.Text.Trim();
            if (sWord.Length == 0)
                return;

            IResViewSearch search = mResPanel as IResViewSearch;
            if (search == null)
                return;

            search.SetSearchWord(sWord);
            search.SearchNext();

        }
        private void btnMsgSearchPrev_Click(object sender, RoutedEventArgs e)
        {
            string sWord = txtMsgSearch.Text.Trim();
            if (sWord.Length == 0)
                return;

            IResViewSearch search = mResPanel as IResViewSearch;
            if (search == null)
                return;

            search.SetSearchWord(sWord);
            search.SearchPrev();

        }
        
#if false      
        private void btnJmpNextBookmark_Click(object sender, RoutedEventArgs e)
        {
            mResPanel.JumpToNextBookmark();
            /*
            TabItem ti = tabCtrlDat.SelectedItem as TabItem;
            if (ti == null)
                return;

            NTThreadTitle tt = ti.Tag as NTThreadTitle;
            if (tt == null)
                return;

            tt.FocusNextBookmark();*/
        }
#endif
        private void btnAddNgName_Click(object sender, RoutedEventArgs e)
        {

            cmbNgEditKind.SelectedIndex = 1;

            string src = txtNgNameEdit.Text;
            NTNgItems ng = NTNgItems.getContext();
            if(!ng.addNgName(src))
                return;

            List<string> list = new List<string>();
            list.Add(src);
            Thread th = new Thread(uploadNgNames);
            th.Start(list);

            string dest = txtNgEdit.Text;
            string [] dests = NTTextUtiles.splitLine(dest);
            StringBuilder sb = new StringBuilder(64);
            foreach(string s in dests)
            {
                if(s.Length > 0)
                    sb.Append(s).Append('\n');
            }
            sb.Append(src).Append('\n');
            txtNgEdit.Text = sb.ToString();
            txtNgNameEdit.Text = string.Empty;

            NTFileAccess.ntWriteNgNamesToFile(ng.getNgNames());
        }

        private void btnAddNgId_Click(object sender, RoutedEventArgs e)
        {
            cmbNgEditKind.SelectedIndex = 2;
            
            string src = txtNgIdEdit.Text;
            NTNgItems ng = NTNgItems.getContext();
            if(!ng.addNgId(src))
                return;

            List<string> list = new List<string>();
            list.Add(src);
            Thread th = new Thread(uploadNgIds);
            th.Start(list);


            string dest = txtNgEdit.Text;
            string[] dests = NTTextUtiles.splitLine(dest);
            StringBuilder sb = new StringBuilder(64);
            foreach (string s in dests)
            {
                if (s.Length > 0)
                    sb.Append(s).Append('\n');
            }
            sb.Append(src).Append('\n');
            txtNgEdit.Text = sb.ToString();
            txtNgIdEdit.Text = string.Empty;

            NTFileAccess.ntWriteNgIdsToFile(ng.getNgIds());

        }

        private void btnAddNgWord_Click(object sender, RoutedEventArgs e)
        {
            cmbNgEditKind.SelectedIndex = 0;

            string src = txtNgWordEdit.Text;
            List<string> list = new List<string>();

            NTNgItems ng = NTNgItems.getContext();
            string[] lines = NTTextUtiles.splitLine(src);
            foreach (string s in lines)
            {
                string s1 = s.Trim();
                if(s1.Length>0)
                    if (ng.addNgWord(s1))
                        list.Add(s1);
            }
            if (list.Count == 0)
                return;

            Thread th = new Thread(uploadNgWords);
            th.Start(list);

            NTFileAccess.ntWriteNgWordsToFile(ng.getNgWords());

            
            string dest = txtNgEdit.Text;
            string[] dests = NTTextUtiles.splitLine(dest);
            StringBuilder sb = new StringBuilder(64);
            foreach (string s in dests)
            {
                if (s.Length > 0)
                    sb.Append(s).Append('\n');
            }
            foreach (string s in list)
            {
                sb.Append(s).Append('\n');
            }
            txtNgEdit.Text = sb.ToString();
            txtNgWordEdit.Text = string.Empty;
        }

        void uploadNgWords(object para)
        {
            List<string> list = para as List<string>;
            if (list == null)
                return;
            string result;
            if (NTUserPreference.NTUserCloudIsEnabled)
            {
                string uid = NTUserPreference.NTCloudID;
                string hashed = NTUserPreference.NTUserCloudGetHashedPasswd();
                    //NTCrypt.getSHA256Hashed(
                    //NTUserPreference.NTCloudPSS + NTUserPreference.NTUserCloudSeed);
                result = NTHttpAccess.UserCloudUploadNgWord(uid, hashed, list, true);

            }
            else
            {
                string uid = NTUserPreference.NTCloudID;
                string passwd = NTUserPreference.NTCloudPSS;
                result = NTHttpAccess.ntUploadNgWord(uid, passwd, list, true);
            }
            NTDebug.l(result);
        }

        void uploadNgIds(object para)
        {
            List<string> list = para as List<string>;
            if (list == null)
                return;
            string result;
            if (NTUserPreference.NTUserCloudIsEnabled)
            {
                string uid = NTUserPreference.NTCloudID;
                string hashed = NTUserPreference.NTUserCloudGetHashedPasswd(); 
                //NTCrypt.getSHA256Hashed(
                //    NTUserPreference.NTCloudPSS + NTUserPreference.NTUserCloudSeed);
                result = NTHttpAccess.UserCloudUploadNgId(uid, hashed, list, true);

            }
            else
            {
                string uid = NTUserPreference.NTCloudID;
                string passwd = NTUserPreference.NTCloudPSS;
                result = NTHttpAccess.ntUploadNgId(uid, passwd, list, true);
            }
            NTDebug.l(result);
        }

        void uploadNgNames(object para)
        {
            List<string> list = para as List<string>;
            if (list == null)
                return;
            string result;
            if (NTUserPreference.NTUserCloudIsEnabled)
            {
                string uid = NTUserPreference.NTCloudID;
                string hashed = NTUserPreference.NTUserCloudGetHashedPasswd(); 
                //NTCrypt.getSHA256Hashed(
                 //   NTUserPreference.NTCloudPSS + NTUserPreference.NTUserCloudSeed);
                result = NTHttpAccess.UserCloudUploadNgName(uid, hashed, list, true);

            }
            else
            {
                string uid = NTUserPreference.NTCloudID;
                string passwd = NTUserPreference.NTCloudPSS;
                result = NTHttpAccess.ntUploadNgName(uid, passwd, list, true);
            }
            NTDebug.l(result);
        }

        void uploadAllNgWords(object para)
        {
            List<string> list = para as List<string>;
            if (list == null)
                return;
            string result;
            if (NTUserPreference.NTUserCloudIsEnabled)
            {
                string uid = NTUserPreference.NTCloudID;
                string hashed = NTUserPreference.NTUserCloudGetHashedPasswd(); 
                //NTCrypt.getSHA256Hashed(
                  //  NTUserPreference.NTCloudPSS + NTUserPreference.NTUserCloudSeed);
                result = NTHttpAccess.UserCloudUploadNgWord(uid, hashed, list, false);

            }
            else
            {
                string uid = NTUserPreference.NTCloudID;
                string passwd = NTUserPreference.NTCloudPSS;
                result = NTHttpAccess.ntUploadNgWord(uid, passwd, list, false);
            }
            NTDebug.l(result);
        }

        void uploadAllNgIds(object para)
        {
            List<string> list = para as List<string>;
            if (list == null)
                return;
            string result;
            if (NTUserPreference.NTUserCloudIsEnabled)
            {
                string uid = NTUserPreference.NTCloudID;
                string hashed = NTUserPreference.NTUserCloudGetHashedPasswd(); 
                //NTCrypt.getSHA256Hashed(
                  //  NTUserPreference.NTCloudPSS + NTUserPreference.NTUserCloudSeed);
                result = NTHttpAccess.UserCloudUploadNgId(uid, hashed, list, false);

            }
            else
            {
                string uid = NTUserPreference.NTCloudID;
                string passwd = NTUserPreference.NTCloudPSS;
                result = NTHttpAccess.ntUploadNgId(uid, passwd, list, false);
            }
            NTDebug.l(result);
        }

        void uploadAllNgNames(object para)
        {
            List<string> list = para as List<string>;
            if (list == null)
                return;
            string result;
            if (NTUserPreference.NTUserCloudIsEnabled)
            {
                string uid = NTUserPreference.NTCloudID;
                string hashed = NTUserPreference.NTUserCloudGetHashedPasswd(); 
                //NTCrypt.getSHA256Hashed(
                  //  NTUserPreference.NTCloudPSS + NTUserPreference.NTUserCloudSeed);
                result = NTHttpAccess.UserCloudUploadNgName(uid, hashed, list, false);

            }
            else
            {
                string uid = NTUserPreference.NTCloudID;
                string passwd = NTUserPreference.NTCloudPSS;
                result = NTHttpAccess.ntUploadNgName(uid, passwd, list, false);
            }
            NTDebug.l(result);
        }

        private void txtNgEdit_TextChanged(object sender, TextChangedEventArgs e)
        {
            btnSaveNgEdit.IsEnabled = true;
        }


        private void btnSaveNgEdit_Click(object sender, RoutedEventArgs e)
        {

            string src = txtNgEdit.Text;
            string[] sArr = NTTextUtiles.splitLine(src);
            List<string> list = new List<string>();

            foreach (string s in sArr)
            {
                string s1 = s.Trim();
                if (s1.Length == 0)
                    continue;
                list.Add(s1);
            }

            NTNgItems ngItem = NTNgItems.getContext();

            int idx = cmbNgEditKind.SelectedIndex;
            switch (idx)
            {
                case 0: // word
                    ngItem.WriteNgWord(list.ToArray());
                    Thread th = new Thread(uploadAllNgWords);
                    th.Start(list);
                    NTFileAccess.ntWriteNgWordsToFile(ngItem.getNgWords());
                    break;
                case 1: // name
                    ngItem.WriteNgName(list.ToArray());
                    th = new Thread(uploadAllNgNames);
                    th.Start(list);
                    NTFileAccess.ntWriteNgNamesToFile(ngItem.getNgNames());
                    break;
                case 2: // id
                    ngItem.WriteNgId(list.ToArray());
                    th = new Thread(uploadAllNgIds);
                    th.Start(list);
                    NTFileAccess.ntWriteNgIdsToFile(ngItem.getNgIds());
                    break;
                default:
                    return;
            }
            btnSaveNgEdit.IsEnabled = false;
            //txtNgEdit.Text = string.Empty;
        }


        private void cmbNgEditKind_SelectionChanged(object sender, SelectionChangedEventArgs e)
        {
            constructNgTabItem(tabItemNgEdit);
        }


        private void tabCtrlMain_SelectionChanged(object sender, SelectionChangedEventArgs e)
        {
            TabControl tc = sender as TabControl;
            if (tc == null)
                return;

            TabItem ti = tc.SelectedItem as TabItem;
            if (ti == null || ti.Name == null)
                return;
            switch (ti.Name)
            {
                case "tabItemNgEdit":
                    constructNgTabItem(ti);
                    break;
            }





        }


        private void btnExit_Click(object sender, RoutedEventArgs e)
        {
            Close();
        }
        private void btnRestoreWindow_Click(object sender, RoutedEventArgs e)
        {
            RestoreMainWindow();
        }
        private void btnMaximizeWindow_Click(object sender, RoutedEventArgs e)
        {
            MaximizeMainWindow();
        }

        private void btnSetup_Click(object sender, RoutedEventArgs e)
        {

            NTSetupWindow w = new NTSetupWindow();
            w.Owner = this;
            if (w.ShowDialog() == true)
            {
                NTDebug.l("OK");
            }
            else
            {
                NTDebug.l("Cancel");
            }
            progressCtrlCloud.IsIndeterminate = NTUserPreference.NTCloudIsEnabled;
            
        }


        /*private void imgBtnTabClose_MouseDown(object sender, MouseButtonEventArgs e)
        {
            //MessageBox.Show();
            NTDebug.l("Invoke the tab close");
        }*/

        private void btnWriteRes_Click(object sender, RoutedEventArgs e)
        {
            IThread ithread = mResPanel.getCurrentThread();
            NTThreadTitle thread = ithread as NTThreadTitle;// findSelectedThreadTitle();
            if (thread == null)
            {
                MessageBox.Show("書き込む板が見つかりません。");
                return;
            }
            WriteRes_Invoke(thread, null);
        }

        private void btnFontSetup_Click(object sender, RoutedEventArgs e)
        {
            mResPanel.ToggleFontSetupTool();
        }

        private void btnPlayAutoScroll_Click(object sender, RoutedEventArgs e)
        {
            mResPanel.ToggleAutoScroll();
            btnPlayAutoScroll.Visibility = System.Windows.Visibility.Collapsed;
            btnStopAutoScroll.Visibility = System.Windows.Visibility.Visible;
        }

        private void btnStopAutoScroll_Click(object sender, RoutedEventArgs e)
        {
            mResPanel.ToggleAutoScroll();
            btnPlayAutoScroll.Visibility = System.Windows.Visibility.Visible;
            btnStopAutoScroll.Visibility = System.Windows.Visibility.Collapsed;
        }

#if DOTNET45
        private void btnTextTool_Click(object sender, RoutedEventArgs e)
        {
            NTUserPreference.ResViewTextSelMode = true;
            mResPanel.UpdateTextSelMode(true);
            btnTextTool.Visibility = System.Windows.Visibility.Collapsed;
            btnTouchMode.Visibility = System.Windows.Visibility.Visible;

        }
        private void btnTouchMode_Click(object sender, RoutedEventArgs e)
        {
            NTUserPreference.ResViewTextSelMode = false;
            mResPanel.UpdateTextSelMode(false);
            btnTextTool.Visibility = System.Windows.Visibility.Visible;
            btnTouchMode.Visibility = System.Windows.Visibility.Collapsed;

        }
#endif
        public void WriteRes_Invoke(NTThreadTitle tt, string siteMsg)
        {

            NTWriteResWindow w = new NTWriteResWindow(this, tt, siteMsg);
            w.Owner = this;
            w.Show();

        }

        public void WriteResCallback(bool update, NTThreadTitle thread)
        {
            if (update)
            {
                UpdateThread(thread);
                //OpenNewThread(thread);
                //updateResViewTabItem(thread);
            }
        }
        
#if false
        private void treeBoardView_SelectedItemChanged(object sender, RoutedPropertyChangedEventArgs<object> e)
        {
            //MessageBox.Show("sender: " + sender.ToString());
            if (e.NewValue is TreeViewItem)
            {
                TreeViewItem item = (TreeViewItem)e.NewValue;

                NTDebug.l(item.Header.ToString());
                if (item.Tag is NTBoard)
                {
                    NTBoard board = (NTBoard)item.Tag;
                    mSubjectPanel.OpenBoard(board);
                    constructBoardTabItem(board/*, true*/);
                    TabItem tabitem = searchBoardFromTabItem(board);
                    if (tabitem != null || tabitem.Tag == null)
                    {
                        constructBoardTabItemContent(board, tabitem);
                        int num = tabCtrlSubject.Items.Count;
                        if (num > 0)
                        {
                            tabCtrlSubject.SelectedIndex = num - 1;
                        }
                    }
                 }
            }

        }
#endif
        private void btnUpdate_Click(object sender, RoutedEventArgs e)
        {
            NTThreadTitle thread = mResPanel.getCurrentThread() as NTThreadTitle;
            if(thread != null)
                UpdateThread(thread);
#if false
            NTDebug.l("Entering btnUpdate");
            object o;
            if ((o = tabCtrlDat.SelectedItem) != null)
            {
                TabItem tabItem = (TabItem)o;
                if (tabItem.Tag is NTThreadTitle)
                {
                    updateResViewTabItem((NTThreadTitle)tabItem.Tag);
                }

            }


            IInputElement focusedElement = FocusManager.GetFocusedElement(this);
            TabItem tabItem;
            if (focusedElement != null)
            {
                if (focusedElement is ListViewItem)
                {
                    NTDebug.l("Update subject");
                    tabItem = (TabItem)tabCtrlSubject.SelectedItem;

                    if (tabItem.Tag is NTBoard)
                    {
                        UpdateBoardTabItem((NTBoard)tabItem.Tag);
                    }
                }
                else if (focusedElement is TreeView)
                {
                    NTDebug.l("Update board_menu");

                }
                else if (focusedElement is FlowDocumentScrollViewer)
                {
                    NTDebug.l("Update dat");
                    tabItem = (TabItem)tabCtrlDat.SelectedItem;

                    if (tabItem.Tag is NTThreadTitle)
                    {
                        updateResViewTabItem((NTThreadTitle)tabItem.Tag);
                    }
                }
                else
                {
                    object o;
                    if ((o = tabCtrlDat.SelectedItem) != null)
                    {
                        tabItem = (TabItem)o;
                        if (tabItem.Tag is NTThreadTitle)
                        {
                            updateResViewTabItem((NTThreadTitle)tabItem.Tag);
                        }
                    }
                    else if ((o = tabCtrlSubject.SelectedItem) != null)
                    {
                        tabItem = (TabItem)o;

                        if (tabItem.Tag is NTBoard)
                        {
                            UpdateBoardTabItem((NTBoard)tabItem.Tag);
                        }
                    }
                }
            }
            else
            {
                object o;
                if ((o = tabCtrlDat.SelectedItem) != null)
                {
                    tabItem = (TabItem)o;
                    if (tabItem.Tag is NTThreadTitle)
                    {
                        updateResViewTabItem((NTThreadTitle)tabItem.Tag);
                    }
                }
                else if ((o = tabCtrlSubject.SelectedItem) != null)
                {
                    tabItem = (TabItem)o;

                    if (tabItem.Tag is NTBoard)
                    {
                        UpdateBoardTabItem((NTBoard)tabItem.Tag);
                    }
                }
            }
#endif               
        }

        private void btnUpdateInSubject_Click(object sender, RoutedEventArgs e)
        {
            NTBoard board = mSubjectPanel.GetCurrentBoard() as NTBoard;
            if (board == null)
                return;

            board.Update(null);
            
            /*object o;
            if ((o = tabCtrlSubject.SelectedItem) != null)
            {
                TabItem tabItem = (TabItem)o;

                if (tabItem.Tag is NTBoard)
                {
                    UpdateBoardTabItem((NTBoard)tabItem.Tag);
                }
            }*/
        }
#if true
        private void btnJumpToTopInSubject_Click(object sender, RoutedEventArgs e)
        {
            mSubjectPanel.JumpToTop();
            /*TabItem item = tabCtrlSubject.SelectedItem as TabItem;
            if (item == null)
                return;

            ListView lv = item.Content as ListView;
            if (lv == null)
                return;

            int cnt = lv.Items.Count;
            if (cnt < 1)
                return;

            NTThreadTitle th = lv.Items[0] as NTThreadTitle;
            if (th != null)
                lv.ScrollIntoView(th);*/
        }

        private void btnJumpToBottomInSubject_Click(object sender, RoutedEventArgs e)
        {
            mSubjectPanel.JumpToBottom();
            /*TabItem item = tabCtrlSubject.SelectedItem as TabItem;
            if (item == null)
                return;

            ListView lv = item.Content as ListView;
            if (lv == null)
                return;

            int cnt = lv.Items.Count;
            if (cnt < 1)
                return;

            NTThreadTitle th = lv.Items[cnt - 1] as NTThreadTitle;
            if (th != null)
                lv.ScrollIntoView(th);*/

        }
#endif


#if false
        void lv_MouseLeftButtonUp(object sender, System.Windows.Input.MouseButtonEventArgs e)
        {
            //NTDebug.l("TEST");
            ListView lv;
            //lv.SelectionMode = SelectionMode.Single;
            //lv.
            if (!(sender is ListView))
                return;

            lv = (ListView)sender;
            object o = lv.SelectedItem;
            if (!(o is NTThreadTitle))
                return;

            NTThreadTitle tt = (NTThreadTitle)o;

           
            constructResViewTabItem(tt, true);


        }

        void lv_MouseLeftButtonDown(object sender, System.Windows.Input.MouseButtonEventArgs e)
        {
            NTDebug.l("TEST");
        }

        void btnSubjectTabItemClose_Click(object sender, RoutedEventArgs e)
        {
            //NTDebug.l("Clicked");

            if (!(sender is Button))
                return;

            if (!((((Button)sender).Tag) is NTBoard))
                return;
            NTBoard board = (NTBoard)(((Button)sender).Tag);
            int idx;
            if (0 <= (idx = searchBoardFromTabItemIndex(board)))
            {
                tabCtrlSubject.Items.RemoveAt(idx);
                //storeOpenedBoardList();
            }

        }

        void btnDatTabItemClose_Click(object sender, RoutedEventArgs e)
        {
            //NTDebug.l("Clicked");

            if (!(sender is Button))
                return;

            if (!((((Button)sender).Tag) is NTThreadTitle))
                return;
            NTThreadTitle thread = (NTThreadTitle)(((Button)sender).Tag);
            int idx;
            if (0 <= (idx = searchThreadFromTabItems(thread)))
            {
                tabCtrlDat.Items.RemoveAt(idx);
               
                //storeOpenedThreadList();


                int num = tabCtrlDat.Items.Count;
                if (num <= 0)
                    return;
                num--;
                //idx++;
                idx = (idx > num) ? num : idx;
                TabItem tabItem = tabCtrlDat.Items[idx] as TabItem;
                if (tabItem == null)
                    return;
                if(tabItem.Content == null)
                    constructResContent(tabItem);

                tabCtrlDat.SelectedIndex = idx;
                
            }

        }
#endif


        void btnAllBoardSearch_Click(object sender, RoutedEventArgs e)
        {
            string sWord = txtAllBoardSeach.Text.Trim();
            if (sWord.Length == 0)
                return;

            string result = NTHttpAccess.queryThreadFromAllBoard(sWord);
            if (result == null)
            {
                MessageBox.Show("検索に失敗しました。");
                return;
            }

            NTDebug.l(sWord);

            lstSearchedThread.Items.Clear();



            List<NTAllboardSearch> abs = NTAllboardSearch.Parse(result);

            foreach (NTAllboardSearch search in abs)
            {
                ListBoxItem lbi = new ListBoxItem();
                lbi.Content = search.mTitle + "[" + search.mBoard.mName + "]";
                lbi.Tag = search;
                lstSearchedThread.Items.Add(lbi);
            }


        }

        public void setupTitleSearchListBySimString(NTThreadTitle tt)
        {
            tabItemSearch.IsSelected = true;

            NTSimString simStr = new NTSimString(tt.Title);
            NTBoard board = tt.mBoard;
            lstSearchedThread.Items.Clear();
            foreach (NTThreadTitle thread in board.mThreadTitleList)
            {
                string title = thread.Title;
                int match_len =simStr.match(title);
                if((match_len*2) > (title.Length))
                {
                    ListBoxItem lbi = new ListBoxItem();
                    lbi.Content = thread.Title;
                    lbi.Tag = thread;
                    lstSearchedThread.Items.Add(lbi);
                }
            }
        }

        void btnTitleSearch_Click(object sender, RoutedEventArgs e)
        {


            /*TabItem item = tabCtrlSubject.SelectedItem as TabItem;
            if (item == null)
                return;


            NTBoard board = item.Tag as NTBoard;*/
            NTBoard board = mSubjectPanel.GetCurrentBoard() as NTBoard;
            if (board == null)
                return;

            string sWord = txtTitleSearch.Text.Trim();
            if (sWord.Length == 0)
                return;

            NTVagueSearchWord v = new NTVagueSearchWord(sWord);

            lstSearchedThread.Items.Clear();

            foreach (NTThreadTitle tt in board.mThreadTitleList)
            {
                string title = tt.Title;
                int len;
                if (0 <= v.match(title, 0, out len))
                {

                    ListBoxItem lbi = new ListBoxItem();
                    lbi.Content = tt.Title;
                    lbi.Tag = tt;
                    lstSearchedThread.Items.Add(lbi);
                }
            }

        }

        private void lstSearchedThread_SelectionChanged(object sender, SelectionChangedEventArgs e)
        {
            ListBoxItem item = lstSearchedThread.SelectedItem as ListBoxItem;
            if (item == null)
                return;

            NTThreadTitle tt = item.Tag as NTThreadTitle;
            if (tt == null)
            {
                NTAllboardSearch abs = item.Tag as NTAllboardSearch;
                if (abs != null)
                {
                    NTBoard board = abs.mBoard;
                    if (board == null)
                        return;

                    string strSubject = null;
                    if (!board.mDataInit)
                    {

                       // if (!NTFileAccess.isSubjectExsists(board.mName))
                            if (!NTHttpAccess.getSubject(board.mAddress, board.mName))
                                return;

                        strSubject = NTFileAccess.retrieveSubjectDataFromFile(board.mName);
                        if (strSubject == null)
                            return;

                        if (!board.parseSubjectData(strSubject, mFavoriteData))
                            return;
                    }

                    tt = board.findThreadTitleByDatName(abs.mDat + ".dat");
                    if (tt != null)
                    {
                        OpenNewThread(tt);
#if false
                        //bool datExists = NTFileAccess.isDatExsists(board.mName, tt.mDat);
                        constructResViewTabItem(tt/*, !datExists*/);
                        int idx = searchThreadFromTabItems(tt);
                        if (idx >= 0)
                        {
                            TabItem tabItem = tabCtrlDat.Items[idx] as TabItem;
                            if (tabItem != null)
                            {

                                constructResContent(tabItem);
                                tabCtrlDat.SelectedIndex = idx;
                            }

                        }
#endif
                    }


                }
                return;
            }
            //NTDebug.l(tt.Title);
            else
            {
                NTBoard board = tt.mBoard;
                if (board == null)
                    return;

                string strSubject = null;
                if (!board.mDataInit)
                {

                    if (!NTFileAccess.isSubjectExsists(board.mName))
                        if (!NTHttpAccess.getSubject(board.mAddress, board.mName))
                            return;

                    strSubject = NTFileAccess.retrieveSubjectDataFromFile(board.mName);
                    if (strSubject == null)
                        return;

                    if (!board.parseSubjectData(strSubject, mFavoriteData))
                        return;
                }

                OpenNewThread(tt);
#if false
                //NTThreadTitle tt = board.findThreadTitleByDatName(values[0]);
                //if (tt != null)
                //{
                bool datExists = NTFileAccess.isDatExsists(board.mName, tt.mDat);
                //constructResViewTabItem(tt/*, !datExists*/);
                idx = searchThreadFromTabItems(tt);
                if (idx >= 0)
                {
                    TabItem tabItem = tabCtrlDat.Items[idx] as TabItem;
                    if (tabItem != null && tabItem.Content == null)
                    {
                        constructResContent(tabItem);
                    }
                    tabCtrlDat.SelectedIndex = idx;
                }
                //}
#endif
            }
        }
 


    }
}
