﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using NT2chView.NtUI;

namespace NT2chView
{
    public class NTFavoriteThread
    {
        private string mAddress;
        private string mBoardName;
        private string mTitle;
        public string Address { get { return mAddress; } }
        public string Title { get{return mTitle;} }
        public string BoardName { get{ return mBoardName; }}

        //private int mResCnt;
        //private int mReadResCnt;


        private Paragraph mParagraph = null;
        private bool mMousePressed = false;
        //LinearGradientBrush mFavoriteMouseOverBKBrush;
        Brush mFavoriteBKBrush;
        Brush mFavoriteForeBrush;
        Brush mBoardForeBrush;
        Brush mFavoriteEmphasizeBKBrush;
        Brush mFavoriteEmphasizeForeBrush;
        Brush mFavoriteMouseOverBKBrush;
        Brush mFavoriteDragOverBKBrush;


        ScrollViewer mScrollViewer;
        StackPanel mPanelMain;

        public void setScrollViewer(ScrollViewer sv, StackPanel panel)
        {
            mScrollViewer = sv;
            mPanelMain = panel;
        }

        public string getDescription()
        {
            StringBuilder sb = new StringBuilder(128);
            sb.Append(mAddress).Append(NTTextUtiles.YEN_VALUE[0]);
            sb.Append(mBoardName).Append(NTTextUtiles.YEN_VALUE[0]);
            sb.Append(mTitle);
            return sb.ToString();
        }
        
        public bool Same(NTFavoriteThread source)
        {
            return Same(source.mAddress, source.mBoardName, source.mTitle);
        }

        public bool Same(string address, string boardName, string title)
        {
            return (mAddress != null && mBoardName != null && mTitle != null &&
                      address != null && boardName != null && title != null &&
                      mAddress.Equals(address) &&
                      mBoardName.Equals(boardName) &&
                      mTitle.Equals(title));
        }

        public NTFavoriteThread(string address, string boardName, string title)
        {
            mAddress = address;
            mBoardName = boardName;
            mTitle = title;
            mFavoriteMouseOverBKBrush = (Brush)
                NTAppState.getMainWindow().TryFindResource("FavoriteThreadMouseOverBKBrush");
            mFavoriteDragOverBKBrush = (Brush)
                NTAppState.getMainWindow().TryFindResource("FavoriteThreadDragOverBKBrush");
            mFavoriteBKBrush = (Brush)
                NTAppState.getMainWindow().TryFindResource("FavoriteThreadBKBrush");
            mFavoriteForeBrush = (Brush)
                NTAppState.getMainWindow().TryFindResource("FavoriteThreadForeBrush");
            mBoardForeBrush = (Brush)
                NTAppState.getMainWindow().TryFindResource("FavoriteThreadBoardForeBrush");
            mFavoriteEmphasizeBKBrush = (Brush)
                NTAppState.getMainWindow().TryFindResource("FavoriteThreadEmphasizedBKBrush");
            mFavoriteEmphasizeForeBrush = (Brush)
                NTAppState.getMainWindow().TryFindResource("FavoriteThreadEmphasizedForeBrush");

            //FavoriteThreadBoardForeBrush FavoriteThreadEmphasizedBKBrush
            // NTAppState.getMainWindow().TryFindResource("FavoriteThreadBKBrush");FavoriteThreadMouseOverBKBrush
        }

        public void updateParagraph(NTThreadTitle thread)
        {
            if (mParagraph == null)
                return;

            int cnt = mParagraph.Inlines.Count;
            if(cnt < 3)
                return;

            for(int i = cnt; cnt > 3; cnt--)
            {
                Inline inline = mParagraph.Inlines.LastInline;
                mParagraph.Inlines.Remove(inline);

            }

            int resCnt = thread.ResCnt;
            Run run = new Run("("+resCnt+") ");
            if (mFavoriteForeBrush != null)
            {
                run.Foreground = mFavoriteForeBrush;
            }
            else
            {
                run.Foreground = Brushes.Black;
            }
            run.FontSize = 12;
            //run.AllowDrop = true;
            mParagraph.Inlines.Add(run);

            int readCnt = thread.ReadCnt;
            int unreadCnt = resCnt - readCnt;

            if (readCnt != 0)
            {
                run = new Run("未読" + unreadCnt);
                if (resCnt > readCnt)
                {
                    if (mFavoriteEmphasizeForeBrush != null)
                        run.Foreground = mFavoriteEmphasizeForeBrush;
                    else
                        run.Foreground = Brushes.White;
                    if (mFavoriteEmphasizeBKBrush != null)
                        run.Background = mFavoriteEmphasizeBKBrush;
                    else
                        run.Background = Brushes.Red;
                }
                else
                {
                    if (mFavoriteForeBrush != null)
                        run.Foreground = mFavoriteForeBrush;
                    else
                        run.Foreground = Brushes.Black;
                }
                run.FontSize = 14;
                //run.AllowDrop = true;
                mParagraph.Inlines.Add(run);
            }
        }

        public void setDragOverBrush(bool isOver)
        {
            if (isOver)
            {
                if (mFavoriteDragOverBKBrush != null)
                    mParagraph.Background = mFavoriteDragOverBKBrush;
            }
            else
            {
                if (mFavoriteBKBrush != null)
                    mParagraph.Background = mFavoriteBKBrush;
            }
        }

        public Paragraph createParagraph()
        {
            Paragraph para = new Paragraph();
            para.Tag = this;
            para.Margin = new Thickness(0, 5, 0, 5);
            para.MouseEnter += para_MouseEnter;
            para.MouseLeave += para_MouseLeave;
            para.MouseLeftButtonDown += para_MouseLeftButtonDown;
            para.MouseLeftButtonUp += para_MouseLeftButtonUp;
            para.MouseMove += para_MouseMove;
            para.MouseWheel += para_MouseWheel;
            //para.AllowDrop = true;

            para.Typography.NumeralStyle = FontNumeralStyle.Lining;
            para.Typography.Fraction = FontFraction.Slashed;
            para.Typography.Variants = FontVariants.Normal;

            Run run = new Run(mBoardName);
            if (mBoardForeBrush != null)
                run.Foreground = mBoardForeBrush;
            else
                run.Foreground = Brushes.Orange;

            //if (mFavoriteBKBrush != null)
            //{
            //    para.Background = mFavoriteBKBrush;
            //    run.Background = mFavoriteBKBrush;
            //}

            run.FontWeight = FontWeights.Bold;
            run.FontSize = 12;
            para.Inlines.Add(run);

            LineBreak lb = new LineBreak();
            para.Inlines.Add(lb);

            run = new Run(mTitle);
            if (mFavoriteForeBrush != null)
                run.Foreground = mFavoriteForeBrush;
            else
                run.Foreground = Brushes.Black;
            //if (mFavoriteBKBrush != null)
            //    run.Background = mFavoriteBKBrush;
            run.FontSize = 14;
            run.AllowDrop = true;
            para.Inlines.Add(run);

           // lb = new LineBreak();
           // para.Inlines.Add(lb);

            mParagraph = para;

            return para;

        }

        bool fDown = false;
        TouchPoint mPos;
        double mVOffest;
        void document_TouchUp(object sender, TouchEventArgs e)
        {
            fDown = false;
            //throw new NotImplementedException();
        }

        void document_TouchMove(object sender, TouchEventArgs e)
        {
            if (!fDown)
                return;
            if (mScrollViewer == null)
                return;


            TouchPoint pos = e.GetTouchPoint(mPanelMain);
            double y = mPos.Position.Y - pos.Position.Y;
            double newOffset = mVOffest + y;
            if (mScrollViewer != null)
                mScrollViewer.ScrollToVerticalOffset(newOffset);
        }


        void document_TouchDown(object sender, TouchEventArgs e)
        {
            if (mScrollViewer == null)
                return;

            try
            {
                mPos = e.GetTouchPoint(mPanelMain);
                mVOffest = mScrollViewer.VerticalOffset;
                fDown = true;
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }
        void para_MouseWheel(object sender, MouseWheelEventArgs e)
        {
            int d = e.Delta;
            if (d == 0)
                return;
            if (mScrollViewer == null)
                return;

            int vOffset = (int)mScrollViewer.VerticalOffset;

            vOffset -= e.Delta;

            mScrollViewer.ScrollToVerticalOffset(vOffset);


            //throw new NotImplementedException();
        }

        Paragraph mMouseObservParagraph = null;
        Point mMouseObservePoint;

        void para_MouseLeftButtonUp(object sender, System.Windows.Input.MouseButtonEventArgs e)
        {
            //NTDebug.l("Mouse LeftUp");
            if (mMousePressed)
            {
               NTBoard board = NTDataRoot.getBoardByName(mBoardName);
                if (board != null)
                {
                    if (NTAppState.getMainWindow().OpenNewBoard(board))
                    {
                        NTThreadTitle tt = board.findThreadTitleByDatName(mAddress);
                        if (tt != null)
                        {
                            NTAppState.getMainWindow().OpenNewThread(tt);
                            e.Handled = true;
                        }
                    }
                }
            }
            mMousePressed = false;
            if (mFavoriteMouseOverBKBrush != null)
                mParagraph.Background = mFavoriteMouseOverBKBrush;
            else
                mParagraph.Background = Brushes.Yellow;
        }

        void para_MouseLeftButtonDown(object sender, System.Windows.Input.MouseButtonEventArgs e)
        {
            //NTDebug.l("Mouse LeftDown");
            mMousePressed = true;
            e.Handled = true;

            Paragraph para = sender as Paragraph;
            if (para == null)
            {
                mMouseObservParagraph = null;
                return;
            }
            mMouseObservParagraph = para;
            mMouseObservePoint = e.GetPosition(para);

        }

        void para_MouseMove(object sender, MouseEventArgs e)
        {
            //NTDebug.l("Mouse Move");
            if (mMouseObservParagraph == null)
                return;
            Paragraph para = sender as Paragraph;
            if (para == null || !para.Equals(mMouseObservParagraph))
            {
                mMouseObservParagraph = null;
                return;
            }
            Point point = e.GetPosition(para);
            NTDebug.l("Point (" + point.X + "," + point.Y + ")");
            Vector v = Point.Subtract(point, mMouseObservePoint);
            if (v.Length > NTDragDrop.DRAG_START_MOVE_DELTA)
            {
                startDrag();
                e.Handled = true;
                mMousePressed = false;
                //mParagraph.Background = Brushes.White;
                mMouseObservParagraph = null;
            }

        }

        void startDrag()
        {
            //NTDebug.l("*** Drag Start!!! ***");
            NTDragDrop.ThreadData data = new NTDragDrop.ThreadData(this);
            DataObject dObj = new DataObject(NTDragDrop.THREAD_DRAG_DATA_FORMAT, data);

            DragDrop.DoDragDrop(mParagraph, dObj, DragDropEffects.All);
        }

        void para_MouseLeave(object sender, System.Windows.Input.MouseEventArgs e)
        {
            mMousePressed = false;
            if(mFavoriteBKBrush != null)
                mParagraph.Background = mFavoriteBKBrush;
            else
                mParagraph.Background = Brushes.White;
            mMouseObservParagraph = null;
            //NTDebug.l("Mouse Leave");
        }

        void para_MouseEnter(object sender, System.Windows.Input.MouseEventArgs e)
        {
            //NTDebug.l("Mouse Enter");
            mMousePressed = false;
            if (mFavoriteMouseOverBKBrush != null)
                mParagraph.Background = mFavoriteMouseOverBKBrush;
            else
                mParagraph.Background = Brushes.Yellow;
        }

    }
}
