﻿using NT2chObject;
using System;
using System.Collections.Generic;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using System.IO;
using NT2chCtrl.html;

namespace NT2chCtrl
{

    /// <summary>
    /// NTResViewPanel.xaml の相互作用ロジック
    /// 
    /// ２ぃとちゃん for Windowsのレス画面に表示される
    /// コントロールを定義します。IResViewインターフェースのメソッドは
    /// フレームワークから呼び出すので、削除しないで下さい。
    /// また、このコントロールの名前も変更できません。
    /// NTResViewPanel_util.csはアプリケーションフレームワークとの
    /// インターフェースとなるヘルパーメソッドを定義してありますので
    /// 編集しないで下さい。
    /// フレームワークから渡される２ｃｈデータのオブジェクトについては
    /// NTInterfaceDecl.csの定義を参照して下さい。
    /// 基本的にNTが先頭に着くファイル名は本ファイルを除いて編集できません。
    /// 本ファイルについては、IResViewインターフェースのメソッドが実装されている限り
    /// 自由に由に変更できます。
    /// 
    /// </summary>
    public partial class NTResViewPanel : UserControl,
        IResView , IResViewJump, IResViewSearch
    {
        IThread mCurrentThread = null;
        //ResViewUI mResUI = null;
        ThreadHistoryUI mThreadHistoryUI = null;
        int mSavedPrevReadCount = 0;
        ResListAdapter mResListAdapter = null;

        public NTResViewPanel()
        {
            InitializeComponent();
        }

        private void ResViewPanel_Loaded(object sender, RoutedEventArgs e)
        {
            mThreadHistoryPanel.Children.Clear();
            mFontSetupToolbar.Visibility = System.Windows.Visibility.Collapsed;
            mAutoScrollToolbar.Visibility = System.Windows.Visibility.Collapsed;
            mBtnResumeAutoPlay.Visibility = System.Windows.Visibility.Collapsed;

#if DOTNET45
            TouchSupportScrollViewer sv =
                new TouchSupportScrollViewer(mThreadMenuScrollViewer,
                    mThreadHistoryPanel);
#endif
        }

        /*
         * 現在アクティブなスレッドを確認する為にフレームワークから
         * 呼び出されます。
         */
        public IThread getCurrentThread()
        {
            return mCurrentThread;
        }


        /*
         * アプリケーションフレームワークから、新しいスレッドを表示する要求が
         * 有った時に呼ばれます。
         */
        public bool OpenThread(IThread ithread)
        {
            mCurrentThread = ithread;
            if (ithread == null)
                return false;

            setTitle(ithread);

            if (mThreadHistoryUI != null)
            {
                mThreadHistoryUI.AddButton(ithread);
                mThreadMenuScrollViewer.ScrollToTop();
            }

            mResListAdapter = new ResListAdapter(this, ithread, mCommand, mUtil);

            mSavedPrevReadCount = ithread.getPrevReadCount();
            if (mSavedPrevReadCount < 0)
            {
                mSavedPrevReadCount = 0;
            }

            mResListPanel.setAdapter(mResListAdapter, mSavedPrevReadCount);

            continueAutoScroll();

            return true;// mResUI.OpenThread(ithread, mFlowDocResView);     
        }

        private const string RES_LAYOUT_HTML_FILE = @"\res_layout.html";


        public void initResLayout(bool debug)
        {
            if (mCommand == null)
                return;

            string path = mCommand.GetDataPath() + RES_LAYOUT_HTML_FILE;

            string htmlSource = loadHtml(path);
            //if (htmlSource == null)
            //    return;
            html.HtmlParser parser;
            if (!ResViewCtrlState.getInstance().init(htmlSource, mCommand, out parser)
                && debug && (parser != null && parser.hasError()))
            {
                
                NTScriptDebugger debugger = new NTScriptDebugger();
                debugger.ErrorMessage = parser.getErrorMessage();
                debugger.ErrorLine = parser.getErrorLine();
                debugger.ErrorSrcIndex = parser.getErrorSrcIndex();
                debugger.HtmlSource = htmlSource;

                debugger.initParam();
                NTScriptDebugger.ShowWindow(debugger);
            }

        }

        //コントロール初期化時に、これまでに閲覧したスレッドの履歴リストが渡されます。
        public bool SetThreadReadHistory(List<IThreadDescription> threadDescriptionList)
        {
            mThreadHistoryUI = new ThreadHistoryUI(mCommand,mUtil, threadDescriptionList,
                mThreadHistoryPanel);

            /*object o; 
            if(getDict().TryGetValue(PREF_PARAM.RES_VIEW_ZOOM_VALUE, out o))
            {
                string s = o as string;
                if (s != null)
                {
                    double zoom;
                    if (double.TryParse(s, out zoom))
                    {
                        //mFlowDocResView.Zoom = zoom;
                    }
                }
            }*/
            return true;
        }

        public void OnNotifyThreadUpdated(IBoard iboard)
        {
            if (mThreadHistoryUI == null)
                return;
            mThreadHistoryUI.UpdateButton(iboard);

        }

        //このコントロールで管理しているスレッド閲覧リストを取得する為に呼ばれます。
        public List<IThreadDescription> QueryThreadReadHistory()
        {
            if (mThreadHistoryUI == null)
                return null;
            return mThreadHistoryUI.getCurrentList();
        }
        //オブジェクトがアンロードされる前に呼ばれます。
        //ここで、オブジェクトの永続データーを保存して下さい。
        public void SaveCurrentState()
        {
            //double zoom = mFlowDocResView.Zoom;
            //getDict().Remove(PREF_PARAM.RES_VIEW_ZOOM_VALUE);
            //getDict().Add(PREF_PARAM.RES_VIEW_ZOOM_VALUE, zoom.ToString());
        }


        public void ToggleFontSetupTool()
        {
            if(mFontSetupToolbar.Visibility != System.Windows.Visibility.Collapsed)
                mFontSetupToolbar.Visibility = System.Windows.Visibility.Collapsed;
            else
                mFontSetupToolbar.Visibility = System.Windows.Visibility.Visible;
        }

        public void ToggleAutoScroll()
        {
            if (mAutoScrollToolbar.Visibility != System.Windows.Visibility.Collapsed)
            {
                mAutoScrollToolbar.Visibility = System.Windows.Visibility.Collapsed;
                mResListPanel.setAutoScroll(false, 0);
            }
            else
            {
                mAutoScrollToolbar.Visibility = System.Windows.Visibility.Visible;
                mResListPanel.setAutoScroll(true, mAutoScrollSliderValue);
            }
        }

        public void UpdateTextSelMode(bool selMode)
        {
            if (null == mResListAdapter)
                return;
            mResListAdapter.updateTextSelMode(selMode);
        }

        void continueAutoScroll()
        {
            if (mAutoScrollToolbar.Visibility == System.Windows.Visibility.Visible)
            {
                mAutoScrollToolbar.Visibility = System.Windows.Visibility.Visible;
                mResListPanel.setAutoScroll(true, mAutoScrollSliderValue);
            }
        }

        /*
           *  スレッドの先頭にスクロースする要求が有った時に呼ばれます。
           */
        public void JumpToTop()
        {
            mResListPanel.setScrollItemPosition(0);
        }
        /*
         *  スレッドの最後にスクロースする要求が有った時に呼ばれます。
         */
        public void JumpToBottom()
        {
            List<IRes> resList = mCurrentThread.getResList();
            int num = resList.Count;
            num--;
            if (num < 0)
                num = 0;
            mResListPanel.setScrollItemPosition(num);
        }
        /*
         *  スレッドの新着にスクロースする要求が有った時に呼ばれます。
         */
        public void JumpToNew()
        {
            mResListPanel.setScrollItemPosition(mSavedPrevReadCount);
        }
        public void JumpTo(int position)
        {
            mResListPanel.setScrollItemPosition(position);
        }
        public void InvalidateItems()
        {
            mResListPanel.InvalidateItems();
        }
        /*
         *  スレッドの新着にスクロースする要求が有った時に呼ばれます。
         */
        public void JumpToNextBookmark()
        {
            int current = mResListPanel.getCurrentPosition();
            if (current < 0)
                current = 0;
            int scrollTo = mResListAdapter.NextBookmark(current);
            if (scrollTo < 0)
                return;

            mResListPanel.setScrollItemPosition(scrollTo);
        }

        //指定された検索文字列を選択状態にして下さい。
        public void SetSearchWord(string searchWord)
        {
            int current = mResListPanel.getCurrentPosition();
            if (current < 0)
                current = 0;
            mResListAdapter.SetSearchWord(searchWord, current);
        }
        //指定された検索文字列の後方にマッチする文字列を選択して下さい。
        public void SearchNext()
        {
            int cursor = mResListAdapter.SearchNext();
            if (cursor < 0)
                return;

            mResListPanel.setScrollItemPosition(cursor);
        }
        //指定された検索文字列の前方にマッチする文字列を選択して下さい。
        public void SearchPrev()
        {
            int cursor = mResListAdapter.SearchPrev();
            if (cursor < 0)
                return;

            mResListPanel.setScrollItemPosition(cursor);
        }

        private void UIElementListPanel_Loaded(object sender, RoutedEventArgs e)
        {
            this.mResListPanel.init();
        }

        private void btnFontReduce_Click(object sender, RoutedEventArgs e)
        {
            mResListAdapter.ZoomOut();
        }

        private void btnFontEnlarge_Click(object sender, RoutedEventArgs e)
        {
            mResListAdapter.ZoomIn();
        }

        double mAutoScrollSliderValue = 1;
        private void mAutoScrollRatioSlider_ValueChanged(object sender, RoutedPropertyChangedEventArgs<double> e)
        {
            if (mAutoScrollRatio == null)
                return;

            double val = e.NewValue;
            val *= val;
            val /= 100;
            mAutoScrollSliderValue = val;
            string s =string.Format("Current Speed x{0:0.##}", val);
            mAutoScrollRatio.Text = s;

            mResListPanel.setAutoScroll(true, val);
        }

        private void mBtnPauseAutoPlay_Click(object sender, RoutedEventArgs e)
        {
            mBtnResumeAutoPlay.Visibility = System.Windows.Visibility.Visible;
            mBtnPauseAutoPlay.Visibility = System.Windows.Visibility.Collapsed;
            mResListPanel.pauseAutoScroll();
        }

        private void mBtnResumeAutoPlay_Click(object sender, RoutedEventArgs e)
        {
            mBtnResumeAutoPlay.Visibility = System.Windows.Visibility.Collapsed;
            mBtnPauseAutoPlay.Visibility = System.Windows.Visibility.Visible;
            mResListPanel.resumeAutoScroll();
        }
        private void mBtnReverseAutoPlay_Click(object sender, RoutedEventArgs e)
        {
            mResListPanel.toggleScrollDirection();
        }

    }

    
}
