﻿using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using NT2chView.NtNet;


namespace NT2chView.NtFile
{
    

    sealed class NTFileAccess
    {
        const string ROOTDIR_NAME = @"\Data";
        const string IMAGE_DIR = @"Images";
        const string BOARDMENU_DIR_NAME = @"\BoardMenu";
        const string BOARDMENU_FILE_NAME = @"\BoardMenu.txt";
        const string BOARDMENU_ATTR_FILE_NAME = @"\BoardMenuAttr.txt";
        const string PATH_PEPARATOR = @"\";
        const string SUBJECT_TXT_FILE_NAME = @"\Subject.txt";
        const string SUBJECT_ATTR_FILE_NAME = @"\SubjectAttr.txt";
        const string DAT_FILE_NAME = @"\dat.txt";
        const string DAT_ATTR_FILE_NAME = @"\attr.txt";
        const string DAT_ATTR_B_FILE_NAME = @"\b_attr.txt";
        const string DAT_FILE_SUFFIX = @".dat";
        const string COOKIE_DIR_NAME = @"\Cookie";
        const string FAVORITE_BOARD_LIST_FILE_NAME = @"\FavoriteBoards.txt";
        const string FAVORITE_THREAD_LIST_FILE_NAME = @"\FavoriteThreads.txt";
        const string FAVORITE_THREAD_TAG_LIST_FILE_NAME = @"\FavoriteThreadTag.txt";
        const string FAVORITE_BOARD_ATTR_FILE_NAME = @"\FavoriteBoardsAttr.txt";
        const string FAVORITE_THREAD_ATTR_FILE_NAME = @"\FavoriteThreadsAttr.txt";
        const string FAVORITE_THREAD_TAG_ATTR_FILE_NAME = @"\FavoriteThreadTagAttr.txt";
        const string AES_FAVORITE_BOARD_LIST_FILE_NAME = @"\AesFavoriteBoards.txt";
        const string AES_FAVORITE_THREAD_LIST_FILE_NAME = @"\AesFavoriteThreads.txt";
        const string AES_FAVORITE_THREAD_TAG_LIST_FILE_NAME = @"\AesFavoriteThreadTag.txt";
        const string AES_FAVORITE_BOARD_ATTR_FILE_NAME = @"\AesFavoriteBoardsAttr.txt";
        const string AES_FAVORITE_THREAD_ATTR_FILE_NAME = @"\AesFavoriteThreadsAttr.txt";
        const string AES_FAVORITE_THREAD_TAG_ATTR_FILE_NAME = @"\AesFavoriteThreadTagAttr.txt";
        
        public const string NGWORD_FILE_NAME = @"\NgWord.txt";
        public const string NGWORD_ATTR_FILE_NAME = @"\NgWordAttr.txt";
        public const string NGID_FILE_NAME = @"\NgId.txt";
        public const string NGID_ATTR_FILE_NAME = @"\NgIdAttr.txt";
        public const string NGNAME_FILE_NAME = @"\NgName.txt";
        public const string NGNAME_ATTR_FILE_NAME = @"\NgNameAttr.txt";

        public const string EXTERNAL_BOARD_FILE_NAME = @"\ExteranlBoard.txt";
        const string EXTERNALBOARD_ATTR_FILE_NAME = @"\ExternalBoardAttr.txt";
        public const string THREAD_HISTORY_LIST_FILE_NAME = @"\ThreadHistory.txt";
        const string THREAD_HISTORY_LIST_ATTR_FILE_NAME = @"\ThreadHistoryAttr.txt";

        public const string AES_NGWORD_FILE_NAME = @"\AesNgWord.txt";
        public const string AES_NGWORD_ATTR_FILE_NAME = @"\AesNgWordAttr.txt";
        public const string AES_NGID_FILE_NAME = @"\AesNgId.txt";
        public const string AES_NGID_ATTR_FILE_NAME = @"\AesNgIdAttr.txt";
        public const string AES_NGNAME_FILE_NAME = @"\AesNgName.txt";
        public const string AES_NGNAME_ATTR_FILE_NAME = @"\AesNgNameAttr.txt";

        public const string MOVIE_HISTORY_LIST_FILE_NAME = @"\MovieHistory.txt";

        /*public const string AES_EXTERNAL_BOARD_FILE_NAME = @"\AesExteranlBoard.txt";
        const string AES_EXTERNALBOARD_ATTR_FILE_NAME = @"\AesExternalBoardAttr.txt";
        public const string AES_THREAD_HISTORY_LIST_FILE_NAME = @"\AesThreadHistory.txt";
        const string AES_THREAD_HISTORY_LIST_ATTR_FILE_NAME = @"\AesThreadHistoryAttr.txt";*/


        static string mRootPath = null;
        //static byte[] mByteBuffer = new byte[1024*2];

        public static string getRootPath()
        {
            return mRootPath + PATH_PEPARATOR;
        }

        public static string getImageDir()
        {
            return getRootPath() + IMAGE_DIR + PATH_PEPARATOR;
        }

        public static string[] retrieveThreadHistoryList()
        {
            string path = mRootPath + THREAD_HISTORY_LIST_FILE_NAME;
            string[] results = null;
            try
            {
                results = File.ReadAllLines(path);
            }
            catch (Exception ex)
            {
                NTDebug.l(ex.Message);
            }
            return results;
        }

        public static void writeThreadHistoryList(string[] threadDescriptions)
        {
            string path = mRootPath + THREAD_HISTORY_LIST_FILE_NAME;
            try
            {
                File.WriteAllLines(path, threadDescriptions);
            }
            catch (Exception e)
            {
                NTDebug.l(e.Message);
            }
        }

        public static string[] retrieveExternalBoards()
        {
            string path = mRootPath + EXTERNAL_BOARD_FILE_NAME;
            string[] results = null;
            try
            {
                results = File.ReadAllLines(path);
            }
            catch (Exception ex)
            {
                NTDebug.l(ex.Message);
            }
            return results;
        }

        public static void writeExternalBoards(string [] externalBoards)
        {
            string path = mRootPath + EXTERNAL_BOARD_FILE_NAME;
            try
            {
                File.WriteAllLines(path, externalBoards);
            }
            catch (Exception e)
            {
                NTDebug.l(e.Message);
            }
        }

        public static void appendExternalBoard(string boardDiscription)
        {
            string path = mRootPath + EXTERNAL_BOARD_FILE_NAME;
            FileStream fs = null;
            StreamWriter sw = null;
            try
            {
                fs = File.Open(path, FileMode.Append, FileAccess.Write);
                sw = new StreamWriter(fs);
                sw.WriteLine(boardDiscription);
                sw.Flush();
                fs.Flush();
            }
            catch (Exception e)
            {
                NTDebug.l(e.Message);
            }
            finally
            {
                if (null != sw)
                    sw.Close();
                if (null != fs)
                    fs.Close();
            }
        }

        public static void ntWriteNgWordsToFile(List<string> list)
        {
            string path;
            if(NTUserPreference.AESEnabled)
                path = mRootPath + AES_NGWORD_FILE_NAME;
            else
                path = mRootPath + NGWORD_FILE_NAME;
            
            int len = list.Count;
            List<string> arr = new List<string>();
            for (int i = 0; i < len; i++)
            {
                string s = list[i].Trim();
                if (s.Length == 0)
                    continue;
                if (NTUserPreference.AESEnabled)
                    s = NTTextUtiles.aesEncodeBase64URL(s);
                else
                    s = NTTextUtiles.encodeBase64URL(s);
                arr.Add(s);
            }
            File.WriteAllLines(path, arr.ToArray());
        }
        public static void ntWriteNgIdsToFile(List<string> list)
        {
            string path;
            if(NTUserPreference.AESEnabled)
                path = mRootPath + AES_NGID_FILE_NAME;
            else
                path = mRootPath + NGID_FILE_NAME;
            
            int len = list.Count;
            List<string> arr = new List<string>();
            for (int i = 0; i < len; i++)
            {
                string s = list[i].Trim();
                if (s.Length == 0)
                    continue;
                if (NTUserPreference.AESEnabled)
                    s = NTTextUtiles.aesEncodeBase64URL(s);
                else
                    s = NTTextUtiles.encodeBase64URL(s);
                arr.Add(s);
            }
            File.WriteAllLines(path, arr.ToArray());
        }
        public static void ntWriteNgNamesToFile(List<string> list)
        {
            string path;
            if(NTUserPreference.AESEnabled)
                path = mRootPath + AES_NGNAME_FILE_NAME;
            else
                path = mRootPath + NGNAME_FILE_NAME;
            
            int len = list.Count;
            List<string> arr = new List<string>();
            for (int i = 0; i < len; i++)
            {
                string s = list[i].Trim();
                if (s.Length == 0)
                    continue;
                if(NTUserPreference.AESEnabled)
                    s = NTTextUtiles.aesEncodeBase64URL(s);
                else
                    s = NTTextUtiles.encodeBase64URL(s);
                    
                arr.Add(s);
            }
            File.WriteAllLines(path, arr.ToArray());
        }

        public static void saveCookie(List<KeyValuePair<string, string>> list, string host)
        {
            string cookieDirPath = mRootPath + COOKIE_DIR_NAME;

            DirectoryInfo dir = new DirectoryInfo(cookieDirPath);
            if (!dir.Exists)
                dir.Create();

            //if (host == null)
            //    host = COOKIE_ROOT_NAME;

            string filePath = cookieDirPath + PATH_PEPARATOR + host;

            FileStream fs = null;
            StreamWriter sw = null;

            try
            {
                fs = new FileStream(filePath, FileMode.Create, FileAccess.Write);
                sw = new StreamWriter(fs);

                foreach (KeyValuePair<string, string> pair in list)
                {
                    string key = pair.Key;
                    string value = pair.Value;
                    if (key != null && value != null)
                        sw.WriteLine(key + "=" + value);
                }
                sw.Flush();
                fs.Flush();
            }
            finally
            {
                if (null != sw)
                    sw.Close();
                if (null != fs)
                    fs.Close();
            }
        }

        public static List<KeyValuePair<string, string>> retrieveCookie(string host)
        {

            List<KeyValuePair<string, string>> result 
                = new List<KeyValuePair<string, string>>();

            string cookieDirPath = mRootPath + COOKIE_DIR_NAME;

            DirectoryInfo dir = new DirectoryInfo(cookieDirPath);
            if (!dir.Exists)
                dir.Create();

            
            string filePath = cookieDirPath + PATH_PEPARATOR + host;

            FileStream fs = null;
            StreamReader sr = null;

            try
            {
                fs = new FileStream(filePath, FileMode.Open, FileAccess.Read);
                sr = new StreamReader(fs);

                string line;
                while (null != (line = sr.ReadLine()))
                {
                    int idx = line.IndexOf("=");
                    if (idx < 0)
                        continue;

                    string key = line.Substring(0, idx);
                    string value = line.Substring(idx + 1);
                    KeyValuePair<string, string> pair = new KeyValuePair<string, string>(key, value);
                    result.Add(pair);
                }
            }
            catch(Exception e)
            {
                NTDebug.l(e.Message);
            }
            finally
            {
                if (null != sr)
                    sr.Close();
                if (null != fs)
                    fs.Close();
            }
            return result;
        }



        public static bool init(string rootPath)
        {
            bool bRet = false;
            try
            {
                NTPersistentFileAccess.init(rootPath);
                mRootPath = rootPath + ROOTDIR_NAME;
                DirectoryInfo dir = new DirectoryInfo(mRootPath);
                if (!dir.Exists)
                    dir.Create();

                bRet = true;
            }
            catch (Exception e)
            {
                NTDebug.l(e.Message);
            }
            finally
            {
            }
            return bRet;


        }

        public static void storeBoardMenuAttrToFile(string attr)
        {
            string boardPath = mRootPath + BOARDMENU_DIR_NAME;
            DirectoryInfo dir = new DirectoryInfo(boardPath);
            if (!dir.Exists)
                dir.Create();

            string boardAttrFileAbsolutePath = boardPath + BOARDMENU_ATTR_FILE_NAME;

            File.WriteAllText(boardAttrFileAbsolutePath, attr);
        }
        public static bool storeBoardMenuDataToFile(Stream stream)
        {
            string boardPath = mRootPath + BOARDMENU_DIR_NAME;
            byte[] bBuf = new byte[1024 * 2];
            FileStream fStream = null;
            bool bRet = false;
            try
            {
                DirectoryInfo dir = new DirectoryInfo(boardPath);
                if (!dir.Exists)
                    dir.Create();

                string boardFileAbsolutePath = boardPath + BOARDMENU_FILE_NAME;
                fStream = File.Open(boardFileAbsolutePath, FileMode.Create, FileAccess.Write);
                int numRead;
                while (0 < (numRead = stream.Read(bBuf, 0, bBuf.Length)))
                {
                    fStream.Write(bBuf, 0, numRead);
                }
                bRet = true;
            }
            catch (Exception e)
            {
                NTDebug.l(e.Message);
            }
            finally
            {
                if (null != fStream)
                    fStream.Close();
            }
            return bRet;
        }

        public static string retrieveBoardMenuAttrFromFile()
        {
            string boardPath = mRootPath + BOARDMENU_DIR_NAME;
            string retStr = null;
            DirectoryInfo dir = new DirectoryInfo(boardPath);
            if (!dir.Exists)
                return null;

            string boardAttrFileAbsolutePath = boardPath + BOARDMENU_ATTR_FILE_NAME;

            try
            {
                retStr = File.ReadAllText(boardAttrFileAbsolutePath);
            }
            catch
            {
            }
            return retStr;
        }
        public static string retrieveBoardMenuDataFromFile()
        {
            string retStr = null;
            string boardPath = mRootPath + BOARDMENU_DIR_NAME;
            FileStream fStream = null;
            StreamReader sr = null;

            try
            {
                Encoding enc = Encoding.GetEncoding(NTAppState.HOST_2CH_ENCODING);

                DirectoryInfo dir = new DirectoryInfo(boardPath);
                if (!dir.Exists)
                    return null;
                
                string boardFileAbsolutePath = boardPath + BOARDMENU_FILE_NAME;
                fStream = File.OpenRead(boardFileAbsolutePath);
                sr = new StreamReader(fStream, enc);
                retStr = sr.ReadToEnd();
                
            }
            catch (Exception e)
            {
                NTDebug.l(e.Message);
            }
            finally
            {
                if (null != fStream)
                    fStream.Close();
                if (null != sr)
                    sr.Close();
            }

            return retStr;
        }

        public static string retrieveSubjectAttrFromFile(string boardName)
        {
            string subjectPath = mRootPath + PATH_PEPARATOR + boardName;
            string retStr = null;
            DirectoryInfo dir = new DirectoryInfo(subjectPath);
            if (!dir.Exists)
                return null;

            string subjectAttrFileAbsolutePath = subjectPath + SUBJECT_ATTR_FILE_NAME;

            try
            {
                retStr = File.ReadAllText(subjectAttrFileAbsolutePath);
            }
            catch
            {
            }
            return retStr;
        }
        public static void storeSubjectAttrToFile(string ifMod, string boardName)
        {
            string subjectPath = mRootPath + PATH_PEPARATOR + boardName;
            DirectoryInfo dir = new DirectoryInfo(subjectPath);
            if (!dir.Exists)
                dir.Create();

            string subjectAttrFileAbsolutePath = subjectPath + SUBJECT_ATTR_FILE_NAME;

            File.WriteAllText(subjectAttrFileAbsolutePath, ifMod);

        }

        public static bool storeSubjectDataToFile(Stream stream, string boardName)
        {
            string subjectPath = mRootPath + PATH_PEPARATOR + boardName;
            FileStream fStream = null;
            bool bRet = false;
            byte[] bBuf = new byte[1024 * 2];
            try
            {
                DirectoryInfo dir = new DirectoryInfo(subjectPath);
                if (!dir.Exists)
                    dir.Create();

                string boardFileAbsolutePath = subjectPath + SUBJECT_TXT_FILE_NAME;
                fStream = File.Open(boardFileAbsolutePath, FileMode.Create, FileAccess.Write);
                int numRead;
                while (0 < (numRead = stream.Read(bBuf, 0, bBuf.Length)))
                {
                    fStream.Write(bBuf, 0, numRead);
                }
                fStream.Flush();
                bRet = true;
            }
            catch (Exception e)
            {
                NTDebug.l(e.Message);
            }
            finally
            {
                if (null != fStream)
                    fStream.Close();
            }
            return bRet;
        }

        public static bool isSubjectExsists(string boardName)
        {

            string path = mRootPath + PATH_PEPARATOR + boardName + SUBJECT_TXT_FILE_NAME;
            FileInfo info = new FileInfo(path);
            return info.Exists;
        }

        public static void deleteCloudLastModified()
        {
            FileInfo fi = new FileInfo(mRootPath + FAVORITE_BOARD_ATTR_FILE_NAME);
            fi.Delete();
            fi = new FileInfo(mRootPath + FAVORITE_THREAD_ATTR_FILE_NAME);
            fi.Delete();
            fi = new FileInfo(mRootPath + FAVORITE_THREAD_TAG_ATTR_FILE_NAME);
            fi.Delete();
            fi = new FileInfo(mRootPath + AES_FAVORITE_BOARD_ATTR_FILE_NAME);
            fi.Delete();
            fi = new FileInfo(mRootPath + AES_FAVORITE_THREAD_ATTR_FILE_NAME);
            fi.Delete();
            fi = new FileInfo(mRootPath + AES_FAVORITE_THREAD_TAG_ATTR_FILE_NAME);
            fi.Delete();
            fi = new FileInfo(mRootPath + NGWORD_ATTR_FILE_NAME);
            fi.Delete();
            fi = new FileInfo(mRootPath + NGID_ATTR_FILE_NAME);
            fi.Delete();
            fi = new FileInfo(mRootPath + NGNAME_ATTR_FILE_NAME);
            fi.Delete();
            fi = new FileInfo(mRootPath + EXTERNALBOARD_ATTR_FILE_NAME);
            fi.Delete();
            fi = new FileInfo(mRootPath + THREAD_HISTORY_LIST_ATTR_FILE_NAME);
            fi.Delete();
            fi = new FileInfo(mRootPath + AES_NGWORD_ATTR_FILE_NAME);
            fi.Delete();
            fi = new FileInfo(mRootPath + AES_NGID_ATTR_FILE_NAME);
            fi.Delete();
            fi = new FileInfo(mRootPath + AES_NGNAME_ATTR_FILE_NAME);
            fi.Delete();        
        }

        public static string retrieveSubjectDataFromFile(string boardName)
        {
            string retStr = null;
            string subjectPath = mRootPath + PATH_PEPARATOR + boardName;
            FileStream fStream = null;
            StreamReader sr = null;

            try
            {
                Encoding enc = Encoding.GetEncoding(NTAppState.HOST_2CH_ENCODING);

                DirectoryInfo dir = new DirectoryInfo(subjectPath);
                if (!dir.Exists)
                    return null;

                string boardFileAbsolutePath = subjectPath + SUBJECT_TXT_FILE_NAME;
                fStream = File.OpenRead(boardFileAbsolutePath);
                sr = new StreamReader(fStream, enc);
                retStr = sr.ReadToEnd();

            }
            catch (Exception e)
            {
                NTDebug.l(e.Message);
            }
            finally
            {
                if (null != fStream)
                    fStream.Close();
                if (null != sr)
                    sr.Close();
            }

            return retStr;
        }

        public static string ridSuffixFromDatName(string datName)
        {
            int n1 = datName.IndexOf(".dat");
            if (n1 >= 0)
                datName = datName.Substring(0, n1);
            n1 = datName.IndexOf(".cgi");
            if (n1 >= 0)
                datName = datName.Substring(0, n1);
            return datName;
        }


        public static string[] retrieveDatAttrBinFromFile(string boardName, string datName)
        {
            datName = ridSuffixFromDatName(datName);

            string[] retStr = null;
            string datPath = mRootPath + PATH_PEPARATOR + boardName + PATH_PEPARATOR + datName;
            
            string datAttrPath = datPath + DAT_ATTR_B_FILE_NAME;
            try
            {
                retStr = File.ReadAllLines(datAttrPath);
            }
            catch(Exception e)
            {
                NTDebug.l(e.Message);
            }
            return retStr;
        }

        public static bool addFavoriteBoardToFile(string boardDescription)
        {
            string path;
            if (NTUserPreference.AESEnabled)
            {
                path = mRootPath + AES_FAVORITE_BOARD_LIST_FILE_NAME;
                return aesAddFavoriteToFile(path, boardDescription);
            }
            else
            {
                path = mRootPath + FAVORITE_BOARD_LIST_FILE_NAME;
                return addFavoriteToFile(path, boardDescription);
            }            
        }

        public static bool updateFavoriteBoardToFile(string [] boardDescriptions)
        {
            string path;
            if (NTUserPreference.AESEnabled)
            {
                path = mRootPath + AES_FAVORITE_BOARD_LIST_FILE_NAME;
                return aesUpdateFavoritesToFile(path, boardDescriptions);
            }
            else
            {
                path = mRootPath + FAVORITE_BOARD_LIST_FILE_NAME;
                return updateFavoritesToFile(path, boardDescriptions);
            }
        }

        public static bool addFavoriteThreadToFile(string threadDescription)
        {
            string path;
            if (NTUserPreference.AESEnabled)
                path = mRootPath + AES_FAVORITE_THREAD_LIST_FILE_NAME;
            else
                path = mRootPath + FAVORITE_THREAD_LIST_FILE_NAME;
            return addFavoriteToFile(path, threadDescription);
        }
        public static bool addFavoriteThreadTagToFile(string threadDescription)
        {
            string path;
            if (NTUserPreference.AESEnabled)
                path = mRootPath + AES_FAVORITE_THREAD_TAG_LIST_FILE_NAME;
            else
                path = mRootPath + FAVORITE_THREAD_TAG_LIST_FILE_NAME;
            return addFavoriteToFile(path, threadDescription);
        }

        public static bool updateFavoriteThreadToFile(string[] threadDescriptions)
        {
            string path;
            if (NTUserPreference.AESEnabled)
                path = mRootPath + AES_FAVORITE_THREAD_LIST_FILE_NAME;
            else
                path = mRootPath + FAVORITE_THREAD_LIST_FILE_NAME;
            return updateFavoritesToFile(path, threadDescriptions);
        }
        public static bool updateFavoriteThreadTagToFile(string[] threadTagDescriptions)
        {
            string path;
            if (NTUserPreference.AESEnabled)
                path = mRootPath + AES_FAVORITE_THREAD_TAG_LIST_FILE_NAME;
            else
                path = mRootPath + FAVORITE_THREAD_TAG_LIST_FILE_NAME;
            return updateFavoritesToFile(path, threadTagDescriptions);
        }

        private static bool addFavoriteToFile(string path, string description)
        {
            string s = NTTextUtiles.encodeBase64URL(description);
            if(s.Length == 0)
                return false;

            FileStream fs = null;
            StreamWriter sw = null;
            bool bRet = false;
            try
            {
                fs = File.Open(path, FileMode.Append, FileAccess.Write);
                sw = new StreamWriter(fs);
                sw.WriteLine(s);
                sw.Flush();
                fs.Flush();
                bRet = true;
            }
            catch(Exception e)
            {
                NTDebug.l(e.Message);
            }
            finally
            {
                if (sw != null)
                    sw.Close();
                if (fs != null)
                    fs.Close();
            }
            return bRet;
         }

        private static bool aesAddFavoriteToFile(string path, string description)
        {
            string s = NTTextUtiles.aesEncodeBase64URL(description);
            if (s.Length == 0)
                return false;

            FileStream fs = null;
            StreamWriter sw = null;
            bool bRet = false;
            try
            {
                fs = File.Open(path, FileMode.Append, FileAccess.Write);
                sw = new StreamWriter(fs);
                sw.WriteLine(s);
                sw.Flush();
                fs.Flush();
                bRet = true;
            }
            catch (Exception e)
            {
                NTDebug.l(e.Message);
            }
            finally
            {
                if (sw != null)
                    sw.Close();
                if (fs != null)
                    fs.Close();
            }
            return bRet;
        }

        private static bool updateFavoritesToFile(string path, string [] descriptions)
        {
            
            if (descriptions == null)
                return false;

            FileStream fs = null;
            StreamWriter sw = null;
            bool bRet = false;
            try
            {
                fs = File.Open(path, FileMode.Create, FileAccess.Write);
                sw = new StreamWriter(fs);

                foreach (string description in descriptions)
                {
                    if (description == null || description.Length == 0)
                        continue;
                    string s = NTTextUtiles.encodeBase64URL(description);
                    sw.WriteLine(s);
                }

                sw.Flush();
                fs.Flush();
                bRet = true;
            }
            catch (Exception e)
            {
                NTDebug.l(e.Message);
            }
            finally
            {
                if (sw != null)
                    sw.Close();
                if (fs != null)
                    fs.Close();
            }
            return bRet;
        }

        private static bool aesUpdateFavoritesToFile(string path, string[] descriptions)
        {

            if (descriptions == null)
                return false;

            FileStream fs = null;
            StreamWriter sw = null;
            bool bRet = false;
            try
            {
                fs = File.Open(path, FileMode.Create, FileAccess.Write);
                sw = new StreamWriter(fs);

                foreach (string description in descriptions)
                {
                    if (description == null || description.Length == 0)
                        continue;
                    string s = NTTextUtiles.aesEncodeBase64URL(description);
                    sw.WriteLine(s);
                }

                sw.Flush();
                fs.Flush();
                bRet = true;
            }
            catch (Exception e)
            {
                NTDebug.l(e.Message);
            }
            finally
            {
                if (sw != null)
                    sw.Close();
                if (fs != null)
                    fs.Close();
            }
            return bRet;
        }

        
        
        
        public static bool storeFavoriteBoardsToFile(Stream stream, string ifModified, bool append)
        {
            if (NTUserPreference.AESEnabled)
                return storeFavoritesToFile(stream, ifModified, append,
                    AES_FAVORITE_BOARD_LIST_FILE_NAME, AES_FAVORITE_BOARD_ATTR_FILE_NAME);
            else
                return storeFavoritesToFile(stream, ifModified, append,
                    FAVORITE_BOARD_LIST_FILE_NAME, FAVORITE_BOARD_ATTR_FILE_NAME);

        }
        public static bool storeFavoriteThreadsToFile(Stream stream, string ifModified, bool append)
        {
            if (NTUserPreference.AESEnabled)
                return storeFavoritesToFile(stream, ifModified, append,
                    AES_FAVORITE_THREAD_LIST_FILE_NAME, AES_FAVORITE_THREAD_ATTR_FILE_NAME);
            else
                return storeFavoritesToFile(stream, ifModified, append,
                    FAVORITE_THREAD_LIST_FILE_NAME, FAVORITE_THREAD_ATTR_FILE_NAME);

        }

        public static bool storeFavoriteThreadTagToFile(Stream stream, string ifModified, bool append)
        {
            if (NTUserPreference.AESEnabled)
                return storeFavoritesToFile(stream, ifModified, append,
                    AES_FAVORITE_THREAD_TAG_LIST_FILE_NAME, AES_FAVORITE_THREAD_TAG_ATTR_FILE_NAME);
            else
                return storeFavoritesToFile(stream, ifModified, append,
                    FAVORITE_THREAD_TAG_LIST_FILE_NAME, FAVORITE_THREAD_TAG_ATTR_FILE_NAME);

        }

        public static bool StreamToFile(string path, Stream st)
        {
            FileStream fStream = null;
            bool bRet = false;
            try
            {
                fStream = File.Open(path, FileMode.Create, FileAccess.Write);

                int numRead;
                byte[] buf = new byte[1024];
                while (0 < (numRead = st.Read(buf, 0, buf.Length)))
                {
                    fStream.Write(buf, 0, numRead);
                }

                fStream.Flush();
                fStream.Close();
                fStream = null;

                bRet = true;
            }
            catch (Exception e)
            {
                NTDebug.l(e.Message);
            }
            finally
            {
                if (null != fStream)
                    fStream.Close();
            }
            return bRet;

        }

        public static bool storeExternalBoardsToFile(Stream stream, string ifModified)
        {
            FileStream fs = null;
            StreamWriter sw = null;
            bool bRet = false;
            try
            {
                string path = mRootPath + EXTERNAL_BOARD_FILE_NAME;
                fs = File.Open(path, FileMode.Create, FileAccess.Write);
                sw = new StreamWriter(fs);



                StreamReader sr = new StreamReader(stream);
                string line;
                while (null != (line = sr.ReadLine()))
                {
                    string decord;
                    if(NTUserPreference.AESEnabled)
                        decord = NTTextUtiles.aesDecodeBase64URL(line);
                    else
                        decord = NTTextUtiles.decodeBase64URL(line);
                    
                    sw.WriteLine(decord);

                }
                sw.Flush();
                fs.Flush();
 
                if (ifModified != null)
                {
                    string attrPath = mRootPath + EXTERNALBOARD_ATTR_FILE_NAME;
                    NTFileAccess.storeAttrToFile(attrPath, ifModified);
                }

                bRet = true;
            }
            catch (Exception e)
            {
                NTDebug.l(e.Message);
            }
            finally
            {
                if (null != sw)
                    sw.Close();
                if (null != fs)
                    fs.Close();
            }
            return bRet;
        }

        public static bool storeThreadHistoryListToFile(Stream stream, string ifModified)
        {
            FileStream fs = null;
            StreamWriter sw = null;
            bool bRet = false;
            try
            {
                string path;
                string attrPath;
                path = mRootPath + THREAD_HISTORY_LIST_FILE_NAME;
                attrPath = mRootPath + THREAD_HISTORY_LIST_ATTR_FILE_NAME;
                
                    fs = File.Open(path, FileMode.Create, FileAccess.Write);
                sw = new StreamWriter(fs);



                StreamReader sr = new StreamReader(stream);
                string line;
                while (null != (line = sr.ReadLine()))
                {
                    string decord;
                    if(NTUserPreference.AESEnabled)
                        decord = NTTextUtiles.aesDecodeBase64URL(line);
                    else
                        decord = NTTextUtiles.decodeBase64URL(line);
                    
                    sw.WriteLine(decord);

                }
                sw.Flush();
                fs.Flush();

                if (ifModified != null)
                {                    
                    NTFileAccess.storeAttrToFile(attrPath, ifModified);
                }

                bRet = true;
            }
            catch (Exception e)
            {
                NTDebug.l(e.Message);
            }
            finally
            {
                if (null != sw)
                    sw.Close();
                if (null != fs)
                    fs.Close();
            }
            return bRet;
        }
 
        static bool storeFavoritesToFile(Stream stream, string ifModified, bool append, string fileName, string attrFile)
        {
            FileStream fStream = null;
            bool bRet = false;
            try
            {
                string path = mRootPath + fileName;
                FileMode mode;
                if (append)
                {
                    mode = FileMode.Append;
                }
                else
                {
                    mode = FileMode.Create;
                }
                fStream = File.Open(path, mode, FileAccess.Write);

                int numRead;
                byte[] buf = new byte[1024];
                while (0 < (numRead = stream.Read(buf, 0, buf.Length)))
                {
                    fStream.Write(buf, 0, numRead);
                }

                fStream.Flush();
                fStream.Close();
                fStream = null;


                if (ifModified != null)
                {
                    string attrPath = mRootPath + attrFile;
                    //FileInfo info = new FileInfo(path);
                    NTFileAccess.storeAttrToFile(attrPath, ifModified);
                }

                bRet = true;
            }
            catch (Exception e)
            {
                NTDebug.l(e.Message);
            }
            finally
            {
                if (null != fStream)
                    fStream.Close();
            }
            return bRet;
        }

        public static string retrieveNgWordFromFile()
        {
            string path;
            if(NTUserPreference.AESEnabled)
                path = mRootPath + AES_NGWORD_FILE_NAME;
            else
                path = mRootPath + NGWORD_FILE_NAME;
            
            return retrieveTextFromFile(path);
        }
        public static string retrieveNgIdFromFile()
        {
            string path;
            if(NTUserPreference.AESEnabled)
                path = mRootPath + AES_NGID_FILE_NAME;
            else
                path = mRootPath + NGID_FILE_NAME;
            return retrieveTextFromFile(path);
        }
        public static string retrieveNgNameFromFile()
        {
            string path;
            if(NTUserPreference.AESEnabled)
                path = mRootPath + AES_NGNAME_FILE_NAME;
            else
                path = mRootPath + NGNAME_FILE_NAME;
            return retrieveTextFromFile(path);
        }

        public static string retrieveFavoriteBoardFromFile()
        {
            string path;
            if(NTUserPreference.AESEnabled)
                path = mRootPath + AES_FAVORITE_BOARD_LIST_FILE_NAME;
            else
                path = mRootPath + FAVORITE_BOARD_LIST_FILE_NAME;
            
            return retrieveTextFromFile(path);
        }
        public static string [] retrieveFavoriteThreadFromFile()
        {
            string[] result = new string[2]; 
            string path;
            if(NTUserPreference.AESEnabled)
                path = mRootPath + AES_FAVORITE_THREAD_LIST_FILE_NAME;
            else
                path = mRootPath + FAVORITE_THREAD_LIST_FILE_NAME;

            result[0] = retrieveTextFromFile(path);

            if (NTUserPreference.AESEnabled)
                path = mRootPath + AES_FAVORITE_THREAD_TAG_LIST_FILE_NAME;
            else
                path = mRootPath + FAVORITE_THREAD_TAG_LIST_FILE_NAME;

            result[1] = retrieveTextFromFile(path);

            return result;
        }


        static string retrieveTextFromFile(string path)
        {
            string retStr = string.Empty;
            FileStream fStream = null;
            StreamReader sr = null;

            try
            {
                Encoding enc = Encoding.GetEncoding(NTAppState.HOST_2CH_ENCODING);

                fStream = File.OpenRead(path);
                sr = new StreamReader(fStream, enc);
                retStr = sr.ReadToEnd();

            }
            catch (Exception e)
            {
                NTDebug.l(e.Message);
            }
            finally
            {
                if (null != fStream)
                    fStream.Close();
                if (null != sr)
                    sr.Close();
            }

            return retStr;
        }

        public static bool retrieveExternalBoardAttrFromFile(out string ifModified)
        {
            string path = mRootPath + EXTERNALBOARD_ATTR_FILE_NAME;
            return retrieveAttrFromFile(path, out ifModified);
        }
        public static bool retrieveThreadHistoryListAttrFromFile(out string ifModified)
        {
            string path;
            path = mRootPath + THREAD_HISTORY_LIST_ATTR_FILE_NAME;       
            return retrieveAttrFromFile(path, out ifModified);
        }
        public static bool retrieveFavoriteBoardAttrFromFile(out string ifModified)
        {
            string path;
            if(NTUserPreference.AESEnabled)
                path = mRootPath + AES_FAVORITE_BOARD_ATTR_FILE_NAME;
            else
                path = mRootPath + FAVORITE_BOARD_ATTR_FILE_NAME;
            
            return retrieveAttrFromFile(path, out ifModified);
        }
        public static bool retrieveFavoriteThreadAttrFromFile(out string ifModified)
        {
            string path;
            if (NTUserPreference.AESEnabled)
                path = mRootPath + AES_FAVORITE_THREAD_ATTR_FILE_NAME;
            else
                path = mRootPath + FAVORITE_THREAD_ATTR_FILE_NAME;

            return retrieveAttrFromFile(path, out ifModified);
        }
        public static bool retrieveFavoriteThreadTagAttrFromFile(out string ifModified)
        {
            string path;
            if (NTUserPreference.AESEnabled)
                path = mRootPath + AES_FAVORITE_THREAD_TAG_ATTR_FILE_NAME;
            else
                path = mRootPath + FAVORITE_THREAD_TAG_ATTR_FILE_NAME;

            return retrieveAttrFromFile(path, out ifModified);
        }

        public static void storeAttrToFile(string path, string ifModified)
        {
            string[] attr = new string[1];
            attr[0] = ifModified;
            //attr[1] = fileSize.ToString();
            File.WriteAllLines(path, attr);
        }

        public static bool retrieveAttrFromFile(string path , out string ifModified)
        {
            bool bRet = false;
            ifModified = string.Empty;
            //fileSize = 0;
            try
            {
                string [] lines = File.ReadAllLines(path);
                if (lines.Length < 1)
                    return false;
                ifModified = lines[0];
                //fileSize = int.Parse(lines[1]);
                bRet = true;
            }
            catch (Exception e)
            {
                NTDebug.l(e.Message);
            }
            return bRet;
        }

        public static List<string> getStoredDat(string boardName)
        {
            List<string> list = new List<string>();

            string path = mRootPath + PATH_PEPARATOR + boardName;
            DirectoryInfo dInfo = new DirectoryInfo(path);
            try
            {
                DirectoryInfo[] dArr = dInfo.GetDirectories();
                foreach (DirectoryInfo info in dArr)
                {
                    list.Add(info.Name);
                }
            }
            catch (DirectoryNotFoundException ex)
            {
                NTDebug.l(ex.Message);
            }
            return list;
        }

        static void storeDatAttrBinToFile(string path, string title, string ifModified, long fileSize)
        {
            string datAttrPath = path + DAT_ATTR_B_FILE_NAME;
            string[] attr = new string[3];
            attr[0] = title;
            attr[1] = ifModified;
            attr[2] = fileSize.ToString();
 
            File.WriteAllLines(datAttrPath, attr);
       }

        public static bool retrieveDatAttrToFile(string boardName, string datName, 
            out int numRead, out int[] writeIndexies, out int[] bookmarkedIndexies , out string lastWriteDateTime)
        {
            bool bRet = false;
            string[] retStr = null;
            string datAttrPath = mRootPath + PATH_PEPARATOR + boardName + PATH_PEPARATOR
                + ridSuffixFromDatName(datName) + DAT_ATTR_FILE_NAME;
            numRead = -1;
            writeIndexies = NTTextUtiles.EMPTY_INT_ARRAY;
            bookmarkedIndexies = NTTextUtiles.EMPTY_INT_ARRAY;

            lastWriteDateTime = string.Empty;
            try{
                FileInfo fInfo = new FileInfo(datAttrPath);
                DateTime dt = fInfo.LastWriteTime;
                lastWriteDateTime = dt.ToString();
            }catch//(Exception e)
            {
                //NTDebug.l(e.Message);
            }

            try
            {
                retStr = File.ReadAllLines(datAttrPath);
                if (retStr.Length < 3)
                    throw new Exception();

                numRead = int.Parse(retStr[0]);
                writeIndexies = NTTextUtiles.extructCommaSepLineFromInt(retStr[1]);
                bookmarkedIndexies = NTTextUtiles.extructCommaSepLineFromInt(retStr[2]);

                bRet = true;
            }
            catch //(Exception e)
            {
                //NTDebug.l(e.Message);
            }
            return bRet;
        }
        public static void storeDatAttrToFile(string boardName, string datName, int numRead, int[] writeIndexies, int[] bookmarkedIndexies)
        {
            //datName = ridSuffixFromDatName(datName);
            //datName = ridSuffixFromDatName
            string datAttrPath = mRootPath + PATH_PEPARATOR + boardName + PATH_PEPARATOR
                + ridSuffixFromDatName(datName) + DAT_ATTR_FILE_NAME;
            string[] attr = new string[3];
            attr[0] = numRead.ToString();
            attr[1] = NTTextUtiles.constructCommaSepLineFromInt(writeIndexies);
            attr[2] = NTTextUtiles.constructCommaSepLineFromInt(bookmarkedIndexies);
            try
            {
                File.WriteAllLines(datAttrPath, attr);
            }
            catch { }
        }

        public static bool storeDatTitle(string boardName, string datName, string title)
        {
            datName = ridSuffixFromDatName(datName);
            bool bRet = false;
            string[] arr = retrieveDatAttrBinFromFile(boardName, datName);
            if(arr != null && arr.Length > 2){
                arr[0] = title;
                string datPath = mRootPath + PATH_PEPARATOR + boardName + PATH_PEPARATOR + datName;
                int nRet;
                if (int.TryParse(arr[2], out nRet))
                {
                    storeDatAttrBinToFile(datPath, title, arr[1], nRet);
                    bRet = true;
                }
            }
            return bRet;
        }
        
        public static bool storeDatToFile(Stream stream, string boardName, 
            string datName,  string title, string ifModified, bool append)
        {
            string datPath = mRootPath + PATH_PEPARATOR + boardName + PATH_PEPARATOR + datName;
            FileStream fStream = null;
            bool bRet = false;
            byte[] bBuf = new byte[1024 * 2];
            try
            {
                DirectoryInfo dir = new DirectoryInfo(datPath);
                if (!dir.Exists)
                    dir.Create();

                string datFileAbsolutePath = datPath + DAT_FILE_NAME;

                FileMode mode;
                if (append)
                {
                    mode = FileMode.Append;
                }
                else
                {
                    mode = FileMode.Create;
                }
                fStream = File.Open(datFileAbsolutePath, mode, FileAccess.Write);

                int numRead;
                while (0 < (numRead = stream.Read(bBuf, 0, bBuf.Length)))
                {
                    fStream.Write(bBuf, 0, numRead);
                }

                fStream.Flush();
                fStream.Close();
                fStream = null;


                if (ifModified != null)
                {
                    FileInfo info = new FileInfo(datFileAbsolutePath);
                    storeDatAttrBinToFile(datPath, title, ifModified, info.Length);
                }

                bRet = true;
            }
            catch (Exception e)
            {
                NTDebug.l(e.Message);
            }
            finally
            {
                if (null != fStream)
                    fStream.Close();
            }
            return bRet;
        }

        public static bool isDatExsists(string boardName, string datName)
        {

            string path = mRootPath + PATH_PEPARATOR + boardName + PATH_PEPARATOR + datName;
            FileInfo info = new FileInfo(path);
            return info.Exists;
        }
        public static void deleteDatDir(string boardName, string datName)
        {
            datName = ridSuffixFromDatName(datName);

            string path = mRootPath + PATH_PEPARATOR + boardName + PATH_PEPARATOR + datName;
            DirectoryInfo info = new DirectoryInfo(path);
            if(info.Exists)
            {
                info.Delete(true);
            }
        }

        public static void deleteBoardDir(string boardName)
        {

            string path = mRootPath + PATH_PEPARATOR + boardName;
            DirectoryInfo info = new DirectoryInfo(path);
            if (info.Exists)
            {
                info.Delete(true);
            }
        }

        public static string retrieveTitleFromDat(string source)
        {
            string[] lines = NTTextUtiles.splitLine(source);
            foreach (string line in lines)
            {
                string line1 = line.Trim();
                int idx = line1.LastIndexOf("<>");
                if (idx >= 0)
                {
                    if (idx < (line1.Length - 2))
                    {
                        return line1.Substring(idx + 2);
                    }
                    return null;
                }
            }
            return null;
        }

        public static string retrieveDatFromFile(string boardName, string datName)
        {
            datName = ridSuffixFromDatName(datName);

            string retStr = null;
            string datPath = mRootPath + PATH_PEPARATOR + boardName + PATH_PEPARATOR + datName;
            FileStream fStream = null;
            StreamReader sr = null;

            try
            {
                Encoding enc = Encoding.GetEncoding(NTAppState.HOST_2CH_ENCODING);

                DirectoryInfo dir = new DirectoryInfo(datPath);
                if (!dir.Exists)
                    return null;

                string boardFileAbsolutePath = datPath + DAT_FILE_NAME;
                fStream = File.OpenRead(boardFileAbsolutePath);
                sr = new StreamReader(fStream, enc);
                retStr = sr.ReadToEnd();

            }
            catch (Exception e)
            {
                NTDebug.l(e.Message);
            }
            finally
            {
                if (null != fStream)
                    fStream.Close();
                if (null != sr)
                    sr.Close();
            }

            return retStr;
        }

        public static string[] retrieveMovieHistory()
        {
            string path = mRootPath + MOVIE_HISTORY_LIST_FILE_NAME;
            
            FileInfo fInfo = new FileInfo(path);
            if (!fInfo.Exists)
            {
                return new string[0];
            }
            else
            {
                return retrieveLinesFile(path);
            }

        }

        public static bool storeMovieHistory(string[] lines)
        {
            string path = mRootPath + MOVIE_HISTORY_LIST_FILE_NAME;
            return NTFileAccess.sotreLinesFile(path, lines);
        }


        public static string[] retrieveLinesFile(string fileName)
        {
            string[] ret = null;
            try
            {
                ret = File.ReadAllLines(fileName);
            }
            catch (Exception e)
            {
                NTDebug.l(e.Message);
            }
            return ret;
        }

        public static bool sotreLinesFile(string fileName, string[] lines)
        {
            if (lines == null)
                return false;

            bool ret = false;
            try
            {
                File.WriteAllLines(fileName, lines);
                ret = true;
            }
            catch (Exception e)
            {
                NTDebug.l(e.Message);
            }
            return ret;
        }
    }
}
