﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using NT2chView.NtFile;
using NT2chView.NtNet;

namespace NT2chView
{
    public sealed class NTFavorite
    {

        List<NTFavoriteBoard> mBoardList = new List<NTFavoriteBoard>();
        List<NTFavoriteThread> mThreadList = new List<NTFavoriteThread>();
        List<NTFavoriteThreadTag> mThreadTagList = new List<NTFavoriteThreadTag>();

        
        public NTFavorite()
        { 
        
        }

        public int findBoard(string boardName)
        {
            int cnt = mBoardList.Count;
            for (int i = 0; i < cnt; i++)
            {
                if (mBoardList[i].BoardName.Equals(boardName))
                    return i;
            }
            return -1;
        }

        public int findThread(NTFavoriteThread thread)
        {
            int cnt = mThreadList.Count;
            for (int i = 0; i < cnt; i++)
            {
                if (mThreadList[i].Equals(thread))
                {
                    return i;
                }
            }
            return -1;
        }

        public int findThread(string boardName,
            string address, string title)
        {
            int cnt = mThreadList.Count;
            for (int i = 0; i < cnt; i++)
            {
                if (mThreadList[i].BoardName.Equals(boardName) &&
                    mThreadList[i].Address.Equals(address) &&
                    mThreadList[i].Title.Equals(title))
                {
                    return i;
                }
            }
            return -1;
        }

        public NTFavoriteThreadTag findTag(string tagName)
        {
            foreach (NTFavoriteThreadTag tag in mThreadTagList)
            {
                if (tag.getTagName().Equals(tagName))
                    return tag;
            }
            return null;
        }

        public NTFavoriteThreadTag findTag(NTFavoriteThread thread)
        {
            foreach (NTFavoriteThreadTag tag in mThreadTagList)
            {
                List<NTFavoriteThread> threadList = tag.getThreadList();
                foreach (NTFavoriteThread ft in threadList)
                {
                    if(ft.Equals(thread))
                        return tag;
                }
            }
            return null;
        }

        public List<NTFavoriteBoard> getBoardList()
        {
            return mBoardList;
        }

        public List<NTFavoriteThread> getThreadList()
        {
            return mThreadList;
        }

        public List<NTFavoriteThreadTag> getThreadTagList()
        {
            return mThreadTagList;
        }

        public void parseBoardList(string boardList)
        {
            string[] lines = NTTextUtiles.splitLine(boardList);
            foreach (string line in lines)
            {
                addBoardByDescription(line, true);
            }
        }

        public NTFavoriteBoard addBoardByDescription(string boardDescriptiont, bool doEncode)
        {
            if (boardDescriptiont.Trim().Length == 0)
                    return null;
            NTFavoriteBoard fb = null;
            if (doEncode)
            {
                string decSrc;
                if(NTUserPreference.AESEnabled)
                    decSrc = NTTextUtiles.aesDecodeBase64URL(boardDescriptiont);
                else
                    decSrc = NTTextUtiles.decodeBase64URL(boardDescriptiont);
                
                fb = new NTFavoriteBoard(decSrc);
            }
            else
            {
                fb = new NTFavoriteBoard(boardDescriptiont);
            }
            if(fb != null)
                mBoardList.Add(fb);
            return fb;
        }

        public void parseThreadList(string [] threadLists)
        {
            int cnt = mThreadList.Count;
            if (cnt > 0)
            {
                mThreadList.RemoveRange(0, cnt);
            }
            string[] threads = NTTextUtiles.splitLine(threadLists[0]);
            string[] tags = NTTextUtiles.splitLine(threadLists[1]);



            foreach (string line in threads)
            {
                addThreadByDescription(line, true, false);
            }

            foreach (string line in tags)
            {
                addThreadTagByDescription(line, true, false);
            }
            int threadCnt = mThreadList.Count;
            int threadIdx = 0;
            foreach (NTFavoriteThreadTag tag in mThreadTagList)
            {
                int count = tag.getCount();
                if ((count + threadIdx) > threadCnt)
                {
                    count = threadCnt - threadIdx;
                    tag.setCount(count);
                }
                for (int i = 0; i < count; i++)
                {
                    tag.add(mThreadList[threadIdx + i]);
                }

                threadIdx += count;
            }
            if (threadIdx < threadCnt)
                cnt = threadCnt - threadIdx;
            else
                cnt = 0;
            NTFavoriteThreadTag tag1 = 
                new NTFavoriteThreadTag("お気に入りのスレ", 
                    cnt.ToString(), "open update");
            for (int i = 0; i < cnt; i++)
            {
                tag1.add(mThreadList[threadIdx + i]);
            }
            mThreadTagList.Add(tag1);
  

        }

        public bool removeBoardByBoardName(string boardName, bool save)
        {
            if (boardName.Trim().Length == 0)
                return false;


            
            bool found = false;
            foreach (NTFavoriteBoard fb in mBoardList)
            {
                if (fb.BoardName.Equals(boardName))
                {
                    found = true;
                    mBoardList.Remove(fb);
                    break;
                }
            }
            if (!found)
                return false;

            if (save)
            {

                int cnt = mBoardList.Count;
                List<string> descriptions = new List<string>();
                foreach (NTFavoriteBoard fb in mBoardList)
                {
                    descriptions.Add(fb.BoardName);
                }

                NTFileAccess.updateFavoriteBoardToFile(descriptions.ToArray());

                Thread th = new Thread(new ParameterizedThreadStart(removeFavoriteBoardFromCloud));
                th.Start(boardName);
            }
            return true;

        }

        public bool removeThreadByDescription(string threadDescription, bool save)
        {
            if (threadDescription.Trim().Length == 0)
                return false;

            
            string[] values = threadDescription.Split(NTTextUtiles.YEN_VALUE);
            if (values.Length < 3)
                return false;

            bool found = false;
            foreach (NTFavoriteThread ft in mThreadList)
            {
                if (ft.Same(values[0], values[1], values[2]))
                {
                    found = true;
                    mThreadList.Remove(ft);
                    break;
                }
            }
            if (!found)
                return false;

            if (save)
            {

                int cnt = mThreadList.Count;
                List<string> descriptions = new List<string>();
                foreach(NTFavoriteThread ft in mThreadList)
                {
                    descriptions.Add(ft.getDescription());
                }
                NTFileAccess.updateFavoriteThreadToFile(descriptions.ToArray());

                Thread th = new Thread(new ParameterizedThreadStart(removeFavoriteThreadFromCloud));
                th.Start(threadDescription);
            }
            return true;

        }

        public NTFavoriteThread addThreadByDescription(string threadDescription, bool doEncode, bool save)
        {
            if (threadDescription.Trim().Length == 0)
                    return null;
            string decSrc;
            if (doEncode)
            {
                if(NTUserPreference.AESEnabled)
                    decSrc = NTTextUtiles.aesDecodeBase64URL(threadDescription);
                else
                    decSrc = NTTextUtiles.decodeBase64URL(threadDescription);
            }
            else
            {
                decSrc = threadDescription;
            }

            string[] values = decSrc.Split(NTTextUtiles.YEN_VALUE);
            if (values.Length < 3)
                return null;

            foreach (NTFavoriteThread comp in mThreadList)
            {
                if (comp.Same(values[0], values[1], values[2]))
                    return null;
            }

            NTFavoriteThread thread = new NTFavoriteThread(values[0], values[1], values[2]);
            mThreadList.Add(thread);

            if (save)
            {
                NTFileAccess.addFavoriteThreadToFile(decSrc);

                Thread th = new Thread(uploadFavoriteThreadToCloud);
                th.Start(decSrc);
            }
            return thread;

        }

        public NTFavoriteThreadTag addThreadTagByDescription(string tagDescription, bool doEncode, bool save)
        {
            return addThreadTagByDescription(tagDescription, doEncode, save, false);
        }
        public NTFavoriteThreadTag insertThreadTagByDescription(string tagDescription, bool doEncode, bool save)
        {
            return addThreadTagByDescription(tagDescription, doEncode, save, true);
        }
        private NTFavoriteThreadTag addThreadTagByDescription(string tagDescription, bool doEncode, bool save, bool insertLast)
        {
            if (tagDescription.Trim().Length == 0)
                return null;
            string decSrc;
            if (doEncode)
            {
                if (NTUserPreference.AESEnabled)
                    decSrc = NTTextUtiles.aesDecodeBase64URL(tagDescription);
                else
                    decSrc = NTTextUtiles.decodeBase64URL(tagDescription);
            }
            else
            {
                decSrc = tagDescription;
            }

            string[] values = decSrc.Split(NTTextUtiles.COMMA_VALUE);
            if (values.Length < 3)
                return null;


            NTFavoriteThreadTag tag = new NTFavoriteThreadTag(values[0], values[1], values[2]);
            if (insertLast)
            {
                int tagCnt = mThreadTagList.Count;
                if (tagCnt == 0)
                    return null;
                mThreadTagList.Insert(tagCnt - 1, tag);
            }
            else
            {
                mThreadTagList.Add(tag);
            }

            if (save)
            {
                NTFileAccess.addFavoriteThreadTagToFile(decSrc);
                string [] threadLists = NTFileAccess.retrieveFavoriteThreadFromFile();
                //Thread th = new Thread(uploadFavoriteThreadTagToCloud);
                //th.Start(threadLists[1]);
            }
            return tag;

        }

        public static void uploadFavoriteThreadToCloud(object t)
        {
            string src = t as string;
            if (src == null)
                return;

            if (NTUserPreference.NTCloudIsEnabled)
            {
                string uid = NTUserPreference.NTCloudID;
                string pass = NTUserPreference.NTCloudPSS;

                List<string> boardList = new List<string>();
                List<string> threadList = new List<string>();


                threadList.Add(src);

                string result = NTHttpAccess.ntUploadFavorites(uid, pass, boardList, threadList);
            }
        }

        public static void uploadFavoriteBoardToCloud(object t)
        {
            string src = t as string;
            if (src == null)
                return;

            if (NTUserPreference.NTCloudIsEnabled)
            {
                string uid = NTUserPreference.NTCloudID;
                string pass = NTUserPreference.NTCloudPSS;

                List<string> boardList = new List<string>();
                List<string> threadList = new List<string>();


                boardList.Add(src);

                string result = NTHttpAccess.ntUploadFavorites(uid, pass, boardList, threadList);
            }
        }

        public static void removeFavoriteBoardFromCloud(object o)
        {
            string boardDescription = o as string;
            if (boardDescription == null)
                return;

            if (NTUserPreference.NTCloudIsEnabled)
            {
                string uid = NTUserPreference.NTCloudID;
                string pass = NTUserPreference.NTCloudPSS;

                List<string> boardList = new List<string>();
                boardList.Add(boardDescription);

                string result = NTHttpAccess.ntDeletedFavoriteBoard(uid, pass, boardList);
            }

        }

        public static void removeFavoriteThreadFromCloud(object o)
        {
            string threadDescription = o as string;
            if (threadDescription == null)
                return;

            if (NTUserPreference.NTCloudIsEnabled)
            {
                string uid = NTUserPreference.NTCloudID;
                string pass = NTUserPreference.NTCloudPSS;

                List<string> threadList = new List<string>();
                threadList.Add(threadDescription);

                string result = NTHttpAccess.ntDeletedFavoriteThread(uid, pass, threadList);
            }
        }

        public void updateFavoriteBoards()
        {
            NTFileAccess.updateFavoriteBoardToFile(
                NTFavoriteBoard.getStringArray(mBoardList).ToArray());
           
            if (NTUserPreference.NTCloudIsEnabled)
            {
                if (NTUserPreference.NTUserCloudIsEnabled)
                {
                    string uid = NTUserPreference.NTCloudID;
                    //string pass = NTUserPreference.NTCloudPSS + NTUserPreference.NTUserCloudSeed;
                    string hashedPass = NTUserPreference.NTUserCloudGetHashedPasswd(); 
                    //NTCrypt.getSHA256Hashed(pass);
                    string result = NTHttpAccess.UserCloudUpdateFavoriteBoards(uid, hashedPass,
                        NTFavoriteBoard.getStringArray(mBoardList));
                }
                else
                {
                    string uid = NTUserPreference.NTCloudID;
                    string pass = NTUserPreference.NTCloudPSS;
                    string result = NTHttpAccess.ntUpdateFavoriteBoards(uid, pass,
                        NTFavoriteBoard.getStringArray(mBoardList));
                }
            }
        }

        public void updateFavoriteThread()
        {
            List<string> threadList = new List<string>(mThreadList.Count);
            foreach (NTFavoriteThread ft in mThreadList)
            {
                threadList.Add(ft.getDescription());
            }

            NTFileAccess.updateFavoriteThreadToFile(threadList.ToArray());

            List<string> tagList;
            int tagCnt = mThreadTagList.Count;
            if (tagCnt > 1)
            {
                tagCnt--;
                tagList = new List<string>(tagCnt);

                for(int i = 0; i < tagCnt; i++)
                {
                    NTFavoriteThreadTag tag = mThreadTagList[i];
                    tagList.Add(tag.getDescription());
                }
            }
            else
            {
                tagList = new List<string>();
            }

            NTFileAccess.updateFavoriteThreadTagToFile(tagList.ToArray());

            if (NTUserPreference.NTCloudIsEnabled)
            {
                if (NTUserPreference.NTUserCloudIsEnabled)
                {
                    string uid = NTUserPreference.NTCloudID;
                    //string pass = NTUserPreference.NTCloudPSS + NTUserPreference.NTUserCloudSeed;
                    string hashedPass = NTUserPreference.NTUserCloudGetHashedPasswd(); 
                    //NTCrypt.getSHA256Hashed(pass);
                    string result = NTHttpAccess.UserCloudUpdateFavoriteThreads(uid, hashedPass,
                        threadList, tagList);
                }
                else
                {
                    string uid = NTUserPreference.NTCloudID;
                    string pass = NTUserPreference.NTCloudPSS;
                    string result = NTHttpAccess.ntUpdateFavoriteThreads(uid, pass, threadList, tagList);
                }
            }
        }
    }
}
