﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace NT2chCtrl.html.js
{
    class JsDomFunction : JsFunction
    {
        JsToken mFuncNameKey;
        JsFunction mThis;

        public override bool IsArranged()
        {
            return mThis.IsArranged();
        }
        public override int getPriority()
        {
            return FUNC_PRIORITY_FUNCTION;
        }
        public override bool IsAssignable()
        {
            switch (mFuncNameKey)
            {
                //case JsToken.KEY_DOM_getElementById:
                //    return false;
                case JsToken.KEY_DOM_innerHTML:
                    return true;
            }
            return false;
        }

        public JsDomFunction(JsToken funcNameKey, int lineNo, int srcIdx)
            : base(lineNo, srcIdx)
        {
            mFuncNameKey = funcNameKey;
            switch (mFuncNameKey)
            {
                case JsToken.KEY_DOM_getElementById:
                    mThis = new JsDOMFunc_getElementById(lineNo, srcIdx);
                    break;
                case JsToken.KEY_DOM_innerHTML:
                    mThis = new JsDOMFunc_innerHTML(lineNo, srcIdx);
                    break;
            }
        }
        public override bool rearegeSquence(List<JsVariant> insList, int currIdx)
        {
            return mThis.rearegeSquence(insList, currIdx);
        }
        public override JsVariant Execute(JsFunctionContext ctx, HtmlElement rootElement)
        {
            return mThis.Execute(ctx, rootElement);
        }
        public override JsVariant Execute(JsFunctionContext ctx, HtmlElement rootElement, JsVariant assignVal)
        {
            return mThis.Execute(ctx, rootElement, assignVal);
        }
    }

    class JsDOMFunc_getElementById : JsFunction
    {
        List<JsVariant> mParams = null;
        public override int getPriority()
        {
            return FUNC_PRIORITY_FUNCTION;
        }

        public JsDOMFunc_getElementById(int lineNo, int srcIdx)
            : base(lineNo, srcIdx)
        {
        }

        public override bool rearegeSquence(List<JsVariant> insList, int currIdx)
        {
            JsRBracket rBraket = null;
            int count = insList.Count;
            
            if (currIdx + 1 >= count)
                return false;
            rBraket = insList[currIdx+1] as JsRBracket;
            if (rBraket == null)
                return false;

            mParams = rBraket.mArgs;
            if (mParams.Count != 1)
                return false;

            insList.RemoveAt(currIdx + 1);

            mArranged = true;
            return true;
        }

        public override JsVariant Execute(JsFunctionContext ctx, HtmlElement rootElement)
        {
            base.Execute(ctx,rootElement);
            /*DebugContext dCtx = ctx.getDbgCtx();
            if (dCtx != null)
            {
                dCtx.mCurrentLine = mSourceLine;
                dCtx.mCurentIndex = mSourceIdx;
            }*/

            if (mParams == null || mParams.Count != 1)
                return null;

            JsVariant param = ctx.getParamValue(rootElement, mParams[0]);
            JsStringValue sVal =  param as JsStringValue;
            if (sVal == null)
                return null;                

            List<HtmlElement> elems = 
                rootElement.getElements(null, null, null,
                        sVal.getValue(), null, true);
            if (elems == null)
                return JsNullValue.getConstant();

            return new JsDOMValue(elems);
        }
    }

    class JsDOMFunc_innerHTML : JsFunction
    {
        // This must be JsHTMLVariable;
        JsVariant mElem = null;
        public override int getPriority()
        {
            return FUNC_PRIORITY_FUNCTION;
        }

        public JsDOMFunc_innerHTML(int lineNo, int srcIdx)
            : base(lineNo, srcIdx)
        {
        }

        public override bool rearegeSquence(List<JsVariant> insList, int currIdx)
        {
            int count = insList.Count;
            if (currIdx < 1 || count <= currIdx)
                return false;

            mElem = insList[currIdx - 1];
            insList.RemoveAt(currIdx - 1);

            mArranged = true;
            return true;
        }

        public override JsVariant Execute(JsFunctionContext ctx, HtmlElement rootElement)
        {
            base.Execute(ctx, rootElement);
            string htmlStr;
            JsIdentifier idVal = mElem as JsIdentifier;
            if (idVal == null)
            {
                return null;
            }
            JsDOMValue domVal = ctx.getValue(idVal) as JsDOMValue;
            if (domVal == null)
                return null;

            if (domVal.getInnerHTML(out htmlStr))
            {
                return new JsStringValue(htmlStr);
            }
            else
            {
                return null;
            }
        }
        public override JsVariant Execute(JsFunctionContext ctx, HtmlElement rootElement, JsVariant assignVal)
        {
            DebugContext dCtx = ctx.getDbgCtx();
            if (dCtx != null)
            {
                dCtx.mCurrentLine = mSourceLine;
                dCtx.mCurentIndex = mSourceIdx;
            }

            JsIdentifier idVal = mElem as JsIdentifier;
            if(idVal == null){
                return null;
            }
            JsDOMValue domVal = ctx.getValue(idVal) as JsDOMValue;
            if (domVal == null)
                return null;


            JsVariant var = ctx.getParamValue(rootElement, assignVal);

            JsStringValue sVal = var.getStringValue();
            if (sVal == null)
                return null;

            /*JsStringValue sVal = assignVal as JsStringValue;
            if (sVal == null)
            {
                idVal = assignVal as JsIdentifier;
                if (idVal == null)
                    return null;
                sVal = ctx.getValue(idVal) as JsStringValue;
                if (sVal == null)
                    return null;
            }*/
            domVal.setInnerHTML(sVal.getValue());
            return domVal;
        }

    }
}
