﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Windows;

namespace NT2chView
{
    public class NTHistoryThread : DependencyObject
    {
        const string UNKNOWN_THREADTITLE_DESCRIPTION = "Unknown Title";

        private string mDatName;
        public string getDatName() { return mDatName; }

        public static readonly DependencyProperty BoardNameProperty;
        public static readonly DependencyProperty TitleProperty;
        public static readonly DependencyProperty DateTimeDescriptionProperty;

        static NTHistoryThread()
        {
            
            PropertyMetadata pmBoard = new PropertyMetadata(string.Empty);
            PropertyMetadata pmDateTime = new PropertyMetadata(string.Empty);
            PropertyMetadata pmTitle = new PropertyMetadata(string.Empty);

            BoardNameProperty = DependencyProperty.Register("BoardName", typeof(string), 
                        typeof(NTHistoryThread), pmBoard);
            TitleProperty = DependencyProperty.Register("Title", typeof(string), 
                        typeof(NTHistoryThread), pmTitle);
            DateTimeDescriptionProperty = DependencyProperty.Register("DateTimeDescription",
                        typeof(string), typeof(NTHistoryThread), pmDateTime);
       
        }

        public string Title
        {
            set { SetValue(TitleProperty, value); }
            get { return (string)GetValue(TitleProperty); }
        }

        public string BoardName
        {
            set { SetValue(BoardNameProperty, value); }
            get { return (string)GetValue(BoardNameProperty); }
        }
        public string DateTimeDescription
        {
            set { SetValue(DateTimeDescriptionProperty, value); }
            get { return (string)GetValue(DateTimeDescriptionProperty); }
        }


        public void update(NTBoard board)
        {
            if (board == null || !board.mDataInit)
                return;

            foreach (NTThreadTitle tt in board.mThreadTitleList)
            {
                if (tt.mDat.Equals(this.mDatName))
                {
                    this.Title = tt.Title;
                    return;
                }
            }
        }

  
        public NTHistoryThread(string boardName, string datName, string dateTimeDescription)
        {
            mDatName = datName;
            BoardName = boardName;
            Title = UNKNOWN_THREADTITLE_DESCRIPTION + " (" + boardName + ")";
            DateTimeDescription = dateTimeDescription;
        }
    }
}
