﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace NT2chCtrl.html.js
{
    class JsDomStrFunc_indexOf : JsFunction
    {
        JsVariant mObj = null;
        List<JsVariant> mParams = null;
        public JsDomStrFunc_indexOf(int lineNo, int srcIdx)
            : base(lineNo, srcIdx)
        {
        }
        public override int getPriority()
        {
            return FUNC_PRIORITY_FUNCTION;
        }
        public override bool rearegeSquence(List<JsVariant> insList, int currIdx)
        {
            int count = insList.Count;
            if (currIdx < 1 || count <= (currIdx+1))
                return false;

            mObj = insList[currIdx - 1];

            JsRBracket rBraket = null;

            if (currIdx + 1 >= count)
                return false;
            rBraket = insList[currIdx + 1] as JsRBracket;
            if (rBraket == null)
                return false;

            mParams = rBraket.mArgs;

            insList.RemoveAt(currIdx + 1);
            insList.RemoveAt(currIdx - 1);

            mArranged = true;
            return true;
        }
        public override JsVariant Execute(JsFunctionContext ctx, HtmlElement rootElement)
        {
            base.Execute(ctx, rootElement);


            if (mParams == null || mObj == null)
                return null;

            if (mParams.Count != 1)
            {
                ctx.getDbgCtx().mErrorMessage = JsError.INVALID_ARGMENT;
                return null;
            }

            JsVariant var = ctx.getParamValue(rootElement, mObj);
            if (var == null)
                return null;

            JsStringValue sVal = var.getStringValue();
            if (sVal == null)
                return null;

            string orgStr = sVal.getValue();

            List<JsVariant> args = mParams;

            JsCommaFunction comma = args[0] as JsCommaFunction;
            if (comma != null)
            {
                args = comma.getArgs();
                if (args.Count != 1 && args.Count != 2)
                {
                    ctx.getDbgCtx().mErrorMessage = JsError.INVALID_ARGMENT;
                    return null;
                }
            }

            var = ctx.getParamValue(rootElement, args[0]);
            if (var == null)
                return null;

            sVal = var.getStringValue();
            if (sVal == null)
                return null;

            string findStr = sVal.getValue();

            if (args.Count == 1)
            {
                return new JsNumberValue(orgStr.IndexOf(findStr));
            }

            var = ctx.getParamValue(rootElement, args[1]);
            JsNumberValue nVal = var.getNumberValue();
            if (nVal == null)
            {
                ctx.getDbgCtx().mErrorMessage = JsError.INVALID_NUMBER_TYPE;
                return null;
            }
            if (nVal.IsNaN())
            {
                ctx.getDbgCtx().mErrorMessage = JsError.INVALID_NUMBER;
                return null;
            }

            int num = (int)nVal.getValue();

            if (num < 0 || num >= orgStr.Length)
            {
                ctx.getDbgCtx().mErrorMessage = JsError.INDEX_OUT_OF_RANGE;
                return null;
            }
            return new JsNumberValue(orgStr.IndexOf(findStr, num));
        }
    }

    class JsDomStrFunc_substring : JsFunction
    {
        JsVariant mObj;
        List<JsVariant> mParams;
        public JsDomStrFunc_substring(int lineNo, int srcIdx)
            : base(lineNo, srcIdx)
        {
        }
        public override int getPriority()
        {
            return FUNC_PRIORITY_FUNCTION;
        }
        public override bool rearegeSquence(List<JsVariant> insList, int currIdx)
        {
            int count = insList.Count;
            if (currIdx < 1 || count <= (currIdx+1))
                return false;

            mObj = insList[currIdx - 1];

            JsRBracket rBraket = null;

            if (currIdx + 1 >= count)
                return false;
            rBraket = insList[currIdx + 1] as JsRBracket;
            if (rBraket == null)
                return false;

            mParams = rBraket.mArgs;

            insList.RemoveAt(currIdx + 1);
            insList.RemoveAt(currIdx - 1);

            mArranged = true;
            return true;
        }
        public override JsVariant Execute(JsFunctionContext ctx, HtmlElement rootElement)
        {
            base.Execute(ctx, rootElement);


            if (mParams == null || mObj == null)
                return null;

            if (mParams.Count != 1)
            {
                ctx.getDbgCtx().mErrorMessage = JsError.INVALID_ARGMENT;
                return null;
            }

            JsVariant var = ctx.getParamValue(rootElement, mObj);
            if (var == null)
                return null;

            JsStringValue sVal = var.getStringValue();
            if (sVal == null)
                return null;

            string orgStr = sVal.getValue();

            List<JsVariant> args = mParams;

            JsCommaFunction comma = args[0] as JsCommaFunction;
            if (comma != null)
            {
                args = comma.getArgs();
                if (args.Count != 1 && args.Count != 2)
                {
                    ctx.getDbgCtx().mErrorMessage = JsError.INVALID_ARGMENT;
                    return null;
                }
            }

            var = ctx.getParamValue(rootElement, args[0]);
            if (var == null)
            {
                ctx.getDbgCtx().mErrorMessage = JsError.INVALID_NUMBER_TYPE;
                return null;
            }

            JsNumberValue nVal = var.getNumberValue();
            if (nVal == null)
            {
                ctx.getDbgCtx().mErrorMessage = JsError.INVALID_NUMBER_TYPE;
                return null;
            }
            if (nVal.IsNaN())
            {
                ctx.getDbgCtx().mErrorMessage = JsError.INVALID_NUMBER;
                return null;
            }

            int startIdx = (int)nVal.getValue();

            if (args.Count == 1)
            {
                return new JsStringValue(orgStr.Substring(startIdx));
            }

            var = ctx.getParamValue(rootElement, args[1]);
            nVal = var.getNumberValue();
            if (nVal == null)
            {
                ctx.getDbgCtx().mErrorMessage = JsError.INVALID_NUMBER_TYPE;
                return null;
            }
            if (nVal.IsNaN())
            {
                ctx.getDbgCtx().mErrorMessage = JsError.INVALID_NUMBER;
                return null;
            }

            int num = (int)nVal.getValue();

            if (num < 0 || num >= orgStr.Length || startIdx > num)
            {
                ctx.getDbgCtx().mErrorMessage = JsError.INDEX_OUT_OF_RANGE;
                return null;
            }
            return new JsStringValue(orgStr.Substring(startIdx, num - startIdx));
        }
    }

    class JsDomStrFunc_replace : JsFunction
    {
        JsVariant mObj = null;
        List<JsVariant> mParams = null;
        public JsDomStrFunc_replace(int lineNo, int srcIdx)
            : base(lineNo, srcIdx)
        {
        }
        public override int getPriority()
        {
            return FUNC_PRIORITY_FUNCTION;
        }
        public override bool rearegeSquence(List<JsVariant> insList, int currIdx)
        {
            int count = insList.Count;
            if (currIdx < 1 || count <= (currIdx + 1))
                return false;

            mObj = insList[currIdx - 1];

            JsRBracket rBraket = null;

            if (currIdx + 1 >= count)
                return false;
            rBraket = insList[currIdx + 1] as JsRBracket;
            if (rBraket == null)
                return false;

            mParams = rBraket.mArgs;

            insList.RemoveAt(currIdx + 1);
            insList.RemoveAt(currIdx - 1);

            mArranged = true;
            return true;
        }
        public override JsVariant Execute(JsFunctionContext ctx, HtmlElement rootElement)
        {
            base.Execute(ctx, rootElement);


            if (mParams == null || mObj == null)
                return null;

            if (mParams.Count != 1)
            {
                ctx.getDbgCtx().mErrorMessage = JsError.INVALID_ARGMENT;
                return null;
            }

            JsVariant var = ctx.getParamValue(rootElement, mObj);
            if (var == null)
                return null;

            JsStringValue sVal = var.getStringValue();
            if (sVal == null)
                return null;

            string orgStr = sVal.getValue();

            List<JsVariant> args = mParams;

            JsCommaFunction comma = args[0] as JsCommaFunction;
            if (comma != null)
            {
                args = comma.getArgs();
                if (args.Count != 2)
                {
                    ctx.getDbgCtx().mErrorMessage = JsError.INVALID_ARGMENT;
                    return null;
                }
            }

            var = ctx.getParamValue(rootElement, args[0]);
            if (var == null)
                return null;

            sVal = var.getStringValue();
            if (sVal == null)
                return null;

            string targetStr = sVal.getValue();


            var = ctx.getParamValue(rootElement, args[1]);
            sVal = var.getStringValue();
            if (sVal == null)
            {
                ctx.getDbgCtx().mErrorMessage = JsError.INVALID_STRING_TYPE;
                return null;
            }

            return new JsStringValue(orgStr.Replace(targetStr, sVal.getValue()));
        }
    }

    class JsDomStrFunc_length : JsFunction
    {
        JsVariant mObj = null;
        public JsDomStrFunc_length(int lineNo, int srcIdx)
            : base(lineNo, srcIdx)
        {
        }
        public override int getPriority()
        {
            return FUNC_PRIORITY_FUNCTION;
        }
        public override bool rearegeSquence(List<JsVariant> insList, int currIdx)
        {
            int count = insList.Count;
            if (currIdx < 1 || count < 2)
                return false;

            mObj = insList[currIdx - 1];
            insList.RemoveAt(currIdx - 1);

            mArranged = true;
            return true;
        }
        public override JsVariant Execute(JsFunctionContext ctx, HtmlElement rootElement)
        {
            base.Execute(ctx, rootElement);


            if (mObj == null)
                return null;


            JsVariant var = ctx.getParamValue(rootElement, mObj);
            if (var == null)
            {
                ctx.getDbgCtx().mErrorMessage = JsError.INVALID_STRING_TYPE;
                return null;
            }

            JsStringValue sVal = var.getStringValue();
            if (sVal == null)
                return null;

            string orgStr = sVal.getValue();


            return new JsNumberValue(orgStr.Length);
        }
    }
#if false
    class JsDomStrFunc_concat : JsFunction
    {
        public JsDomStrFunc_concat(int lineNo, int srcIdx)
            : base(lineNo, srcIdx)
        {
        }
        public override int getPriority()
        {
            return FUNC_PRIORITY_FUNCTION;
        }
    }
#endif
}
