﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Media;

namespace NT2chCtrl.html
{
#if false
    class HtmlColor
    {
        string mColorName;
        int mColorValue;

        HtmlColor(string colorName, int colorValue)
        {
            mColorName = colorName;
            mColorValue = colorValue;
        }

        public static Color getColor(string colorText)
        {
            colorText = colorText.Trim();
            int idx;

            idx = colorText.IndexOf("rgb(");
            if (idx == 0)
            {
                int endIdx;
                return getColorFromRgbString(colorText, 4, out endIdx);
            }
            idx = colorText.IndexOf('#');
            if (idx == 0)
            {
                return getColorFromHexString(colorText, 1);
            }
            foreach (HtmlColor c in mColorList)
            {
                if (colorText.Equals(c.mColorName, StringComparison.OrdinalIgnoreCase))
                    return getColor(c.mColorValue);
            }
            return Colors.Transparent;
        }


        private static Color getColorFromRgbString(string rgbString, int startIdx, out int endIdx)
        {

            int length = rgbString.Length;
            int digits = 0;
            int value = 0;
            int colorIdx = 0;
            int r = 0, g = 0;//, b = 0;

            endIdx = 0;

            for (int i = startIdx; i < length; i++)
            {
                char c = rgbString[i];
                if (c >= '0' && c <= '9')
                {
                    if (digits == 0)
                        value = c - '0';
                    else if (digits == 1)
                        value = (c - '0') + (value * 10);
                    else if (digits == 2)
                        value = (c - '0') + (value * 10);
                    else
                        return Colors.Transparent;
                    digits++;
                }
                else if (c == ',')
                {
                    if (digits == 0)
                        return Colors.Transparent;

                    if (colorIdx == 0)
                        r = value;
                    else if (colorIdx == 1)
                        g = value;
                    //else if (colorIdx == 2)
                    //    b = value;
                    else
                        return Colors.Transparent;
                    colorIdx++;
                    digits = 0;
                }
                else if (c == ' ' || c == '\t' || c == 'r' || c == '\n')
                {
                }
                else if (c == ')')
                {
                    if (colorIdx != 2)
                        return Colors.Transparent;
                    endIdx = i;
                    return Color.FromRgb((byte)r, (byte)g, (byte)value);
                }
                else
                {
                    return Colors.Transparent;
                }
            }
            return Colors.Transparent;
        }

        private static Color getColorFromHexString(string hexString, int startIdx)
        {
            int[] by = new int[8];
            int length = Math.Min(hexString.Length, 8);
            int idx = 0;
            for (int i = startIdx; i < length; i++)
            {
                char c = hexString[i];
                if (c >= '0' && c <= '9')
                {
                    by[idx] = (c - '0');
                }else if(c >= 'a' && c <= 'f'){
                    by[idx] = (c - 'a' + 10);
                }
                else if (c >= 'A' && c <= 'F')
                {
                    by[idx] = (c - 'A' + 10);
                }
                else
                {
                    idx++;
                    break;
                }
                idx++;
            }
            if (idx < 0 || idx > 6)
                return Colors.Transparent;

            int r = 0, g = 0, b = 0;
            idx--;
            if (idx < 3)
            {
                for (int i = 0; idx >= 0; i++)
                {
                    switch (i)
                    {
                        case 0:
                            b = by[idx];
                            break;
                        case 1:
                            g = by[idx];
                            break;
                        case 2:
                            r = by[idx];
                            break;
                    }

                    idx--;
                }
            }
            else
            {
                for (int i = 0; idx >= 0; i++)
                {
                    switch (i)
                    {
                        case 0:
                            b = by[idx];
                            break;
                        case 1:
                            b += (by[idx] << 4);
                            break;
                        case 2:
                            g = by[idx];
                            break;
                        case 3:
                            g += (by[idx] << 4);
                            break;
                        case 4:
                            r = by[idx];
                            break;
                        case 5:
                            r += (by[idx] << 4);
                            break;
                    }

                    idx--;
                }
            }

            return Color.FromRgb((byte)r, (byte)g, (byte)b);

        }

        private static Color getColor(int value)
        {
            int r = (value & 0xff0000) >> 16;
            int g = (value & 0xff00) >> 8;
            int b = (value & 0xff);
            return Color.FromRgb((byte)r, (byte)g, (byte)b);
        }

        static HtmlColor [] mColorList = 
        {
            new HtmlColor("aliceblue", 0xF0F8FF),	// 240,248,255
            new HtmlColor("antiquewhite", 0xFAEBD7),	//250,235,215
            new HtmlColor("aqua", 0x00FFFF),	//0,255,255
            new HtmlColor("aquamarine", 0x7FFFD4),	//127,255,212
            new HtmlColor("azure", 0xF0FFFF),	//240,255,255
            new HtmlColor("beige", 0xF5F5DC),	//245,245,220
            new HtmlColor("bisque", 0xFFE4C4),	//255,228,196
            new HtmlColor("black", 0x000000),	//0,0,0
            new HtmlColor("blanchedalmond", 0xFFEBCD),	//255,235,205
            new HtmlColor("blue", 0x0000FF),	//0,0,255
            new HtmlColor("blueviolet", 0x8A2BE2),	//138,43,226
            new HtmlColor("brown", 0xA52A2A),	//165,42,42
            new HtmlColor("burlywood", 0xDEB887),	//222,184,135
            new HtmlColor("cadetblue", 0x5F9EA0),	//95,158,160
            new HtmlColor("chartreuse", 0x7FFF00),	//127,255,0
            new HtmlColor("chocolate", 0xD2691E),	//210,105,30
            new HtmlColor("coral", 0xFF7F50),	//255,127,80
            new HtmlColor("cornflowerblue", 0x6495ED),	//100,149,237
            new HtmlColor("cornsilk", 0xFFF8DC),	//255,248,220
            new HtmlColor("crimson", 0xDC143C),	//220,20,60
            new HtmlColor("cyan", 0x00FFFF),	//0,255,255
            new HtmlColor("darkblue", 0x00008B),	//0,0,139
            new HtmlColor("darkcyan", 0x008B8B),	//0,139,139
            new HtmlColor("darkgoldenrod", 0xB8860B),	//184,134,11
            new HtmlColor("darkgray", 0xA9A9A9),	//169,169,169
            new HtmlColor("darkgreen", 0x006400),	//0,100,0
            new HtmlColor("darkgrey", 0xA9A9A9),	//169,169,169
            new HtmlColor("darkkhaki", 0xBDB76B),	//189,183,107
            new HtmlColor("darkmagenta", 0x8B008B),	//139,0,139
            new HtmlColor("darkolivegreen", 0x556B2F),	//85,107,47
            new HtmlColor("darkorange", 0xFF8C00),	//255,140,0
            new HtmlColor("darkorchid", 0x9932CC),	//153,50,204
            new HtmlColor("darkred", 0x8B0000),	//139,0,0
            new HtmlColor("darksalmon", 0xE9967A),	//233,150,122
            new HtmlColor("darkseagreen", 0x8FBC8F),	//143,188,143
            new HtmlColor("darkslateblue", 0x483D8B),	//72,61,139
            new HtmlColor("darkslategray", 0x2F4F4F),	//47,79,79
            new HtmlColor("darkslategrey", 0x2F4F4F),	//47,79,79
            new HtmlColor("darkturquoise", 0x00CED1),	//0,206,209
            new HtmlColor("darkviolet", 0x9400D3),	//148,0,211
            new HtmlColor("deeppink", 0xFF1493),	//255,20,147
            new HtmlColor("deepskyblue", 0x00BFFF),	//0,191,255
            new HtmlColor("dimgray", 0x696969),	//105,105,105
            new HtmlColor("dimgrey", 0x696969),	//105,105,105
            new HtmlColor("dodgerblue", 0x1E90FF),	//30,144,255
            new HtmlColor("firebrick", 0xB22222),	//178,34,34
            new HtmlColor("floralwhite", 0xFFFAF0),	//255,250,240
            new HtmlColor("forestgreen", 0x228B22),	//34,139,34
            new HtmlColor("fuchsia", 0xFF00FF),	//255,0,255
            new HtmlColor("gainsboro", 0xDCDCDC),	//220,220,220
            new HtmlColor("ghostwhite", 0xF8F8FF),	//248,248,255
            new HtmlColor("gold", 0xFFD700),	//255,215,0
            new HtmlColor("goldenrod", 0xDAA520),	//218,165,32
            new HtmlColor("gray", 0x808080),	//128,128,128
            new HtmlColor("green", 0x008000),	//0,128,0
            new HtmlColor("greenyellow", 0xADFF2F),	//173,255,47
            new HtmlColor("grey", 0x808080),	//128,128,128
            new HtmlColor("honeydew", 0xF0FFF0),	//240,255,240
            new HtmlColor("hotpink", 0xFF69B4),	//255,105,180
            new HtmlColor("indianred", 0xCD5C5C),	//205,92,92
            new HtmlColor("indigo", 0x4B0082),	//75,0,130
            new HtmlColor("ivory", 0xFFFFF0),	//255,255,240
            new HtmlColor("khaki", 0xF0E68C),	//240,230,140
            new HtmlColor("lavender", 0xE6E6FA),	//230,230,250
            new HtmlColor("lavenderblush", 0xFFF0F5),	//255,240,245
            new HtmlColor("lawngreen", 0x7CFC00),	//124,252,0
            new HtmlColor("lemonchiffon", 0xFFFACD),	//255,250,205
            new HtmlColor("lightblue", 0xADD8E6),	//173,216,230
            new HtmlColor("lightcoral", 0xF08080),	//240,128,128
            new HtmlColor("lightcyan", 0xE0FFFF),	//224,255,255
            new HtmlColor("lightgoldenrodyellow", 0xFAFAD2),	//250,250,210
            new HtmlColor("lightgray", 0xD3D3D3),	//211,211,211
            new HtmlColor("lightgreen", 0x90EE90),	//144,238,144
            new HtmlColor("lightgrey", 0xD3D3D3),	//211,211,211
            new HtmlColor("lightpink", 0xFFB6C1),	//255,182,193
            new HtmlColor("lightsalmon", 0xFFA07A),	//255,160,122
            new HtmlColor("lightseagreen", 0x20B2AA),	//32,178,170
            new HtmlColor("lightskyblue", 0x87CEFA),	//135,206,250
            new HtmlColor("lightslategray", 0x778899),	//119,136,153
            new HtmlColor("lightslategrey", 0x778899),	//119,136,153
            new HtmlColor("lightsteelblue", 0xB0C4DE),	//176,196,222
            new HtmlColor("lightyellow", 0xFFFFE0),	//255,255,224
            new HtmlColor("lime", 0x00FF00),	//0,255,0
            new HtmlColor("limegreen", 0x32CD32),	//50,205,50
            new HtmlColor("linen", 0xFAF0E6),	//250,240,230
            new HtmlColor("magenta", 0xFF00FF),	//255,0,255
            new HtmlColor("maroon", 0x800000),	//128,0,0
            new HtmlColor("mediumaquamarine", 0x66CDAA),	//102,205,170
            new HtmlColor("mediumblue", 0x0000CD),	//0,0,205
            new HtmlColor("mediumorchid", 0xBA55D3),	//186,85,211
            new HtmlColor("mediumpurple", 0x9370DB),	//147,112,219
            new HtmlColor("mediumseagreen", 0x3CB371),	//60,179,113
            new HtmlColor("mediumslateblue", 0x7B68EE),	//123,104,238
            new HtmlColor("mediumspringgreen", 0x00FA9A),	//0,250,154
            new HtmlColor("mediumturquoise", 0x48D1CC),	//72,209,204
            new HtmlColor("mediumvioletred", 0xC71585),	//199,21,133
            new HtmlColor("midnightblue", 0x191970),	//25,25,112
            new HtmlColor("mintcream", 0xF5FFFA),	//245,255,250
            new HtmlColor("mistyrose", 0xFFE4E1),	//255,228,225
            new HtmlColor("moccasin", 0xFFE4B5),	//255,228,181
            new HtmlColor("navajowhite", 0xFFDEAD),	//255,222,173
            new HtmlColor("navy", 0x000080),	//0,0,128
            new HtmlColor("oldlace", 0xFDF5E6),	//253,245,230
            new HtmlColor("olive", 0x808000),	//128,128,0
            new HtmlColor("olivedrab", 0x6B8E23),	//107,142,35
            new HtmlColor("orange", 0xFFA500),	//255,165,0
            new HtmlColor("orangered", 0xFF4500),	//255,69,0
            new HtmlColor("orchid", 0xDA70D6),	//218,112,214
            new HtmlColor("palegoldenrod", 0xEEE8AA),	//238,232,170
            new HtmlColor("palegreen", 0x98FB98),	//152,251,152
            new HtmlColor("paleturquoise", 0xAFEEEE),	//175,238,238
            new HtmlColor("palevioletred", 0xDB7093),	//219,112,147
            new HtmlColor("papayawhip", 0xFFEFD5),	//255,239,213
            new HtmlColor("peachpuff", 0xFFDAB9),	//255,218,185
            new HtmlColor("peru", 0xCD853F),	//205,133,63
            new HtmlColor("pink", 0xFFC0CB),	//255,192,203
            new HtmlColor("plum", 0xDDA0DD),	//221,160,221
            new HtmlColor("powderblue", 0xB0E0E6),	//176,224,230
            new HtmlColor("purple", 0x800080),	//128,0,128
            new HtmlColor("red", 0xFF0000),	//255,0,0
            new HtmlColor("rosybrown", 0xBC8F8F),	//188,143,143
            new HtmlColor("royalblue", 0x4169E1),	//65,105,225
            new HtmlColor("saddlebrown", 0x8B4513),	//139,69,19
            new HtmlColor("salmon", 0xFA8072),	//250,128,114
            new HtmlColor("sandybrown", 0xF4A460),	//244,164,96
            new HtmlColor("seagreen", 0x2E8B57),	//46,139,87
            new HtmlColor("seashell", 0xFFF5EE),	//255,245,238
            new HtmlColor("sienna", 0xA0522D),	//160,82,45
            new HtmlColor("silver", 0xC0C0C0),	//192,192,192
            new HtmlColor("skyblue", 0x87CEEB),	//135,206,235
            new HtmlColor("slateblue", 0x6A5ACD),	//106,90,205
            new HtmlColor("slategray", 0x708090),	//112,128,144
            new HtmlColor("slategrey", 0x708090),	//112,128,144
            new HtmlColor("snow", 0xFFFAFA),	//255,250,250
            new HtmlColor("springgreen", 0x00FF7F),	//0,255,127
            new HtmlColor("steelblue", 0x4682B4),	//70,130,180
            new HtmlColor("tan", 0xD2B48C),	//210,180,140
            new HtmlColor("teal", 0x008080),	//0,128,128
            new HtmlColor("thistle", 0xD8BFD8),	//216,191,216
            new HtmlColor("tomato", 0xFF6347),	//255,99,71
            new HtmlColor("turquoise", 0x40E0D0),	//64,224,208
            new HtmlColor("violet", 0xEE82EE),	//238,130,238
            new HtmlColor("wheat", 0xF5DEB3),	//245,222,179
            new HtmlColor("white", 0xFFFFFF),	//255,255,255
            new HtmlColor("whitesmoke", 0xF5F5F5),	//245,245,245
            new HtmlColor("yellow", 0xFFFF00),	//255,255,0
            new HtmlColor("yellowgreen", 0x9ACD32),	//154,205,50
        };
    }
#endif
}
