﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using NT2chCtrl.html;
using NT2chObject;

namespace NT2chCtrl
{
    partial class ResListAdapter : UIElementListPanel.IUIElementListAdapter
    {
        IThread mCurrentThread = null;
        List<IRes> mResList = null;
        int mPrevReadCount;

        IUtil mUtil;
        ICommand mCommand;
        NTResViewPanel mMainPanel;
        ResViewCtrlState mState;

        public ResListAdapter(NTResViewPanel mainPanel, IThread ithread, ICommand icmd, IUtil iutil)
        {
            mState = ResViewCtrlState.getInstance();
            mMainPanel = mainPanel;
            mCurrentThread = ithread;
            mResList = ithread.getResList();
            mPrevReadCount = ithread.getPrevReadCount();
            mCommand = icmd;
            mUtil = iutil;
            initCashData(getCount());
            if (!getZoomValue(out mZoomValue))
                mZoomValue = 95;
            if (mZoomValue < 50 || mZoomValue > 500)
                mZoomValue = 95;

        }

        public int getCount()
        {
            return (mResList == null) ? 0 : mResList.Count;
        }

        public void updateTextSelMode(bool mode)
        {
            if(null == mResCashDataList)
                return;

            int count = mResCashDataList.Count;
            for (int i = 0; i < count; i++)
            {
                FlowDocumentScrollViewer fdsv = mResCashDataList[i].element
                    as FlowDocumentScrollViewer;
                if (fdsv != null)
                {
                    fdsv.IsSelectionEnabled = mode;
                }
            }

        }

        public UIElement getElement(int pos, UIElement convertElement)
        {
            FlowDocumentScrollViewer fdsv;

            if (pos < 0 || pos >= getCount())
                return null;

            if (getCount() != mResCashDataList.Count)
            {
                initCashData(getCount());
            }

            UIElement element = mResCashDataList[pos].element;
            if (element != null)
            {
                fdsv = element as FlowDocumentScrollViewer;
                if (fdsv != null)
                {
                    fdsv.Zoom = mZoomValue;
                    fdsv.IsSelectionEnabled = mMainPanel.getTextSelMode();

                }
                return element;
            }

            fdsv = new FlowDocumentScrollViewer();
            fdsv.HorizontalScrollBarVisibility = ScrollBarVisibility.Hidden;
            fdsv.VerticalScrollBarVisibility = ScrollBarVisibility.Hidden;
            fdsv.Margin = new Thickness(0);
            fdsv.Padding = new Thickness(0);
            fdsv.MaxZoom = 500;
            fdsv.MinZoom = 50;
            fdsv.Zoom = mZoomValue;

            fdsv.IsSelectionEnabled = mMainPanel.getTextSelMode();

            mUtil.CreateResViewContextMenu(fdsv);
            bool newMsg;
            //int prevReadCnt = mCurrentThread.getPrevReadCount();
            if (mPrevReadCount > 0 && pos > (mPrevReadCount - 1))
            {
                newMsg = true;
            }
            else
            {
                newMsg = false;
            }

            ResViewCtrlState state = ResViewCtrlState.getInstance();
            FontFamily font = null;
            FontFamily aaFont = null;
            string fontName = NTResViewPanel.getResFontTypeface();
            if (fontName != null)
                //font = new FontFamily(fontName);
                font = html.wpf.FontCash.getFontFamily(fontName);
            fontName = NTResViewPanel.getResAAFontTypeface();
            if (fontName != null)
                //aaFont = new FontFamily(fontName);
                aaFont = html.wpf.FontCash.getFontFamily(fontName);
            FlowDocument fd = new FlowDocument();

            IRes ires = mResList[pos];
            //ires.
            Section sec;
            if (state.EnableHtmlLayout)
                sec = createResSection2(state, mCurrentThread, ires, newMsg, true, fd);
            else
                sec = createResSection(mCurrentThread, ires, newMsg, true);

            sec.Margin = new Thickness(0);
            sec.Padding = new Thickness(0);

            if (aaFont != null && NTResViewPanel.testAsciiArt(ires.getMsg()))
            {
                sec.FontFamily = aaFont;
            }
            else if (font != null)
            {
                sec.FontFamily = font;
            }

            //document.Blocks.Add(sec);
            //if (mainView)
            ires.setExtra(sec);

            if (ires.getAttribute(RES_ATTRIBUTE.BOOKMARK))
            {
                addBookmark(mCurrentThread, ires, false);
            }

            fdsv.Document = fd;
            fd.Blocks.Add(sec);

            fdsv.Margin = new Thickness(0);
            fdsv.Padding = new Thickness(0);

            mResCashDataList[pos].element = fdsv;
            mResCashDataList[pos].section = sec;

            return fdsv;
        }

        public FlowDocument createDocument(IThread ithread, List<IRes> rList, bool mainView)
        {

            FlowDocument document = new FlowDocument();

            FontFamily font = null;
            FontFamily aaFont = null;
            string fontName = NTResViewPanel.getResFontTypeface();
            if (fontName != null)
                font = new FontFamily(fontName);
            fontName = NTResViewPanel.getResAAFontTypeface();
            if (fontName != null)
                aaFont = new FontFamily(fontName);


            mPrevReadCount = ithread.getPrevReadCount();

            int prevMsg;
            if (ithread.getPrevReadCount() <= 0)
                prevMsg = 2000;
            else
                prevMsg = mPrevReadCount - 1;


            for (int i = 0; i < rList.Count; i++)
            {
                IRes res = rList[i];
                Section sec = createResSection(ithread, res, (i > prevMsg), false);
                if (sec != null)
                {
                    if (aaFont != null && NTResViewPanel.testAsciiArt(res.getMsg()))
                    {
                        sec.FontFamily = aaFont;
                    }
                    else if (font != null)
                    {
                        sec.FontFamily = font;
                    }

                    document.Blocks.Add(sec);
                    //if (mainView)
                    //    res.setExtra(sec);

                    if (res.getAttribute(RES_ATTRIBUTE.BOOKMARK))
                    {
                        addBookmark(ithread, res, false);
                    }
                }
            }

            return document;
        }

        Section createResSection2(ResViewCtrlState ctrlState, IThread thread,
            IRes res, bool newMsg, bool topItem, FlowDocument fd)
        {
            Section sec = new Section();

            sec.Margin = new Thickness(0);
            sec.Padding = new Thickness(0);

            HtmlParser parser = ctrlState.getResViewLayoutParser();

            HtmlElement rootElement = parser.CloneHtmlElement();

            bool mymsg = res.getAttribute(RES_ATTRIBUTE.MYMESSAGE);
            bool reply = res.getAttribute(RES_ATTRIBUTE.REPRY);
            bool bookmark = res.getAttribute(RES_ATTRIBUTE.BOOKMARK);
            bool asciiart = NTResViewPanel.testAsciiArt(res.getMsg());

            string ngword = null;
            string ngname = null;
            string ngid = null;
            string[] ngWordList = mCommand.GetNgWordList();
            string[] ngIdList = mCommand.GetNgIdList();
            string[] ngNameList = mCommand.GetNgNameList();

            foreach (string ng in ngNameList)
            {
                string s = ng.Trim();
                if (s.Length == 0)
                    continue;
                if (0 <= res.getName().IndexOf(s))
                {
                    ngname = s;
                    break;
                }
            }
            foreach (string ng in ngIdList)
            {
                string s = ng.Trim();
                if (s.Length == 0)
                    continue;
                if (0 <= res.getID().IndexOf(s))
                {
                    ngid = s;
                    break;
                }
            }
            foreach (string ng in ngWordList)
            {
                string s = ng.Trim();
                if (s.Length == 0)
                    continue;
                if (0 <= res.getMsg().IndexOf(s))
                {
                    ngword = s;
                    break;
                }
            }

            if(!html.wpf.Html2FlowDoc.MargeResDataIntoHtml(rootElement, thread, res, 
                    newMsg, mymsg ,reply, bookmark, asciiart,
                    ngword, ngname, ngid, mAmbisuousSearch))
                return sec;
            html.js.JsFunctionContext fCtx;
            html.DebugContext dCtx = new DebugContext();
            if (!parser.runJS(dCtx, rootElement, out fCtx))
            {
                //MessageBox.Show("Error");
                string htmlSource = 
                    ResViewCtrlState.getInstance().
                        getResViewLayoutParser().getHtmlSource();
                NTScriptDebugger debugger = new NTScriptDebugger();
                debugger.ErrorMessage = dCtx.mErrorMessage;//parser.getErrorMessage();
                debugger.ErrorLine = dCtx.mCurrentLine;//parser.getErrorLine();
                debugger.ErrorSrcIndex = dCtx.mCurentIndex;//parser.getErrorSrcIndex();
                debugger.HtmlSource = htmlSource;
                debugger.FuncContext = fCtx;
                debugger.initParam();
                NTScriptDebugger.ShowWindow(debugger);
            }
            parser.applyCSS(rootElement);

            List<HtmlElement> rList = rootElement.getElements(null,
                "body", null, null, null, false);
            if (rList == null || rList.Count == 0)
                return sec;

            HtmlElement bodyElem = rList[0];

            Color c;
            if (bodyElem.tryGetBackgroundColor(out c))
            {
                fd.Background = new SolidColorBrush(c);
            }
            Brush brush;
            if (bodyElem.tryGetBackgroundImage(out brush))
            {
                fd.Background = brush;
            }

            if (!html.wpf.Html2FlowDoc.DrawHtml(this, sec, thread, res, bodyElem))
                return sec;
            return sec;
        }

        Section createResSection(IThread thread, IRes res, bool newMsg, bool topItem)
        {
            Section sec = new Section();
            //if (res.mIsDummy)
            //    return sec;

            Color c;
            Paragraph paraHeader = new Paragraph();
            if (newMsg)
                c = Colors.LightPink;
            else
                c = Colors.LightGray;

            paraHeader.Background = new LinearGradientBrush(Colors.White, c, 90.0);
            paraHeader.Padding = new Thickness(3);

            string[] ngWordList = mCommand.GetNgWordList();
            string[] ngIdList = mCommand.GetNgIdList();
            string[] ngNameList = mCommand.GetNgNameList();

            foreach (string ng in ngNameList)
            {
                string s = ng.Trim();
                if (s.Length == 0)
                    continue;
                if (0 <= res.getName().IndexOf(s))
                {
                    paraHeader.Inlines.Add(new Run("NG:NAME " + s));
                    sec.Blocks.Add(paraHeader);
                    return sec;
                }
            }
            foreach (string ng in ngIdList)
            {
                string s = ng.Trim();
                if (s.Length == 0)
                    continue;
                if (0 <= res.getID().IndexOf(s))
                {
                    paraHeader.Inlines.Add(new Run("NG:ID " + s));
                    sec.Blocks.Add(paraHeader);
                    return sec;
                }
            }
            foreach (string ng in ngWordList)
            {
                string s = ng.Trim();
                if (s.Length == 0)
                    continue;
                if (0 <= res.getMsg().IndexOf(s))
                {
                    paraHeader.Inlines.Add(new Run("NG:WORD " + s));
                    sec.Blocks.Add(paraHeader);
                    return sec;
                }
            }

            Run r = new Run();
            r.Text = res.getSequenceNo().ToString() + ":";
            List<object> param = new List<object>();
            param.Add(thread);
            param.Add(res);
            Hyperlink hlink = new Hyperlink();
            hlink.Inlines.Add(r);
            hlink.Tag = param;
            if(topItem)
                hlink.MouseEnter += ResSeqNo_MouseEnter;
            else
                hlink.MouseEnter += ResSeqNoSubItem_MouseEnter;
            hlink.MouseLeftButtonDown += ResSeqNo_MouseLeftButtonDown;
            hlink.PreviewMouseLeftButtonDown += hlink_PreviewMouseLeftButtonDown;
            paraHeader.Inlines.Add(hlink);

            r = new Run();
            Hyperlink hl = null;
            string name = res.getName();
            try
            {
                int n = int.Parse(name);
                List<int> arr = new List<int>();
                arr.Add(n);

                arr[0] = n;
                param = new List<object>();
                param.Add(thread);
                param.Add(arr);
                hl = new Hyperlink(new Run("　" + name + "　"));
                hl.Tag = param;
                if (getEnablePopupMouseHover())
                    hl.MouseEnter += resLink_MouseEnter;
                else
                    hl.Click += resLink_MouseEnter;
                paraHeader.Inlines.Add(hl);
            }
            catch
            {
                //NTDebug.l(e.Message);
            }
            Span span;
            if (hl == null)
            {
                span = new Span();
                if (res.getAttribute(RES_ATTRIBUTE.MYMESSAGE))
                {
                    name = "<自分>";
                    span.Foreground = Brushes.Red;
                }
                else if (res.getAttribute(RES_ATTRIBUTE.REPRY))
                {
                    name = "<返信>";
                    span.Foreground = Brushes.Purple;
                }
                else
                    span.Foreground = Brushes.Green;

                r.Text = "　" + name + "　";
                span.Inlines.Add(r);
                paraHeader.Inlines.Add(span);
            }

            r = new Run();
            string mail = res.getMail();
            if (0 < mail.Length)
                r.Text = "(" + mail + ") ";
            else
                r.Text = " --- ";
            span = new Span();
            span.Foreground = Brushes.Blue;
            span.Inlines.Add(r);
            paraHeader.Inlines.Add(span);

            r = new Run();
            r.Text = res.getDate() + " ";
            span = new Span();
            span.Foreground = Brushes.Black;
            span.Inlines.Add(r);
            paraHeader.Inlines.Add(span);
            string id = res.getID();
            if (id != null && id.Length > 0)
            {
                int before = 0;
                int after = 0;
                bool chk = false;
                List<IRes> rList = thread.getResList();
                List<int> arrSeqNum = new List<int>();
                if (rList != null)
                {
                    int rCnt = rList.Count;
                    for (int i = 0; i < rCnt; i++)
                    {
                        if (!id.Equals(rList[i].getID()))
                            continue;

                        arrSeqNum.Add(rList[i].getSequenceNo());

                        if (res.Equals(rList[i]))
                        {
                            chk = true;
                            continue;
                        }


                        if (chk)
                            after++;
                        else
                            before++;
                    }
                }
                if (0 < (before + after))
                {
                    param = new List<object>();
                    param.Add(thread);
                    param.Add(arrSeqNum.ToArray());
                    hl = new Hyperlink(new Run("ID:" + id + "(" + (before + 1) + "/" + (before + after + 1) + ")"));
                    hl.Tag = param;
                    if (topItem)
                    {
                        if (getEnablePopupMouseHover())
                            hl.MouseEnter += resLink_MouseEnter;
                        else
                            hl.Click += resLink_MouseEnter;
                    }
                    else
                    {
                        if (getEnablePopupMouseHover())
                            hl.MouseEnter += resLinkSubItem_MouseEnter;
                        else
                            hl.Click += resLinkSubItem_MouseEnter;
                    }
                    paraHeader.Inlines.Add(hl);
                }
                else
                {
                    r = new Run();
                    r.Text = "ID:" + id;
                    span = new Span();
                    span.Foreground = Brushes.Black;
                    span.Inlines.Add(r);
                    paraHeader.Inlines.Add(span);
                }
            }

            sec.Blocks.Add(paraHeader);

            Paragraph paraBody = new Paragraph();

            Thickness thick = paraBody.Padding;
            thick.Left += 3;
            thick.Top = 0;
            parseResMsg(paraBody, thread, res, -1, -1, topItem);

            sec.Blocks.Add(paraBody);

            return sec;
        }

        public void parseResMsg(Paragraph paraBody, IThread thread, IRes res,
    int emphStart, int emphEnd, bool topItem)
        {
            string source = res.getMsg();
            int i = 0;
            int start = 0;

            int n;
            start = 0;
            i = 0;
            for (; i < source.Length; i++)
            {
                //レス参照を判定します。
                n = NTResViewPanel.getUtil().ParseResLinkReference(source, i);
                if (n > 0)
                {
                    Hyperlink hl = new Hyperlink();
                    Run r = new Run();
                    string link = source.Substring(i, n);
                    r.Text = link;
                    hl.Inlines.Add(r);
                    List<object> param = new List<object>();
                    param.Add(thread);
                    int[] arr = NTResViewPanel.getUtil().ParseResLinkReferenceNumber(link);
                    param.Add(arr);
                    hl.Tag = param;
                    if (topItem)
                    {
                        if (getEnablePopupMouseHover())
                            hl.MouseEnter += resLink_MouseEnter;
                        else
                            hl.Click += resLink_MouseEnter;
                    }
                    else
                    {
                        if (getEnablePopupMouseHover())
                            hl.MouseEnter += resLinkSubItem_MouseEnter;
                        else
                            hl.Click += resLinkSubItem_MouseEnter;
                    }
                    paraBody.Inlines.Add(hl);
                    i += (n - 1);
                    start = i + 1;
                    continue;
                }
                char c = source[i];

                //datファイルのhtmlのリンクタグ<a href=>は、表示テキストと同じ内容なので（多分）
                //単純にタグを削除します。<br>タグは改行エレメントにします。
                //その他のタグは見たことが無いので考慮しません。
                if (c == '<')
                {
                    //開始タグの前に未設定の文字列が有るときは、最初に表示エレメントを設定する。
                    if (start < i)
                    {
                        Run r;
                        if (start <= emphStart && i >= emphEnd)
                        {
                            if (start < emphStart)
                            {
                                r = new Run();
                                r.Text = source.Substring(start, emphStart - start);
                                paraBody.Inlines.Add(r);
                            }
                            r = new Run();
                            r.Text = source.Substring(emphStart, emphEnd - emphStart);
                            r.Background = new SolidColorBrush(Colors.Yellow);
                            r.Foreground = new SolidColorBrush(Colors.Green);
                            paraBody.Inlines.Add(r);
                            if (emphEnd < i)
                            {
                                r = new Run();
                                r.Text = source.Substring(emphEnd, i - emphEnd);
                                paraBody.Inlines.Add(r);
                            }
                        }
                        else
                        {
                            r = new Run();
                            r.Text = source.Substring(start, i - start);
                            paraBody.Inlines.Add(r);
                        }
                    }
                    n = source.IndexOf('>', i + 1);
                    if (n > -1)
                    {
                        string s1 = source.Substring(i + 1, n - (i + 1)).Trim();
                        if (-1 < s1.IndexOf("A HREF", StringComparison.CurrentCultureIgnoreCase)
                            || s1.Equals("/A", StringComparison.CurrentCultureIgnoreCase))
                        {
                            i = n;
                            start = n + 1;
                        }
                        else if (s1.Equals("br", StringComparison.CurrentCultureIgnoreCase))
                        {
                            LineBreak rb = new LineBreak();
                            paraBody.Inlines.Add(rb);
                            i = n;
                            start = n + 1;
                        }
                        else
                        {
                            start = i;
                        }
                    }
                    else
                    {
                        start = i;
                    }
                }
                else
                {
                    int urlLength = mUtil.ParseURLString(source, i);
                    if (urlLength >= 0)
                    {

                        Run r;
                        if (start > 0 && start < i)
                        {
                            r = new Run();
                            r.Text = source.Substring(start, i - start);
                            paraBody.Inlines.Add(r);
                        }

                        Hyperlink hl = new Hyperlink();
                        r = new Run();
                        string link = source.Substring(i, urlLength);
                        r.Text = link;
                        hl.Inlines.Add(r);
                        if (c == 't' || c == 'T')
                            link = "h" + link;

                        if (chkGraphicLink(link))
                        {
                            ThumbnailImageHelper helper =
                                ThumbnailImageHelper.CreateInstance(link);
                            paraBody.Inlines.Add(helper.GetContainer());
                            mCommand.SetThumbnailImage(helper, link);
                        }

                        try
                        {
                            hl.NavigateUri = new Uri(link);
                            hl.Click += urlLink_Click;
                        }
                        catch// (Exception e)
                        {
                            //NTDebug.l(e.Message + ": " + link);
                        }

                        paraBody.Inlines.Add(hl);
                        i += urlLength;// n1 + scheme_len + (n - i);
                        start = i;
                        i--;
                    }
                }
            }//end of for

            //処理が終わっていない文字列を表示エレメントに入れます。
            if (start < source.Length)
            {
                Run r;
                if (start <= emphStart && source.Length >= emphEnd)
                {
                    if (start < emphStart)
                    {
                        r = new Run();
                        r.Text = source.Substring(start, emphStart - start);
                        paraBody.Inlines.Add(r);
                    }
                    r = new Run();
                    r.Text = source.Substring(emphStart, emphEnd - emphStart);
                    r.Background = new SolidColorBrush(Colors.Yellow);
                    r.Foreground = new SolidColorBrush(Colors.Green);
                    paraBody.Inlines.Add(r);
                    if (emphEnd < source.Length)
                    {
                        r = new Run();
                        r.Text = source.Substring(emphEnd, source.Length - emphEnd);
                        paraBody.Inlines.Add(r);
                    }
                }
                else
                {
                    r = new Run();
                    r.Text = source.Substring(start, source.Length - start);
                    paraBody.Inlines.Add(r);
                }
            }
            int[] refArray = res.getReferenceArray();
            setFooter(thread, paraBody, refArray, topItem);
        }

        public void parseSequenceNo(InlineCollection inlines, IThread thread, IRes res)
            //int emphStart, int emphEnd, bool topItem)
        {
            Run r = new Run();
            r.Text = res.getSequenceNo().ToString();
            List<object> param = new List<object>();
            param.Add(thread);
            param.Add(res);
            Hyperlink hlink = new Hyperlink();
            hlink.Inlines.Add(r);
            hlink.Tag = param;
            //if (topItem)
            hlink.MouseEnter += ResSeqNo_MouseEnter;
            //else
            //    hlink.MouseEnter += ResSeqNoSubItem_MouseEnter;
            hlink.MouseLeftButtonDown += ResSeqNo_MouseLeftButtonDown;
            hlink.PreviewMouseLeftButtonDown += hlink_PreviewMouseLeftButtonDown;
            inlines.Add(hlink);
        }


        public void parseBackwardReferences(InlineCollection inlines, IThread thread, IRes res)
        {
            int [] refArray = res.getReferenceArray();
            string extraText = formatReferenceNumbers(refArray);
            if (extraText != null)
            {
                //inlines.Add(new LineBreak());
                Run r = new Run();
                //r.Text = "-----------------------------";
                //inlines.Add(r);
                //inlines.Add(new LineBreak());
                //r = new Run();
                r.Text = extraText;
                Hyperlink hl = new Hyperlink();

                //if (topItem)
                //{
                    if (getEnablePopupMouseHover())
                        hl.MouseEnter += resLink_MouseEnter;
                    else
                        hl.Click += resLink_MouseEnter;
                /*}
                else
                {
                    if (getEnablePopupMouseHover())
                        hl.MouseEnter += resLinkSubItem_MouseEnter;
                    else
                        hl.Click += resLinkSubItem_MouseEnter;
                }*/
                List<object> param = new List<object>();
                param.Add(thread);
                param.Add(refArray);
                hl.Tag = param;
                hl.Inlines.Add(r);
                inlines.Add(hl);
            }
        }


        public void parseIdentifier(InlineCollection inlines, IThread thread, IRes res)
        {
            Span span;
            Run r;
            string id = res.getID();
            if (id != null && id.Length > 0)
            {
                int before = 0;
                int after = 0;
                bool chk = false;
                List<IRes> rList = thread.getResList();
                List<int> arrSeqNum = new List<int>();
                if (rList != null)
                {
                    int rCnt = rList.Count;
                    for (int i = 0; i < rCnt; i++)
                    {
                        if (!id.Equals(rList[i].getID()))
                            continue;

                        arrSeqNum.Add(rList[i].getSequenceNo());

                        if (res.Equals(rList[i]))
                        {
                            chk = true;
                            continue;
                        }


                        if (chk)
                            after++;
                        else
                            before++;
                    }
                }
                if (0 < (before + after))
                {
                    List<object> param = new List<object>();
                    param.Add(thread);
                    param.Add(arrSeqNum.ToArray());
                    Hyperlink hl = new Hyperlink(new Run(id + "(" + (before + 1) + "/" + (before + after + 1) + ")"));
                    hl.Tag = param;
                    //if (topItem)
                    //{
                        if (getEnablePopupMouseHover())
                            hl.MouseEnter += resLink_MouseEnter;
                        else
                            hl.Click += resLink_MouseEnter;
                    /*}
                    else
                    {
                        if (getEnablePopupMouseHover())
                            hl.MouseEnter += resLinkSubItem_MouseEnter;
                        else
                            hl.Click += resLinkSubItem_MouseEnter;
                    }*/
                    inlines.Add(hl);
                }
                else
                {
                    r = new Run();
                    r.Text = id;
                    span = new Span();
                    span.Foreground = Brushes.Black;
                    span.Inlines.Add(r);
                    inlines.Add(span);
                }
            }
        }
#if false
        public void parseResMsg(InlineCollection inlines, IThread thread, IRes res, 
            int emphStart, int emphEnd, bool topItem)
        {
            string source = res.getMsg();
            int i = 0;
            int start = 0;

            int n;
            start = 0;
            i = 0;
            for (; i < source.Length; i++)
            {
                //レス参照を判定します。
                n = NTResViewPanel.getUtil().ParseResLinkReference(source, i);
                if (n > 0)
                {
                    Hyperlink hl = new Hyperlink();
                    Run r = new Run();
                    string link = source.Substring(i, n);
                    r.Text = link;
                    hl.Inlines.Add(r);
                    List<object> param = new List<object>();
                    param.Add(thread);
                    int[] arr = NTResViewPanel.getUtil().ParseResLinkReferenceNumber(link);
                    param.Add(arr);
                    hl.Tag = param;
                    if (topItem)
                    {
                        if (getEnablePopupMouseHover())
                            hl.MouseEnter += resLink_MouseEnter;
                        else
                            hl.Click += resLink_MouseEnter;
                    }
                    else
                    {
                        if (getEnablePopupMouseHover())
                            hl.MouseEnter += resLinkSubItem_MouseEnter;
                        else
                            hl.Click += resLinkSubItem_MouseEnter;
                    }
                    inlines.Add(hl);
                    i += (n - 1);
                    start = i + 1;
                    continue;
                }
                char c = source[i];

                //datファイルのhtmlのリンクタグ<a href=>は、表示テキストと同じ内容なので（多分）
                //単純にタグを削除します。<br>タグは改行エレメントにします。
                //その他のタグは見たことが無いので考慮しません。
                if (c == '<')
                {
                    //開始タグの前に未設定の文字列が有るときは、最初に表示エレメントを設定する。
                    if (start < i)
                    {
                        Run r;
                        if (start <= emphStart && i >= emphEnd)
                        {
                            if (start < emphStart)
                            {
                                r = new Run();
                                r.Text = source.Substring(start, emphStart - start);
                                inlines.Add(r);
                            }
                            r = new Run();
                            r.Text = source.Substring(emphStart, emphEnd - emphStart);
                            r.Background = new SolidColorBrush(Colors.Yellow);
                            r.Foreground = new SolidColorBrush(Colors.Green);
                            inlines.Add(r);
                            if (emphEnd < i)
                            {
                                r = new Run();
                                r.Text = source.Substring(emphEnd, i - emphEnd);
                                inlines.Add(r);
                            }
                        }
                        else
                        {
                            r = new Run();
                            r.Text = source.Substring(start, i - start);
                            inlines.Add(r);
                        }
                    }
                    n = source.IndexOf('>', i + 1);
                    if (n > -1)
                    {
                        string s1 = source.Substring(i + 1, n - (i + 1)).Trim();
                        if (-1 < s1.IndexOf("A HREF", StringComparison.CurrentCultureIgnoreCase)
                            || s1.Equals("/A", StringComparison.CurrentCultureIgnoreCase))
                        {
                            i = n;
                            start = n + 1;
                        }
                        else if (s1.Equals("br", StringComparison.CurrentCultureIgnoreCase))
                        {
                            LineBreak rb = new LineBreak();
                            inlines.Add(rb);
                            i = n;
                            start = n + 1;
                        }
                        else
                        {
                            start = i;
                        }
                    }
                    else
                    {
                        start = i;
                    }
                }
                else
                {
                    int urlLength = mUtil.ParseURLString(source, i);
                    if (urlLength >= 0)
                    {

                        Run r;
                        if (start > 0 && start < i)
                        {
                            r = new Run();
                            r.Text = source.Substring(start, i - start);
                            inlines.Add(r);
                        }

                        Hyperlink hl = new Hyperlink();
                        r = new Run();
                        string link = source.Substring(i, urlLength);
                        r.Text = link;
                        hl.Inlines.Add(r);
                        if (c == 't' || c == 'T')
                            link = "h" + link;

                        if (chkGraphicLink(link))
                        {
                            ThumbnailImageHelper helper =
                                ThumbnailImageHelper.CreateInstance(link);
                            inlines.Add(helper.GetContainer());
                            mCommand.SetThumbnailImage(helper, link);
                        }

                        try
                        {
                            hl.NavigateUri = new Uri(link);
                            hl.Click += urlLink_Click;
                        }
                        catch// (Exception e)
                        {
                            //NTDebug.l(e.Message + ": " + link);
                        }

                        inlines.Add(hl);
                        i += urlLength;// n1 + scheme_len + (n - i);
                        start = i;
                        i--;
                    }
                }
            }//end of for

            //処理が終わっていない文字列を表示エレメントに入れます。
            if (start < source.Length)
            {
                Run r;
                if (start <= emphStart && source.Length >= emphEnd)
                {
                    if (start < emphStart)
                    {
                        r = new Run();
                        r.Text = source.Substring(start, emphStart - start);
                        inlines.Add(r);
                    }
                    r = new Run();
                    r.Text = source.Substring(emphStart, emphEnd - emphStart);
                    r.Background = new SolidColorBrush(Colors.Yellow);
                    r.Foreground = new SolidColorBrush(Colors.Green);
                    inlines.Add(r);
                    if (emphEnd < source.Length)
                    {
                        r = new Run();
                        r.Text = source.Substring(emphEnd, source.Length - emphEnd);
                        inlines.Add(r);
                    }
                }
                else
                {
                    r = new Run();
                    r.Text = source.Substring(start, source.Length - start);
                    inlines.Add(r);
                }
            }
            //int[] refArray = res.getReferenceArray();
            //setFooter(thread, paraBody, refArray, topItem);
        }
#endif
        public void setThumbnailImage(ThumbnailImageHelper helper, string link)
        {
            mCommand.SetThumbnailImage(helper, link);
        }

        bool chkGraphicLink(string src)
        {
            if (!chkShowThumbnail())
                return false;

            if (src == null || src.Length < 4)
                return false;
            int idx = src.LastIndexOf('.');
            if (idx < 0)
                return false;

            string suffix = src.Substring(idx + 1).ToLower();
            switch (suffix)
            {
                case "png":
                case "jpg":
                case "jpeg":
                case "bmp":
                case "gif":
                    return true;
                default:
                    return false;
            }
        }
        bool chkShowThumbnail()
        {
            object o;
            Dictionary<PREF_PARAM, object> dict = mCommand.GetPreference();
            if (!dict.TryGetValue(PREF_PARAM.RES_VIEW_SHOW_THUMBNAIL, out o))
                return false;

            string show = o as string;
            if (show == null)
                return false;

            return show.Equals(bool.TrueString);
        }
        void setFooter(IThread thread, Paragraph para, int[] refArray , bool topItem)
        {
            string extraText = formatReferenceNumbers(refArray);
            if (extraText != null)
            {
                para.Inlines.Add(new LineBreak());
                Run r = new Run();
                r.Text = "-----------------------------";
                para.Inlines.Add(r);
                para.Inlines.Add(new LineBreak());
                r = new Run();
                r.Text = extraText;
                Hyperlink hl = new Hyperlink();

                if (topItem)
                {
                    if (getEnablePopupMouseHover())
                        hl.MouseEnter += resLink_MouseEnter;
                    else
                        hl.Click += resLink_MouseEnter;
                }
                else
                {
                    if (getEnablePopupMouseHover())
                        hl.MouseEnter += resLinkSubItem_MouseEnter;
                    else
                        hl.Click += resLinkSubItem_MouseEnter;
                }
                List<object> param = new List<object>();
                param.Add(thread);
                param.Add(refArray);
                hl.Tag = param;
                hl.Inlines.Add(r);
                para.Inlines.Add(hl);
            }

        }

        public static string formatReferenceNumbers(int[] valList)
        {
            if (null == valList) { return null; }
            if (0 >= valList.Length) { return null; }

            StringBuilder buf = new StringBuilder();
            buf.Append("<<");

            bool flagFirst = true;

            int prevVal = 0;
            int i = 0;
            for (; i < valList.Length - 1; i++)
            {
                int val1 = valList[i];
                int val2 = valList[i + 1];
                if (val1 == val2 - 1)
                {
                    if (0 == prevVal)
                    {
                        prevVal = val1;
                    }
                }
                else
                {
                    if (!flagFirst)
                    {
                        buf.Append(',');
                    }
                    else
                    {
                        flagFirst = false;
                    }
                    if (0 != prevVal)
                    {
                        buf.Append(prevVal.ToString());
                        buf.Append('-');
                        buf.Append(val1.ToString());
                        prevVal = 0;
                    }
                    else
                    {
                        buf.Append(val1.ToString());
                    }
                }
            }

            if (!flagFirst)
            {
                buf.Append(',');
            }
            if (0 != prevVal)
            {
                buf.Append(prevVal.ToString());
                buf.Append('-');
                buf.Append(valList[i].ToString());
            }
            else
            {
                buf.Append(valList[i].ToString());
            }

            return buf.ToString();
        }
        public void removeBookmark(IThread ithread, IRes ires, bool save)
        {
            if (save && !NTResViewPanel.getCommand().DeleteBookmark(ithread, ires))
                return;

            ResViewCtrlState state = ResViewCtrlState.getInstance();
            if (state.EnableHtmlLayout)
            {
                if (save)
                {
                    mResCashDataList.Clear();
                    mMainPanel.InvalidateItems();
                }
            }
            else
            {
                Section sec = ires.getExtra() as Section;
                if (sec == null)
                    return;

                if (2 > sec.Blocks.Count)
                    return;

                Paragraph paraBody = sec.Blocks.LastBlock as Paragraph;

                if (paraBody == null)
                    return;

                Inline il = paraBody.Inlines.FirstInline;
                if (il == null)
                    return;
                Span span = il as Span;
                if (span == null)
                    return;
                Hyperlink hl = span as Hyperlink;
                if (hl != null)
                    return;
                paraBody.Inlines.Remove(span);
            }
        }

        public void addBookmark(IThread ithread, IRes ires, bool save)
        {
            if (save && !NTResViewPanel.getCommand().AddBookmark(ithread, ires))
                return;

            ResViewCtrlState state = ResViewCtrlState.getInstance();
            if (state.EnableHtmlLayout)
            {
                if (save)
                {
                    mResCashDataList.Clear();
                    mMainPanel.InvalidateItems();
                }
            }
            else
            {

                Section sec = ires.getExtra() as Section;

                if (sec == null)
                    return;

                if (2 > sec.Blocks.Count)
                    return;

                Paragraph paraBody = sec.Blocks.LastBlock as Paragraph;

                if (paraBody == null)
                    return;

                Inline il = paraBody.Inlines.FirstInline;
                if (il == null)
                    return;

                Span span = il as Span;
                if (span != null)
                {
                    Hyperlink hl = span as Hyperlink;
                    if (hl == null)
                        return;
                }

                Image img = new Image();
                img.Width = 12;
                img.Height = 20;
                Uri oUri = new Uri(
                    "pack://application:,,,/NT2chStyle45;component/images/tag.png",
                    UriKind.RelativeOrAbsolute);
                BitmapImage bi = new BitmapImage();
                bi.BeginInit();
                bi.UriSource = oUri;

                bi.EndInit();
                img.Source = bi;
                img.VerticalAlignment = System.Windows.VerticalAlignment.Center;
                span = new Span();
                span.Inlines.Add(img);
                paraBody.Inlines.InsertBefore(il, span);
            }
        }

        public void JumpTo(int newPosition)
        {
            newPosition--;
            if (newPosition < 0 || newPosition >= mResList.Count)
                return;

            mMainPanel.JumpTo(newPosition);
        }

    }
}
