﻿using NT2chCtrl2;
using NT2chObject;
using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Media;

namespace NT2chCtrl2
{
    class NTBoardData
    {
        bool mDummy;
        public IBoard mBoard;
        double mWidth;
        string mName;
        Brush mBrush;
        public NTBoardData(IBoard iboard)
        {
            mBoard = iboard;
            if (iboard != null)
                mName = iboard.getName();
            else
                mName = " ";
            mDummy = false;
            mWidth = 100;
            mBrush = null;
        }

        static NTBoardData mDummyData = null;
        public static NTBoardData getDummy()
        {
            if (mDummyData == null)
            {
                NTBoardData data = new NTBoardData(null);
                data.mDummy = true;
                data.mWidth = 10;
                mDummyData = data;
                data.mBrush = new SolidColorBrush(Colors.Yellow);
            }
            return mDummyData;        
        }

        public bool IsDummy()
        {
            return mDummy;
        }

        public string BoardName
        {
            get { return mName; }
        }
        public double Width
        {
            get { return mWidth; }
        }
        public Brush Background
        {
            get { return mBrush; }
        }
    }
}
