﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Controls.Primitives;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using NT2chCtrl;

namespace NT2chView
{
    /// <summary>
    /// NTCategoryPanel.xaml の相互作用ロジック
    /// </summary>
    public partial class NTCategoryPanel : UserControl
    {
        public MainWindow.DelegateMsgOpenBoardListRequest OpenBoardListRequest
        {
            get;
            set;
        }

        public MainWindow.DelegateMsgOpenFavoriteListRequest OpenFavoriteListRequest
        {
            get;
            set;
        }


        public NTCategoryPanel()
        {
            InitializeComponent();
        }
        List<NTCategory> mCategoryTable;

        public List<NTCategory> CategoryTable
        {
            get 
            {
                return mCategoryTable;
            }
            set
            {
                mCategoryTable = value;
                initCategory();
            }
        }

        public void addExternalCategory(NTCategory exCate)
        {
            if (mCategoryTable == null || exCate == null)
                return;

            if (hasExternalCategory())
                return;

            Style style = (Style)TryFindResource("CategoryDisplayButton");

 
            ToggleButton btn = new ToggleButton();
            btn.Checked += btn_Checked;
            btn.Unchecked += btn_Unchecked;

            if (style != null)
                btn.Style = style;
            btn.Content = NTDataRoot.EXTERNAL_BOARD_CATEGORY_NAME;
            btn.Tag = exCate;

            mMainPanel.Children.Add(btn);
            mCategoryTable.Add(exCate);
        }

        private bool hasExternalCategory()
        {
            foreach (object o in mMainPanel.Children)
            {
                ToggleButton tglBtn = o as ToggleButton;
                if (tglBtn == null)
                    continue;
                string content = tglBtn.Content as string;
                if (content == null)
                    continue;

                if (content.Equals(NTDataRoot.EXTERNAL_BOARD_CATEGORY_NAME))
                    return true; ;

            }
            return false;
        }

        public bool isExternalCategorySelected()
        {
            foreach (object o in mMainPanel.Children)
            {
                ToggleButton tglBtn = o as ToggleButton;
                if (tglBtn == null)
                    continue;
                string content = tglBtn.Content as string;
                if (content == null)
                    continue;

                if(!content.Equals(NTDataRoot.EXTERNAL_BOARD_CATEGORY_NAME))
                    continue;
                if(tglBtn.IsChecked.HasValue)
                    return (bool)tglBtn.IsChecked;
                else
                    return false;

            }
            return false;
        }

        private void initCategory()
        {
            if(mCategoryTable == null)
                return;

            Brush brush = (Brush)TryFindResource("BasicBkBrush");

            Style style = (Style)TryFindResource("CategoryDisplayButton");

            //StackPanel sp = null;
            
            //StackPanel sp = new StackPanel();
            //sp.Orientation = Orientation.Horizontal;
            if (brush != null)
                mMainPanel.Background = brush;

            ToggleButton btn = new ToggleButton();
            btn.Checked += btn_Checked;
            btn.Unchecked += btn_Unchecked;
            
            if (style != null)
                btn.Style = style;
            btn.Content = "お気に入り";
            btn.Tag = new NTFavorite();

            mMainPanel.Children.Add(btn);

            //sp = sp2;


            foreach(NTCategory category in mCategoryTable)
            {
                btn = new ToggleButton();
                btn.Checked += btn_Checked;
                btn.Unchecked += btn_Unchecked;

                if (style != null)
                    btn.Style = style;
                btn.Content = category.mName;
                btn.Tag = category;

                mMainPanel.Children.Add(btn);

                //TextBlock tb = new TextBlock(new Run(category.mName));
                /*if (sp == null)
                {
                    sp = new StackPanel();
                    sp.Orientation = Orientation.Horizontal;
                    if (brush != null)
                        sp.Background = brush;
                    sp.Children.Add(btn);
                }
                else
                {
                    sp.Children.Add(btn);
                    mMainPanel.Children.Add(sp);
                    sp = null;
                }
            }
            if(sp != null)
            {
                mMainPanel.Children.Add(sp);*/
            }
        }

        void btn_Checked(object sender, RoutedEventArgs e)
        {
            object selectedObj = null;
            foreach (object o in mMainPanel.Children)
            {
                ToggleButton tb = o as ToggleButton;
                if (tb == null)
                    continue;

                if (sender.Equals(o))
                {
                    selectedObj = o;
                }
                else
                {
                    tb.IsChecked = false;
                }

            }
            if (OpenBoardListRequest != null)
            {
                ToggleButton tglBtn = selectedObj as ToggleButton;
                if (tglBtn != null)
                {
                    NTCategory category = tglBtn.Tag as NTCategory;
                    if(category != null)
                        OpenBoardListRequest(category);

                    NTFavorite favorite = tglBtn.Tag as NTFavorite;
                    if (favorite != null)
                        OpenFavoriteListRequest(favorite);
                }
            }

        }

        void btn_Unchecked(object sender, RoutedEventArgs e)
        {
            //throw new NotImplementedException();
        }

        private void CategoryPanel_Loaded(object sender, RoutedEventArgs e)
        {
#if DOTNET45

            TouchSupportScrollViewer sv =
                new TouchSupportScrollViewer(mCategoryPanelScrollViewer, mMainPanel);
#endif
        }
    }
}
