﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Windows;

namespace NT2chObject
{
    public abstract class NTThread : DependencyObject
    {

        public static readonly DependencyProperty SeqNoProperty;
        public static readonly DependencyProperty TitleProperty;
        public static readonly DependencyProperty ResCntProperty;
        public static readonly DependencyProperty ReadCntProperty;
        public static readonly DependencyProperty RemainCntProperty;
        public static readonly DependencyProperty LastModProperty;
        public static readonly DependencyProperty LastWriteProperty;
        public static readonly DependencyProperty IsFavoriteProperty;

        static NTThread()
        {

            PropertyMetadata pm1 = new PropertyMetadata(0);
            PropertyMetadata pm3 = new PropertyMetadata(0, new PropertyChangedCallback(OnResCntChanged));
            PropertyMetadata pm4 = new PropertyMetadata(0, new PropertyChangedCallback(OnReadCntChanged));
            PropertyMetadata pm5 = new PropertyMetadata(0);
            PropertyMetadata pm2 = new PropertyMetadata(string.Empty);
            PropertyMetadata pm6 = new PropertyMetadata(string.Empty);
            PropertyMetadata pm7 = new PropertyMetadata(string.Empty);
            PropertyMetadata pm8 = new PropertyMetadata(false);

            SeqNoProperty = DependencyProperty.Register("SeqNo", typeof(int), typeof(NTThread), pm1);
            TitleProperty = DependencyProperty.Register("Title", typeof(string), typeof(NTThread), pm2);
            ResCntProperty = DependencyProperty.Register("ResCnt", typeof(int), typeof(NTThread), pm3);
            ReadCntProperty = DependencyProperty.Register("ReadCnt", typeof(int), typeof(NTThread), pm4);
            RemainCntProperty = DependencyProperty.Register("RemainCnt", typeof(int), typeof(NTThread), pm5);
            LastModProperty = DependencyProperty.Register("LastMod", typeof(string), typeof(NTThread), pm6);
            LastWriteProperty = DependencyProperty.Register("LastWrite", typeof(string), typeof(NTThread), pm7);
            IsFavoriteProperty = DependencyProperty.Register("IsFavorite", typeof(bool), typeof(NTThread), pm8);

        }

        public int SeqNo
        {
            set { SetValue(SeqNoProperty, value); }
            get { return (int)GetValue(SeqNoProperty); }
        }
        public string Title
        {
            set { SetValue(TitleProperty, value); }
            get { return (string)GetValue(TitleProperty); }
        }
        public int ResCnt
        {
            set { SetValue(ResCntProperty, value); }
            get { return (int)GetValue(ResCntProperty); }
        }
        public int ReadCnt
        {
            set { SetValue(ReadCntProperty, value); }
            get { return (int)GetValue(ReadCntProperty); }
        }
        public int RemainCnt
        {
            set { SetValue(RemainCntProperty, value); }
            get { return (int)GetValue(RemainCntProperty); }
        }
        public string LastMod
        {
            set { SetValue(LastModProperty, value); }
            get { return (string)GetValue(LastModProperty); }
        }
        public string LastWrite
        {
            set { SetValue(LastWriteProperty, value); }
            get { return (string)GetValue(LastWriteProperty); }
        }
        public bool IsFavorite
        {
            set { SetValue(IsFavoriteProperty, value); }
            get { return (bool)GetValue(IsFavoriteProperty); }
        }

        static void OnResCntChanged(DependencyObject d, DependencyPropertyChangedEventArgs e)
        {
            NTThread t = (NTThread)d;
            t.RemainCnt = (int)e.NewValue - t.ReadCnt;
        }

        static void OnReadCntChanged(DependencyObject d, DependencyPropertyChangedEventArgs e)
        {
            NTThread t = (NTThread)d;
            if (t.ResCnt < (int)e.NewValue)
                t.ResCnt = (int)e.NewValue;
            else
                t.RemainCnt = t.ResCnt - (int)e.NewValue;
        }

        public abstract string getDatName();

    }
}
