﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace NT2chCtrl.html.js
{
    class JsOpFunction_for : JsFunction
    {

        JsFunction mInitializeFunc;
        JsFunction mEvaluateFunc;
        JsFunction mRepeatFunc;

        public JsVariant initialize(JsFunctionContext fCtx, HtmlElement hElem)
        {
            return mInitializeFunc.Execute(fCtx, hElem);
        }
        public JsVariant evaluate(JsFunctionContext fCtx, HtmlElement hElem)
        {
            return mEvaluateFunc.Execute(fCtx, hElem);
        }
        public JsVariant repeat(JsFunctionContext fCtx, HtmlElement hElem)
        {
            return mRepeatFunc.Execute(fCtx, hElem);
        }


        public JsOpFunction_for(int lineNo, int srcIdx)
            : base(lineNo, srcIdx)
        {
        }

        public override bool rearegeSquence(List<JsVariant> insList, int currIdx)
        {
            List<JsVariant> para;
            JsRBracket rBraket = null;
            int count = insList.Count;

            if (currIdx + 1 >= count)
                return false;
            rBraket = insList[currIdx + 1] as JsRBracket;
            if (rBraket == null)
                return false;

            para = rBraket.mArgs;
            if (para.Count != 1)
                return false;

            JsSemiColonFunction semicolon = para[0] as JsSemiColonFunction;
            if (semicolon == null)
                return false;

            List<JsVariant> args = semicolon.mArgs;

            if(args.Count != 3)
                return false;

            mInitializeFunc = args[0] as JsFunction;
            mEvaluateFunc = args[1] as JsFunction;
            mRepeatFunc = args[2] as JsFunction; 

            insList.RemoveAt(currIdx + 1);

            mArranged = true;
            return true;
        }

        public override int getPriority()
        {
            return FUNC_PRIORITY_FUNCTION;
        }

        public override JsVariant Execute(JsFunctionContext ctx, HtmlElement rootElement)
        {
            DebugContext dCtx = ctx.getDbgCtx();
            if (dCtx != null)
            {
                dCtx.mCurrentLine = mSourceLine;
                dCtx.mCurentIndex = mSourceIdx;
            }
            return null;
            /*
            if (mParams == null || mParams.Count != 1)
                return null;


            JsVariant param = ctx.getParamValue(rootElement, mParams[0]);

            if (param == null)
                return null;

            return param.getBooleanValue();*/
        }
    }
    class JsOpFunction_if : JsFunction
    {
        public List<JsVariant> mParams = null;

        public JsOpFunction_if(int lineNo, int srcIdx)
            : base(lineNo, srcIdx)
        {
        }

        public override bool rearegeSquence(List<JsVariant> insList, int currIdx)
        {
            JsRBracket rBraket = null;
            int count = insList.Count;

            if (currIdx + 1 >= count)
                return false;
            rBraket = insList[currIdx + 1] as JsRBracket;
            if (rBraket == null)
                return false;

            mParams = rBraket.mArgs;
            if (mParams.Count != 1)
                return false;

            insList.RemoveAt(currIdx + 1);

            mArranged = true;
            return true;
        }

        public override int getPriority()
        {
            return FUNC_PRIORITY_FUNCTION;
        }

        public override JsVariant Execute(JsFunctionContext ctx, HtmlElement rootElement)
        {
            DebugContext dCtx = ctx.getDbgCtx();
            if (dCtx != null)
            {
                dCtx.mCurrentLine = mSourceLine;
                dCtx.mCurentIndex = mSourceIdx;
            }

            if (mParams == null || mParams.Count != 1)
                return null;


            JsVariant param = ctx.getParamValue(rootElement, mParams[0]);

            if (param == null)
                return null;

            return param.getBooleanValue();
        }
    }
    class JsOpFunction_else : JsFunction
    {

        public JsOpFunction_else(int lineNo, int srcIdx)
            : base(lineNo, srcIdx)
        {
        }
        public override int getPriority()
        {
            return FUNC_PRIORITY_FUNCTION;
        }

    }
    class JsL_CURLY_Bracket : JsFunction
    {

        public JsL_CURLY_Bracket(int lineNo, int srcIdx)
            : base(lineNo, srcIdx)
        {
        }
        public override int getPriority()
        {
            return FUNC_PRIORITY_FUNCTION;
        }

        public override JsVariant Execute(JsFunctionContext ctx, HtmlElement rootElement)
        {
            return null;
        }
    }
    class JsR_CURLY_Bracket : JsFunction
    {

        public JsR_CURLY_Bracket(int lineNo, int srcIdx)
            : base(lineNo, srcIdx)
        {
        }
        public override int getPriority()
        {
            return FUNC_PRIORITY_FUNCTION;
        }

        public override JsVariant Execute(JsFunctionContext ctx, HtmlElement rootElement)
        {
            return null;
        }
    }

}
