﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Media;

namespace NT2chCtrl.html.css
{
    public class cssColor
    {
        string mColorName;
        int mColorValue;

        cssColor(string colorName, int colorValue)
        {
            mColorName = colorName;
            mColorValue = colorValue;
        }

        public static Color getColor(string colorText)
        {
            colorText = colorText.Trim();
            int idx;

            idx = colorText.IndexOf("rgb(");
            if (idx == 0)
            {
                int endIdx;
                return getColorFromRgbString(colorText, 4, out endIdx);
            }
            idx = colorText.IndexOf('#');
            if (idx == 0)
            {
                return getColorFromHexString(colorText, 1);
            }
            foreach (cssColor c in mColorList)
            {
                if (colorText.Equals(c.mColorName, StringComparison.OrdinalIgnoreCase))
                    return getColor(c.mColorValue);
            }
            return Colors.Transparent;
        }


        private static Color getColorFromRgbString(string rgbString, int startIdx, out int endIdx)
        {

            int length = rgbString.Length;
            int digits = 0;
            int value = 0;
            int colorIdx = 0;
            int r = 0, g = 0;//, b = 0;

            endIdx = 0;

            for (int i = startIdx; i < length; i++)
            {
                char c = rgbString[i];
                if (c >= '0' && c <= '9')
                {
                    if (digits == 0)
                        value = c - '0';
                    else if (digits == 1)
                        value = (c - '0') + (value * 10);
                    else if (digits == 2)
                        value = (c - '0') + (value * 10);
                    else
                        return Colors.Transparent;
                    digits++;
                }
                else if (c == ',')
                {
                    if (digits == 0)
                        return Colors.Transparent;

                    if (colorIdx == 0)
                        r = value;
                    else if (colorIdx == 1)
                        g = value;
                    //else if (colorIdx == 2)
                    //    b = value;
                    else
                        return Colors.Transparent;
                    colorIdx++;
                    digits = 0;
                }
                else if (c == ' ' || c == '\t' || c == 'r' || c == '\n')
                {
                }
                else if (c == ')')
                {
                    if (colorIdx != 2)
                        return Colors.Transparent;
                    endIdx = i;
                    return Color.FromRgb((byte)r, (byte)g, (byte)value);
                }
                else
                {
                    return Colors.Transparent;
                }
            }
            return Colors.Transparent;
        }

        private static Color getColorFromHexString(string hexString, int startIdx)
        {
            int[] by = new int[8];
            int length = Math.Min(hexString.Length, 8);
            int idx = 0;
            for (int i = startIdx; i < length; i++)
            {
                char c = hexString[i];
                if (c >= '0' && c <= '9')
                {
                    by[idx] = (c - '0');
                }else if(c >= 'a' && c <= 'f'){
                    by[idx] = (c - 'a' + 10);
                }
                else if (c >= 'A' && c <= 'F')
                {
                    by[idx] = (c - 'A' + 10);
                }
                else
                {
                    idx++;
                    break;
                }
                idx++;
            }
            if (idx < 0 || idx > 6)
                return Colors.Transparent;

            int r = 0, g = 0, b = 0;
            idx--;
            if (idx < 3)
            {
                for (int i = 0; idx >= 0; i++)
                {
                    switch (i)
                    {
                        case 0:
                            b = by[idx]<<4;
                            break;
                        case 1:
                            g = by[idx]<<4;
                            break;
                        case 2:
                            r = by[idx]<<4;
                            break;
                    }

                    idx--;
                }
            }
            else
            {
                for (int i = 0; idx >= 0; i++)
                {
                    switch (i)
                    {
                        case 0:
                            b = by[idx];
                            break;
                        case 1:
                            b += (by[idx] << 4);
                            break;
                        case 2:
                            g = by[idx];
                            break;
                        case 3:
                            g += (by[idx] << 4);
                            break;
                        case 4:
                            r = by[idx];
                            break;
                        case 5:
                            r += (by[idx] << 4);
                            break;
                    }

                    idx--;
                }
            }

            return Color.FromRgb((byte)r, (byte)g, (byte)b);

        }

        private static Color getColor(int value)
        {
            int r = (value & 0xff0000) >> 16;
            int g = (value & 0xff00) >> 8;
            int b = (value & 0xff);
            return Color.FromRgb((byte)r, (byte)g, (byte)b);
        }

        static cssColor [] mColorList = 
        {
            new cssColor("aliceblue", 0xF0F8FF),	// 240,248,255
            new cssColor("antiquewhite", 0xFAEBD7),	//250,235,215
            new cssColor("aqua", 0x00FFFF),	//0,255,255
            new cssColor("aquamarine", 0x7FFFD4),	//127,255,212
            new cssColor("azure", 0xF0FFFF),	//240,255,255
            new cssColor("beige", 0xF5F5DC),	//245,245,220
            new cssColor("bisque", 0xFFE4C4),	//255,228,196
            new cssColor("black", 0x000000),	//0,0,0
            new cssColor("blanchedalmond", 0xFFEBCD),	//255,235,205
            new cssColor("blue", 0x0000FF),	//0,0,255
            new cssColor("blueviolet", 0x8A2BE2),	//138,43,226
            new cssColor("brown", 0xA52A2A),	//165,42,42
            new cssColor("burlywood", 0xDEB887),	//222,184,135
            new cssColor("cadetblue", 0x5F9EA0),	//95,158,160
            new cssColor("chartreuse", 0x7FFF00),	//127,255,0
            new cssColor("chocolate", 0xD2691E),	//210,105,30
            new cssColor("coral", 0xFF7F50),	//255,127,80
            new cssColor("cornflowerblue", 0x6495ED),	//100,149,237
            new cssColor("cornsilk", 0xFFF8DC),	//255,248,220
            new cssColor("crimson", 0xDC143C),	//220,20,60
            new cssColor("cyan", 0x00FFFF),	//0,255,255
            new cssColor("darkblue", 0x00008B),	//0,0,139
            new cssColor("darkcyan", 0x008B8B),	//0,139,139
            new cssColor("darkgoldenrod", 0xB8860B),	//184,134,11
            new cssColor("darkgray", 0xA9A9A9),	//169,169,169
            new cssColor("darkgreen", 0x006400),	//0,100,0
            new cssColor("darkgrey", 0xA9A9A9),	//169,169,169
            new cssColor("darkkhaki", 0xBDB76B),	//189,183,107
            new cssColor("darkmagenta", 0x8B008B),	//139,0,139
            new cssColor("darkolivegreen", 0x556B2F),	//85,107,47
            new cssColor("darkorange", 0xFF8C00),	//255,140,0
            new cssColor("darkorchid", 0x9932CC),	//153,50,204
            new cssColor("darkred", 0x8B0000),	//139,0,0
            new cssColor("darksalmon", 0xE9967A),	//233,150,122
            new cssColor("darkseagreen", 0x8FBC8F),	//143,188,143
            new cssColor("darkslateblue", 0x483D8B),	//72,61,139
            new cssColor("darkslategray", 0x2F4F4F),	//47,79,79
            new cssColor("darkslategrey", 0x2F4F4F),	//47,79,79
            new cssColor("darkturquoise", 0x00CED1),	//0,206,209
            new cssColor("darkviolet", 0x9400D3),	//148,0,211
            new cssColor("deeppink", 0xFF1493),	//255,20,147
            new cssColor("deepskyblue", 0x00BFFF),	//0,191,255
            new cssColor("dimgray", 0x696969),	//105,105,105
            new cssColor("dimgrey", 0x696969),	//105,105,105
            new cssColor("dodgerblue", 0x1E90FF),	//30,144,255
            new cssColor("firebrick", 0xB22222),	//178,34,34
            new cssColor("floralwhite", 0xFFFAF0),	//255,250,240
            new cssColor("forestgreen", 0x228B22),	//34,139,34
            new cssColor("fuchsia", 0xFF00FF),	//255,0,255
            new cssColor("gainsboro", 0xDCDCDC),	//220,220,220
            new cssColor("ghostwhite", 0xF8F8FF),	//248,248,255
            new cssColor("gold", 0xFFD700),	//255,215,0
            new cssColor("goldenrod", 0xDAA520),	//218,165,32
            new cssColor("gray", 0x808080),	//128,128,128
            new cssColor("green", 0x008000),	//0,128,0
            new cssColor("greenyellow", 0xADFF2F),	//173,255,47
            new cssColor("grey", 0x808080),	//128,128,128
            new cssColor("honeydew", 0xF0FFF0),	//240,255,240
            new cssColor("hotpink", 0xFF69B4),	//255,105,180
            new cssColor("indianred", 0xCD5C5C),	//205,92,92
            new cssColor("indigo", 0x4B0082),	//75,0,130
            new cssColor("ivory", 0xFFFFF0),	//255,255,240
            new cssColor("khaki", 0xF0E68C),	//240,230,140
            new cssColor("lavender", 0xE6E6FA),	//230,230,250
            new cssColor("lavenderblush", 0xFFF0F5),	//255,240,245
            new cssColor("lawngreen", 0x7CFC00),	//124,252,0
            new cssColor("lemonchiffon", 0xFFFACD),	//255,250,205
            new cssColor("lightblue", 0xADD8E6),	//173,216,230
            new cssColor("lightcoral", 0xF08080),	//240,128,128
            new cssColor("lightcyan", 0xE0FFFF),	//224,255,255
            new cssColor("lightgoldenrodyellow", 0xFAFAD2),	//250,250,210
            new cssColor("lightgray", 0xD3D3D3),	//211,211,211
            new cssColor("lightgreen", 0x90EE90),	//144,238,144
            new cssColor("lightgrey", 0xD3D3D3),	//211,211,211
            new cssColor("lightpink", 0xFFB6C1),	//255,182,193
            new cssColor("lightsalmon", 0xFFA07A),	//255,160,122
            new cssColor("lightseagreen", 0x20B2AA),	//32,178,170
            new cssColor("lightskyblue", 0x87CEFA),	//135,206,250
            new cssColor("lightslategray", 0x778899),	//119,136,153
            new cssColor("lightslategrey", 0x778899),	//119,136,153
            new cssColor("lightsteelblue", 0xB0C4DE),	//176,196,222
            new cssColor("lightyellow", 0xFFFFE0),	//255,255,224
            new cssColor("lime", 0x00FF00),	//0,255,0
            new cssColor("limegreen", 0x32CD32),	//50,205,50
            new cssColor("linen", 0xFAF0E6),	//250,240,230
            new cssColor("magenta", 0xFF00FF),	//255,0,255
            new cssColor("maroon", 0x800000),	//128,0,0
            new cssColor("mediumaquamarine", 0x66CDAA),	//102,205,170
            new cssColor("mediumblue", 0x0000CD),	//0,0,205
            new cssColor("mediumorchid", 0xBA55D3),	//186,85,211
            new cssColor("mediumpurple", 0x9370DB),	//147,112,219
            new cssColor("mediumseagreen", 0x3CB371),	//60,179,113
            new cssColor("mediumslateblue", 0x7B68EE),	//123,104,238
            new cssColor("mediumspringgreen", 0x00FA9A),	//0,250,154
            new cssColor("mediumturquoise", 0x48D1CC),	//72,209,204
            new cssColor("mediumvioletred", 0xC71585),	//199,21,133
            new cssColor("midnightblue", 0x191970),	//25,25,112
            new cssColor("mintcream", 0xF5FFFA),	//245,255,250
            new cssColor("mistyrose", 0xFFE4E1),	//255,228,225
            new cssColor("moccasin", 0xFFE4B5),	//255,228,181
            new cssColor("navajowhite", 0xFFDEAD),	//255,222,173
            new cssColor("navy", 0x000080),	//0,0,128
            new cssColor("oldlace", 0xFDF5E6),	//253,245,230
            new cssColor("olive", 0x808000),	//128,128,0
            new cssColor("olivedrab", 0x6B8E23),	//107,142,35
            new cssColor("orange", 0xFFA500),	//255,165,0
            new cssColor("orangered", 0xFF4500),	//255,69,0
            new cssColor("orchid", 0xDA70D6),	//218,112,214
            new cssColor("palegoldenrod", 0xEEE8AA),	//238,232,170
            new cssColor("palegreen", 0x98FB98),	//152,251,152
            new cssColor("paleturquoise", 0xAFEEEE),	//175,238,238
            new cssColor("palevioletred", 0xDB7093),	//219,112,147
            new cssColor("papayawhip", 0xFFEFD5),	//255,239,213
            new cssColor("peachpuff", 0xFFDAB9),	//255,218,185
            new cssColor("peru", 0xCD853F),	//205,133,63
            new cssColor("pink", 0xFFC0CB),	//255,192,203
            new cssColor("plum", 0xDDA0DD),	//221,160,221
            new cssColor("powderblue", 0xB0E0E6),	//176,224,230
            new cssColor("purple", 0x800080),	//128,0,128
            new cssColor("red", 0xFF0000),	//255,0,0
            new cssColor("rosybrown", 0xBC8F8F),	//188,143,143
            new cssColor("royalblue", 0x4169E1),	//65,105,225
            new cssColor("saddlebrown", 0x8B4513),	//139,69,19
            new cssColor("salmon", 0xFA8072),	//250,128,114
            new cssColor("sandybrown", 0xF4A460),	//244,164,96
            new cssColor("seagreen", 0x2E8B57),	//46,139,87
            new cssColor("seashell", 0xFFF5EE),	//255,245,238
            new cssColor("sienna", 0xA0522D),	//160,82,45
            new cssColor("silver", 0xC0C0C0),	//192,192,192
            new cssColor("skyblue", 0x87CEEB),	//135,206,235
            new cssColor("slateblue", 0x6A5ACD),	//106,90,205
            new cssColor("slategray", 0x708090),	//112,128,144
            new cssColor("slategrey", 0x708090),	//112,128,144
            new cssColor("snow", 0xFFFAFA),	//255,250,250
            new cssColor("springgreen", 0x00FF7F),	//0,255,127
            new cssColor("steelblue", 0x4682B4),	//70,130,180
            new cssColor("tan", 0xD2B48C),	//210,180,140
            new cssColor("teal", 0x008080),	//0,128,128
            new cssColor("thistle", 0xD8BFD8),	//216,191,216
            new cssColor("tomato", 0xFF6347),	//255,99,71
            new cssColor("turquoise", 0x40E0D0),	//64,224,208
            new cssColor("violet", 0xEE82EE),	//238,130,238
            new cssColor("wheat", 0xF5DEB3),	//245,222,179
            new cssColor("white", 0xFFFFFF),	//255,255,255
            new cssColor("whitesmoke", 0xF5F5F5),	//245,245,245
            new cssColor("yellow", 0xFFFF00),	//255,255,0
            new cssColor("yellowgreen", 0x9ACD32),	//154,205,50
        };
    }
}
