﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Media;

namespace NT2chCtrl.html.css
{
    public class Property
    {
        public enum Visibility
        {
            Collapse, Visible, Hidden, Other
        }
        public enum FontStyle
        {
            Normal, Italic, Oblique
        }

        string mName;
        string mValue;
        Color mColor;
        bool mInitColor;
        Visibility mVisibility;
        bool mInitVisibility;
        
        Property(string name, string value)
        {
            mName = name;
            mValue = value;

            mInitColor = false;
            mInitVisibility = false;
        }

        public string getName()
        {
            return mName;
        }
        public string getValue()
        {
            return mValue;
        }


        public Color getColor()
        {
            if (mInitColor)
                return mColor;
            mInitColor = true;
            mColor = css.cssColor.getColor(mValue);
            return mColor;
        }


        private static string retrieveTextFromBrackets(string source, int startIdx)
        {
            //int state = 0;
            int length = source.Length;
            int textStart = 0;
            int indent = 0;
            for (int i = startIdx/* + 15*/; i < length; i++)
            {
                switch (source[i])
                {
                    case '(':
                        //if (state != 0)
                        //    return null;
                        //state = 1;
                        if(indent == 0)
                            textStart = i + 1;
                        indent++;
                        break;
                    case ')':
                        //if (state != 1)
                        //    return null;
                        indent--;
                        if(indent == 0)
                            return source.Substring(textStart, i - textStart);
                        break;
                }
            }
            return null;
        }
        public string getLinearGradientValue()
        {
            int idx = mValue.IndexOf("linear-gradient");
            if (idx < 0)
                return null;
            return retrieveTextFromBrackets(mValue, idx + 15);
        }

        public string getRadialGradientValue()
        {
            int idx = mValue.IndexOf("radial-gradient");
            if (idx < 0)
                return null;
            return retrieveTextFromBrackets(mValue, idx + 15);
        }

        public string getUrlPath()
        {
            int idx = mValue.IndexOf("url(", 0);
            if (idx < 0)
            {
                idx = mValue.IndexOf("URL(", 0);
                if (idx < 0)
                    return null;
            }
            int length = mValue.Length;
            int state = 0;
            int textStart = 0;
            int textEnd = 0;
            bool dquote = false;
            bool squote = false;
            string resultStr = null;
            for (int i = idx + 4; i < length; i++)
            {
                char c = mValue[i];
                switch (c)
                {
                    case ' ':
                    case '\n':
                    case '\t':
                    case '\r':
                        break;
                    case '"':
                        if (!dquote)
                        {
                            if (squote)
                            {
                                if (state == 0)
                                {
                                    textStart = i;
                                    state = 1;
                                }
                                textEnd = i + 1;
                            }
                            else
                            {
                                if (state != 0)
                                    return null;
                                dquote = true;
                            }
                        }
                        else
                        {
                            if (state != 1)
                                return null;
                            state = 2;
                            resultStr = mValue.Substring(textStart, textEnd - textStart);
                        }
                        break;
                    case '\'':
                        if (!squote)
                        {
                            if (dquote)
                            {
                                if (state == 0)
                                {
                                    textStart = i;
                                    state = 1;
                                }
                                textEnd = i + 1;
                            }
                            else
                            {
                                if (state != 0)
                                    return null;
                                squote = true;
                            }
                        }
                        else
                        {
                            if (state != 1)
                                return null;
                            state = 3;
                            resultStr = mValue.Substring(textStart, textEnd - textStart);
                        }
                        break;
                    case ')':
                        switch (state)
                        {
                            case 1:
                                return mValue.Substring(textStart, textEnd - textStart);
                            case 2:
                            case 3:
                                return resultStr;
                            default:
                                return null;
                        }
                    default:
                        if (state == 0)
                        {
                            textStart = i;
                            state = 1;
                        }
                        textEnd = i + 1;
                        break;
                }
            }
            return null;
        }

        public double getLength(double? fontSize)
        {
            return cssLength.getLength(mValue, fontSize);
        }

        public double getLength()
        {
            return cssLength.getLength(mValue);
        }

        public bool getFontFamily(out string fontNames)
        {
            return cssFont.tryGetFontFamily(mValue, out fontNames);
        }
        public bool getFontWeight(out int weight)
        {
            return cssFont.tryGetFontWeight(mValue, out weight);
        }
        public bool getFontStyle(out FontStyle style)
        {
            return cssFont.tryGetFontStyle(mValue, out style);
        }

        

        public Visibility getVisibility()
        {
            if (mInitVisibility)
                return mVisibility;

            if (mValue.Equals("collapse", StringComparison.OrdinalIgnoreCase))
                mVisibility = Visibility.Collapse;
            else if (mValue.Equals("hidden", StringComparison.OrdinalIgnoreCase))
                mVisibility = Visibility.Hidden;
            else if (mValue.Equals("visible", StringComparison.OrdinalIgnoreCase))
                mVisibility =  Visibility.Visible;
            else
                mVisibility = Visibility.Other;

            mInitVisibility = true;
            return mVisibility;
        }

        private static string concat2pices(string source, int start, int end, int excludeS, int excludeE, bool exclude)
        {
            if (!exclude || excludeS == excludeE)
                return source.Substring(start, end - start);
            if (excludeS < excludeE)
            {
                if (excludeE <= start || excludeS >= end)
                    return source.Substring(start, end - start);
            }
            if (start > excludeS || end < excludeE)
                return string.Empty;

            string s1 = source.Substring(start, excludeS - start);
            return s1 + source.Substring(excludeE, end - excludeE);
        }

        public static int Parse(DebugContext ctx, string source, int startIdx, List<Property> list)
        {
            int state = 0;
            int textStart = startIdx;
            int length = source.Length;
            string name = null;
            Property property;
            bool dquote = false;
            bool squote = false;

            bool comment = false;
            int commentS = 0, commentE = -1;
            string s;


            for (int i = startIdx; i < length; i++)
            {
                char c = source[i];
                HtmlParser.CHAR_TOKEN token = 
                    HtmlParser.getCharToken(c);

                switch (token)
                {
                    case HtmlParser.CHAR_TOKEN.L_CURLY_BRACKET:
                        if (startIdx != i)
                        {
                            ctx.setCurrentIdx(i);
                            return -1;
                        }
                        break;
                    case HtmlParser.CHAR_TOKEN.ALPHA:
                        if (state == 0)
                        {
                            state = 1;
                            textStart = i;
                        }
                        else if(state == 3){
                            state = 4;
                            textStart = i;
                        }
                        break;
                    case HtmlParser.CHAR_TOKEN.NUMBER:
                    case HtmlParser.CHAR_TOKEN.HYPHIEN:
                    case HtmlParser.CHAR_TOKEN.UNDERBAR:
                        if (state == 3)
                        {
                            state = 4;
                            textStart = i;
                        }
                        else if (state != 1 && state != 4)
                        {
                            ctx.setCurrentIdx(i);
                            return -1;
                        }
                        break;
                    case HtmlParser.CHAR_TOKEN.DQUOTE:
                        if (state == 3 && !dquote)
                        {
                            state = 4;
                            textStart = i;
                        }
                        else if (state != 4)
                        {
                            ctx.setCurrentIdx(i);
                            return -1;
                        }
                        if(!squote)
                            dquote = !dquote;
                        break;
                    case HtmlParser.CHAR_TOKEN.SQUOTE:
                        if (state == 3 && !squote)
                        {
                            state = 4;
                            textStart = i;
                        }
                        else if (state != 4)
                        {
                            ctx.setCurrentIdx(i);
                            return -1;
                        }
                        if(!dquote)
                            squote = !squote;
                        break;
                    case HtmlParser.CHAR_TOKEN.COLON:
                        if (state == 1)
                        {
                            name = concat2pices(source, textStart, i, commentS, commentE, comment);
                            comment = false;
                            //name = source.Substring(textStart, i - textStart);
                        }
                        else if (state != 2)
                        {
                            ctx.setCurrentIdx(i);
                            return -1;
                        }
                        state = 3;
                        break;
                    case HtmlParser.CHAR_TOKEN.SEMICOLON:
                        if (state == 4 && !dquote && !squote)
                        {
                            s = concat2pices(source, textStart, i, commentS, commentE, comment);
                            comment = false;
                            property = new Property(name, s);//ource.Substring(textStart, i - textStart));
                            list.Add(property);
                        }
                        else
                        {
                            ctx.setCurrentIdx(i);
                            return -1;
                        }
                        state = 0;
                        break;
                    case HtmlParser.CHAR_TOKEN.NL:
                        ctx.incrementLine();
                        if (state == 1)
                        {
                            state = 2;
                            name = concat2pices(source, textStart, i, commentS, commentE, comment);
                            comment = false;
                            //name = source.Substring(textStart, i - textStart);
                        }
                        break;
                    case HtmlParser.CHAR_TOKEN.WHITESPACE:
                        if (state == 1)
                        {
                            state = 2;
                            name = concat2pices(source, textStart, i, commentS, commentE, comment);
                            comment = false;
                            //name = source.Substring(textStart, i - textStart);
                        }
                        break;
                    case HtmlParser.CHAR_TOKEN.SLASH:
                        if (i < length - 1 && source[i+1] == '*')
                        {
                            int idx = source.IndexOf("*/", i + 2);
                            if (idx >= 0)
                            {
                                comment = true;
                                commentS = i;
                                commentE = idx + 2;                                
                                i = idx + 1;
                            }
                        }
                        break;
                    case HtmlParser.CHAR_TOKEN.R_CURLY_BRACKET:
                        if (state == 4 && !dquote && !squote)
                        {
                            s = concat2pices(source, textStart, i, commentS, commentE, comment);
                            comment = false;
                            property = new Property(name, s);//ource.Substring(textStart, i - textStart));
                            list.Add(property);
                        }
                        else if(state != 0)
                        {
                            ctx.setCurrentIdx(i);
                            return -1;
                        }
                        return i;
                    case HtmlParser.CHAR_TOKEN.OTHER:
                        if (state != 4)
                        {
                            ctx.setCurrentIdx(i);
                            return -1;
                        }
                        break;
                }
            }
            return length;
        }
    }
}
