/*
 * Decompiled with CFR 0.152.
 */
package nor.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.MessagingException;
import javax.mail.internet.MimeUtility;

public class Base64Util {
    private static final Logger LOGGER = Logger.getLogger(Base64Util.class.getName());
    private static final String ENCODING = "base64";
    private static final String CHARSET = "utf-8";

    public static String decode(String value) throws MessagingException, IOException {
        LOGGER.entering(Base64Util.class.getName(), "decode", value);
        assert (value != null);
        String tmp = value;
        while (tmp.length() % 4 != 0) {
            tmp = String.valueOf(tmp) + "=";
        }
        String ret = new String(Base64Util.decode(tmp.getBytes()), CHARSET);
        LOGGER.exiting(Base64Util.class.getName(), "decode", ret);
        return ret;
    }

    public static byte[] decode(byte[] value) throws MessagingException, IOException {
        int len;
        LOGGER.entering(Base64Util.class.getName(), "decode", (Object)value);
        assert (value != null);
        InputStream in = MimeUtility.decode((InputStream)new ByteArrayInputStream(value), (String)ENCODING);
        byte[] buf = new byte[1024];
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        while ((len = in.read(buf)) != -1) {
            out.write(buf, 0, len);
        }
        byte[] ret = out.toByteArray();
        LOGGER.exiting(Base64Util.class.getName(), "decode", ret);
        return ret;
    }

    public static String encode(String value) throws MessagingException, IOException {
        LOGGER.entering(Base64Util.class.getName(), "encode", value);
        assert (value != null);
        String ret = Base64Util.encode(value.getBytes());
        LOGGER.exiting(Base64Util.class.getName(), "encode", ret);
        return ret;
    }

    public static String encode(byte[] value) throws MessagingException, IOException {
        LOGGER.entering(Base64Util.class.getName(), "encode", (Object)value);
        assert (value != null);
        ByteArrayOutputStream bao = new ByteArrayOutputStream();
        OutputStream out = MimeUtility.encode((OutputStream)bao, (String)ENCODING);
        out.write(value);
        out.close();
        String ret = bao.toString(CHARSET);
        LOGGER.exiting(Base64Util.class.getName(), "encode", value);
        return ret;
    }

    public static String[] decodeRawText(String text) {
        Pattern pat = Pattern.compile("[A-Za-z0-9+/=]+");
        Matcher m = pat.matcher(text);
        ArrayList<String> list = new ArrayList<String>();
        while (m.find()) {
            String target = m.group(0);
            try {
                list.add(Base64Util.decode(target));
            }
            catch (MessagingException e) {
                list.add(target);
            }
            catch (IOException e) {
                list.add(target);
            }
        }
        String[] ret = new String[list.size()];
        list.toArray(ret);
        return ret;
    }
}

