/*
 * Decompiled with CFR 0.152.
 */
package nor.http.server.tserver;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import nor.http.server.HttpRequestHandler;
import nor.http.server.HttpServer;
import nor.http.server.tserver.ListenWorker;
import nor.util.log.EasyLogger;

public class HttpTServer
implements HttpServer {
    private final HttpRequestHandler handler;
    private Thread listenThread;
    private ListenWorker listener = null;
    private static final EasyLogger LOGGER = EasyLogger.getLogger(HttpTServer.class);

    public HttpTServer(HttpRequestHandler handler) {
        LOGGER.entering("<init>", handler);
        assert (handler != null);
        this.handler = handler;
        LOGGER.exiting("<init>");
    }

    @Override
    public void start(String hostname, int port) throws IOException {
        LOGGER.entering("start", hostname, (Object)port);
        ServerSocket socket = new ServerSocket();
        socket.setReuseAddress(true);
        LOGGER.info("Create new socket.");
        socket.bind(new InetSocketAddress(hostname, port));
        LOGGER.info("Bind the socket to port " + port);
        this.listener = new ListenWorker(socket, this.handler, 0);
        LOGGER.info("Start listening.");
        this.listenThread = new Thread(this.listener);
        this.listenThread.setName("ListenWorker");
        this.listenThread.start();
        LOGGER.exiting("service");
    }

    @Override
    public void close() throws IOException {
        LOGGER.entering("close", new Object[0]);
        if (this.listener != null) {
            this.listener.close();
            try {
                this.listenThread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            LOGGER.info("End.");
        }
        LOGGER.exiting("close");
    }
}

