/*
 * Decompiled with CFR 0.152.
 */
package nor.http.server.rest;

import java.util.Calendar;
import java.util.Date;
import java.util.logging.Logger;
import nor.http.ContentType;
import nor.http.HttpRequest;
import nor.http.HttpResponse;
import nor.http.server.rest.FileResource;
import nor.http.server.rest.Resource;
import nor.http.server.rest.SimpleResponseBuilder;

public class TextResource
extends Resource {
    private static final Logger LOGGER = Logger.getLogger(TextResource.class.getName());
    private static final ContentType DEFAULT_CONTENT_TYPE = new ContentType("text/plain");
    private final String name;
    private String text;
    private final ContentType type;
    private Date modified;

    public TextResource(String name, String text, ContentType type) {
        LOGGER.entering(TextResource.class.getName(), "<init>", new Object[]{name, text, type});
        assert (name != null);
        assert (text != null);
        assert (type != null);
        this.name = name;
        this.text = text;
        this.type = type;
        this.modified = Calendar.getInstance().getTime();
        LOGGER.exiting(TextResource.class.getName(), "<init>");
    }

    public TextResource(String name, String text, String type) {
        this(name, text, new ContentType(type));
    }

    public TextResource(String name, String text) {
        this(name, text, DEFAULT_CONTENT_TYPE);
    }

    public String getText() {
        LOGGER.entering(TextResource.class.getName(), "getText");
        String ret = this.text;
        LOGGER.exiting(TextResource.class.getName(), "getText", ret);
        return ret;
    }

    public void setText(String text) {
        LOGGER.entering(TextResource.class.getName(), "setText", text);
        assert (text != null);
        this.text = text;
        this.modified = Calendar.getInstance().getTime();
        LOGGER.exiting(TextResource.class.getName(), "setText");
    }

    @Override
    public HttpResponse toGet(String path, HttpRequest request) {
        LOGGER.entering(FileResource.class.getName(), "toGet", new Object[]{path, request});
        assert (path != null);
        assert (request != null);
        HttpResponse ret = SimpleResponseBuilder.create(request, this.text, this.type);
        LOGGER.exiting(FileResource.class.getName(), "toGet", ret);
        return ret;
    }

    @Override
    public String getName() {
        LOGGER.entering(FileResource.class.getName(), "getName");
        String ret = this.name;
        LOGGER.exiting(FileResource.class.getName(), "getName", ret);
        return ret;
    }

    public String toString() {
        return String.valueOf(this.text) + "(" + this.modified + ")";
    }
}

