/*
 * Decompiled with CFR 0.152.
 */
package nor.http.server.rest;

import java.util.ArrayList;
import java.util.logging.Logger;
import nor.http.HeaderName;
import nor.http.HttpHeader;
import nor.http.HttpRequest;
import nor.http.HttpResponse;
import nor.http.Method;
import nor.http.Status;
import nor.http.error.HttpException;

public abstract class Resource {
    private static final Logger LOGGER = Logger.getLogger(Resource.class.getName());
    private static final String TO_DELETE = "toDelete";
    private static final String TO_GET = "toGet";
    private static final String TO_POST = "toPost";
    private static final String TO_PUT = "toPut";
    private final Method[] allowd;

    public Resource() {
        LOGGER.entering(Resource.class.getName(), "<init>");
        Class<?> c = this.getClass();
        ArrayList<Method> allowd = new ArrayList<Method>();
        try {
            java.lang.reflect.Method toDelete = c.getMethod(TO_DELETE, String.class, HttpRequest.class);
            if (!toDelete.equals(Resource.class.getMethod(TO_DELETE, String.class, HttpRequest.class))) {
                allowd.add(Method.DELETE);
            }
            java.lang.reflect.Method toGet = c.getMethod(TO_GET, String.class, HttpRequest.class);
            if (!toGet.equals(Resource.class.getMethod(TO_GET, String.class, HttpRequest.class))) {
                allowd.add(Method.GET);
            }
            java.lang.reflect.Method toPost = c.getMethod(TO_POST, String.class, HttpRequest.class);
            if (!toPost.equals(Resource.class.getMethod(TO_POST, String.class, HttpRequest.class))) {
                allowd.add(Method.POST);
            }
            java.lang.reflect.Method toPut = c.getMethod(TO_PUT, String.class, HttpRequest.class);
            if (!toPut.equals(Resource.class.getMethod(TO_PUT, String.class, HttpRequest.class))) {
                allowd.add(Method.PUT);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        this.allowd = new Method[allowd.size()];
        allowd.toArray(this.allowd);
        LOGGER.exiting(Resource.class.getName(), "<init>");
    }

    public String getName() {
        LOGGER.entering(Resource.class.getName(), "getName");
        String ret = this.getClass().getSimpleName();
        LOGGER.exiting(Resource.class.getName(), "getName", ret);
        return ret;
    }

    public HttpResponse toDelete(String path, HttpRequest request) throws HttpException {
        LOGGER.entering(Resource.class.getName(), TO_DELETE, new Object[]{path, request});
        HttpResponse ret = this.createErrorResponse(request);
        LOGGER.exiting(Resource.class.getName(), TO_DELETE, ret);
        return ret;
    }

    public HttpResponse toGet(String path, HttpRequest request) throws HttpException {
        LOGGER.entering(Resource.class.getName(), TO_GET, new Object[]{path, request});
        HttpResponse ret = this.createErrorResponse(request);
        LOGGER.exiting(Resource.class.getName(), TO_GET, ret);
        return ret;
    }

    public HttpResponse toPost(String path, HttpRequest request) throws HttpException {
        LOGGER.entering(Resource.class.getName(), TO_POST, new Object[]{path, request});
        HttpResponse ret = this.createErrorResponse(request);
        LOGGER.exiting(Resource.class.getName(), TO_POST, ret);
        return ret;
    }

    public HttpResponse toPut(String path, HttpRequest request) throws HttpException {
        LOGGER.entering(Resource.class.getName(), TO_PUT, new Object[]{path, request});
        HttpResponse ret = this.createErrorResponse(request);
        LOGGER.exiting(Resource.class.getName(), TO_PUT, ret);
        return ret;
    }

    private HttpResponse createErrorResponse(HttpRequest request) {
        String body = "405 Method Not Allowed";
        HttpResponse ret = request.createResponse(Status.MethodNotAllowed, "405 Method Not Allowed");
        HttpHeader header = ret.getHeader();
        header.add(HeaderName.ContentType, "text/javascript; charset=utf-8\n");
        header.add(HeaderName.Server, System.getProperty("app.name"));
        header.add(HeaderName.ContentLength, Integer.toString("405 Method Not Allowed".getBytes().length));
        if (this.allowd.length != 0) {
            String allow = new String();
            Method[] methodArray = this.allowd;
            int n = this.allowd.length;
            int n2 = 0;
            while (n2 < n) {
                Method m = methodArray[n2];
                allow = String.valueOf(allow) + m.toString();
                allow = String.valueOf(allow) + ", ";
                ++n2;
            }
            header.add(HeaderName.Allow, allow.substring(0, allow.length() - 2));
        }
        return ret;
    }
}

