/*
 * Decompiled with CFR 0.152.
 */
package nor.http.server.proxyserver;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import nor.http.HeaderName;
import nor.http.HttpHeader;
import nor.http.HttpRequest;
import nor.http.HttpResponse;
import nor.http.Method;
import nor.http.Status;
import nor.http.error.HttpException;
import nor.http.server.HttpRequestHandler;
import nor.http.server.proxyserver.Router;
import nor.util.log.EasyLogger;

public class ProxyRequestHandler
implements HttpRequestHandler {
    private final String name;
    private final String version;
    private final Router router;
    private static final String Close = "close";
    private static final String VIA_FORMAT = "%s %s";
    private static final EasyLogger LOGGER = EasyLogger.getLogger(ProxyRequestHandler.class);

    public ProxyRequestHandler(String name, String version, Router router) {
        LOGGER.entering("<init>", name, version, router);
        assert (name != null && name.length() != 0);
        assert (version != null);
        assert (router != null);
        this.name = name;
        this.version = version;
        this.router = router;
        HttpURLConnection.setFollowRedirects(false);
        LOGGER.exiting("<init>");
    }

    @Override
    public HttpResponse doRequest(HttpRequest request) {
        LOGGER.entering("doRequest", request);
        assert (request != null);
        LOGGER.finest(request.getHeadLine());
        HttpResponse response = null;
        try {
            if (Method.CONNECT.equals(request.getMethod())) {
                throw new HttpException(Status.NotImplemented);
            }
            this.cleanHeader(request);
            URL url = new URL(request.getPath());
            Proxy proxy = this.router.query(request.getPath());
            if (proxy != Proxy.NO_PROXY) {
                LOGGER.info("Using proxy " + proxy);
            }
            HttpURLConnection con = (HttpURLConnection)url.openConnection(proxy);
            response = request.createResponse(con);
        }
        catch (IOException e) {
            LOGGER.warning(String.format("Catch a IOException(%s)", e.getMessage()));
            response = HttpException.createResponse(request, Status.InternalServerError, e);
        }
        catch (HttpException e) {
            LOGGER.warning(String.format("Catch a HttpException(%s)", e.getMessage()));
            response = e.createResponse(request);
        }
        this.cleanHeader(response);
        LOGGER.exiting("doRequest", response);
        return response;
    }

    private void cleanHeader(HttpRequest request) {
        String value;
        int n;
        int n2;
        String[] stringArray;
        LOGGER.entering("cleanHeader", request);
        assert (request != null);
        HttpHeader header = request.getHeader();
        header.set(HeaderName.AcceptEncoding, "gzip, identity");
        String timeout = null;
        boolean close = false;
        if (header.containsKey(HeaderName.KeepAlive)) {
            timeout = header.get(HeaderName.KeepAlive);
        } else if (header.containsValue(HeaderName.Connection, Close)) {
            close = true;
        }
        if (header.containsKey(HeaderName.Connection)) {
            stringArray = header.get(HeaderName.Connection).split(",");
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                value = stringArray[n];
                header.remove(value.trim());
                ++n;
            }
            header.remove(HeaderName.Connection);
        }
        if (this.router.query(request.getPath()) == null && header.containsKey(HeaderName.ProxyConnection)) {
            stringArray = header.get(HeaderName.ProxyConnection).split(",");
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                value = stringArray[n];
                header.remove(value.trim());
                ++n;
            }
            header.remove(HeaderName.ProxyConnection);
        }
        if (timeout != null) {
            header.set(HeaderName.Connection, HeaderName.KeepAlive.toString());
            header.set(HeaderName.KeepAlive, timeout);
        } else if (close) {
            header.set(HeaderName.Connection, Close);
        }
        header.add(HeaderName.Via, String.format(VIA_FORMAT, this.version, this.name));
        LOGGER.exiting("cleanHeader");
    }

    private void cleanHeader(HttpResponse response) {
        int n;
        LOGGER.entering("cleanHeader", response);
        assert (response != null);
        HttpHeader header = response.getHeader();
        if (header.containsKey(HeaderName.Connection)) {
            boolean isClose = false;
            String[] stringArray = header.get(HeaderName.Connection).split(",");
            int n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                String value = stringArray[n];
                String tvalue = value.trim();
                if (Close.equalsIgnoreCase(tvalue)) {
                    isClose = true;
                } else {
                    header.remove(value.trim());
                }
                ++n;
            }
            header.remove(HeaderName.Connection);
            if (isClose) {
                header.set(HeaderName.Connection, Close);
            }
        }
        if (header.containsKey(HeaderName.ProxyConnection)) {
            String[] stringArray = header.get(HeaderName.ProxyConnection).split(",");
            n = stringArray.length;
            int n3 = 0;
            while (n3 < n) {
                String value = stringArray[n3];
                header.remove(value.trim());
                ++n3;
            }
            header.remove(HeaderName.ProxyConnection);
        }
        header.add(HeaderName.Via, String.format(VIA_FORMAT, this.version, this.name));
        LOGGER.exiting("cleanHeader");
    }
}

