/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.util.validator;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import jp.ossc.nimbus.util.validator.ValidateException;
import jp.ossc.nimbus.util.validator.Validator;

public class CombinationValidator
implements Validator,
Serializable {
    private static final long serialVersionUID = 1695449609101701493L;
    protected List validators = new ArrayList();

    public void add(Validator validator) throws ValidateException {
        if (this.validators.size() != 0) {
            throw new ValidateException("It is not the first validator.");
        }
        ValidatorWithCondition cond = new ValidatorWithCondition(validator);
        this.validators.add(cond);
    }

    public void addNot(Validator validator) throws ValidateException {
        if (this.validators.size() != 0) {
            throw new ValidateException("It is not the first validator.");
        }
        ValidatorWithCondition cond = new ValidatorWithCondition(validator);
        cond.isNot = true;
        this.validators.add(cond);
    }

    public void or(Validator validator) {
        ValidatorWithCondition cond = new ValidatorWithCondition(validator);
        cond.isOr = true;
        this.validators.add(cond);
    }

    public void and(Validator validator) {
        ValidatorWithCondition cond = new ValidatorWithCondition(validator);
        cond.isAnd = true;
        this.validators.add(cond);
    }

    public void orNot(Validator validator) {
        ValidatorWithCondition cond = new ValidatorWithCondition(validator);
        cond.isNot = true;
        cond.isOr = true;
        this.validators.add(cond);
    }

    public void andNot(Validator validator) {
        ValidatorWithCondition cond = new ValidatorWithCondition(validator);
        cond.isNot = true;
        cond.isAnd = true;
        this.validators.add(cond);
    }

    public void clear() {
        this.validators.clear();
    }

    @Override
    public boolean validate(Object obj) throws ValidateException {
        if (this.validators.size() == 0) {
            return true;
        }
        Boolean result = null;
        int imax = this.validators.size();
        for (int i = 0; i < imax; ++i) {
            ValidatorWithCondition cond = (ValidatorWithCondition)this.validators.get(i);
            result = cond.validate(result, obj) ? Boolean.TRUE : Boolean.FALSE;
        }
        return result == null ? true : result;
    }

    protected static class ValidatorWithCondition
    implements Serializable {
        private static final long serialVersionUID = 924450733620787066L;
        protected boolean isNot;
        protected boolean isOr;
        protected boolean isAnd;
        protected Validator validator;

        public ValidatorWithCondition(Validator validator) {
            this.validator = validator;
        }

        public boolean validate(Boolean preResult, Object obj) throws ValidateException {
            if (preResult != null) {
                if (!preResult.booleanValue() && this.isAnd) {
                    return false;
                }
                if (preResult.booleanValue() && this.isOr) {
                    return true;
                }
            }
            boolean result = this.validator.validate(obj);
            boolean bl = this.isNot ? !result : (result = result);
            if (preResult != null) {
                if (this.isOr) {
                    result |= preResult.booleanValue();
                } else if (this.isAnd) {
                    result &= preResult.booleanValue();
                }
            }
            return result;
        }
    }
}

