/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.util.net;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.ServerSocketChannel;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.net.ssl.SSLServerSocket;
import jp.ossc.nimbus.beans.NoSuchPropertyException;
import jp.ossc.nimbus.beans.Property;
import jp.ossc.nimbus.beans.PropertyFactory;

public class SSLServerSocketWrapper
extends SSLServerSocket {
    protected SSLServerSocket serverSocket;
    protected Map socketProperties;

    public SSLServerSocketWrapper(SSLServerSocket serverSock) throws IOException {
        this.serverSocket = serverSock;
    }

    @Override
    public void bind(SocketAddress endpoint) throws IOException {
        this.serverSocket.bind(endpoint);
    }

    @Override
    public void bind(SocketAddress endpoint, int backlog) throws IOException {
        this.serverSocket.bind(endpoint, backlog);
    }

    @Override
    public InetAddress getInetAddress() {
        return this.serverSocket.getInetAddress();
    }

    @Override
    public int getLocalPort() {
        return this.serverSocket.getLocalPort();
    }

    @Override
    public SocketAddress getLocalSocketAddress() {
        return this.serverSocket.getLocalSocketAddress();
    }

    @Override
    public void close() throws IOException {
        this.serverSocket.close();
    }

    @Override
    public ServerSocketChannel getChannel() {
        return this.serverSocket.getChannel();
    }

    @Override
    public boolean isBound() {
        return this.serverSocket.isBound();
    }

    @Override
    public boolean isClosed() {
        return this.serverSocket.isClosed();
    }

    @Override
    public void setSoTimeout(int timeout) throws SocketException {
        this.serverSocket.setSoTimeout(timeout);
    }

    @Override
    public int getSoTimeout() throws IOException {
        return this.serverSocket.getSoTimeout();
    }

    @Override
    public void setReuseAddress(boolean on) throws SocketException {
        this.serverSocket.setReuseAddress(on);
    }

    @Override
    public boolean getReuseAddress() throws SocketException {
        return this.serverSocket.getReuseAddress();
    }

    @Override
    public void setReceiveBufferSize(int size) throws SocketException {
        this.serverSocket.setReceiveBufferSize(size);
    }

    @Override
    public int getReceiveBufferSize() throws SocketException {
        return this.serverSocket.getReceiveBufferSize();
    }

    @Override
    public void setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
        try {
            Method method = this.serverSocket.getClass().getMethod("setPerformancePreferences", Integer.TYPE, Integer.TYPE, Integer.TYPE);
            method.invoke((Object)this.serverSocket, new Integer(connectionTime), new Integer(latency), new Integer(bandwidth));
        }
        catch (NoSuchMethodException e) {
            throw new UnsupportedOperationException(e.toString());
        }
        catch (IllegalAccessException e) {
            throw new UnsupportedOperationException(e.toString());
        }
        catch (InvocationTargetException e) {
            Throwable target = e.getTargetException();
            if (target instanceof RuntimeException) {
                throw (RuntimeException)target;
            }
            if (target instanceof Error) {
                throw (Error)target;
            }
            throw new UndeclaredThrowableException(target);
        }
    }

    @Override
    public String toString() {
        return this.serverSocket.toString();
    }

    @Override
    public Socket accept() throws IOException {
        return this.applySocketProperties(this.serverSocket.accept());
    }

    @Override
    public String[] getEnabledCipherSuites() {
        return this.serverSocket.getEnabledCipherSuites();
    }

    @Override
    public void setEnabledCipherSuites(String[] suites) {
        this.serverSocket.setEnabledCipherSuites(suites);
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.serverSocket.getSupportedCipherSuites();
    }

    @Override
    public String[] getSupportedProtocols() {
        return this.serverSocket.getSupportedProtocols();
    }

    @Override
    public String[] getEnabledProtocols() {
        return this.serverSocket.getEnabledProtocols();
    }

    @Override
    public void setEnabledProtocols(String[] protocols) {
        this.serverSocket.setEnabledProtocols(protocols);
    }

    @Override
    public void setNeedClientAuth(boolean need) {
        this.serverSocket.setNeedClientAuth(need);
    }

    @Override
    public boolean getNeedClientAuth() {
        return this.serverSocket.getNeedClientAuth();
    }

    @Override
    public void setWantClientAuth(boolean want) {
        this.serverSocket.setWantClientAuth(want);
    }

    @Override
    public boolean getWantClientAuth() {
        return this.serverSocket.getWantClientAuth();
    }

    @Override
    public void setUseClientMode(boolean mode) {
        this.serverSocket.setUseClientMode(mode);
    }

    @Override
    public boolean getUseClientMode() {
        return this.serverSocket.getUseClientMode();
    }

    @Override
    public void setEnableSessionCreation(boolean flag) {
        this.serverSocket.setEnableSessionCreation(flag);
    }

    @Override
    public boolean getEnableSessionCreation() {
        return this.serverSocket.getEnableSessionCreation();
    }

    public void setSocketProperties(Map props) {
        if (props == null || props.size() == 0) {
            if (this.socketProperties != null) {
                this.socketProperties = null;
            }
            return;
        }
        for (String name : props.keySet()) {
            this.setSocketProperty(name, props.get(name));
        }
    }

    public void setSocketProperty(String name, Object value) {
        if (this.socketProperties == null) {
            this.socketProperties = new LinkedHashMap();
        }
        Property prop = PropertyFactory.createProperty(name);
        this.socketProperties.put(prop, value);
    }

    public Object getSocketProperty(String name) {
        if (this.socketProperties == null) {
            return null;
        }
        for (Property prop : this.socketProperties.keySet()) {
            if (!prop.getPropertyName().equals(name)) continue;
            return this.socketProperties.get(prop);
        }
        return null;
    }

    protected Socket applySocketProperties(Socket socket) throws IOException {
        try {
            if (this.socketProperties != null && this.socketProperties.size() != 0) {
                for (Property prop : this.socketProperties.keySet()) {
                    prop.setProperty(socket, this.socketProperties.get(prop));
                }
            }
        }
        catch (InvocationTargetException e) {
            Throwable target = e.getTargetException();
            if (target instanceof IOException) {
                throw (IOException)target;
            }
            if (target instanceof RuntimeException) {
                throw (RuntimeException)target;
            }
            if (target instanceof Error) {
                throw (Error)target;
            }
            throw new UndeclaredThrowableException(target);
        }
        catch (NoSuchPropertyException e) {
            throw new UndeclaredThrowableException(e);
        }
        return socket;
    }
}

