/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.util.converter;

import java.math.BigDecimal;
import jp.ossc.nimbus.util.converter.ConvertException;
import jp.ossc.nimbus.util.converter.Converter;

public class DecimalScaleConverter
implements Converter {
    private int scale = 0;
    private int roundingMode = 4;
    private Class returnType;

    public void setScale(int scale) {
        this.scale = scale;
    }

    public int getScale() {
        return this.scale;
    }

    public void setRoundingMode(int roundingMode) {
        new BigDecimal(0.0).setScale(this.scale, roundingMode);
        this.roundingMode = roundingMode;
    }

    public int getRoundingMode() {
        return this.roundingMode;
    }

    public void setReturnType(Class type) {
        if (!(type == null || type.equals(BigDecimal.class) || type.equals(Double.class) || type.equals(Float.class) || type.equals(String.class))) {
            throw new IllegalArgumentException("Unsupported type." + type.getName());
        }
        this.returnType = type;
    }

    public Class getReturnType() {
        return this.returnType;
    }

    @Override
    public Object convert(Object obj) throws ConvertException {
        if (obj == null) {
            return null;
        }
        Class retType = this.returnType;
        BigDecimal retVal = null;
        if (obj instanceof BigDecimal) {
            retVal = ((BigDecimal)obj).setScale(this.scale, this.roundingMode);
            if (retType == null) {
                retType = BigDecimal.class;
            }
        } else if (obj instanceof Number) {
            retVal = new BigDecimal(((Number)obj).doubleValue()).setScale(this.scale, this.roundingMode);
            if (retType == null) {
                retType = obj instanceof Float ? Float.class : Double.class;
            }
        } else if (obj instanceof String) {
            try {
                retVal = new BigDecimal((String)obj).setScale(this.scale, this.roundingMode);
            }
            catch (NumberFormatException e) {
                throw new ConvertException(e);
            }
            if (retType == null) {
                retType = String.class;
            }
        } else {
            return obj;
        }
        if (retType.equals(BigDecimal.class)) {
            return retVal;
        }
        if (retType.equals(Double.class)) {
            return new Double(retVal.doubleValue());
        }
        if (retType.equals(Float.class)) {
            return new Float(retVal.floatValue());
        }
        return retVal.toString();
    }
}

