/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.ossc.nimbus.beans.ServiceNameArrayEditor;
import jp.ossc.nimbus.beans.ServiceNameEditor;
import jp.ossc.nimbus.beans.dataset.PropertySchema;
import jp.ossc.nimbus.beans.dataset.Record;
import jp.ossc.nimbus.beans.dataset.RecordList;
import jp.ossc.nimbus.beans.dataset.RecordSchema;
import jp.ossc.nimbus.core.Service;
import jp.ossc.nimbus.core.ServiceManager;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.context.DistributedSharedContext;
import jp.ossc.nimbus.service.context.DistributedSharedContextService;
import jp.ossc.nimbus.service.context.SharedContext;
import jp.ossc.nimbus.service.context.SharedContextRecord;
import jp.ossc.nimbus.service.context.SharedContextRecordList;
import jp.ossc.nimbus.service.context.SharedContextValueDifference;
import jp.ossc.nimbus.service.interpreter.BeanShellInterpreterService;
import jp.ossc.nimbus.service.interpreter.Interpreter;

public class SharedContextServlet
extends HttpServlet {
    private static final long serialVersionUID = -6992362984683159336L;
    protected static final String INIT_PARAM_NAME_SERVICE_NAMES = "ServiceNames";
    protected static final String INIT_PARAM_NAME_INTERPRETER_SERVICE_NAME = "InterpreterServiceName";
    protected static final String INIT_PARAM_NAME_PUT_ENABLED = "PutEnabled";
    protected static final String INIT_PARAM_NAME_UPDATE_ENABLED = "UpdateEnabled";
    protected static final String INIT_PARAM_NAME_REMOVE_ENABLED = "RemoveEnabled";
    protected static final String INIT_PARAM_NAME_CLEAR_ENABLED = "ClearEnabled";
    protected static final String INIT_PARAM_NAME_LOAD_ENABLED = "LoadEnabled";
    protected static final String INIT_PARAM_NAME_SAVE_ENABLED = "SaveEnabled";
    private Interpreter interpreter;

    private ServiceName[] getServiceNames() {
        ServletConfig config = this.getServletConfig();
        String serviceNamesStr = config.getInitParameter(INIT_PARAM_NAME_SERVICE_NAMES);
        if (serviceNamesStr == null) {
            return null;
        }
        ServiceNameArrayEditor editor = new ServiceNameArrayEditor();
        editor.setAsText(serviceNamesStr);
        return (ServiceName[])editor.getValue();
    }

    private ServiceName getInterpreterServiceName() {
        ServletConfig config = this.getServletConfig();
        String serviceNameStr = config.getInitParameter(INIT_PARAM_NAME_INTERPRETER_SERVICE_NAME);
        if (serviceNameStr == null) {
            return null;
        }
        ServiceNameEditor editor = new ServiceNameEditor();
        editor.setAsText(serviceNameStr);
        return (ServiceName)editor.getValue();
    }

    private boolean isPutEnabled() {
        ServletConfig config = this.getServletConfig();
        String isEnabled = config.getInitParameter(INIT_PARAM_NAME_PUT_ENABLED);
        return isEnabled == null ? false : Boolean.valueOf(isEnabled);
    }

    private boolean isUpdateEnabled() {
        ServletConfig config = this.getServletConfig();
        String isEnabled = config.getInitParameter(INIT_PARAM_NAME_UPDATE_ENABLED);
        return isEnabled == null ? false : Boolean.valueOf(isEnabled);
    }

    private boolean isRemoveEnabled() {
        ServletConfig config = this.getServletConfig();
        String isEnabled = config.getInitParameter(INIT_PARAM_NAME_REMOVE_ENABLED);
        return isEnabled == null ? false : Boolean.valueOf(isEnabled);
    }

    private boolean isClearEnabled() {
        ServletConfig config = this.getServletConfig();
        String isEnabled = config.getInitParameter(INIT_PARAM_NAME_CLEAR_ENABLED);
        return isEnabled == null ? false : Boolean.valueOf(isEnabled);
    }

    private boolean isLoadEnabled() {
        ServletConfig config = this.getServletConfig();
        String isEnabled = config.getInitParameter(INIT_PARAM_NAME_LOAD_ENABLED);
        return isEnabled == null ? false : Boolean.valueOf(isEnabled);
    }

    private boolean isSaveEnabled() {
        ServletConfig config = this.getServletConfig();
        String isEnabled = config.getInitParameter(INIT_PARAM_NAME_SAVE_ENABLED);
        return isEnabled == null ? false : Boolean.valueOf(isEnabled);
    }

    public synchronized void init() throws ServletException {
        ServiceName interpreterServiceName = this.getInterpreterServiceName();
        if (interpreterServiceName == null) {
            BeanShellInterpreterService bshInterpreter = new BeanShellInterpreterService();
            try {
                bshInterpreter.create();
                bshInterpreter.start();
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
            this.interpreter = bshInterpreter;
        } else {
            this.interpreter = (Interpreter)ServiceManagerFactory.getServiceObject(interpreterServiceName);
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.process(req, resp);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.process(req, resp);
    }

    protected void process(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        req.setCharacterEncoding("UTF-8");
        String action = req.getParameter("action");
        if (action == null) {
            this.processIndexResponse(req, resp);
        } else if (action.equals("context")) {
            this.processContextResponse(req, resp);
        } else if (action.equals("get")) {
            this.processGetResponse(req, resp);
        } else if (action.equals("containsKey")) {
            this.processContainsKeyResponse(req, resp);
        } else if (action.equals("keySet")) {
            this.processKeySetResponse(req, resp);
        } else if (action.equals("query")) {
            this.processQueryResponse(req, resp);
        } else if (action.equals("put")) {
            if (!this.isPutEnabled()) {
                resp.sendError(406);
                return;
            }
            this.processPutResponse(req, resp);
        } else if (action.equals("update")) {
            if (!this.isUpdateEnabled()) {
                resp.sendError(406);
                return;
            }
            this.processUpdateResponse(req, resp);
        } else if (action.equals("remove")) {
            if (!this.isRemoveEnabled()) {
                resp.sendError(406);
                return;
            }
            this.processRemoveResponse(req, resp);
        } else if (action.equals("clear")) {
            if (!this.isClearEnabled()) {
                resp.sendError(406);
                return;
            }
            this.processClearResponse(req, resp);
        } else if (action.equals("load")) {
            if (!this.isLoadEnabled()) {
                resp.sendError(406);
                return;
            }
            this.processLoadResponse(req, resp);
        } else if (action.equals("loadKey")) {
            if (!this.isLoadEnabled()) {
                resp.sendError(406);
                return;
            }
            this.processLoadKeyResponse(req, resp);
        } else if (action.equals("save")) {
            if (!this.isSaveEnabled()) {
                resp.sendError(406);
                return;
            }
            this.processSaveResponse(req, resp);
        } else {
            resp.sendError(404);
        }
    }

    private String getCurrentPath(HttpServletRequest req) {
        String path = req.getServletPath();
        if (path.endsWith("/")) {
            return "." + (req.getPathInfo() == null ? "" : req.getPathInfo());
        }
        return "." + path;
    }

    protected void processIndexResponse(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setContentType("text/html;charset=UTF-8");
        StringBuffer buf = new StringBuffer();
        buf.append("<html>");
        buf.append("<head><title>Nimbus SharedContexts</title></head>");
        buf.append("<body>");
        Object[] contextServiceNames = this.getServiceNames();
        if (contextServiceNames == null) {
            ServiceManager[] managers = ServiceManagerFactory.findManagers();
            ArrayList<ServiceName> names = new ArrayList<ServiceName>();
            for (int i = 0; i < managers.length; ++i) {
                Set services = managers[i].serviceSet();
                for (Service service : services) {
                    if (!(service instanceof SharedContext)) continue;
                    names.add(service.getServiceNameObject());
                }
            }
            contextServiceNames = names.toArray(new ServiceName[names.size()]);
        }
        buf.append("<b>Contexts</b><br>");
        buf.append("<table border=\"1\" cellspacing=\"0\" cellpadding=\"3\" width=\"90%\">");
        buf.append("<tr bgcolor=\"#cccccc\"><th>name</th><th>replicated/distributed</th><th>client/server</th><th>node number</th><th>size</th></tr>");
        Arrays.sort(contextServiceNames);
        StringBuffer url = new StringBuffer();
        for (int i = 0; i < contextServiceNames.length; ++i) {
            Object serviceName = contextServiceNames[i];
            Service service = ServiceManagerFactory.getService((ServiceName)serviceName);
            boolean isDistributed = false;
            if (service instanceof DistributedSharedContext) {
                isDistributed = true;
            } else {
                if (!(service instanceof SharedContext)) continue;
                isDistributed = false;
            }
            SharedContext context = (SharedContext)((Object)service);
            url.setLength(0);
            url.append(this.getCurrentPath(req)).append("?action=context&name=").append(URLEncoder.encode(((ServiceName)serviceName).toString(), "UTF-8"));
            buf.append("<tr>");
            buf.append("<td><a href=\"").append(resp.encodeURL(url.toString())).append("\">");
            buf.append(serviceName).append("</a></td>");
            buf.append("<td>").append(isDistributed ? "distributed" : "replicated").append("</td>");
            buf.append("<td>").append(context.isClient() ? "client" : "server" + (context.isMain() ? "(main)" : "(sub)")).append("</td>");
            buf.append("<td>").append(context.getMemberIdList().size() + "(" + context.getServerMemberIdSet().size() + ")").append("</td>");
            buf.append("<td>").append(context.size() + (context.isClient() || isDistributed ? "(" + context.sizeLocal() + ")" : "")).append("</td>");
            buf.append("</tr>");
        }
        buf.append("</table>");
        buf.append("</body>");
        buf.append("</html>");
        resp.getWriter().println(buf.toString());
    }

    protected void processContextResponse(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String serviceNameStr = req.getParameter("name");
        ServiceNameEditor editor = new ServiceNameEditor();
        editor.setAsText(serviceNameStr);
        ServiceName serviceName = (ServiceName)editor.getValue();
        SharedContext context = (SharedContext)ServiceManagerFactory.getServiceObject(serviceName);
        boolean isDistributed = context instanceof DistributedSharedContext;
        resp.setContentType("text/html;charset=UTF-8");
        StringBuffer buf = new StringBuffer();
        buf.append("<html>");
        buf.append("<head><title>Nimbus SharedContext " + serviceName + "</title></head>");
        buf.append("<body>");
        buf.append("<b>Context " + serviceName + "</b><br>");
        buf.append("<table border=\"1\" cellspacing=\"0\" cellpadding=\"3\" width=\"90%\">");
        buf.append("<tr><th bgcolor=\"#cccccc\">replicated/distributed</th><td colspan=\"2\">").append(isDistributed ? "distributed" : "replicated").append("</td></tr>");
        buf.append("<tr><th bgcolor=\"#cccccc\">client/server</th><td colspan=\"2\">").append(context.isClient() ? "client" : "server" + (context.isMain() ? "(main)" : "(sub)")).append("</td></tr>");
        buf.append("<tr><th bgcolor=\"#cccccc\">node member</th><td colspan=\"2\">").append(context.getMemberIdList() + "(" + context.getServerMemberIdSet() + ")").append("</td></tr>");
        if (context instanceof DistributedSharedContextService) {
            buf.append("<tr><th bgcolor=\"#cccccc\">distribute</th><td colspan=\"2\"><pre>").append(((DistributedSharedContextService)context).displayDistributeInfo()).append("</pre></td></tr>");
        }
        buf.append("<tr><th bgcolor=\"#cccccc\">size</th><td colspan=\"2\">").append(context.size() + (context.isClient() || isDistributed ? "(" + context.sizeLocal() + ")" : "")).append("</td></tr>");
        buf.append("<form method=\"POST\" action=\"").append(this.getCurrentPath(req)).append("\">");
        buf.append("<input type=\"hidden\" name=\"action\" value=\"get\"/>");
        buf.append("<input type=\"hidden\" name=\"name\" value=\"").append(serviceNameStr).append("\"/>");
        buf.append("<tr><th bgcolor=\"#cccccc\"><input type=\"submit\" value=\"get\"/></th><td colspan=\"2\"><table><tr><td>key:</td><td><textarea name=\"key\" cols=\"40\" rows=\"4\"></textarea></td></tr></table></td></tr>");
        buf.append("</form>");
        buf.append("<form method=\"POST\" action=\"").append(this.getCurrentPath(req)).append("\">");
        buf.append("<input type=\"hidden\" name=\"action\" value=\"containsKey\"/>");
        buf.append("<input type=\"hidden\" name=\"name\" value=\"").append(serviceNameStr).append("\"/>");
        buf.append("<tr><th bgcolor=\"#cccccc\"><input type=\"submit\" value=\"containsKey\"/></th><td colspan=\"2\"><table><tr><td>key:</td><td><textarea name=\"key\" cols=\"40\" rows=\"4\"></textarea></td></tr></table></td></tr>");
        buf.append("</form>");
        buf.append("<form method=\"POST\" action=\"").append(this.getCurrentPath(req)).append("\">");
        buf.append("<input type=\"hidden\" name=\"action\" value=\"keySet\"/>");
        buf.append("<input type=\"hidden\" name=\"name\" value=\"").append(serviceNameStr).append("\"/>");
        buf.append("<tr><th bgcolor=\"#cccccc\"><input type=\"submit\" value=\"keySet\"/></th><td colspan=\"2\">&nbsp;</td></tr>");
        buf.append("</form>");
        buf.append("<form method=\"POST\" action=\"").append(this.getCurrentPath(req)).append("\">");
        buf.append("<input type=\"hidden\" name=\"action\" value=\"query\"/>");
        buf.append("<input type=\"hidden\" name=\"name\" value=\"").append(serviceNameStr).append("\"/>");
        if (isDistributed) {
            buf.append("<tr><th bgcolor=\"#cccccc\"><input type=\"submit\" value=\"query\"/></th><td><table><tr><td>query:</td><td><textarea name=\"query\" cols=\"40\" rows=\"4\"></textarea></td></tr><tr><td>mergeQuery:</td><td><textarea name=\"mergeQuery\" cols=\"40\" rows=\"4\"></textarea></td></tr></table></td><td><table><tr><td>timeout:</td><td><textarea name=\"timeout\"></textarea></td></tr></table></td></tr>");
        } else {
            buf.append("<tr><th bgcolor=\"#cccccc\"><input type=\"submit\" value=\"query\"/></th><td><table><tr><td>query:</td><td><textarea name=\"query\" cols=\"40\" rows=\"4\"></textarea></td></tr></table></td><td><table><tr><td>timeout:</td><td><textarea name=\"timeout\"></textarea></td></tr></table></td></tr>");
        }
        buf.append("</form>");
        if (this.isRemoveEnabled()) {
            buf.append("<form method=\"POST\" action=\"").append(this.getCurrentPath(req)).append("\">");
            buf.append("<input type=\"hidden\" name=\"action\" value=\"remove\"/>");
            buf.append("<input type=\"hidden\" name=\"name\" value=\"").append(serviceNameStr).append("\"/>");
            buf.append("<tr><th bgcolor=\"#cccccc\"><input type=\"submit\" value=\"remove\"/></th><td colspan=\"2\"><table><tr><td>key:</td><td><textarea name=\"key\" cols=\"40\" rows=\"4\"></textarea></td></tr></table></td></tr>");
            buf.append("</form>");
        }
        if (this.isPutEnabled()) {
            buf.append("<form method=\"POST\" action=\"").append(this.getCurrentPath(req)).append("\">");
            buf.append("<input type=\"hidden\" name=\"action\" value=\"put\"/>");
            buf.append("<input type=\"hidden\" name=\"name\" value=\"").append(serviceNameStr).append("\"/>");
            buf.append("<tr><th bgcolor=\"#cccccc\"><input type=\"submit\" value=\"put\"/></th><td><table><tr><td>key:</td><td><textarea name=\"key\" cols=\"40\" rows=\"4\"></textarea></td></tr></table></td><td><table><tr><td>value:</td><td><textarea name=\"value\"></textarea></td></tr></table></td></tr>");
            buf.append("</form>");
        }
        if (this.isClearEnabled()) {
            buf.append("<form method=\"POST\" action=\"").append(this.getCurrentPath(req)).append("\">");
            buf.append("<input type=\"hidden\" name=\"action\" value=\"clear\"/>");
            buf.append("<input type=\"hidden\" name=\"name\" value=\"").append(serviceNameStr).append("\"/>");
            buf.append("<tr><th bgcolor=\"#cccccc\"><input type=\"submit\" value=\"clear\"/></th><td colspan=\"2\"><input type=\"radio\" name=\"type\" value=\"local\" checked>local<input type=\"radio\" name=\"type\" value=\"all\">all</td></tr>");
            buf.append("</form>");
        }
        if (this.isLoadEnabled()) {
            buf.append("<form method=\"POST\" action=\"").append(this.getCurrentPath(req)).append("\">");
            buf.append("<input type=\"hidden\" name=\"action\" value=\"load\"/>");
            buf.append("<input type=\"hidden\" name=\"name\" value=\"").append(serviceNameStr).append("\"/>");
            buf.append("<tr><th bgcolor=\"#cccccc\"><input type=\"submit\" value=\"load\"/></th><td colspan=\"2\">&nbsp;</td></tr>");
            buf.append("</form>");
            buf.append("<form method=\"POST\" action=\"").append(this.getCurrentPath(req)).append("\">");
            buf.append("<input type=\"hidden\" name=\"action\" value=\"load\"/>");
            buf.append("<input type=\"hidden\" name=\"name\" value=\"").append(serviceNameStr).append("\"/>");
            buf.append("<tr><th bgcolor=\"#cccccc\"><input type=\"submit\" value=\"load\"/></th><td colspan=\"2\"><table><tr><td>key:</td><td><textarea name=\"key\" cols=\"40\" rows=\"4\"></textarea></td></tr></table></td></tr>");
            buf.append("</form>");
            buf.append("<form method=\"POST\" action=\"").append(this.getCurrentPath(req)).append("\">");
            buf.append("<input type=\"hidden\" name=\"action\" value=\"loadKey\"/>");
            buf.append("<input type=\"hidden\" name=\"name\" value=\"").append(serviceNameStr).append("\"/>");
            buf.append("<tr><th bgcolor=\"#cccccc\"><input type=\"submit\" value=\"loadKey\"/></th><td colspan=\"2\">&nbsp;</td></tr>");
            buf.append("</form>");
        }
        if (this.isSaveEnabled()) {
            buf.append("<form method=\"POST\" action=\"").append(this.getCurrentPath(req)).append("\">");
            buf.append("<input type=\"hidden\" name=\"action\" value=\"save\"/>");
            buf.append("<input type=\"hidden\" name=\"name\" value=\"").append(serviceNameStr).append("\"/>");
            buf.append("<tr><th bgcolor=\"#cccccc\"><input type=\"submit\" value=\"save\"/></th><td colspan=\"2\"><table><tr><td>key:</td><td><textarea name=\"key\" cols=\"40\" rows=\"4\"></textarea></td></tr></table></td></tr>");
            buf.append("</form>");
            buf.append("<form method=\"POST\" action=\"").append(this.getCurrentPath(req)).append("\">");
            buf.append("<input type=\"hidden\" name=\"action\" value=\"save\"/>");
            buf.append("<input type=\"hidden\" name=\"name\" value=\"").append(serviceNameStr).append("\"/>");
            buf.append("<tr><th bgcolor=\"#cccccc\"><input type=\"submit\" value=\"save\"/></th><td colspan=\"2\">&nbsp;</td></tr>");
            buf.append("</form>");
        }
        buf.append("</table>");
        buf.append("<hr>");
        buf.append("<a href=\"").append(this.getCurrentPath(req)).append("\">Contexts</a>");
        buf.append("</body>");
        buf.append("</html>");
        resp.getWriter().println(buf.toString());
    }

    protected void processGetResponse(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String serviceNameStr = req.getParameter("name");
        ServiceNameEditor editor = new ServiceNameEditor();
        editor.setAsText(serviceNameStr);
        ServiceName serviceName = (ServiceName)editor.getValue();
        SharedContext context = (SharedContext)ServiceManagerFactory.getServiceObject(serviceName);
        String keyStr = req.getParameter("key");
        if (keyStr.indexOf("\n") == -1 && keyStr.indexOf("\r") == -1) {
            keyStr = "return " + keyStr;
        }
        StringBuffer buf = new StringBuffer();
        resp.setContentType("text/html;charset=UTF-8");
        buf.append("<html>");
        buf.append("<head><title>Nimbus SharedContext " + serviceName + " Get </title></head>");
        buf.append("<body>");
        try {
            Object key = this.interpreter.evaluate(keyStr);
            if (context.containsKey(key)) {
                Object value = context.get(key);
                this.writeValue(req, resp, serviceNameStr, keyStr, buf, value, true);
            } else {
                buf.append("not contains key : ").append(key);
            }
        }
        catch (Exception e) {
            this.writeThrowable(buf, e);
        }
        buf.append("<hr>");
        buf.append("<a href=\"").append(this.getCurrentPath(req)).append("\">Contexts</a>");
        buf.append("</body>");
        buf.append("</html>");
        resp.getWriter().println(buf.toString());
    }

    private StringBuffer writeThrowable(StringBuffer buf, Throwable th) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        th.printStackTrace(pw);
        pw.flush();
        String stackTrace = sw.toString();
        return buf.append("<pre>").append(stackTrace).append("</pre>");
    }

    private StringBuffer writeValue(HttpServletRequest req, HttpServletResponse resp, String contextName, String key, StringBuffer buf, Object value, boolean isLink) throws IOException {
        if (value == null) {
            buf.append("null");
        } else if (value instanceof Record) {
            Record record = (Record)value;
            boolean isUpdateSupport = isLink && record instanceof SharedContextRecord && this.isUpdateEnabled();
            RecordSchema schema = record.getRecordSchema();
            PropertySchema[] propSchemata = schema.getPropertySchemata();
            if (isUpdateSupport) {
                buf.append("<form method=\"POST\" action=\"").append(this.getCurrentPath(req)).append("\">");
                buf.append("<input type=\"hidden\" name=\"action\" value=\"update\"/>");
                buf.append("<input type=\"hidden\" name=\"name\" value=\"").append(contextName).append("\"/>");
                buf.append("<textarea name=\"key\" hidden>").append(key).append("</textarea>");
            }
            buf.append("<table border=\"1\" cellspacing=\"0\" cellpadding=\"3\" width=\"90%\">");
            buf.append("<tr><th bgcolor=\"#cccccc\">type</th><td colspan=\"4\">").append(value.getClass().getName()).append("</td></tr>");
            if (isUpdateSupport) {
                buf.append("<tr bgcolor=\"#cccccc\"><th rowspan=\"2\">name</th><th rowspan=\"2\">type</th><th colspan=\"2\">value</th></tr>");
                buf.append("<tr bgcolor=\"#cccccc\"><th>current</th><th>new</th></tr>");
            } else {
                buf.append("<tr bgcolor=\"#cccccc\"><th>name</th><th>type</th><th>value</th></tr>");
            }
            for (int i = 0; i < propSchemata.length; ++i) {
                buf.append("<tr><th bgcolor=\"#cccccc\">").append(propSchemata[i].getName()).append("</th>").append("<td>").append(propSchemata[i].getType().getName()).append("</td>").append("<td>").append(record.getProperty(i)).append("</td>");
                if (isUpdateSupport) {
                    buf.append("<td><table><tr><td>\u2192</td><td><textarea name=\"value\" cols=\"40\" rows=\"4\"></textarea></td></tr></table></td>");
                }
                buf.append("</tr>");
            }
            buf.append("</table>");
            if (isUpdateSupport) {
                buf.append("<input type=\"submit\" value=\"update\">");
                buf.append("</form>");
            }
        } else if (value instanceof RecordList) {
            int i;
            RecordList recordList = (RecordList)value;
            boolean isUpdateSupport = isLink && recordList instanceof SharedContextRecordList && this.isUpdateEnabled();
            RecordSchema schema = recordList.getRecordSchema();
            PropertySchema[] propSchemata = schema.getPropertySchemata();
            if (isUpdateSupport) {
                buf.append("<form method=\"POST\" action=\"").append(this.getCurrentPath(req)).append("\">");
                buf.append("<input type=\"hidden\" name=\"action\" value=\"update\"/>");
                buf.append("<input type=\"hidden\" name=\"name\" value=\"").append(contextName).append("\"/>");
                buf.append("<textarea name=\"key\" hidden>").append(key).append("</textarea>");
            }
            buf.append("<table border=\"1\" cellspacing=\"0\" cellpadding=\"3\" width=\"90%\">");
            if (isUpdateSupport) {
                buf.append("<tr><th bgcolor=\"#cccccc\" colspan=\"2\">type</th><td colspan=\"").append(propSchemata.length).append("\">").append(value.getClass().getName()).append("</td></tr>");
            } else {
                buf.append("<tr><th bgcolor=\"#cccccc\">type</th><td colspan=\"").append(propSchemata.length).append("\">").append(value.getClass().getName()).append("</td></tr>");
            }
            buf.append("<tr bgcolor=\"#cccccc\">");
            if (isUpdateSupport) {
                buf.append("<th rowspan=\"2\" colspan=\"2\">Index</th>");
            } else {
                buf.append("<th rowspan=\"2\">Index</th>");
            }
            for (i = 0; i < propSchemata.length; ++i) {
                buf.append("<th>").append(propSchemata[i].getName()).append("</th>");
            }
            buf.append("</tr>");
            buf.append("<tr bgcolor=\"#cccccc\">");
            for (i = 0; i < propSchemata.length; ++i) {
                buf.append("<th>").append(propSchemata[i].getType().getName()).append("</th>");
            }
            buf.append("</tr>");
            for (i = 0; i < recordList.size(); ++i) {
                int j;
                Record record = (Record)recordList.get(i);
                if (isUpdateSupport) {
                    buf.append("<tr><td rowspan=\"2\">").append(i).append("</td>").append("<td>current</td>");
                } else {
                    buf.append("<tr><td>").append(i).append("</td>");
                }
                for (j = 0; j < propSchemata.length; ++j) {
                    buf.append("<td>").append(record.getProperty(j)).append("</td>");
                }
                buf.append("</tr>");
                if (!isUpdateSupport) continue;
                buf.append("<tr>").append("<td>new</td>");
                for (j = 0; j < propSchemata.length; ++j) {
                    buf.append("<td><table><tr><td style=\"text-align:center;\">\u2193</td></tr><tr><td><textarea name=\"value_").append(i).append("\" cols=\"40\" rows=\"4\"></textarea></td></tr></table></td>");
                }
                buf.append("</tr>");
            }
            buf.append("</table>");
            if (isUpdateSupport) {
                buf.append("<input type=\"submit\" value=\"update\">");
                buf.append("</form>");
            }
        } else {
            if (isLink && this.isPutEnabled()) {
                buf.append("<form method=\"POST\" action=\"").append(this.getCurrentPath(req)).append("\">");
                buf.append("<input type=\"hidden\" name=\"action\" value=\"put\"/>");
                buf.append("<input type=\"hidden\" name=\"name\" value=\"").append(contextName).append("\"/>");
                buf.append("<textarea name=\"key\" hidden>").append(key).append("</textarea>");
            }
            buf.append("<table><tr><td>").append(value.toString()).append("</td>");
            if (isLink && this.isPutEnabled()) {
                buf.append("<td>\u2192</td><td><textarea name=\"value\" cols=\"40\" rows=\"4\"></textarea></td><td><input type=\"submit\" value=\"put\"></td></tr></table>");
                buf.append("</form>");
            } else {
                buf.append("</tr></table>");
            }
        }
        return buf;
    }

    protected void processContainsKeyResponse(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String serviceNameStr = req.getParameter("name");
        ServiceNameEditor editor = new ServiceNameEditor();
        editor.setAsText(serviceNameStr);
        ServiceName serviceName = (ServiceName)editor.getValue();
        SharedContext context = (SharedContext)ServiceManagerFactory.getServiceObject(serviceName);
        String keyStr = req.getParameter("key");
        if (keyStr.indexOf("\n") == -1 && keyStr.indexOf("\r") == -1) {
            keyStr = "return " + keyStr;
        }
        StringBuffer buf = new StringBuffer();
        resp.setContentType("text/html;charset=UTF-8");
        buf.append("<html>");
        buf.append("<head><title>Nimbus SharedContext " + serviceName + " ContainsKey</title></head>");
        buf.append("<body>");
        try {
            Object key = this.interpreter.evaluate(keyStr);
            if (context.containsKey(key)) {
                buf.append("contains key : ").append(key);
                if (context.containsKeyLocal(key)) {
                    buf.append(" on local");
                }
            } else {
                buf.append("not contains key : ").append(key);
            }
        }
        catch (Exception e) {
            this.writeThrowable(buf, e);
        }
        buf.append("<hr>");
        buf.append("<a href=\"").append(this.getCurrentPath(req)).append("\">Contexts</a>");
        buf.append("</body>");
        buf.append("</html>");
        resp.getWriter().println(buf.toString());
    }

    protected void processKeySetResponse(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String serviceNameStr = req.getParameter("name");
        ServiceNameEditor editor = new ServiceNameEditor();
        editor.setAsText(serviceNameStr);
        ServiceName serviceName = (ServiceName)editor.getValue();
        SharedContext context = (SharedContext)ServiceManagerFactory.getServiceObject(serviceName);
        StringBuffer buf = new StringBuffer();
        resp.setContentType("text/html;charset=UTF-8");
        buf.append("<html>");
        buf.append("<head><title>Nimbus SharedContext " + serviceName + " KeySet</title></head>");
        buf.append("<body>");
        try {
            ArrayList keys = new ArrayList(context.keySet());
            if (keys.size() != 0) {
                if (keys.get(0) instanceof Comparable) {
                    Collections.sort(keys);
                } else {
                    Collections.sort(keys, new Comparator(){

                        public int compare(Object o1, Object o2) {
                            if (o1 == null && o2 == null) {
                                return 0;
                            }
                            if (o1 == null && o2 != null) {
                                return -1;
                            }
                            if (o1 != null && o2 == null) {
                                return 1;
                            }
                            return o1.toString().compareTo(o2.toString());
                        }
                    });
                }
            }
            buf.append("<table border=\"1\" cellspacing=\"0\" cellpadding=\"3\" width=\"90%\">");
            buf.append("<tr bgcolor=\"#cccccc\"><th colspan=\"2\">key</th><th rowspan=\"2\">local/remote</th><th rowspan=\"2\">&nbsp;</th></tr>");
            buf.append("<tr bgcolor=\"#cccccc\"><th>value</th><th>type</th></tr>");
            for (int i = 0; i < keys.size(); ++i) {
                Object key = keys.get(i);
                buf.append("<tr><td>").append(key).append("</td>");
                buf.append("<td>").append(key == null ? "&nbsp;" : key.getClass().getName()).append("</td>");
                buf.append("<td>").append(context.containsKeyLocal(key) ? "local" : "remote").append("</td>");
                buf.append("<form method=\"POST\" action=\"").append(this.getCurrentPath(req)).append("\" name=\"key_").append(i).append("\">");
                buf.append("<input type=\"hidden\" name=\"action\" value=\"\"/>");
                buf.append("<input type=\"hidden\" name=\"name\" value=\"").append(serviceNameStr).append("\"/>");
                buf.append("<td><table><tr><td>key:</td><td><textarea name=\"key\" cols=\"40\" rows=\"4\">");
                if (key instanceof String) {
                    buf.append('\"').append(key).append('\"');
                }
                buf.append("</textarea></td>");
                buf.append("<td><input type=\"submit\" value=\"get\" onclick=\"document.key_").append(i).append(".action.value='get'\"/></td>");
                if (this.isRemoveEnabled()) {
                    buf.append("<td><input type=\"submit\" value=\"remove\" onclick=\"document.key_").append(i).append(".action.value='remove'\"/></td>");
                }
                if (this.isLoadEnabled()) {
                    buf.append("<td><input type=\"submit\" value=\"load\" onclick=\"document.key_").append(i).append(".action.value='load'\"/></td>");
                }
                if (this.isSaveEnabled()) {
                    buf.append("<td><input type=\"submit\" value=\"save\" onclick=\"document.key_").append(i).append(".action.value='save'\"/></td>");
                }
                buf.append("</tr></table></td></form>");
                buf.append("</tr>");
            }
            buf.append("</table>");
        }
        catch (Exception e) {
            this.writeThrowable(buf, e);
        }
        buf.append("<hr>");
        buf.append("<a href=\"").append(this.getCurrentPath(req)).append("\">Contexts</a>");
        buf.append("</body>");
        buf.append("</html>");
        resp.getWriter().println(buf.toString());
    }

    protected void processQueryResponse(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String serviceNameStr = req.getParameter("name");
        ServiceNameEditor editor = new ServiceNameEditor();
        editor.setAsText(serviceNameStr);
        ServiceName serviceName = (ServiceName)editor.getValue();
        SharedContext context = (SharedContext)ServiceManagerFactory.getServiceObject(serviceName);
        String query = req.getParameter("query");
        String mergeQuery = req.getParameter("mergeQuery");
        String timeoutStr = req.getParameter("timeout");
        long timeout = 0L;
        try {
            timeout = Long.parseLong(timeoutStr);
        }
        catch (NumberFormatException e) {
            timeoutStr = null;
        }
        StringBuffer buf = new StringBuffer();
        resp.setContentType("text/html;charset=UTF-8");
        buf.append("<html>");
        buf.append("<head><title>Nimbus SharedContext " + serviceName + " Query</title></head>");
        buf.append("<body>");
        try {
            Object ret = null;
            if (mergeQuery != null && mergeQuery.length() != 0 && context instanceof DistributedSharedContext) {
                DistributedSharedContext distContext = (DistributedSharedContext)context;
                ret = timeoutStr == null ? distContext.executeInterpretQuery(query, mergeQuery, null) : distContext.executeInterpretQuery(query, mergeQuery, null, timeout);
            } else {
                ret = timeoutStr == null ? context.executeInterpretQuery(query, null) : context.executeInterpretQuery(query, null, timeout);
            }
            this.writeValue(req, resp, null, null, buf, ret, false);
        }
        catch (Exception e) {
            this.writeThrowable(buf, e);
        }
        buf.append("<hr>");
        buf.append("<a href=\"").append(this.getCurrentPath(req)).append("\">Contexts</a>");
        buf.append("</body>");
        buf.append("</html>");
        resp.getWriter().println(buf.toString());
    }

    protected void processRemoveResponse(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String serviceNameStr = req.getParameter("name");
        ServiceNameEditor editor = new ServiceNameEditor();
        editor.setAsText(serviceNameStr);
        ServiceName serviceName = (ServiceName)editor.getValue();
        SharedContext context = (SharedContext)ServiceManagerFactory.getServiceObject(serviceName);
        String keyStr = req.getParameter("key");
        if (keyStr.indexOf("\n") == -1 && keyStr.indexOf("\r") == -1) {
            keyStr = "return " + keyStr;
        }
        StringBuffer buf = new StringBuffer();
        resp.setContentType("text/html;charset=UTF-8");
        buf.append("<html>");
        buf.append("<head><title>Nimbus SharedContext " + serviceName + " Remove</title></head>");
        buf.append("<body>");
        try {
            Object key = this.interpreter.evaluate(keyStr);
            context.remove(key);
            buf.append("removed key : ").append(key);
        }
        catch (Exception e) {
            this.writeThrowable(buf, e);
        }
        buf.append("<hr>");
        buf.append("<a href=\"").append(this.getCurrentPath(req)).append("\">Contexts</a>");
        buf.append("</body>");
        buf.append("</html>");
        resp.getWriter().println(buf.toString());
    }

    protected void processPutResponse(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String valueStr;
        String serviceNameStr = req.getParameter("name");
        ServiceNameEditor editor = new ServiceNameEditor();
        editor.setAsText(serviceNameStr);
        ServiceName serviceName = (ServiceName)editor.getValue();
        SharedContext context = (SharedContext)ServiceManagerFactory.getServiceObject(serviceName);
        String keyStr = req.getParameter("key");
        if (keyStr.indexOf("\n") == -1 && keyStr.indexOf("\r") == -1) {
            keyStr = "return " + keyStr;
        }
        if ((valueStr = req.getParameter("value")).indexOf("\n") == -1 && valueStr.indexOf("\r") == -1) {
            valueStr = "return " + valueStr;
        }
        StringBuffer buf = new StringBuffer();
        resp.setContentType("text/html;charset=UTF-8");
        buf.append("<html>");
        buf.append("<head><title>Nimbus SharedContext " + serviceName + " Put</title></head>");
        buf.append("<body>");
        try {
            Object key = this.interpreter.evaluate(keyStr);
            Object value = this.interpreter.evaluate(valueStr);
            context.put(key, value);
            buf.append("put key : ").append(key).append(" value : ").append(value);
        }
        catch (Exception e) {
            this.writeThrowable(buf, e);
        }
        buf.append("<hr>");
        buf.append("<a href=\"").append(this.getCurrentPath(req)).append("\">Contexts</a>");
        buf.append("</body>");
        buf.append("</html>");
        resp.getWriter().println(buf.toString());
    }

    protected void processClearResponse(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String serviceNameStr = req.getParameter("name");
        ServiceNameEditor editor = new ServiceNameEditor();
        editor.setAsText(serviceNameStr);
        ServiceName serviceName = (ServiceName)editor.getValue();
        SharedContext context = (SharedContext)ServiceManagerFactory.getServiceObject(serviceName);
        String type = req.getParameter("type");
        StringBuffer buf = new StringBuffer();
        resp.setContentType("text/html;charset=UTF-8");
        buf.append("<html>");
        buf.append("<head><title>Nimbus SharedContext " + serviceName + " Clear</title></head>");
        buf.append("<body>");
        try {
            if ("local".equals(type)) {
                context.clearLocal();
            } else {
                context.clear();
            }
            buf.append("clear ").append(type);
        }
        catch (Exception e) {
            this.writeThrowable(buf, e);
        }
        buf.append("<hr>");
        buf.append("<a href=\"").append(this.getCurrentPath(req)).append("\">Contexts</a>");
        buf.append("</body>");
        buf.append("</html>");
        resp.getWriter().println(buf.toString());
    }

    protected void processLoadResponse(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String serviceNameStr = req.getParameter("name");
        ServiceNameEditor editor = new ServiceNameEditor();
        editor.setAsText(serviceNameStr);
        ServiceName serviceName = (ServiceName)editor.getValue();
        SharedContext context = (SharedContext)ServiceManagerFactory.getServiceObject(serviceName);
        String keyStr = req.getParameter("key");
        if (keyStr != null && keyStr.length() != 0 && keyStr.indexOf("\n") == -1 && keyStr.indexOf("\r") == -1) {
            keyStr = "return " + keyStr;
        }
        StringBuffer buf = new StringBuffer();
        resp.setContentType("text/html;charset=UTF-8");
        buf.append("<html>");
        buf.append("<head><title>Nimbus SharedContext " + serviceName + " Load</title></head>");
        buf.append("<body>");
        try {
            if (keyStr != null && keyStr.length() != 0) {
                Object key = this.interpreter.evaluate(keyStr);
                context.load(key);
                buf.append("load ").append(key).append(" complete");
            } else {
                context.load();
                buf.append("load complete");
            }
        }
        catch (Exception e) {
            this.writeThrowable(buf, e);
        }
        buf.append("<hr>");
        buf.append("<a href=\"").append(this.getCurrentPath(req)).append("\">Contexts</a>");
        buf.append("</body>");
        buf.append("</html>");
        resp.getWriter().println(buf.toString());
    }

    protected void processLoadKeyResponse(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String serviceNameStr = req.getParameter("name");
        ServiceNameEditor editor = new ServiceNameEditor();
        editor.setAsText(serviceNameStr);
        ServiceName serviceName = (ServiceName)editor.getValue();
        SharedContext context = (SharedContext)ServiceManagerFactory.getServiceObject(serviceName);
        StringBuffer buf = new StringBuffer();
        resp.setContentType("text/html;charset=UTF-8");
        buf.append("<html>");
        buf.append("<head><title>Nimbus SharedContext " + serviceName + " LoadKey</title></head>");
        buf.append("<body>");
        try {
            context.loadKey();
            buf.append("load key complete");
        }
        catch (Exception e) {
            this.writeThrowable(buf, e);
        }
        buf.append("<hr>");
        buf.append("<a href=\"").append(this.getCurrentPath(req)).append("\">Contexts</a>");
        buf.append("</body>");
        buf.append("</html>");
        resp.getWriter().println(buf.toString());
    }

    protected void processSaveResponse(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String serviceNameStr = req.getParameter("name");
        ServiceNameEditor editor = new ServiceNameEditor();
        editor.setAsText(serviceNameStr);
        ServiceName serviceName = (ServiceName)editor.getValue();
        SharedContext context = (SharedContext)ServiceManagerFactory.getServiceObject(serviceName);
        String keyStr = req.getParameter("key");
        if (keyStr != null && keyStr.length() != 0 && keyStr.indexOf("\n") == -1 && keyStr.indexOf("\r") == -1) {
            keyStr = "return " + keyStr;
        }
        StringBuffer buf = new StringBuffer();
        resp.setContentType("text/html;charset=UTF-8");
        buf.append("<html>");
        buf.append("<head><title>Nimbus SharedContext " + serviceName + " Save</title></head>");
        buf.append("<body>");
        try {
            if (keyStr != null && keyStr.length() != 0) {
                Object key = this.interpreter.evaluate(keyStr);
                context.save(key);
                buf.append("save ").append(key).append(" complete");
            } else {
                context.save();
                buf.append("save complete");
            }
        }
        catch (Exception e) {
            this.writeThrowable(buf, e);
        }
        buf.append("<hr>");
        buf.append("<a href=\"").append(this.getCurrentPath(req)).append("\">Contexts</a>");
        buf.append("</body>");
        buf.append("</html>");
        resp.getWriter().println(buf.toString());
    }

    protected void processUpdateResponse(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String serviceNameStr = req.getParameter("name");
        ServiceNameEditor editor = new ServiceNameEditor();
        editor.setAsText(serviceNameStr);
        ServiceName serviceName = (ServiceName)editor.getValue();
        SharedContext context = (SharedContext)ServiceManagerFactory.getServiceObject(serviceName);
        String keyStr = req.getParameter("key");
        StringBuffer buf = new StringBuffer();
        resp.setContentType("text/html;charset=UTF-8");
        buf.append("<html>");
        buf.append("<head><title>Nimbus SharedContext " + serviceName + " Update</title></head>");
        buf.append("<body>");
        try {
            Object key = this.interpreter.evaluate(keyStr);
            Object value = context.get(key);
            SharedContextValueDifference diff = null;
            if (value instanceof SharedContextRecord) {
                SharedContextRecord record = (SharedContextRecord)value;
                String[] values = req.getParameterValues("value");
                for (int i = 0; i < values.length; ++i) {
                    if (values[i] == null || values[i].length() == 0) continue;
                    String valueStr = values[i];
                    if (valueStr.indexOf("\n") == -1 && valueStr.indexOf("\r") == -1) {
                        valueStr = "return " + valueStr;
                    }
                    Object updateValue = this.interpreter.evaluate(valueStr);
                    diff = record.updateProperty(i, updateValue, diff);
                }
            } else if (value instanceof SharedContextRecordList) {
                SharedContextRecordList recordList = (SharedContextRecordList)value;
                int imax = recordList.size();
                for (int i = 0; i < imax; ++i) {
                    SharedContextRecord record = (SharedContextRecord)recordList.get(i);
                    String[] vals = req.getParameterValues("value_" + i);
                    if (vals == null || vals.length == 0) continue;
                    for (int j = 0; j < vals.length; ++j) {
                        if (vals[j] == null || vals[j].length() == 0) continue;
                        String valueStr = vals[j];
                        if (valueStr.indexOf("\n") == -1 && valueStr.indexOf("\r") == -1) {
                            valueStr = "return " + valueStr;
                        }
                        Object updateValue = this.interpreter.evaluate(valueStr);
                        diff = record.updateProperty(j, updateValue, diff);
                    }
                }
            }
            if (diff != null) {
                context.update(key, diff);
                buf.append("update " + key + " complete");
            } else {
                buf.append("no difference " + key);
            }
        }
        catch (Exception e) {
            this.writeThrowable(buf, e);
        }
        buf.append("<hr>");
        buf.append("<a href=\"").append(this.getCurrentPath(req)).append("\">Contexts</a>");
        buf.append("</body>");
        buf.append("</html>");
        resp.getWriter().println(buf.toString());
    }
}

