/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.writer.log4j;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Layout;
import org.apache.log4j.RollingFileAppender;
import org.apache.log4j.helpers.LogLog;

public class CustomizedRollingFileAppender
extends RollingFileAppender {
    private static final int BUFFER_SIZE = 16384;
    public static final String INDEX = "%INDEX%";
    private String indexedFileName;
    private List fileNames;

    public CustomizedRollingFileAppender() {
        this.initFileNames();
    }

    private synchronized void initFileNames() {
        if (this.fileNames == null) {
            this.fileNames = new ArrayList();
        }
        int maxIndex = this.getMaxBackupIndex();
        if (this.fileNames.size() < maxIndex) {
            int max = maxIndex - this.fileNames.size();
            for (int i = 0; i < max; ++i) {
                this.fileNames.add(null);
            }
        }
    }

    public CustomizedRollingFileAppender(Layout layout, String filename, boolean append) throws IOException {
        super(layout, filename, append);
        this.initFileNames();
    }

    public CustomizedRollingFileAppender(Layout layout, String filename) throws IOException {
        super(layout, filename);
        this.initFileNames();
    }

    public void setMaxBackupIndex(int maxBackups) {
        super.setMaxBackupIndex(maxBackups);
        this.initFileNames();
    }

    public void setFile(String file) {
        int index = file.indexOf(INDEX);
        String tmpFile = null;
        if (index == -1) {
            this.indexedFileName = null;
            tmpFile = file;
        } else {
            this.indexedFileName = file;
            tmpFile = index + INDEX.length() == this.indexedFileName.length() ? this.indexedFileName.substring(0, index) : this.indexedFileName.substring(0, index) + this.indexedFileName.substring(index + INDEX.length());
        }
        super.setFile(tmpFile);
    }

    public void rollOver() {
        if (this.maxBackupIndex > 0) {
            int i;
            String tmpFileName = null;
            File tmpFile = null;
            tmpFileName = this.getNextFileName(this.maxBackupIndex);
            int index = this.maxBackupIndex;
            if (tmpFileName == null) {
                for (i = 1; i <= this.maxBackupIndex; ++i) {
                    tmpFileName = this.getNextFileName(i);
                    tmpFile = new File(tmpFileName);
                    if (tmpFile.exists()) continue;
                    index = i;
                    break;
                }
            } else {
                tmpFile = new File(tmpFileName);
                tmpFile.delete();
                index = this.maxBackupIndex;
            }
            i = index;
            while (--i >= 1) {
                tmpFileName = this.getNextFileName(i);
                tmpFile = new File(tmpFileName);
                if (!tmpFile.exists()) continue;
                tmpFileName = this.getNextFileName(i + 1);
                tmpFile.renameTo(new File(tmpFileName));
            }
            this.closeFile();
            try {
                this.copyFile(new File(this.fileName), new File(this.getNextFileName(1)));
            }
            catch (Exception e) {
                LogLog.debug((String)"Renaming IOExcetpion when writing file");
            }
        }
        try {
            this.setFile(this.fileName, false, this.bufferedIO, this.bufferSize);
        }
        catch (IOException e) {
            LogLog.error((String)("setFile(" + this.fileName + ", false) call failed."), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFile(File file, File target) throws IOException {
        byte[] buffer = new byte[16384];
        FileInputStream from_stream = null;
        OutputStream to_stream = null;
        try {
            int rcount;
            from_stream = new FileInputStream(file);
            to_stream = new FileOutputStream(target);
            while ((rcount = ((InputStream)from_stream).read(buffer)) >= 0) {
                to_stream.write(buffer, 0, rcount);
            }
        }
        finally {
            if (from_stream != null) {
                ((InputStream)from_stream).close();
            }
            if (to_stream != null) {
                to_stream.close();
            }
        }
    }

    private String getNextFileName(int backupIndex) {
        if (this.fileNames.size() < backupIndex) {
            this.initFileNames();
        }
        if (this.fileNames.get(backupIndex - 1) != null) {
            return (String)this.fileNames.get(backupIndex - 1);
        }
        String result = null;
        if (this.indexedFileName == null) {
            result = this.fileName + backupIndex;
        } else {
            int index = this.indexedFileName.indexOf(INDEX);
            StringBuffer buf = new StringBuffer();
            buf.append(this.indexedFileName.substring(0, index));
            buf.append(backupIndex);
            if (index != this.indexedFileName.length() - INDEX.length()) {
                buf.append(this.indexedFileName.substring(index + INDEX.length()));
            }
            result = buf.toString();
        }
        this.fileNames.set(backupIndex - 1, result);
        return result;
    }
}

