/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.writer;

import java.lang.reflect.InvocationTargetException;
import jp.ossc.nimbus.service.writer.SimpleElement;

public class ThrowableSimpleElement
extends SimpleElement {
    private static final long serialVersionUID = -6342673505293153134L;
    private static final String LINE_SEP = System.getProperty("line.separator");
    private static final String TAB = "\t";
    private static final String MSG_TITLE = "Exception occuers :";
    private static final String MSG_CAUSE = "Caused by:";
    private static final String SERVLET_EXCEPTION_NAME = "javax.servlet.ServletException";
    private static final String GET_ROOT_CAUSE_METHOD = "getRootCause";
    private static final String JMS_EXCEPTION_NAME = "javax.jms.JMSException";
    private static final String GET_LINKED_EXCEPTION_METHOD = "getLinkedException";
    private boolean isOutputCause = true;
    private boolean isOutputTab = true;

    public ThrowableSimpleElement() {
    }

    public ThrowableSimpleElement(Object value) {
        super(value);
    }

    public ThrowableSimpleElement(Object key, Object value) {
        super(key, value);
    }

    public void setOutputCause(boolean output) {
        this.isOutputCause = output;
    }

    public boolean getOutputCause() {
        return this.isOutputCause;
    }

    public void setOutputTab(boolean outputTab) {
        this.isOutputTab = outputTab;
    }

    public boolean getOutputTab() {
        return this.isOutputTab;
    }

    @Override
    public String toString() {
        if (this.mValue == null) {
            return super.toString();
        }
        Throwable e = (Throwable)this.mValue;
        StringBuffer buf = new StringBuffer();
        buf.append(MSG_TITLE).append(e).append(LINE_SEP);
        StackTraceElement[] elemss = e.getStackTrace();
        if (elemss != null) {
            int max = elemss.length;
            for (int i = 0; i < max; ++i) {
                if (this.isOutputTab) {
                    buf.append(TAB);
                }
                buf.append(elemss[i]);
                if (i == max - 1) continue;
                buf.append(LINE_SEP);
            }
        }
        if (this.isOutputCause) {
            Throwable ee = this.getCause(e);
            while (ee != null) {
                buf.append(LINE_SEP).append(MSG_CAUSE).append(ee).append(LINE_SEP);
                StackTraceElement[] elems = ee.getStackTrace();
                if (elems != null) {
                    int max = elems.length;
                    for (int i = 0; i < max; ++i) {
                        if (this.isOutputTab) {
                            buf.append(TAB);
                        }
                        buf.append(elems[i]);
                        if (i == max - 1) continue;
                        buf.append(LINE_SEP);
                    }
                }
                ee = this.getCause(ee);
            }
        }
        return this.convertString(buf.toString());
    }

    private Throwable getCause(Throwable th) {
        Throwable cause = null;
        String thClassName = th.getClass().getName();
        if (thClassName.equals(SERVLET_EXCEPTION_NAME)) {
            try {
                cause = (Throwable)th.getClass().getMethod(GET_ROOT_CAUSE_METHOD, null).invoke((Object)th, (Object[])null);
            }
            catch (NoSuchMethodException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {}
        } else if (thClassName.equals(JMS_EXCEPTION_NAME)) {
            try {
                cause = (Exception)th.getClass().getMethod(GET_LINKED_EXCEPTION_METHOD, null).invoke((Object)th, (Object[])null);
            }
            catch (NoSuchMethodException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {}
        } else {
            cause = th.getCause();
        }
        return cause == th ? null : cause;
    }

    @Override
    public Object toObject() {
        return this.getValue();
    }
}

