/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.trace;

import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.lang.ServiceException;
import jp.ossc.nimbus.service.journal.JournalEditor;
import jp.ossc.nimbus.service.journal.editorfinder.EditorFinder;
import jp.ossc.nimbus.service.log.Logger;
import jp.ossc.nimbus.service.trace.TraceServiceMBean;
import jp.ossc.nimbus.service.trace.Tracer;

public class TraceService
extends ServiceBase
implements TraceServiceMBean,
Tracer {
    private static final long serialVersionUID = 7534818369420794264L;
    private static final String DEFAULT_SEPARATOR = System.getProperty("line.separator");
    private static final int DEFAULT_NESTED_LEVEL = 2;
    private static final String ENTRY_STATE_START = "1";
    private static final char ATMARK_REPLACE_CHAR = '$';
    private static final String ERROR_USE_OF_TRACE_MSG = "entry/exit method must be called after using isXXX() trace-level check function.";
    private int traceLevel = 21;
    private String separator = DEFAULT_SEPARATOR;
    private int nestedLevel = 2;
    private ServiceName logServiceName;
    private ServiceName editorFinderServiceName;
    private Logger mLogService;
    private EditorFinder mEditorFinderService;
    private static ThreadLocal thLocal = new ThreadLocal();

    @Override
    public ServiceName getLogServiceName() {
        return this.logServiceName;
    }

    @Override
    public void setLogServiceName(ServiceName name) {
        this.logServiceName = name;
    }

    @Override
    public ServiceName getEditorFinderServiceName() {
        return this.editorFinderServiceName;
    }

    @Override
    public void setEditorFinderServiceName(ServiceName name) {
        this.editorFinderServiceName = name;
    }

    @Override
    public void setTraceLevel(int level) {
        this.traceLevel = level;
    }

    @Override
    public void setNestedLevel(int level) {
        this.nestedLevel = level;
    }

    @Override
    public void setSeparator(String sep) {
        this.separator = sep;
    }

    public void setEditorFinder(EditorFinder editorFinder) {
        this.mEditorFinderService = editorFinder;
    }

    @Override
    public void setLogger(Logger logger) {
        this.mLogService = logger;
    }

    @Override
    public void createService() throws Exception {
    }

    @Override
    public void startService() throws Exception {
        if (this.logServiceName != null) {
            this.mLogService = (Logger)ServiceManagerFactory.getServiceObject(this.logServiceName);
        }
        if (this.mLogService == null) {
            throw new IllegalArgumentException("Cannot resolve LogService.");
        }
        if (this.editorFinderServiceName != null) {
            this.mEditorFinderService = (EditorFinder)ServiceManagerFactory.getServiceObject(this.editorFinderServiceName);
        }
        if (this.mEditorFinderService == null) {
            throw new IllegalArgumentException("Cannot resolve EditorFinderService.");
        }
    }

    @Override
    public void stopService() throws Exception {
        this.mLogService = null;
        this.mEditorFinderService = null;
    }

    @Override
    public void destroyService() throws Exception {
        this.loggerServiceName = null;
        this.editorFinderServiceName = null;
    }

    @Override
    public void entry(Object[] params) {
        if (!this.isFlagSetted()) {
            throw new ServiceException("Tracer00001", ERROR_USE_OF_TRACE_MSG);
        }
        this.clearFlag();
        String param = this.getParameterStrings(params);
        String callerInfo = this.getCallerInfo();
        this.mLogService.write("TRC__00001", new String[]{callerInfo, param});
    }

    @Override
    public void exit(Object[] params) {
        if (!this.isFlagSetted()) {
            throw new ServiceException("Tracer00001", ERROR_USE_OF_TRACE_MSG);
        }
        this.clearFlag();
        String param = this.getParameterStrings(params);
        String callerInfo = this.getCallerInfo();
        this.mLogService.write("TRC__00002", new String[]{callerInfo, param});
    }

    @Override
    public boolean isPublic() {
        boolean b;
        boolean bl = b = this.traceLevel <= 20;
        if (b) {
            this.setFlag();
        }
        return b;
    }

    @Override
    public boolean isProtected() {
        boolean b;
        boolean bl = b = this.traceLevel <= 10;
        if (b) {
            this.setFlag();
        }
        return b;
    }

    @Override
    public boolean isPrivate() {
        boolean b;
        boolean bl = b = this.traceLevel <= 0;
        if (b) {
            this.setFlag();
        }
        return b;
    }

    protected void clearFlag() {
        thLocal.set(null);
    }

    protected boolean isFlagSetted() {
        return thLocal.get() != null;
    }

    protected void setFlag() {
        thLocal.set(ENTRY_STATE_START);
    }

    private String getCallerInfo() {
        String callerClass = null;
        Exception e = new Exception();
        StackTraceElement[] elms = e.getStackTrace();
        if (elms.length < this.nestedLevel) {
            this.mLogService.write("TRC__00003", this.nestedLevel);
        } else {
            StackTraceElement elm = elms[this.nestedLevel];
            callerClass = elm.toString();
        }
        return callerClass;
    }

    private String getParameterStrings(Object[] params) {
        StringBuffer buff = new StringBuffer();
        if (params == null) {
            buff.append(params);
            return buff.toString();
        }
        for (int i = 0; i < params.length; ++i) {
            Object param = params[i];
            if (param != null) {
                JournalEditor editor = this.mEditorFinderService.findEditor(param.getClass());
                String str = (String)editor.toObject(this.mEditorFinderService, null, param);
                if (str != null) {
                    str.replace('@', '$');
                }
                buff.append(str);
                if (i != params.length - 1) {
                    buff.append(this.separator);
                }
            } else {
                buff.append(param);
            }
            if (i == params.length - 1) continue;
            buff.append(this.separator);
        }
        return buff.toString();
    }
}

