/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.sequence;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.service.sequence.NumberSequenceServiceMBean;
import jp.ossc.nimbus.service.sequence.Sequence;

public class NumberSequenceService
extends ServiceBase
implements Sequence,
NumberSequenceServiceMBean {
    private static final long serialVersionUID = 7700067543446331974L;
    private long initialValue;
    private long minValue;
    private long maxValue;
    private long incrementValue = 1L;
    private long currentValue;
    private String format;
    private NumberFormat numberFormat;
    private NumberFormat currentFormat;

    @Override
    public void setInitialValue(long value) {
        this.initialValue = value;
    }

    @Override
    public long getInitialValue() {
        return this.initialValue;
    }

    @Override
    public void setMinValue(long value) {
        this.minValue = value;
    }

    @Override
    public long getMinValue() {
        return this.minValue;
    }

    @Override
    public void setMaxValue(long value) {
        this.maxValue = value;
    }

    @Override
    public long getMaxValue() {
        return this.maxValue;
    }

    @Override
    public void setIncrementValue(long value) {
        this.incrementValue = value;
    }

    @Override
    public long getIncrementValue() {
        return this.incrementValue;
    }

    @Override
    public void setFormat(String format) {
        this.format = format;
    }

    @Override
    public String getFormat() {
        return this.format;
    }

    @Override
    public void setNumberFormat(NumberFormat format) {
        this.numberFormat = format;
    }

    @Override
    public NumberFormat getNumberFormat() {
        return this.numberFormat;
    }

    @Override
    public synchronized long getCurrentValue() {
        return this.currentValue;
    }

    @Override
    public void startService() throws Exception {
        if (this.minValue > this.maxValue) {
            throw new IllegalArgumentException("MinValue > MaxValue");
        }
        if (this.incrementValue >= 0L && (this.initialValue > this.maxValue || this.initialValue < this.minValue && this.initialValue + this.incrementValue < this.minValue) || this.incrementValue < 0L && (this.initialValue < this.minValue || this.initialValue > this.maxValue && this.initialValue + this.incrementValue > this.maxValue)) {
            throw new IllegalArgumentException("InitialValue is illegal : " + this.initialValue);
        }
        if (this.numberFormat != null) {
            this.currentFormat = this.numberFormat;
        } else if (this.format != null) {
            this.currentFormat = new DecimalFormat(this.format);
        }
        this.currentValue = this.initialValue;
    }

    @Override
    public synchronized String increment() {
        this.currentValue = this.incrementValue >= 0L ? (this.currentValue < this.maxValue ? (this.currentValue += this.incrementValue) : (this.initialValue < this.minValue ? this.initialValue + this.incrementValue : this.minValue)) : (this.currentValue > this.minValue ? (this.currentValue += this.incrementValue) : (this.initialValue > this.maxValue ? this.initialValue + this.incrementValue : this.maxValue));
        if (this.currentFormat != null) {
            return this.currentFormat.format(this.currentValue);
        }
        return String.valueOf(this.currentValue);
    }

    @Override
    public String getInitial() {
        long inital = 0L;
        inital = this.incrementValue >= 0L ? (this.initialValue < this.minValue ? this.initialValue + this.incrementValue : this.initialValue) : (this.initialValue > this.maxValue ? this.initialValue + this.incrementValue : this.initialValue);
        if (this.currentFormat != null) {
            return this.currentFormat.format(inital);
        }
        return String.valueOf(inital);
    }

    @Override
    public synchronized void reset() {
        this.currentValue = this.initialValue;
    }

    @Override
    public synchronized String getCurrent() {
        if (this.currentFormat != null) {
            return this.currentFormat.format(this.currentValue);
        }
        return String.valueOf(this.currentValue);
    }
}

