/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.scheduler2;

import java.beans.PropertyEditor;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Array;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import jp.ossc.nimbus.beans.NimbusPropertyEditorManager;
import jp.ossc.nimbus.beans.ServiceNameEditor;
import jp.ossc.nimbus.beans.StringArrayEditor;
import jp.ossc.nimbus.core.NimbusClassLoader;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.daemon.Daemon;
import jp.ossc.nimbus.daemon.DaemonControl;
import jp.ossc.nimbus.daemon.DaemonRunnable;
import jp.ossc.nimbus.io.CSVReader;
import jp.ossc.nimbus.io.CSVWriter;
import jp.ossc.nimbus.service.scheduler2.DefaultSchedule;
import jp.ossc.nimbus.service.scheduler2.DefaultScheduleMakerService;
import jp.ossc.nimbus.service.scheduler2.DefaultScheduleManagerServiceMBean;
import jp.ossc.nimbus.service.scheduler2.Schedule;
import jp.ossc.nimbus.service.scheduler2.ScheduleControlListener;
import jp.ossc.nimbus.service.scheduler2.ScheduleMakeException;
import jp.ossc.nimbus.service.scheduler2.ScheduleMaker;
import jp.ossc.nimbus.service.scheduler2.ScheduleManageException;
import jp.ossc.nimbus.service.scheduler2.ScheduleManager;
import jp.ossc.nimbus.service.scheduler2.ScheduleMaster;
import jp.ossc.nimbus.service.scheduler2.ScheduleStateControlException;
import jp.ossc.nimbus.service.sequence.Sequence;

public class DefaultScheduleManagerService
extends ServiceBase
implements ScheduleManager,
DefaultScheduleManagerServiceMBean {
    private static final long serialVersionUID = 3176394103850131069L;
    protected static final String DATE_DIR_FORMAT = "yyyyMMdd";
    protected static final String DATE_CSV_FORMAT = "yyyy/MM/dd HH:mm:ss SSS";
    protected static final String LOCAL_SEQUENCE_NUMBER_FILE = "sequence_number";
    protected static final String ARRAY_CLASS_SUFFIX = "[]";
    protected ServiceName[] scheduleMasterServiceNames;
    protected Map addedScheduleMasters;
    protected Map scheduleMasters;
    protected Properties scheduleMakerTypeMapping;
    protected Map addedScheduleMakerMap;
    protected Map scheduleMakerMap;
    protected boolean isScheduleMakerTypeRegexEnabled;
    protected ServiceName defaultScheduleMakerServiceName;
    protected ScheduleMaker defaultScheduleMaker;
    protected boolean isMakeScheduleOnStart = true;
    protected Map scheduleDateMap;
    protected Map scheduleMap;
    protected Map scheduleDependedMap;
    protected List scheduleList;
    protected Map scheduleMasterMap;
    protected ServiceName sequenceServiceName;
    protected Sequence sequence;
    protected long sequenceNumber;
    protected Object sequenceNumberLock = "sequenceNumberLock";
    protected Set scheduleControlListeners;
    protected String persistDir;
    protected long timeoverCheckInterval = 1000L;
    protected Daemon timeoverChecker;

    @Override
    public void setDefaultScheduleMakerServiceName(ServiceName name) {
        this.defaultScheduleMakerServiceName = name;
    }

    @Override
    public ServiceName getDefaultScheduleMakerServiceName() {
        return this.defaultScheduleMakerServiceName;
    }

    @Override
    public void setScheduleMasterServiceNames(ServiceName[] names) {
        this.scheduleMasterServiceNames = names;
    }

    @Override
    public ServiceName[] getScheduleMasterServiceNames() {
        return this.scheduleMasterServiceNames;
    }

    @Override
    public void setScheduleMakerTypeMapping(Properties mapping) {
        this.scheduleMakerTypeMapping = mapping;
    }

    @Override
    public Properties getScheduleMakerTypeMapping() {
        return this.scheduleMakerTypeMapping;
    }

    @Override
    public void setScheduleMakerTypeRegexEnabled(boolean isEnable) {
        this.isScheduleMakerTypeRegexEnabled = isEnable;
    }

    @Override
    public boolean isScheduleMakerTypeRegexEnabled() {
        return this.isScheduleMakerTypeRegexEnabled;
    }

    @Override
    public void setMakeScheduleOnStart(boolean isMake) {
        this.isMakeScheduleOnStart = isMake;
    }

    @Override
    public boolean isMakeScheduleOnStart() {
        return this.isMakeScheduleOnStart;
    }

    @Override
    public void setSequenceServiceName(ServiceName name) {
        this.sequenceServiceName = name;
    }

    @Override
    public ServiceName getSequenceServiceName() {
        return this.sequenceServiceName;
    }

    @Override
    public void setPersistDir(String dir) {
        this.persistDir = dir;
    }

    @Override
    public String getPersistDir() {
        return this.persistDir;
    }

    @Override
    public void setTimeoverCheckInterval(long interval) {
        this.timeoverCheckInterval = interval;
    }

    @Override
    public long getTimeoverCheckInterval() {
        return this.timeoverCheckInterval;
    }

    @Override
    public void createService() throws Exception {
        this.scheduleMakerMap = new HashMap();
        this.scheduleMasters = new HashMap();
        this.scheduleDateMap = Collections.synchronizedMap(new TreeMap());
        this.scheduleMap = Collections.synchronizedMap(new HashMap());
        this.scheduleDependedMap = Collections.synchronizedMap(new HashMap());
        this.scheduleList = Collections.synchronizedList(new ArrayList());
        this.scheduleMasterMap = Collections.synchronizedMap(new HashMap());
        this.scheduleControlListeners = Collections.synchronizedSet(new LinkedHashSet());
        this.addedScheduleMakerMap = null;
        this.addedScheduleMasters = null;
    }

    @Override
    public void startService() throws Exception {
        Date now;
        List oldScheduleList;
        if (this.addedScheduleMasters != null) {
            this.scheduleMasters.putAll(this.addedScheduleMasters);
        }
        if (this.scheduleMasterServiceNames != null) {
            for (int i = 0; i < this.scheduleMasterServiceNames.length; ++i) {
                ScheduleMaster scheduleMaster = (ScheduleMaster)ServiceManagerFactory.getServiceObject(this.scheduleMasterServiceNames[i]);
                this.scheduleMasters.put(scheduleMaster.getId(), scheduleMaster);
            }
        }
        if (this.addedScheduleMakerMap != null) {
            this.scheduleMakerMap.putAll(this.addedScheduleMakerMap);
        }
        if (this.scheduleMakerTypeMapping != null && this.scheduleMakerTypeMapping.size() != 0) {
            ServiceNameEditor editor = new ServiceNameEditor();
            editor.setServiceManagerName(this.getServiceManagerName());
            for (Map.Entry<Object, Object> entry : this.scheduleMakerTypeMapping.entrySet()) {
                editor.setAsText((String)entry.getValue());
                ServiceName scheduleMakerServiceName = (ServiceName)editor.getValue();
                ScheduleMaker scheduleMaker = (ScheduleMaker)ServiceManagerFactory.getServiceObject(scheduleMakerServiceName);
                if (this.scheduleMakerMap.containsKey(entry.getKey())) {
                    throw new IllegalArgumentException("Dupulicate scheduleMakerTypeMapping : " + entry.getKey());
                }
                this.scheduleMakerMap.put(entry.getKey(), scheduleMaker);
            }
        }
        if (this.defaultScheduleMakerServiceName != null) {
            this.defaultScheduleMaker = (ScheduleMaker)ServiceManagerFactory.getServiceObject(this.defaultScheduleMakerServiceName);
        }
        if (this.defaultScheduleMaker == null) {
            DefaultScheduleMakerService defaultScheduleMakerService = new DefaultScheduleMakerService();
            defaultScheduleMakerService.create();
            defaultScheduleMakerService.start();
            this.defaultScheduleMaker = defaultScheduleMakerService;
        }
        if (this.sequenceServiceName != null) {
            this.sequence = (Sequence)ServiceManagerFactory.getServiceObject(this.sequenceServiceName);
        }
        this.loadLocalSequenceNumber();
        this.loadSchedules();
        if (this.isMakeScheduleOnStart && ((oldScheduleList = this.findSchedules(now = new Date())) == null || oldScheduleList.size() == 0)) {
            this.makeSchedule(now);
        }
        if (this.timeoverCheckInterval > 0L) {
            this.timeoverChecker = new Daemon(new TimeoverChecker());
            this.timeoverChecker.setName("Nimbus SchedulerManagerTimeoverChecker " + this.getServiceNameObject());
            this.timeoverChecker.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopService() throws Exception {
        Object object;
        if (this.timeoverChecker != null) {
            this.timeoverChecker.stop();
            this.timeoverChecker = null;
        }
        if (this.scheduleMasters != null) {
            this.scheduleMasters.clear();
        }
        if (this.scheduleMakerMap != null) {
            this.scheduleMakerMap.clear();
        }
        if (this.scheduleMap != null) {
            object = this.scheduleMap;
            synchronized (object) {
                this.scheduleMap.clear();
            }
        }
        if (this.scheduleDependedMap != null) {
            object = this.scheduleDependedMap;
            synchronized (object) {
                this.scheduleDependedMap.clear();
            }
        }
        if (this.scheduleDateMap != null) {
            object = this.scheduleDateMap;
            synchronized (object) {
                this.scheduleDateMap.clear();
            }
        }
        if (this.scheduleList != null) {
            object = this.scheduleList;
            synchronized (object) {
                this.scheduleList.clear();
            }
        }
        if (this.scheduleMasterMap != null) {
            object = this.scheduleMasterMap;
            synchronized (object) {
                this.scheduleMasterMap.clear();
            }
        }
        this.sequenceNumber = 0L;
    }

    @Override
    public void destroyService() throws Exception {
        this.scheduleMakerMap = null;
        this.scheduleMasters = null;
        if (this.scheduleMap != null) {
            this.scheduleMap = null;
        }
        if (this.scheduleDependedMap != null) {
            this.scheduleDependedMap = null;
        }
        if (this.scheduleDateMap != null) {
            this.scheduleDateMap = null;
        }
        if (this.scheduleList != null) {
            this.scheduleList = null;
        }
        if (this.scheduleMasterMap != null) {
            this.scheduleMasterMap = null;
        }
        if (this.scheduleControlListeners != null) {
            this.scheduleControlListeners = null;
        }
        this.addedScheduleMakerMap = null;
        this.addedScheduleMasters = null;
    }

    public void setSequence(Sequence sequence) {
        this.sequence = sequence;
    }

    public Sequence getSequence() {
        return this.sequence;
    }

    public void addScheduleMaster(ScheduleMaster master) {
        if (this.addedScheduleMasters == null) {
            this.addedScheduleMasters = new HashMap();
        }
        if (this.addedScheduleMasters.containsKey(master.getId())) {
            throw new IllegalArgumentException("Dupulicate id : " + master.getId());
        }
        this.addedScheduleMasters.put(master.getId(), master);
    }

    @Override
    public void setScheduleMaker(String scheduleType, ScheduleMaker maker) throws IllegalArgumentException {
        if (this.addedScheduleMakerMap == null) {
            this.addedScheduleMakerMap = new HashMap();
        }
        if (this.addedScheduleMakerMap.containsKey(scheduleType)) {
            throw new IllegalArgumentException("Dupulicate scheduleType : " + scheduleType);
        }
        this.addedScheduleMakerMap.put(scheduleType, maker);
    }

    @Override
    public ScheduleMaker getScheduleMaker(String scheduleType) {
        ScheduleMaker maker = (ScheduleMaker)this.scheduleMakerMap.get(scheduleType);
        if (this.isScheduleMakerTypeRegexEnabled && maker == null) {
            for (Map.Entry entry : this.scheduleMakerMap.entrySet()) {
                String key = (String)entry.getKey();
                try {
                    if (!Pattern.matches(key, scheduleType)) continue;
                    maker = (ScheduleMaker)entry.getValue();
                    break;
                }
                catch (PatternSyntaxException e) {
                }
            }
        }
        if (maker == null) {
            maker = this.defaultScheduleMaker;
        }
        return maker;
    }

    @Override
    public void setDefaultScheduleMaker(ScheduleMaker maker) {
        this.defaultScheduleMaker = maker;
    }

    @Override
    public ScheduleMaker getDefaultScheduleMaker() {
        return this.defaultScheduleMaker;
    }

    @Override
    public void makeSchedule(Date date) throws ScheduleMakeException {
        if (this.scheduleMasters.size() == 0) {
            return;
        }
        Date standardDate = this.getStandardTimeDate(date == null ? new Date() : date);
        Iterator masters = this.scheduleMasters.values().iterator();
        ArrayList<Schedule> tmpScheduleList = new ArrayList<Schedule>();
        HashMap<String, Set<Schedule>> tmpScheduleMasterMap = new HashMap<String, Set<Schedule>>();
        while (masters.hasNext()) {
            Schedule[] schedules;
            ScheduleMaster master = (ScheduleMaster)((ScheduleMaster)masters.next()).clone();
            ScheduleMaker maker = this.getScheduleMaker(master.getScheduleType());
            if (!master.isEnabled() || (schedules = maker.makeSchedule(standardDate, master)) == null || schedules.length == 0) continue;
            Set<Schedule> scheduleSet = Collections.synchronizedSet(new HashSet());
            for (int i = 0; i < schedules.length; ++i) {
                tmpScheduleList.add(schedules[i]);
                scheduleSet.add(schedules[i]);
            }
            tmpScheduleMasterMap.put(master.getId(), scheduleSet);
        }
        Collections.sort(tmpScheduleList);
        int imax = tmpScheduleList.size();
        for (int i = 0; i < imax; ++i) {
            Schedule schedule = (Schedule)tmpScheduleList.get(i);
            this.addSchedule(schedule, true, true);
        }
    }

    protected Date getStandardTimeDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String createScheduleId() throws ScheduleManageException {
        if (this.sequence == null) {
            Object object = this.sequenceNumberLock;
            synchronized (object) {
                ++this.sequenceNumber;
                if (this.sequenceNumber < 0L) {
                    this.sequenceNumber = 1L;
                }
            }
            if (this.persistDir != null) {
                Object object2;
                File baseDir = new File(this.persistDir);
                if (!baseDir.exists()) {
                    object2 = this.persistDir;
                    synchronized (object2) {
                        if (!baseDir.exists() && !baseDir.mkdirs()) {
                            throw new ScheduleManageException("PersistDir can't make." + baseDir.getAbsolutePath());
                        }
                    }
                }
                object2 = this.sequenceNumberLock;
                synchronized (object2) {
                    File file = new File(baseDir, LOCAL_SEQUENCE_NUMBER_FILE);
                    BufferedWriter writer = null;
                    try {
                        if (!file.exists()) {
                            file.createNewFile();
                        }
                        writer = new BufferedWriter(new FileWriter(file));
                        writer.write(String.valueOf(this.sequenceNumber));
                    }
                    catch (IOException e) {
                        throw new ScheduleManageException(e);
                    }
                    finally {
                        if (writer != null) {
                            try {
                                writer.close();
                            }
                            catch (IOException e) {
                                throw new ScheduleManageException(e);
                            }
                        }
                    }
                }
            }
            return String.valueOf(this.sequenceNumber);
        }
        return this.sequence.increment();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List findAllScheduleMasters() throws ScheduleManageException {
        ArrayList result = new ArrayList();
        if (this.scheduleMasters.size() == 0) {
            return result;
        }
        Map map = this.scheduleMasters;
        synchronized (map) {
            result.addAll(this.scheduleMasters.values());
        }
        Collections.sort(result);
        return result;
    }

    @Override
    public ScheduleMaster findScheduleMaster(String id) throws ScheduleManageException {
        return (ScheduleMaster)this.scheduleMasters.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List findAllSchedules() throws ScheduleManageException {
        List list = this.scheduleList;
        synchronized (list) {
            return new ArrayList(this.scheduleList);
        }
    }

    @Override
    public Schedule findSchedule(String id) throws ScheduleManageException {
        return (Schedule)this.scheduleMap.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List findSchedules(String masterId) throws ScheduleManageException {
        ArrayList result = new ArrayList();
        Set scheduleSet = (Set)this.scheduleMasterMap.get(masterId);
        if (scheduleSet == null) {
            return result;
        }
        Set set = scheduleSet;
        synchronized (set) {
            result.addAll(scheduleSet);
        }
        Collections.sort(result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List findSchedules(Date date) throws ScheduleManageException {
        Date standardDate = this.getStandardTimeDate(date);
        List scheduleList = (List)this.scheduleDateMap.get(standardDate);
        if (scheduleList == null) {
            return new ArrayList();
        }
        List list = scheduleList;
        synchronized (list) {
            return new ArrayList(scheduleList);
        }
    }

    @Override
    public List findSchedules(Date from, Date to) throws ScheduleManageException {
        return this.findSchedules(from, to, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List findSchedules(int[] states) throws ScheduleManageException {
        ArrayList<Schedule> result = new ArrayList<Schedule>();
        Schedule[] schedules = null;
        List list = this.scheduleList;
        synchronized (list) {
            schedules = this.scheduleList.toArray(new Schedule[this.scheduleList.size()]);
        }
        block3: for (int i = 0; i < schedules.length; ++i) {
            Schedule schedule = schedules[i];
            for (int j = 0; j < states.length; ++j) {
                if (schedule.getState() != states[j]) continue;
                result.add(schedule);
                continue block3;
            }
        }
        return result;
    }

    @Override
    public List findSchedules(Date from, Date to, int[] states) throws ScheduleManageException {
        return this.findSchedules(from, to, states, null, null, null);
    }

    @Override
    public List findSchedules(Date from, Date to, int[] states, String masterId) throws ScheduleManageException {
        return this.findSchedules(from, to, states, masterId, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List findSchedules(Date from, Date to, int[] states, String masterId, String[] executorTypes, String executorKey) throws ScheduleManageException {
        if (from != null && to != null && from.after(to)) {
            throw new ScheduleManageException("from > to. from=" + from + ", to=" + to);
        }
        if (this.scheduleList.size() == 0) {
            return new ArrayList();
        }
        DefaultSchedule searchKey = new DefaultSchedule();
        ArrayList schedules = null;
        List list = this.scheduleList;
        synchronized (list) {
            int fromIndex = 0;
            if (from != null) {
                Schedule cmp;
                Schedule schedule;
                searchKey.setTime(from);
                fromIndex = Math.abs(Collections.binarySearch(this.scheduleList, searchKey) + 1);
                if (fromIndex != 0 && from.equals((schedule = (Schedule)this.scheduleList.get(fromIndex - 1)).getTime())) {
                    --fromIndex;
                }
                if (fromIndex == this.scheduleList.size()) {
                    return new ArrayList();
                }
                int i = fromIndex;
                while (--i >= 0 && from.equals((cmp = (Schedule)this.scheduleList.get(i)).getTime())) {
                    fromIndex = i;
                }
            }
            int toIndex = this.scheduleList.size();
            if (to != null) {
                Schedule cmp;
                searchKey.setTime(to);
                toIndex = Math.abs(Collections.binarySearch(this.scheduleList, searchKey) + 1);
                if (toIndex == 0) {
                    return new ArrayList();
                }
                int imax = this.scheduleList.size();
                for (int i = toIndex; i < imax && to.equals((cmp = (Schedule)this.scheduleList.get(i)).getTime()); ++i) {
                    toIndex = i + 1;
                }
            }
            schedules = new ArrayList(this.scheduleList.subList(fromIndex, toIndex));
        }
        Iterator itr = schedules.iterator();
        while (itr.hasNext()) {
            Schedule schedule = (Schedule)itr.next();
            if (masterId != null && !masterId.equals(schedule.getMasterId())) {
                itr.remove();
                continue;
            }
            if (executorKey != null && schedule.getExecutorKey() != null && !executorKey.equals(schedule.getExecutorKey())) {
                itr.remove();
                continue;
            }
            boolean isMatch = false;
            if (schedule.getExecutorType() != null && executorTypes != null && executorTypes.length != 0) {
                for (int j = 0; j < executorTypes.length; ++j) {
                    if (!schedule.getExecutorType().equals(executorTypes[j])) continue;
                    isMatch = true;
                    break;
                }
                if (!isMatch) {
                    itr.remove();
                    continue;
                }
            }
            if (states == null || states.length == 0) continue;
            isMatch = false;
            for (int j = 0; j < states.length; ++j) {
                if (schedule.getState() != states[j]) continue;
                isMatch = true;
                break;
            }
            if (isMatch) continue;
            itr.remove();
        }
        return schedules;
    }

    @Override
    public List findExecutableSchedules(Date date, String[] executorTypes) throws ScheduleManageException {
        return this.findExecutableSchedules(date, executorTypes, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List findExecutableSchedules(Date date, String[] executorTypes, String executorKey) throws ScheduleManageException {
        List schedules = this.findSchedules(null, date, new int[]{1, 8}, null, executorTypes, executorKey);
        if (schedules == null || schedules.size() == 0) {
            return schedules;
        }
        ArrayList<Schedule> result = new ArrayList<Schedule>();
        int imax = schedules.size();
        for (int i = 0; i < imax; ++i) {
            Schedule schedule = (Schedule)schedules.get(i);
            String[] depends = schedule.getDepends();
            if (depends == null) {
                result.add(schedule);
                continue;
            }
            boolean isClear = true;
            for (int j = 0; j < depends.length; ++j) {
                Set scheduleSet = (Set)this.scheduleMasterMap.get(depends[j]);
                if (scheduleSet == null) continue;
                Schedule[] dependsSchedules = null;
                Set set = scheduleSet;
                synchronized (set) {
                    dependsSchedules = scheduleSet.toArray(new Schedule[scheduleSet.size()]);
                }
                for (int k = 0; k < dependsSchedules.length; ++k) {
                    if (dependsSchedules[k].getInitialTime().after(schedule.getInitialTime()) || dependsSchedules[k].getState() == 4) continue;
                    isClear = false;
                    break;
                }
                if (!isClear) break;
            }
            if (!isClear) continue;
            result.add(schedule);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List findDependedSchedules(String id) throws ScheduleManageException {
        Schedule schedule = this.findSchedule(id);
        ArrayList<Schedule> result = new ArrayList<Schedule>();
        if (schedule == null) {
            return result;
        }
        Set depended = (Set)this.scheduleDependedMap.get(schedule.getMasterId());
        if (depended == null || depended.size() == 0) {
            return result;
        }
        String[] ids = null;
        Set set = depended;
        synchronized (set) {
            ids = depended.toArray(new String[depended.size()]);
        }
        for (int i = 0; i < ids.length; ++i) {
            schedule = this.findSchedule(ids[i]);
            if (schedule == null) continue;
            result.add(schedule);
        }
        Collections.sort(result);
        return result;
    }

    @Override
    public void addSchedule(Schedule schedule) throws ScheduleManageException {
        this.addSchedule(schedule, true, true);
    }

    @Override
    public void addSchedule(String masterId, Date time, String taskName, Object input, String[] depends, String executorKey, String executorType, long retryInterval, Date retryEndTime, long maxDelayTime) throws ScheduleManageException {
        this.addSchedule(new DefaultSchedule(masterId, time, taskName, input, depends, executorKey, executorType, retryInterval, retryEndTime, maxDelayTime));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addSchedule(Schedule schedule, boolean isCreateId, boolean persist) throws ScheduleManageException {
        Object scheduleSet;
        Collection<Schedule> collection;
        Date standardDate = this.getStandardTimeDate(schedule.getTime());
        if (isCreateId) {
            schedule.setId(this.createScheduleId());
        }
        Map map = this.scheduleDateMap;
        synchronized (map) {
            List<Schedule> schedules = (List<Schedule>)this.scheduleDateMap.get(standardDate);
            if (schedules == null) {
                schedules = Collections.synchronizedList(new ArrayList());
                schedules.add(schedule);
                this.scheduleDateMap.put(standardDate, schedules);
            } else {
                collection = schedules;
                synchronized (collection) {
                    schedules.add(schedule);
                    Collections.sort(schedules);
                }
            }
        }
        this.scheduleMap.put(schedule.getId(), schedule);
        map = this.scheduleMasterMap;
        synchronized (map) {
            scheduleSet = (Set<Schedule>)this.scheduleMasterMap.get(schedule.getMasterId());
            if (scheduleSet == null) {
                scheduleSet = Collections.synchronizedSet(new HashSet());
                scheduleSet.add(schedule);
                this.scheduleMasterMap.put(schedule.getMasterId(), scheduleSet);
            } else {
                collection = scheduleSet;
                synchronized (collection) {
                    scheduleSet.add(schedule);
                }
            }
        }
        String[] depends = schedule.getDepends();
        if (depends != null) {
            scheduleSet = this.scheduleDependedMap;
            synchronized (scheduleSet) {
                for (int i = 0; i < depends.length; ++i) {
                    Set<String> depended = (Set<String>)this.scheduleDependedMap.get(depends[i]);
                    if (depended == null) {
                        depended = Collections.synchronizedSet(new HashSet());
                        this.scheduleDependedMap.put(depends[i], depended);
                    }
                    depended.add(schedule.getId());
                }
            }
        }
        scheduleSet = this.scheduleList;
        synchronized (scheduleSet) {
            this.scheduleList.add(schedule);
            Collections.sort(this.scheduleList);
        }
        if (persist) {
            try {
                this.persistSchedule(schedule);
            }
            catch (IOException e) {
                this.removeSchedule(schedule.getId());
                throw new ScheduleManageException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void persistSchedule(Schedule schedule) throws IOException {
        Date standardDate;
        SimpleDateFormat format;
        File dateDir;
        if (this.persistDir == null) {
            return;
        }
        File baseDir = new File(this.persistDir);
        if (!baseDir.exists()) {
            String string = this.persistDir;
            synchronized (string) {
                if (!baseDir.exists() && !baseDir.mkdirs()) {
                    throw new IOException("PersistDir can't make." + baseDir.getAbsolutePath());
                }
            }
        }
        if (!(dateDir = new File(baseDir, (format = new SimpleDateFormat(DATE_DIR_FORMAT)).format(standardDate = this.getStandardTimeDate(schedule.getTime())))).exists()) {
            String string = this.persistDir;
            synchronized (string) {
                if (!dateDir.exists() && !dateDir.mkdir()) {
                    throw new IOException("Date Directory can't make." + dateDir.getAbsolutePath());
                }
            }
        }
        File scheduleFile = new File(dateDir, schedule.getId());
        Schedule schedule2 = schedule;
        synchronized (schedule2) {
            try (BufferedWriter writer = null;){
                PropertyEditor editor;
                StringBuffer buf;
                writer = new CSVWriter(new FileWriter(scheduleFile));
                ((CSVWriter)writer).writeElement(schedule.getId());
                ((CSVWriter)writer).writeElement(schedule.getMasterId());
                format.applyPattern(DATE_CSV_FORMAT);
                ((CSVWriter)writer).writeElement(format.format(schedule.getTime()));
                ((CSVWriter)writer).writeElement(schedule.getTaskName());
                if (schedule.getInput() == null) {
                    ((CSVWriter)writer).writeElement("");
                } else {
                    buf = new StringBuffer();
                    editor = NimbusPropertyEditorManager.findEditor(schedule.getInput().getClass());
                    buf.append(schedule.getInput().getClass().getName());
                    buf.append(':');
                    if (editor == null) {
                        buf.append(schedule.getInput());
                    } else {
                        editor.setValue(schedule.getInput());
                        buf.append(editor.getAsText());
                    }
                    ((CSVWriter)writer).writeElement(buf.toString());
                }
                if (schedule.getDepends() == null) {
                    ((CSVWriter)writer).writeElement("");
                } else {
                    StringArrayEditor editor2 = new StringArrayEditor();
                    editor2.setValue(schedule.getDepends());
                    ((CSVWriter)writer).writeElement(editor2.getAsText());
                }
                if (schedule.getOutput() == null) {
                    ((CSVWriter)writer).writeElement("");
                } else {
                    buf = new StringBuffer();
                    editor = NimbusPropertyEditorManager.findEditor(schedule.getOutput().getClass());
                    buf.append(schedule.getOutput().getClass().getName());
                    buf.append(':');
                    if (editor == null) {
                        buf.append(schedule.getOutput());
                    } else {
                        editor.setValue(schedule.getOutput());
                        buf.append(editor.getAsText());
                    }
                    ((CSVWriter)writer).writeElement(buf.toString());
                }
                ((CSVWriter)writer).writeElement(schedule.getRetryInterval());
                if (schedule.getRetryEndTime() == null) {
                    ((CSVWriter)writer).writeElement("");
                } else {
                    ((CSVWriter)writer).writeElement(format.format(schedule.getRetryEndTime()));
                }
                ((CSVWriter)writer).writeElement(schedule.getMaxDelayTime());
                ((CSVWriter)writer).writeElement(schedule.isRetry());
                ((CSVWriter)writer).writeElement(schedule.getState());
                ((CSVWriter)writer).writeElement(schedule.getControlState());
                ((CSVWriter)writer).writeElement(schedule.getCheckState());
                if (schedule.getExecutorKey() == null) {
                    ((CSVWriter)writer).writeElement("");
                } else {
                    ((CSVWriter)writer).writeElement(schedule.getExecutorKey());
                }
                if (schedule.getExecutorType() == null) {
                    ((CSVWriter)writer).writeElement("");
                } else {
                    ((CSVWriter)writer).writeElement(schedule.getExecutorType());
                }
                if (schedule.getExecuteStartTime() == null) {
                    ((CSVWriter)writer).writeElement("");
                } else {
                    ((CSVWriter)writer).writeElement(format.format(schedule.getExecuteStartTime()));
                }
                if (schedule.getExecuteEndTime() == null) {
                    ((CSVWriter)writer).writeElement("");
                } else {
                    ((CSVWriter)writer).writeElement(format.format(schedule.getExecuteEndTime()));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadLocalSequenceNumber() throws IOException {
        if (this.persistDir == null) {
            return;
        }
        File baseDir = new File(this.persistDir);
        if (!baseDir.exists()) {
            return;
        }
        File file = new File(baseDir, LOCAL_SEQUENCE_NUMBER_FILE);
        if (!file.exists()) {
            return;
        }
        try (BufferedReader reader = null;){
            reader = new BufferedReader(new FileReader(file));
            String line = reader.readLine();
            if (line != null) {
                this.sequenceNumber = Long.parseLong(line);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadSchedules() throws Exception {
        if (this.persistDir == null) {
            return;
        }
        File baseDir = new File(this.persistDir);
        if (!baseDir.exists()) {
            return;
        }
        File[] dateDirs = baseDir.listFiles();
        if (dateDirs == null || dateDirs.length == 0) {
            return;
        }
        SimpleDateFormat dateDirFormat = new SimpleDateFormat(DATE_DIR_FORMAT);
        SimpleDateFormat dateCsvFormat = new SimpleDateFormat(DATE_CSV_FORMAT);
        for (int i = 0; i < dateDirs.length; ++i) {
            if (!dateDirs[i].isDirectory()) continue;
            try {
                dateDirFormat.parse(dateDirs[i].getName());
            }
            catch (ParseException e) {
                continue;
            }
            File[] scheduleFiles = dateDirs[i].listFiles();
            if (scheduleFiles == null || scheduleFiles.length == 0) continue;
            List csv = null;
            for (int j = 0; j < scheduleFiles.length; ++j) {
                try (BufferedReader reader = null;){
                    String executeEndTimeStr;
                    reader = new CSVReader(new FileReader(scheduleFiles[j]));
                    csv = ((CSVReader)reader).readCSVLineList(csv);
                    DefaultSchedule schedule = new DefaultSchedule();
                    schedule.setId((String)csv.get(0));
                    schedule.setMasterId((String)csv.get(1));
                    schedule.setTime(dateCsvFormat.parse((String)csv.get(2)));
                    schedule.setTaskName((String)csv.get(3));
                    String inputStr = (String)csv.get(4);
                    if (inputStr.length() == 0) {
                        schedule.setInput(null);
                    } else {
                        int index = inputStr.indexOf(58);
                        Class clazz = this.convertStringToClass(inputStr.substring(0, index));
                        PropertyEditor editor = NimbusPropertyEditorManager.findEditor(clazz);
                        if (index == inputStr.length() - 1) {
                            schedule.setInput(null);
                        } else {
                            editor.setAsText(inputStr.substring(index + 1));
                            schedule.setInput(editor.getValue());
                        }
                    }
                    String dependsStr = (String)csv.get(5);
                    if (dependsStr.length() == 0) {
                        schedule.setDepends(null);
                    } else {
                        StringArrayEditor editor = new StringArrayEditor();
                        editor.setAsText(dependsStr);
                        schedule.setDepends((String[])editor.getValue());
                    }
                    String outputStr = (String)csv.get(6);
                    if (outputStr.length() == 0) {
                        schedule.setOutput(null);
                    } else {
                        int index = outputStr.indexOf(58);
                        Class clazz = null;
                        try {
                            clazz = this.convertStringToClass(outputStr.substring(0, index));
                            PropertyEditor editor = NimbusPropertyEditorManager.findEditor(clazz);
                            if (index == outputStr.length() - 1 || editor == null) {
                                schedule.setOutput(outputStr);
                            } else {
                                editor.setAsText(outputStr.substring(index + 1));
                                schedule.setOutput(editor.getValue());
                            }
                        }
                        catch (ClassNotFoundException e) {
                            schedule.setOutput(outputStr);
                        }
                    }
                    schedule.setRetryInterval(Long.parseLong((String)csv.get(7)));
                    String retryEndTimeStr = (String)csv.get(8);
                    if (retryEndTimeStr != null && retryEndTimeStr.length() != 0) {
                        schedule.setRetryEndTime(dateCsvFormat.parse(retryEndTimeStr));
                    }
                    schedule.setMaxDelayTime(Long.parseLong((String)csv.get(9)));
                    schedule.setRetry(Boolean.valueOf((String)csv.get(10)));
                    schedule.setState(Integer.parseInt((String)csv.get(11)));
                    schedule.setControlState(Integer.parseInt((String)csv.get(12)));
                    schedule.setCheckState(Integer.parseInt((String)csv.get(13)));
                    String executorKey = (String)csv.get(14);
                    if (executorKey != null && executorKey.length() == 0) {
                        schedule.setExecutorKey(null);
                    } else {
                        schedule.setExecutorKey(executorKey);
                    }
                    String executorType = (String)csv.get(15);
                    if (executorType != null && executorType.length() == 0) {
                        schedule.setExecutorType(null);
                    } else {
                        schedule.setExecutorType(executorType);
                    }
                    String executeStartTimeStr = (String)csv.get(16);
                    if (executeStartTimeStr != null && executeStartTimeStr.length() != 0) {
                        schedule.setExecuteStartTime(dateCsvFormat.parse(executeStartTimeStr));
                    }
                    if ((executeEndTimeStr = (String)csv.get(17)) != null && executeEndTimeStr.length() != 0) {
                        schedule.setExecuteEndTime(dateCsvFormat.parse(executeEndTimeStr));
                    }
                    this.addSchedule(schedule, false, false);
                    continue;
                }
            }
        }
    }

    protected Class convertStringToClass(String typeStr) throws ClassNotFoundException {
        Class<Comparable<Byte>> type = null;
        if (typeStr != null) {
            if (Byte.TYPE.getName().equals(typeStr)) {
                type = Byte.TYPE;
            } else if (Character.TYPE.getName().equals(typeStr)) {
                type = Character.TYPE;
            } else if (Short.TYPE.getName().equals(typeStr)) {
                type = Short.TYPE;
            } else if (Integer.TYPE.getName().equals(typeStr)) {
                type = Integer.TYPE;
            } else if (Long.TYPE.getName().equals(typeStr)) {
                type = Long.TYPE;
            } else if (Float.TYPE.getName().equals(typeStr)) {
                type = Float.TYPE;
            } else if (Double.TYPE.getName().equals(typeStr)) {
                type = Double.TYPE;
            } else if (Boolean.TYPE.getName().equals(typeStr)) {
                type = Boolean.TYPE;
            } else if (typeStr.endsWith(ARRAY_CLASS_SUFFIX) && typeStr.length() > 2) {
                Class elementType = this.convertStringToClass(typeStr.substring(0, typeStr.length() - 2));
                type = Array.newInstance(elementType, 0).getClass();
            } else {
                type = Class.forName(typeStr, true, NimbusClassLoader.getInstance());
            }
        }
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removePersistSchedule(Schedule schedule) throws IOException {
        if (this.persistDir == null) {
            return;
        }
        File baseDir = new File(this.persistDir);
        if (!baseDir.exists()) {
            return;
        }
        SimpleDateFormat format = new SimpleDateFormat(DATE_DIR_FORMAT);
        Date standardDate = this.getStandardTimeDate(schedule.getTime());
        File dateDir = new File(baseDir, format.format(standardDate));
        if (!dateDir.exists()) {
            return;
        }
        File scheduleFile = new File(dateDir, schedule.getId());
        Schedule schedule2 = schedule;
        synchronized (schedule2) {
            if (scheduleFile.exists() && !scheduleFile.delete()) {
                throw new IOException("Persist file can't delete." + scheduleFile.getAbsolutePath());
            }
        }
        File[] scheduleFiles = dateDir.listFiles();
        if (scheduleFiles == null || scheduleFiles.length == 0) {
            dateDir.delete();
        }
    }

    @Override
    public boolean reschedule(String id, Date time) throws ScheduleManageException {
        Schedule schedule = (Schedule)this.scheduleMap.get(id);
        if (schedule == null) {
            return false;
        }
        if (!this.removeSchedule(id)) {
            return false;
        }
        schedule.setTime(time);
        schedule.setCheckState(1);
        this.addSchedule(schedule, false, true);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeSchedule(String id) throws ScheduleManageException {
        Schedule schedule = (Schedule)this.scheduleMap.get(id);
        if (schedule == null) {
            return false;
        }
        try {
            this.removePersistSchedule(schedule);
        }
        catch (IOException e) {
            throw new ScheduleManageException(e);
        }
        this.scheduleMap.remove(schedule.getId());
        Object e = this.scheduleList;
        synchronized (e) {
            this.scheduleList.remove(schedule);
        }
        e = this.scheduleMasterMap;
        synchronized (e) {
            Set scheduleSet = (Set)this.scheduleMasterMap.get(schedule.getMasterId());
            if (scheduleSet != null) {
                Set set = scheduleSet;
                synchronized (set) {
                    scheduleSet.remove(schedule);
                }
                if (scheduleSet.size() == 0) {
                    this.scheduleMasterMap.remove(schedule.getMasterId());
                }
            }
        }
        e = this.scheduleDependedMap;
        synchronized (e) {
            for (Set depended : this.scheduleDependedMap.values()) {
                depended.remove(schedule.getId());
            }
        }
        Date standardDate = this.getStandardTimeDate(schedule.getTime());
        Map map = this.scheduleDateMap;
        synchronized (map) {
            List schedules = (List)this.scheduleDateMap.get(standardDate);
            if (schedules != null) {
                List list = schedules;
                synchronized (list) {
                    schedules.remove(schedule);
                }
                if (schedules.size() == 0) {
                    this.scheduleDateMap.remove(standardDate);
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeScheduleByMasterId(String masterId) throws ScheduleManageException {
        Set scheduleSet = (Set)this.scheduleMasterMap.get(masterId);
        if (scheduleSet == null) {
            return false;
        }
        Schedule[] schedules = null;
        Set set = scheduleSet;
        synchronized (set) {
            schedules = scheduleSet.toArray(new Schedule[scheduleSet.size()]);
        }
        boolean isRemove = false;
        for (int i = 0; i < schedules.length; ++i) {
            isRemove |= this.removeSchedule(schedules[i].getId());
        }
        return isRemove;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeSchedule(Date date) throws ScheduleManageException {
        Date standardDate = this.getStandardTimeDate(date);
        Schedule[] schedules = null;
        Map map = this.scheduleDateMap;
        synchronized (map) {
            List scheduleList = (List)this.scheduleDateMap.get(standardDate);
            if (scheduleList == null || scheduleList.size() == 0) {
                return false;
            }
            List list = scheduleList;
            synchronized (list) {
                schedules = scheduleList.toArray(new Schedule[scheduleList.size()]);
            }
        }
        boolean isRemove = false;
        for (int i = 0; i < schedules.length; ++i) {
            isRemove |= this.removeSchedule(schedules[i].getId());
        }
        return isRemove;
    }

    @Override
    public boolean removeSchedule(Date from, Date to, int[] states, String masterId) throws ScheduleManageException {
        List schedules = this.findSchedules(from, to, states, masterId);
        boolean isRemove = false;
        int imax = schedules.size();
        for (int i = 0; i < imax; ++i) {
            isRemove |= this.removeSchedule(((Schedule)schedules.get(i)).getId());
        }
        return isRemove;
    }

    @Override
    public void setExecutorKey(String id, String key) throws ScheduleManageException {
        Schedule schedule = (Schedule)this.scheduleMap.get(id);
        if (schedule == null) {
            throw new ScheduleManageException("Schedule not found : " + id);
        }
        schedule.setExecutorKey(key);
        try {
            this.persistSchedule(schedule);
        }
        catch (IOException e) {
            throw new ScheduleManageException(e);
        }
    }

    @Override
    public int getState(String id) throws ScheduleStateControlException {
        Schedule schedule = (Schedule)this.scheduleMap.get(id);
        if (schedule == null) {
            throw new ScheduleStateControlException("Schedule not found : " + id);
        }
        return schedule.getState();
    }

    @Override
    public int getControlState(String id) throws ScheduleStateControlException {
        Schedule schedule = (Schedule)this.scheduleMap.get(id);
        if (schedule == null) {
            throw new ScheduleStateControlException("Schedule not found : " + id);
        }
        return schedule.getControlState();
    }

    @Override
    public boolean changeState(String id, int state) throws ScheduleStateControlException {
        return this.changeState(id, state, null);
    }

    @Override
    public boolean changeState(String id, int oldState, int newState) throws ScheduleStateControlException {
        Schedule schedule = (Schedule)this.scheduleMap.get(id);
        if (schedule == null) {
            throw new ScheduleStateControlException("Schedule not found : " + id);
        }
        switch (newState) {
            case 3: {
                schedule.setExecuteStartTime(new Date());
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                schedule.setExecuteEndTime(new Date());
                break;
            }
            case 1: 
            case 2: {
                schedule.setExecuteStartTime(null);
                schedule.setExecuteEndTime(null);
                break;
            }
            case 6: 
            case 8: {
                break;
            }
            default: {
                throw new ScheduleStateControlException("Unknown state : " + newState);
            }
        }
        if (oldState != schedule.getState()) {
            return false;
        }
        boolean isChange = schedule.getState() != newState;
        schedule.setState(newState);
        try {
            this.persistSchedule(schedule);
        }
        catch (IOException e) {
            throw new ScheduleStateControlException(e);
        }
        return isChange;
    }

    @Override
    public boolean changeState(String id, int state, Object output) throws ScheduleStateControlException {
        Schedule schedule = (Schedule)this.scheduleMap.get(id);
        if (schedule == null) {
            throw new ScheduleStateControlException("Schedule not found : " + id);
        }
        switch (state) {
            case 3: {
                schedule.setExecuteStartTime(new Date());
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                schedule.setExecuteEndTime(new Date());
                break;
            }
            case 1: 
            case 2: {
                schedule.setExecuteStartTime(null);
                schedule.setExecuteEndTime(null);
                break;
            }
            case 6: 
            case 8: {
                break;
            }
            default: {
                throw new ScheduleStateControlException("Unknown state : " + state);
            }
        }
        schedule.setOutput(output);
        boolean isChange = schedule.getState() != state;
        schedule.setState(state);
        try {
            this.persistSchedule(schedule);
        }
        catch (IOException e) {
            throw new ScheduleStateControlException(e);
        }
        return isChange;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean changeControlState(String id, int oldState, int newState) throws ScheduleStateControlException {
        boolean isChange;
        block16: {
            Schedule schedule = (Schedule)this.scheduleMap.get(id);
            if (schedule == null) {
                throw new ScheduleStateControlException("Schedule not found : " + id);
            }
            switch (newState) {
                case 2: {
                    if (this.getState(id) == 3) break;
                    return false;
                }
                case 3: {
                    if (this.getState(id) == 6) break;
                    return false;
                }
                case 4: {
                    if (this.getState(id) == 3) break;
                    return false;
                }
                default: {
                    throw new ScheduleStateControlException("Unknown state : " + newState);
                }
            }
            if (oldState != schedule.getControlState()) {
                return false;
            }
            boolean bl = isChange = schedule.getControlState() != newState;
            if (!isChange) {
                return false;
            }
            schedule.setControlState(newState);
            try {
                this.persistSchedule(schedule);
            }
            catch (IOException e) {
                throw new ScheduleStateControlException(e);
            }
            try {
                if (this.scheduleControlListeners == null || this.scheduleControlListeners.size() == 0) break block16;
                Set e = this.scheduleControlListeners;
                synchronized (e) {
                    for (ScheduleControlListener listener : this.scheduleControlListeners) {
                        listener.changedControlState(id, newState);
                    }
                }
            }
            catch (ScheduleStateControlException e) {
                schedule.setControlState(5);
                throw e;
            }
        }
        return isChange;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean changeControlState(String id, int state) throws ScheduleStateControlException {
        boolean isChange;
        block15: {
            Schedule schedule = (Schedule)this.scheduleMap.get(id);
            if (schedule == null) {
                throw new ScheduleStateControlException("Schedule not found : " + id);
            }
            switch (state) {
                case 2: {
                    if (this.getState(id) == 3) break;
                    return false;
                }
                case 3: {
                    if (this.getState(id) == 6) break;
                    return false;
                }
                case 4: {
                    if (this.getState(id) == 3) break;
                    return false;
                }
                default: {
                    throw new ScheduleStateControlException("Unknown state : " + state);
                }
            }
            boolean bl = isChange = schedule.getControlState() != state;
            if (!isChange) {
                return false;
            }
            try {
                this.persistSchedule(schedule);
            }
            catch (IOException e) {
                throw new ScheduleStateControlException(e);
            }
            schedule.setControlState(state);
            try {
                if (this.scheduleControlListeners == null || this.scheduleControlListeners.size() == 0) break block15;
                Set e = this.scheduleControlListeners;
                synchronized (e) {
                    for (ScheduleControlListener listener : this.scheduleControlListeners) {
                        listener.changedControlState(id, state);
                    }
                }
            }
            catch (ScheduleStateControlException e) {
                schedule.setControlState(5);
                throw e;
            }
        }
        return isChange;
    }

    @Override
    public void addScheduleControlListener(ScheduleControlListener listener) {
        this.scheduleControlListeners.add(listener);
    }

    @Override
    public void removeScheduleControlListener(ScheduleControlListener listener) {
        this.scheduleControlListeners.remove(listener);
    }

    protected class TimeoverChecker
    implements DaemonRunnable {
        protected TimeoverChecker() {
        }

        @Override
        public boolean onStart() {
            return true;
        }

        @Override
        public boolean onStop() {
            return true;
        }

        @Override
        public boolean onSuspend() {
            return true;
        }

        @Override
        public boolean onResume() {
            return true;
        }

        @Override
        public Object provide(DaemonControl ctrl) throws Throwable {
            Thread.sleep(DefaultScheduleManagerService.this.getTimeoverCheckInterval());
            return null;
        }

        @Override
        public void consume(Object input, DaemonControl ctrl) throws Throwable {
            Calendar nowCal = Calendar.getInstance();
            List schedules = DefaultScheduleManagerService.this.findSchedules(nowCal.getTime(), null);
            Calendar tmpCal = Calendar.getInstance();
            int imax = schedules.size();
            for (int i = 0; i < imax; ++i) {
                Schedule schedule = (Schedule)schedules.get(i);
                tmpCal.clear();
                tmpCal.setTime(schedule.getTime());
                if (schedule.getCheckState() == 2 || !tmpCal.before(nowCal) || schedule.getMaxDelayTime() <= 0L || schedule.getState() == 4 || schedule.getState() == 5 || schedule.getState() == 7) continue;
                tmpCal.clear();
                tmpCal.setTimeInMillis(schedule.getTime().getTime() + schedule.getMaxDelayTime());
                if (tmpCal.after(nowCal) || tmpCal.equals(nowCal)) continue;
                schedule.setCheckState(2);
                DefaultScheduleManagerService.this.getLogger().write("DSM__00003", new Object[]{schedule.getId(), new Integer(schedule.getState())});
            }
        }

        @Override
        public void garbage() {
        }
    }
}

