/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.scheduler2;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.scheduler2.AbstractScheduleExecutorServiceMBean;
import jp.ossc.nimbus.service.scheduler2.Schedule;
import jp.ossc.nimbus.service.scheduler2.ScheduleExecutor;
import jp.ossc.nimbus.service.scheduler2.ScheduleManageException;
import jp.ossc.nimbus.service.scheduler2.ScheduleManager;
import jp.ossc.nimbus.service.scheduler2.ScheduleStateControlException;

public abstract class AbstractScheduleExecutorService
extends ServiceBase
implements ScheduleExecutor,
AbstractScheduleExecutorServiceMBean {
    private static final long serialVersionUID = 7621829987739712419L;
    protected ServiceName scheduleManagerServiceName;
    protected ScheduleManager scheduleManager;
    protected String key;
    protected String type;

    @Override
    public void setScheduleManagerServiceName(ServiceName name) {
        this.scheduleManagerServiceName = name;
    }

    @Override
    public ServiceName getScheduleManagerServiceName() {
        return this.scheduleManagerServiceName;
    }

    @Override
    public void setKey(String key) {
        this.key = key;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    @Override
    public void preStartService() throws Exception {
        if (this.scheduleManagerServiceName != null) {
            this.scheduleManager = (ScheduleManager)ServiceManagerFactory.getServiceObject(this.scheduleManagerServiceName);
        }
        if (this.scheduleManager == null) {
            throw new IllegalArgumentException("ScheduleManager is null.");
        }
    }

    @Override
    public ScheduleManager getScheduleManager() {
        return this.scheduleManager;
    }

    @Override
    public void setScheduleManager(ScheduleManager manager) {
        this.scheduleManager = manager;
    }

    @Override
    public String getKey() {
        return this.key == null ? this.getServiceName() : this.key;
    }

    @Override
    public String getType() {
        return this.type;
    }

    protected void checkPreExecute(Schedule schedule) throws Exception {
    }

    protected abstract Schedule executeInternal(Schedule var1) throws Throwable;

    @Override
    public Schedule execute(Schedule schedule) {
        Schedule result;
        block33: {
            result = schedule;
            try {
                this.checkPreExecute(schedule);
            }
            catch (Throwable th) {
                this.getLogger().write("ASE__00003", new Object[]{schedule.getId(), schedule.getTaskName()}, th);
                try {
                    this.scheduleManager.changeState(schedule.getId(), 5, th);
                }
                catch (ScheduleStateControlException e) {
                    this.getLogger().write("ASE__00008", new Object[]{schedule.getId(), schedule.getTaskName(), new Integer(5)}, (Throwable)e);
                }
                return result;
            }
            try {
                boolean isChanged = this.scheduleManager.changeState(schedule.getId(), 2, 3);
                if (!isChanged) {
                    this.getLogger().write("ASE__00009", new Object[]{schedule.getId(), schedule.getTaskName(), new Integer(2), new Integer(3)});
                    return schedule;
                }
            }
            catch (ScheduleStateControlException e) {
                this.getLogger().write("ASE__00008", new Object[]{schedule.getId(), schedule.getTaskName(), new Integer(3)}, (Throwable)e);
                return schedule;
            }
            this.getLogger().write("ASE__00001", new Object[]{schedule.getId(), schedule.getTaskName(), schedule.getInput()});
            try {
                result = this.executeInternal(schedule);
                if (result.getState() == 5) {
                    this.getLogger().write("ASE__00003", new Object[]{schedule.getId(), schedule.getTaskName()});
                    try {
                        this.scheduleManager.changeState(schedule.getId(), 5, result.getOutput());
                    }
                    catch (ScheduleStateControlException e) {
                        this.getLogger().write("ASE__00008", new Object[]{schedule.getId(), schedule.getTaskName(), new Integer(5)}, (Throwable)e);
                    }
                    break block33;
                }
                if (result.getState() == 7) {
                    this.getLogger().write("ASE__00007", new Object[]{result.getId(), result.getTaskName()}, (Throwable)result.getOutput());
                    try {
                        this.scheduleManager.changeState(result.getId(), 7, result.getOutput());
                    }
                    catch (ScheduleStateControlException e2) {
                        this.getLogger().write("ASE__00008", new Object[]{result.getId(), result.getTaskName(), new Integer(7)}, (Throwable)e2);
                    }
                    break block33;
                }
                if (result.getRetryInterval() > 0L && result.isRetry()) {
                    Date retryTime = this.calculateRetryTime(result.getRetryInterval(), result.getRetryEndTime());
                    if (retryTime == null) {
                        this.getLogger().write("ASE__00006", new Object[]{result.getId(), result.getTaskName(), new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS").format(result.getRetryEndTime())});
                        try {
                            this.scheduleManager.changeState(result.getId(), 5);
                        }
                        catch (ScheduleStateControlException e) {
                            this.getLogger().write("ASE__00008", new Object[]{result.getId(), result.getTaskName(), new Integer(5)}, (Throwable)e);
                        }
                        break block33;
                    }
                    try {
                        boolean isReschedule = this.scheduleManager.reschedule(result.getId(), retryTime);
                        if (!isReschedule) {
                            this.getLogger().write("ASE__00005", new Object[]{result.getId(), result.getTaskName()});
                            try {
                                this.scheduleManager.changeState(result.getId(), 5);
                            }
                            catch (ScheduleStateControlException e) {
                                this.getLogger().write("ASE__00008", new Object[]{result.getId(), result.getTaskName(), new Integer(5)}, (Throwable)e);
                            }
                            return result;
                        }
                        int nowState = this.scheduleManager.getState(result.getId());
                        switch (nowState) {
                            case 3: 
                            case 6: {
                                break;
                            }
                            default: {
                                this.getLogger().write("ASE__00009", new Object[]{result.getId(), result.getTaskName(), new Integer(nowState), new Integer(8)});
                                return result;
                            }
                        }
                        boolean isChanged = this.scheduleManager.changeState(result.getId(), nowState, 8);
                        if (!isChanged) {
                            this.getLogger().write("ASE__00009", new Object[]{result.getId(), result.getTaskName(), new Integer(nowState), new Integer(8)});
                            return result;
                        }
                        this.getLogger().write("ASE__00004", new Object[]{result.getId(), result.getTaskName(), new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS").format(retryTime)});
                    }
                    catch (ScheduleManageException e) {
                        this.getLogger().write("ASE__00005", new Object[]{result.getId(), result.getTaskName()}, (Throwable)e);
                    }
                    catch (ScheduleStateControlException e) {
                        this.getLogger().write("ASE__00008", new Object[]{result.getId(), result.getTaskName(), new Integer(8)}, (Throwable)e);
                    }
                    break block33;
                }
                this.getLogger().write("ASE__00002", new Object[]{result.getId(), result.getTaskName(), result.getOutput()});
                try {
                    this.scheduleManager.changeState(result.getId(), 4, result.getOutput());
                }
                catch (ScheduleStateControlException e) {
                    this.getLogger().write("ASE__00008", new Object[]{result.getId(), result.getTaskName(), new Integer(4)}, (Throwable)e);
                }
            }
            catch (Throwable th) {
                this.getLogger().write("ASE__00003", new Object[]{schedule.getId(), schedule.getTaskName()}, th);
                try {
                    this.scheduleManager.changeState(schedule.getId(), 5, th);
                }
                catch (ScheduleStateControlException e) {
                    this.getLogger().write("ASE__00008", new Object[]{schedule.getId(), schedule.getTaskName(), new Integer(5)}, (Throwable)e);
                }
            }
        }
        return result;
    }

    protected Date calculateRetryTime(long interval, Date endTime) {
        Calendar offset = Calendar.getInstance();
        Calendar end = null;
        if (endTime != null) {
            end = Calendar.getInstance();
            end.setTime(endTime);
        }
        if (interval > Integer.MAX_VALUE) {
            long offsetInterval = interval;
            int tmpInterval = 0;
            do {
                tmpInterval = offsetInterval >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)offsetInterval;
                offset.add(14, tmpInterval);
            } while ((offsetInterval -= Integer.MAX_VALUE) > 0L);
        } else {
            offset.add(14, (int)interval);
        }
        if (end != null && offset.after(end)) {
            return null;
        }
        return offset.getTime();
    }
}

