/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.resource.http;

import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.http.HttpClient;
import jp.ossc.nimbus.service.http.HttpClientFactory;
import jp.ossc.nimbus.service.resource.ResourceFactory;
import jp.ossc.nimbus.service.resource.TransactionResource;
import jp.ossc.nimbus.service.resource.http.HttpClientFactoryServiceMBean;

public class HttpClientFactoryService
extends ServiceBase
implements ResourceFactory,
HttpClientFactoryServiceMBean {
    private static final long serialVersionUID = -4952869498749452801L;
    private ServiceName httpClientFactoryServiceName;
    private HttpClientFactory httpClientFactory;

    @Override
    public void setHttpClientFactoryServiceName(ServiceName name) {
        this.httpClientFactoryServiceName = name;
    }

    @Override
    public ServiceName getHttpClientFactoryServiceName() {
        return this.httpClientFactoryServiceName;
    }

    public void setHttpClientFactory(HttpClientFactory factory) {
        this.httpClientFactory = factory;
    }

    @Override
    public void startService() throws Exception {
        if (this.httpClientFactoryServiceName != null) {
            this.httpClientFactory = (HttpClientFactory)ServiceManagerFactory.getServiceObject(this.httpClientFactoryServiceName);
        }
        if (this.httpClientFactory == null) {
            throw new IllegalArgumentException("HttpClientFactoryServiceName or HttpClientFactory must be specified.");
        }
    }

    @Override
    public void stopService() throws Exception {
        this.httpClientFactory = null;
    }

    @Override
    public TransactionResource makeResource(String key) throws Exception {
        if (this.httpClientFactory == null) {
            return null;
        }
        return new HttpClientTransactionResource(this.httpClientFactory.createHttpClient());
    }

    public class HttpClientTransactionResource
    implements TransactionResource {
        protected HttpClient client;

        public HttpClientTransactionResource(HttpClient client) {
            this.client = client;
        }

        @Override
        public void commit() throws Exception {
        }

        @Override
        public void rollback() throws Exception {
        }

        @Override
        public void close() throws Exception {
            this.client.close();
        }

        @Override
        public Object getObject() {
            return this.client;
        }
    }
}

