/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.queue;

import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.daemon.Daemon;
import jp.ossc.nimbus.daemon.DaemonControl;
import jp.ossc.nimbus.daemon.DaemonRunnable;
import jp.ossc.nimbus.service.queue.DistributedQueueHandlerContainerServiceMBean;
import jp.ossc.nimbus.service.queue.DistributedQueueSelector;
import jp.ossc.nimbus.service.queue.Queue;
import jp.ossc.nimbus.service.queue.QueueHandler;
import jp.ossc.nimbus.service.queue.QueueHandlerContainer;

public class DistributedQueueHandlerContainerService
extends ServiceBase
implements QueueHandlerContainer,
DistributedQueueHandlerContainerServiceMBean {
    private static final long serialVersionUID = 4594481433048573418L;
    protected ServiceName distributedQueueSelectorServiceName;
    protected DistributedQueueSelector distributedQueueSelector;
    protected Daemon[] daemons;
    protected QueueReceiver[] invokers;
    protected ServiceName queueHandlerServiceName;
    protected QueueHandler queueHandler;
    protected boolean isDaemonQueueHandler = true;
    protected long waitTimeout = -1L;
    protected int maxRetryCount = 0;
    protected long retryInterval = 1000L;
    protected String handlingErrorMessageId = "QHC__00001";
    protected String retryOverErrorMessageId = "QHC__00002";
    protected int queueHandlerThreadPriority = -1;
    protected boolean isReleaseQueue = true;
    protected boolean isSuspend;

    @Override
    public void setDistributedQueueSelectorServiceName(ServiceName name) {
        this.distributedQueueSelectorServiceName = name;
    }

    @Override
    public ServiceName getDistributedQueueSelectorServiceName() {
        return this.distributedQueueSelectorServiceName;
    }

    @Override
    public void setQueueHandlerServiceName(ServiceName name) {
        if (this.queueHandlerServiceName == null) {
            this.queueHandlerServiceName = name;
            if (this.daemons != null) {
                for (int i = 0; i < this.daemons.length; ++i) {
                    this.daemons[i].resume();
                }
            }
        } else {
            this.queueHandlerServiceName = name;
        }
    }

    @Override
    public ServiceName getQueueHandlerServiceName() {
        return this.queueHandlerServiceName;
    }

    @Override
    public void setReleaseQueue(boolean isRelease) {
        this.isReleaseQueue = isRelease;
    }

    @Override
    public boolean isReleaseQueue() {
        return this.isReleaseQueue;
    }

    @Override
    public void setWaitTimeout(long timeout) {
        this.waitTimeout = timeout;
    }

    @Override
    public long getWaitTimeout() {
        return this.waitTimeout;
    }

    @Override
    public void setMaxRetryCount(int count) {
        this.maxRetryCount = count;
    }

    @Override
    public int getMaxRetryCount() {
        return this.maxRetryCount;
    }

    @Override
    public void setRetryInterval(long interval) {
        this.retryInterval = interval;
    }

    @Override
    public long getRetryInterval() {
        return this.retryInterval;
    }

    @Override
    public void setHandlingErrorMessageId(String id) {
        this.handlingErrorMessageId = id;
    }

    @Override
    public String getHandlingErrorMessageId() {
        return this.handlingErrorMessageId;
    }

    @Override
    public void setRetryOverErrorMessageId(String id) {
        this.retryOverErrorMessageId = id;
    }

    @Override
    public String getRetryOverErrorMessageId() {
        return this.retryOverErrorMessageId;
    }

    @Override
    public int getQueueHandlerSize() {
        return this.invokers == null ? 0 : this.invokers.length;
    }

    @Override
    public int getActiveQueueHandlerSize() {
        int count;
        block3: {
            block2: {
                Queue[] queues;
                count = 0;
                if (this.invokers != null) break block2;
                if (this.distributedQueueSelector == null || !((queues = this.distributedQueueSelector.getQueues())[0] instanceof QueueHandlerContainer)) break block3;
                for (int i = 0; i < queues.length; ++i) {
                    count += ((QueueHandlerContainer)queues[i]).getActiveQueueHandlerSize();
                }
                break block3;
            }
            for (int i = 0; i < this.invokers.length; ++i) {
                if (!this.invokers[i].isActive) continue;
                ++count;
            }
        }
        return count;
    }

    @Override
    public int getStandbyQueueHandlerSize() {
        int count;
        block3: {
            block2: {
                Queue[] queues;
                count = 0;
                if (this.invokers != null) break block2;
                if (this.distributedQueueSelector == null || !((queues = this.distributedQueueSelector.getQueues())[0] instanceof QueueHandlerContainer)) break block3;
                for (int i = 0; i < queues.length; ++i) {
                    count += ((QueueHandlerContainer)queues[i]).getStandbyQueueHandlerSize();
                }
                break block3;
            }
            for (int i = 0; i < this.invokers.length; ++i) {
                if (this.invokers[i].isActive) continue;
                ++count;
            }
        }
        return count;
    }

    @Override
    public void setDaemonQueueHandler(boolean isDaemon) {
        this.isDaemonQueueHandler = isDaemon;
    }

    @Override
    public boolean isDaemonQueueHandler() {
        return this.isDaemonQueueHandler;
    }

    @Override
    public void setQueueHandlerThreadPriority(int newPriority) {
        this.queueHandlerThreadPriority = newPriority;
    }

    @Override
    public int getQueueHandlerThreadPriority() {
        return this.queueHandlerThreadPriority;
    }

    @Override
    public long getAverageHandleProcessTime() {
        long time = 0L;
        if (this.invokers == null) {
            Queue[] queues;
            if (this.distributedQueueSelector != null && (queues = this.distributedQueueSelector.getQueues())[0] instanceof QueueHandlerContainer) {
                for (int i = 0; i < queues.length; ++i) {
                    time += ((QueueHandlerContainer)queues[i]).getAverageHandleProcessTime();
                }
                time /= (long)queues.length;
            }
        } else if (this.invokers.length != 0) {
            for (int i = 0; i < this.invokers.length; ++i) {
                time += this.invokers[i].getAverageReceiveProcessTime();
            }
            time /= (long)this.invokers.length;
        }
        return time;
    }

    public void setDistributedQueueSelector(DistributedQueueSelector selector) {
        this.distributedQueueSelector = selector;
    }

    @Override
    public void startService() throws Exception {
        if (this.distributedQueueSelectorServiceName != null) {
            this.distributedQueueSelector = (DistributedQueueSelector)ServiceManagerFactory.getServiceObject(this.distributedQueueSelectorServiceName);
        }
        if (this.distributedQueueSelector == null) {
            throw new IllegalArgumentException("DistributedQueueSelector is null.");
        }
        this.accept();
        Queue[] queues = this.distributedQueueSelector.getQueues();
        if (!(queues[0] instanceof QueueHandlerContainer)) {
            this.invokers = new QueueReceiver[queues.length];
            this.daemons = new Daemon[this.invokers.length];
            for (int i = 0; i < this.invokers.length; ++i) {
                this.invokers[i] = new QueueReceiver(queues[i]);
                this.invokers[i].handler = this.getQueueHandler();
                this.daemons[i] = new Daemon(this.invokers[i]);
                this.daemons[i].setDaemon(this.isDaemonQueueHandler);
                this.daemons[i].setName(this.getServiceNameObject() + " QueueReceiver" + (i + 1));
                if (this.queueHandlerThreadPriority > 0) {
                    this.daemons[i].setPriority(this.queueHandlerThreadPriority);
                }
                if (this.invokers[i].handler == null) {
                    this.daemons[i].suspend();
                }
                this.daemons[i].start();
            }
        }
    }

    @Override
    public void stopService() throws Exception {
        if (this.daemons != null) {
            for (int i = 0; i < this.daemons.length; ++i) {
                this.daemons[i].stop();
                this.daemons[i] = null;
                this.invokers[i] = null;
            }
        }
        if (this.isReleaseQueue) {
            this.release();
        }
        this.distributedQueueSelector = null;
        this.daemons = null;
        this.invokers = null;
    }

    @Override
    public synchronized void resume() {
        if (!this.isSuspend) {
            return;
        }
        this.isSuspend = false;
        if (this.daemons != null) {
            for (int i = 0; i < this.daemons.length; ++i) {
                this.daemons[i].resume();
            }
        }
    }

    @Override
    public synchronized void suspend() {
        if (this.isSuspend) {
            return;
        }
        if (this.daemons != null) {
            for (int i = 0; i < this.daemons.length; ++i) {
                this.daemons[i].suspend();
            }
        }
        this.isSuspend = true;
    }

    @Override
    public boolean isSuspend() {
        return this.isSuspend;
    }

    @Override
    public void setQueueHandler(QueueHandler handler) {
        if (this.queueHandler == null) {
            Queue[] queues;
            this.queueHandler = handler;
            if (this.daemons != null) {
                for (int i = 0; i < this.daemons.length; ++i) {
                    this.daemons[i].resume();
                }
            } else if (this.distributedQueueSelector != null && (queues = this.distributedQueueSelector.getQueues())[0] instanceof QueueHandlerContainer) {
                for (int i = 0; i < queues.length; ++i) {
                    ((QueueHandlerContainer)queues[i]).setQueueHandler(handler);
                }
            }
        } else {
            this.queueHandler = handler;
        }
    }

    @Override
    public QueueHandler getQueueHandler() {
        if (this.queueHandler != null) {
            return this.queueHandler;
        }
        if (this.queueHandlerServiceName != null) {
            return (QueueHandler)ServiceManagerFactory.getServiceObject(this.queueHandlerServiceName);
        }
        return null;
    }

    @Override
    public synchronized void push(Object item) {
        Queue queue = this.distributedQueueSelector.selectQueue(item);
        queue.push(item);
    }

    @Override
    public Object get() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object get(long timeOutMs) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object peek() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object peek(long timeOutMs) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove(Object item) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        Queue[] queues = this.distributedQueueSelector.getQueues();
        if (queues != null) {
            for (int i = 0; i < queues.length; ++i) {
                queues[i].clear();
            }
        }
    }

    @Override
    public int size() {
        int size = 0;
        Queue[] queues = this.distributedQueueSelector.getQueues();
        if (queues != null) {
            for (int i = 0; i < queues.length; ++i) {
                size += queues[i].size();
            }
        }
        return size;
    }

    @Override
    public long getCount() {
        long count = 0L;
        Queue[] queues = this.distributedQueueSelector.getQueues();
        if (queues != null) {
            for (int i = 0; i < queues.length; ++i) {
                count += queues[i].getCount();
            }
        }
        return count;
    }

    @Override
    public long getDepth() {
        long depth = 0L;
        Queue[] queues = this.distributedQueueSelector.getQueues();
        if (queues != null) {
            for (int i = 0; i < queues.length; ++i) {
                depth += (long)queues[i].size();
            }
        }
        return depth;
    }

    @Override
    public void accept() {
        Queue[] queues = this.distributedQueueSelector.getQueues();
        if (queues != null) {
            for (int i = 0; i < queues.length; ++i) {
                queues[i].accept();
            }
        }
    }

    @Override
    public void release() {
        Queue[] queues = this.distributedQueueSelector.getQueues();
        if (queues != null) {
            for (int i = 0; i < queues.length; ++i) {
                queues[i].release();
            }
        }
    }

    protected class QueueReceiver
    implements DaemonRunnable {
        protected Queue queue;
        protected QueueHandler handler;
        protected long receiveCount;
        protected long receiveProcessTime;
        public boolean isActive;

        public QueueReceiver(Queue queue) {
            this.queue = queue;
        }

        public long getReceiveCount() {
            return this.receiveCount;
        }

        public long getAverageReceiveProcessTime() {
            return this.receiveCount == 0L ? 0L : this.receiveProcessTime / this.receiveCount;
        }

        @Override
        public boolean onStart() {
            return true;
        }

        @Override
        public boolean onStop() {
            return true;
        }

        @Override
        public boolean onSuspend() {
            return true;
        }

        @Override
        public boolean onResume() {
            return true;
        }

        @Override
        public Object provide(DaemonControl ctrl) {
            if (this.handler == null) {
                this.handler = DistributedQueueHandlerContainerService.this.getQueueHandler();
                if (this.handler == null) {
                    return null;
                }
            }
            return this.queue.get(DistributedQueueHandlerContainerService.this.waitTimeout);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void consume(Object dequeued, DaemonControl ctrl) {
            if (this.handler == null) {
                return;
            }
            boolean isRetry = false;
            int retryCount = 0;
            ++this.receiveCount;
            long start = System.currentTimeMillis();
            do {
                block20: {
                    try {
                        this.isActive = true;
                        try {
                            this.handler.handleDequeuedObject(dequeued);
                            isRetry = false;
                        }
                        catch (Throwable th) {
                            if (DistributedQueueHandlerContainerService.this.maxRetryCount > 0) {
                                if (retryCount >= DistributedQueueHandlerContainerService.this.maxRetryCount) {
                                    isRetry = false;
                                    try {
                                        this.handler.handleRetryOver(dequeued, th);
                                    }
                                    catch (Throwable th2) {
                                        DistributedQueueHandlerContainerService.this.getLogger().write(DistributedQueueHandlerContainerService.this.retryOverErrorMessageId, dequeued, th);
                                    }
                                } else {
                                    isRetry = true;
                                    try {
                                        isRetry = this.handler.handleError(dequeued, th);
                                    }
                                    catch (Throwable th2) {
                                        DistributedQueueHandlerContainerService.this.getLogger().write(DistributedQueueHandlerContainerService.this.handlingErrorMessageId, dequeued, th);
                                    }
                                }
                                break block20;
                            }
                            isRetry = false;
                            try {
                                this.handler.handleError(dequeued, th);
                            }
                            catch (Throwable th2) {
                                DistributedQueueHandlerContainerService.this.getLogger().write(DistributedQueueHandlerContainerService.this.retryOverErrorMessageId, dequeued, th);
                            }
                        }
                    }
                    finally {
                        this.isActive = false;
                        if (ctrl != null && ctrl.isRunning()) {
                            Thread.interrupted();
                        }
                    }
                }
                if (isRetry && DistributedQueueHandlerContainerService.this.retryInterval > 0L) {
                    try {
                        Thread.sleep(DistributedQueueHandlerContainerService.this.retryInterval);
                    }
                    catch (InterruptedException e) {
                        isRetry = false;
                    }
                }
                ++retryCount;
            } while (isRetry);
            this.receiveProcessTime += System.currentTimeMillis() - start;
        }

        @Override
        public void garbage() {
            if (this.queue != null) {
                while (this.queue.size() > 0) {
                    this.consume(this.queue.get(0L), null);
                }
            }
        }
    }
}

