/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.publish;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.daemon.Daemon;
import jp.ossc.nimbus.daemon.DaemonControl;
import jp.ossc.nimbus.daemon.DaemonRunnable;
import jp.ossc.nimbus.service.jms.JMSMessageConsumerFactory;
import jp.ossc.nimbus.service.publish.AnalyzeProcessException;
import jp.ossc.nimbus.service.publish.DefaultPublisherServiceMBean;
import jp.ossc.nimbus.service.publish.MessageFilter;
import jp.ossc.nimbus.service.publish.MessageReceiver;
import jp.ossc.nimbus.service.publish.MessageSendException;
import jp.ossc.nimbus.service.publish.Protocol;
import jp.ossc.nimbus.service.publish.ProtocolMismatchException;
import jp.ossc.nimbus.service.publish.PublishContainer;
import jp.ossc.nimbus.service.publish.PublishContainerFactory;
import jp.ossc.nimbus.service.publish.Publisher;
import jp.ossc.nimbus.service.publish.Servant;
import jp.ossc.nimbus.service.queue.Queue;
import jp.ossc.nimbus.service.queue.QueueHandler;
import jp.ossc.nimbus.service.queue.QueueHandlerContainer;

public class DefaultPublisherService
extends ServiceBase
implements DefaultPublisherServiceMBean,
Publisher {
    private static final long serialVersionUID = -5493103525911436403L;
    protected static final String MSG_ID_00001 = "DP___00001";
    protected static final String MSG_ID_00002 = "DP___00002";
    protected static final String MSG_ID_00003 = "DP___00003";
    protected static final String MSG_ID_00004 = "DP___00004";
    protected static final String MSG_ID_00005 = "DP___00005";
    protected static final String MSG_ID_00006 = "DP___00006";
    protected static final String MSG_ID_00007 = "DP___00007";
    protected static final String MSG_ID_00008 = "DP___00008";
    protected static final String MSG_ID_00009 = "DP___00009";
    protected static final String MSG_ID_00010 = "DP___00010";
    protected static final String MSG_ID_00011 = "DP___00011";
    protected static final String MSG_ID_00012 = "DP___00012";
    protected String serverBindAddress;
    protected int port = 0;
    protected int containerNum = 0;
    protected Selector selector;
    protected Daemon socketReader;
    protected Map servants;
    protected List containerList;
    protected ServiceName publishContainerFactoryServiceName;
    protected PublishContainerFactory publishContainerFactory;
    protected ServiceName protocolServiceName;
    protected Protocol protocol;
    protected ServerSocketChannel serverSocketChannel;
    protected boolean isServerSocketChannelBlocking;
    protected boolean isSocketChannelBlocking;
    protected boolean isKeepAlive = true;
    protected long servantGarbageInterval = -1L;
    protected Daemon servantGarbager;
    protected ServiceName[] jmsMessageConsumerFactoryServiceNames;
    protected JMSMessageConsumerFactory[] jmsMessageConsumerFactory;
    protected ServiceName[] queueServiceNames;
    protected Queue[] queues;
    protected JMSMessageListener[] listeners;
    protected Daemon[] messageHandlers;
    protected Set consumers;
    protected ServiceName[] messageFilterServiceNames;
    protected List messageFilters;
    protected int serverSocketSoTimeout = -1;
    protected int serverSocketReceiveBufferSize = -1;
    protected int socketSoTimeout = -1;
    protected int socketReceiveBufferSize = -1;
    protected int socketSendBufferSize = -1;
    protected Boolean socketTcpNoDelay;
    protected Integer socketSoLinger;
    protected ServiceName analyzeQueueServiceName;
    protected Queue analyzeQueue;
    protected int analyzeThreadSize = 1;
    protected Daemon[] analyzeDaemon;
    protected ServiceName messageReceiverServiceName;
    protected MessageReceiver messageReceiver;

    @Override
    public void setProtocolServiceName(ServiceName name) {
        this.protocolServiceName = name;
    }

    @Override
    public ServiceName getProtocolServiceName() {
        return this.protocolServiceName;
    }

    @Override
    public ServiceName getPublishContainerFactoryServiceName() {
        return this.publishContainerFactoryServiceName;
    }

    @Override
    public void setPublishContainerFactoryServiceName(ServiceName name) {
        this.publishContainerFactoryServiceName = name;
    }

    @Override
    public void setJMSMessageConsumerFactoryServiceNames(ServiceName[] names) {
        this.jmsMessageConsumerFactoryServiceNames = names;
    }

    @Override
    public ServiceName[] getJMSMessageConsumerFactoryServiceNames() {
        return this.jmsMessageConsumerFactoryServiceNames;
    }

    @Override
    public void setMessageFilterServiceNames(ServiceName[] names) {
        this.messageFilterServiceNames = names;
    }

    @Override
    public ServiceName[] getMessageFilterServiceNames() {
        return this.messageFilterServiceNames;
    }

    @Override
    public void setServerBindAddress(String address) {
        this.serverBindAddress = address;
    }

    @Override
    public String getServerBindAddress() {
        return this.serverBindAddress;
    }

    @Override
    public void setPort(int port) {
        this.port = port;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public void setContainerNum(int num) {
        this.containerNum = num;
    }

    @Override
    public int getContainerNum() {
        return this.containerNum;
    }

    @Override
    public boolean isServerSocketChannelBlocking() {
        return this.isServerSocketChannelBlocking;
    }

    @Override
    public void setServerSocketChannelBlocking(boolean isBlocking) {
        this.isServerSocketChannelBlocking = isBlocking;
    }

    @Override
    public boolean isSocketChannelBlocking() {
        return this.isSocketChannelBlocking;
    }

    @Override
    public void setSocketChannelBlocking(boolean isBlocking) {
        this.isSocketChannelBlocking = isBlocking;
    }

    @Override
    public void setServerSocketSoTimeout(int timeout) {
        this.serverSocketSoTimeout = timeout;
    }

    @Override
    public int getServerSocketSoTimeout() {
        return this.serverSocketSoTimeout;
    }

    @Override
    public void setServerSocketReceiveBufferSize(int size) {
        this.serverSocketReceiveBufferSize = size;
    }

    @Override
    public int getServerSocketReceiveBufferSize() {
        return this.serverSocketReceiveBufferSize;
    }

    @Override
    public void setSocketSoTimeout(int timeout) {
        this.socketSoTimeout = timeout;
    }

    @Override
    public int getSocketSoTimeout() {
        return this.socketSoTimeout;
    }

    @Override
    public void setSocketReceiveBufferSize(int size) {
        this.socketReceiveBufferSize = size;
    }

    @Override
    public int getSocketReceiveBufferSize() {
        return this.socketReceiveBufferSize;
    }

    @Override
    public void setSocketSendBufferSize(int size) {
        this.socketSendBufferSize = size;
    }

    @Override
    public int getSocketSendBufferSize() {
        return this.socketSendBufferSize;
    }

    @Override
    public void setSocketTcpNoDelay(boolean noDelay) {
        this.socketTcpNoDelay = noDelay ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public boolean isSocketTcpNoDelay() {
        return this.socketTcpNoDelay == null ? false : this.socketTcpNoDelay;
    }

    @Override
    public void setSocketSoLinger(int time) {
        this.socketSoLinger = new Integer(time);
    }

    @Override
    public int getSocketSoLinger() {
        return this.socketSoLinger == null ? -1 : this.socketSoLinger;
    }

    @Override
    public boolean isKeepAlive() {
        return this.isKeepAlive;
    }

    @Override
    public void setKeepAlive(boolean isKeepAlive) {
        this.isKeepAlive = isKeepAlive;
    }

    @Override
    public void setServantGarbageInterval(long millis) {
        this.servantGarbageInterval = millis;
    }

    @Override
    public long getServantGarbageInterval() {
        return this.servantGarbageInterval;
    }

    @Override
    public void setQueueServiceNames(ServiceName[] names) {
        this.queueServiceNames = names;
    }

    @Override
    public ServiceName[] getQueueServiceNames() {
        return this.queueServiceNames;
    }

    @Override
    public void setAnalyzeQueueServiceName(ServiceName name) {
        this.analyzeQueueServiceName = name;
    }

    @Override
    public ServiceName getAnalyzeQueueServiceName() {
        return this.analyzeQueueServiceName;
    }

    @Override
    public void setAnalyzeThreadSize(int size) {
        this.analyzeThreadSize = size;
    }

    @Override
    public int getAnalyzeThreadSize() {
        return this.analyzeThreadSize;
    }

    @Override
    public void setMessageReceiverServiceName(ServiceName name) {
        this.messageReceiverServiceName = name;
    }

    @Override
    public ServiceName getMessageReceiverServiceName() {
        return this.messageReceiverServiceName;
    }

    public void setAnalyzeQueue(Queue queue) {
        this.analyzeQueue = queue;
    }

    public void setQueues(Queue[] queues) {
        this.queues = queues;
    }

    public void setPublishContainerFactory(PublishContainerFactory publishContainerFactory) {
        this.publishContainerFactory = publishContainerFactory;
    }

    public void setMessageFilters(MessageFilter[] filters) {
        if (filters == null || filters.length == 0) {
            this.messageFilters = null;
        } else {
            ArrayList<MessageFilter> filterList = new ArrayList<MessageFilter>();
            for (int i = 0; i < filters.length; ++i) {
                filterList.add(filters[i]);
            }
            this.messageFilters = filterList;
        }
    }

    @Override
    public List getMessageFilterList() {
        return this.messageFilters;
    }

    public void setMessageReceiver(MessageReceiver receiver) {
        this.messageReceiver = receiver;
    }

    @Override
    public void createService() throws Exception {
        this.servants = Collections.synchronizedMap(new HashMap());
        this.consumers = new HashSet();
    }

    @Override
    public void startService() throws Exception {
        int i;
        if (this.protocolServiceName != null) {
            this.protocol = (Protocol)ServiceManagerFactory.getServiceObject(this.protocolServiceName);
        }
        if (this.protocol == null) {
            throw new IllegalArgumentException("ProtocolServiceName or Protocol must be specified.");
        }
        if (this.publishContainerFactoryServiceName != null) {
            this.publishContainerFactory = (PublishContainerFactory)ServiceManagerFactory.getServiceObject(this.publishContainerFactoryServiceName);
        }
        if (this.publishContainerFactory == null) {
            throw new IllegalArgumentException("PublishContainerFactoryServiceName or PublishContainerFactory must be specified.");
        }
        if (this.analyzeQueueServiceName != null) {
            this.analyzeQueue = (Queue)ServiceManagerFactory.getServiceObject(this.analyzeQueueServiceName);
        }
        if (this.analyzeQueue != null) {
            this.analyzeQueue.accept();
            this.analyzeDaemon = new Daemon[this.analyzeThreadSize];
            for (i = 0; i < this.analyzeThreadSize; ++i) {
                this.analyzeDaemon[i] = new Daemon(new Analyzer());
                this.analyzeDaemon[i].setName("Nimbus PublisherAnalyzeDaemon " + this.getServiceNameObject());
                this.analyzeDaemon[i].start();
            }
        }
        if (this.messageReceiverServiceName != null) {
            this.messageReceiver = (MessageReceiver)ServiceManagerFactory.getServiceObject(this.messageReceiverServiceName);
        }
        this.containerList = new ArrayList(this.containerNum);
        for (i = 0; i < this.containerNum; ++i) {
            PublishContainer publishContainer = this.publishContainerFactory.createContainer();
            if (this.messageReceiver != null) {
                publishContainer.setMessageReceiver(this.messageReceiver);
            }
            this.containerList.add(publishContainer);
        }
        if (this.servantGarbageInterval > 0L) {
            this.servantGarbager = new Daemon(new ServantGarbager());
            this.servantGarbager.setName("Nimbus PublisherServantGarbagerDaemon " + this.getServiceNameObject());
            this.servantGarbager.start();
        }
        this.initSelector();
        this.socketReader = new Daemon(new SocketReader());
        this.socketReader.setName("Nimbus PublisherSocketReaderDaemon " + this.getServiceNameObject());
        this.socketReader.start();
        if (this.messageReceiver == null) {
            if (this.messageFilterServiceNames != null && this.messageFilterServiceNames.length != 0) {
                this.messageFilters = new ArrayList();
                for (i = 0; i < this.messageFilterServiceNames.length; ++i) {
                    this.messageFilters.add((MessageFilter)ServiceManagerFactory.getServiceObject(this.messageFilterServiceNames[i]));
                }
            }
            if (this.jmsMessageConsumerFactoryServiceNames != null && this.jmsMessageConsumerFactoryServiceNames.length > 0) {
                this.jmsMessageConsumerFactory = new JMSMessageConsumerFactory[this.jmsMessageConsumerFactoryServiceNames.length];
                for (i = 0; i < this.jmsMessageConsumerFactoryServiceNames.length; ++i) {
                    this.jmsMessageConsumerFactory[i] = (JMSMessageConsumerFactory)ServiceManagerFactory.getServiceObject(this.jmsMessageConsumerFactoryServiceNames[i]);
                }
            }
            if (this.jmsMessageConsumerFactory == null || this.jmsMessageConsumerFactory.length <= 0) {
                throw new IllegalArgumentException("JmsMessageConsumerFactoryServiceNames or JmsMessageConsumerFactory must be specified.");
            }
            if (this.queueServiceNames != null) {
                if (this.queueServiceNames.length == this.jmsMessageConsumerFactory.length) {
                    this.queues = new Queue[this.queueServiceNames.length];
                    for (i = 0; i < this.queueServiceNames.length; ++i) {
                        this.queues[i] = (Queue)ServiceManagerFactory.getServiceObject(this.queueServiceNames[i]);
                        this.queues[i].accept();
                    }
                } else {
                    throw new IllegalArgumentException("Length of QueueServiceNames and JmsMessageConsumerFactory must equal.");
                }
            }
            if (this.queues == null) {
                throw new IllegalArgumentException("QueueServiceNames or Queue must be specified.");
            }
            if (this.queues.length != this.jmsMessageConsumerFactory.length) {
                throw new IllegalArgumentException("Length of Queue and JmsMessageConsumerFactory must equal.");
            }
            this.messageHandlers = new Daemon[this.queues.length];
            this.listeners = new JMSMessageListener[this.jmsMessageConsumerFactoryServiceNames.length];
            for (i = 0; i < this.jmsMessageConsumerFactory.length; ++i) {
                MessageConsumer consumer = this.jmsMessageConsumerFactory[i].createConsumer();
                if (this.queueServiceNames != null) {
                    if (this.queues[i] instanceof QueueHandlerContainer) {
                        ((QueueHandlerContainer)this.queues[i]).setQueueHandler(new JMSMessageQueueHandler());
                        ((QueueHandlerContainer)this.queues[i]).start();
                    } else {
                        this.messageHandlers[i] = new Daemon(new MessageHandler(this.queues[i]));
                        this.messageHandlers[i].setName("Nimbus PublisherMessageHandlerDaemon " + this.getServiceNameObject());
                        this.messageHandlers[i].start();
                    }
                }
                this.listeners[i] = new JMSMessageListener(this.queues[i]);
                consumer.setMessageListener((MessageListener)this.listeners[i]);
                this.consumers.add(consumer);
                Connection con = this.jmsMessageConsumerFactory[i].getSessionFactory().getConnection();
                con.start();
            }
        }
    }

    protected void initSelector() throws IOException {
        this.selector = SelectorProvider.provider().openSelector();
        this.serverSocketChannel = ServerSocketChannel.open();
        this.serverSocketChannel.configureBlocking(this.isServerSocketChannelBlocking);
        InetAddress address = null;
        if (this.serverBindAddress == null) {
            address = InetAddress.getLocalHost();
        } else {
            byte[] ip = new byte[4];
            String tmp = this.serverBindAddress;
            for (int i = 0; i < ip.length; ++i) {
                if (i != ip.length - 1) {
                    int index = tmp.indexOf(46);
                    if (index == -1 || index == tmp.length() - 1) {
                        throw new IllegalArgumentException("Bad serverBindAddress : " + this.serverBindAddress);
                    }
                    ip[i] = (byte)Integer.parseInt(tmp.substring(0, index));
                    tmp = tmp.substring(index + 1);
                    continue;
                }
                ip[i] = (byte)Integer.parseInt(tmp);
            }
            address = InetAddress.getByAddress(ip);
        }
        InetSocketAddress socketAddress = new InetSocketAddress(address, this.port);
        this.serverSocketChannel.socket().bind(socketAddress);
        if (this.serverSocketSoTimeout != -1) {
            this.serverSocketChannel.socket().setSoTimeout(this.serverSocketSoTimeout);
        }
        if (this.serverSocketReceiveBufferSize != -1) {
            this.serverSocketChannel.socket().setReceiveBufferSize(this.serverSocketReceiveBufferSize);
        }
        this.serverSocketChannel.register(this.selector, 16);
    }

    protected void closeSelector() {
        if (this.serverSocketChannel != null) {
            try {
                this.serverSocketChannel.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (this.serverSocketChannel != null) {
            try {
                this.serverSocketChannel.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (this.selector != null) {
            try {
                this.selector.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void stopService() throws Exception {
        for (MessageConsumer consumer : this.consumers) {
            try {
                consumer.close();
            }
            catch (JMSException e) {}
        }
        this.consumers.clear();
        this.listeners = null;
        this.socketReader.stop();
        this.socketReader = null;
        if (this.servantGarbager != null) {
            this.servantGarbager.stop();
            this.servantGarbager = null;
        }
        if (this.analyzeQueue != null) {
            this.analyzeQueue.release();
            for (int i = 0; i < this.analyzeDaemon.length; ++i) {
                this.analyzeDaemon[i].stop();
            }
            this.analyzeDaemon = null;
        }
        this.closeSelector();
        if (this.messageHandlers != null && this.messageHandlers.length != 0) {
            for (int i = 0; i < this.messageHandlers.length; ++i) {
                if (this.messageHandlers[i] == null) continue;
                this.messageHandlers[i].stop();
            }
            this.messageHandlers = null;
        }
        if (this.queues != null && this.queues.length != 0) {
            for (int i = 0; i < this.queues.length; ++i) {
                if (this.queues[i] instanceof QueueHandlerContainer) {
                    ((QueueHandlerContainer)this.queues[i]).stop();
                }
                this.queues[i].release();
            }
        }
        int imax = this.containerList.size();
        for (int i = 0; i < imax; ++i) {
            PublishContainer container = (PublishContainer)this.containerList.get(i);
            container.stop();
        }
        this.containerList.clear();
        this.servants.clear();
        this.messageFilters = null;
    }

    @Override
    public void destroyService() {
        this.protocol = null;
        this.selector = null;
    }

    protected void handleMessage(Message msg) {
        Object obj = null;
        if (msg instanceof ObjectMessage) {
            ObjectMessage objMsg = (ObjectMessage)msg;
            try {
                obj = objMsg.getObject();
            }
            catch (JMSException e) {
                this.getLogger().write(MSG_ID_00007, e);
            }
        } else {
            this.getLogger().write(MSG_ID_00008, msg);
        }
        if (obj == null) {
            return;
        }
        if (this.messageFilters != null) {
            try {
                for (int i = 0; i < this.messageFilters.size(); ++i) {
                    MessageFilter messageFilter = (MessageFilter)this.messageFilters.get(i);
                    obj = messageFilter.filter(obj);
                    if (obj != null) continue;
                    return;
                }
            }
            catch (Throwable th) {
                this.getLogger().write(MSG_ID_00011, obj, th);
            }
        }
        try {
            int imax = this.containerList.size();
            for (int i = 0; i < imax; ++i) {
                PublishContainer container = (PublishContainer)this.containerList.get(i);
                container.handleMessage(obj);
            }
        }
        catch (Throwable th) {
            this.getLogger().write(MSG_ID_00012, obj, th);
        }
    }

    @Override
    public synchronized boolean entryServant(Servant svt) {
        String key = svt.getID();
        int maxVacantNum = 0;
        PublishContainer maxVacantContainer = null;
        int max = this.containerList.size();
        for (int i = 0; i < max; ++i) {
            PublishContainer container = (PublishContainer)this.containerList.get(i);
            int vacantNum = container.getVacantServantNum();
            if (vacantNum <= maxVacantNum) continue;
            maxVacantNum = vacantNum;
            maxVacantContainer = container;
        }
        if (maxVacantContainer != null) {
            svt.setProtocol(this.protocol);
            if (maxVacantContainer.entryServant(svt)) {
                this.servants.put(key, svt);
                return true;
            }
            return this.entryServant(svt);
        }
        return false;
    }

    @Override
    public synchronized boolean ejectServant(String key) {
        return this.ejectServant(key, false);
    }

    @Override
    public synchronized boolean ejectServant(String key, boolean isForced) {
        Servant servant = (Servant)this.servants.get(key);
        if (servant != null) {
            PublishContainer container = servant.getContainer();
            if (container == null) {
                return true;
            }
            if (container.ejectServant(servant, isForced)) {
                this.servants.remove(key);
            } else {
                return false;
            }
        }
        return true;
    }

    @Override
    public Servant findServant(String key) {
        return (Servant)this.servants.get(key);
    }

    @Override
    public int getServantNum() {
        return this.servants != null ? this.servants.size() : 0;
    }

    @Override
    public long getPublishCount() {
        if (this.containerList == null) {
            return 0L;
        }
        long count = 0L;
        int imax = this.containerList.size();
        for (int i = 0; i < imax; ++i) {
            PublishContainer container = (PublishContainer)this.containerList.get(i);
            count += container.getPublishCount();
        }
        return count;
    }

    @Override
    public long getReceiveCount() {
        long receiveCount = 0L;
        if (this.listeners != null && this.listeners.length != 0) {
            for (int i = 0; i < this.listeners.length; ++i) {
                receiveCount += this.listeners[i].receiveCount;
            }
        }
        return receiveCount;
    }

    protected class Analyzer
    implements DaemonRunnable {
        protected Analyzer() {
        }

        @Override
        public boolean onStart() {
            return true;
        }

        @Override
        public boolean onStop() {
            return true;
        }

        @Override
        public boolean onSuspend() {
            return true;
        }

        @Override
        public boolean onResume() {
            return true;
        }

        @Override
        public Object provide(DaemonControl ctrl) throws Throwable {
            if (DefaultPublisherService.this.analyzeQueue == null) {
                return null;
            }
            return DefaultPublisherService.this.analyzeQueue.get(1000L);
        }

        @Override
        public void consume(Object paramObj, DaemonControl ctrl) throws Throwable {
            if (paramObj == null) {
                return;
            }
            Object[] params = (Object[])paramObj;
            SelectionKey key = (SelectionKey)params[0];
            if (!key.isValid()) {
                key.cancel();
                return;
            }
            SocketChannel socketChannel = (SocketChannel)params[1];
            try {
                DefaultPublisherService.this.protocol.analyze(key, socketChannel, DefaultPublisherService.this);
                try {
                    key.interestOps(key.interestOps() | 1);
                    DefaultPublisherService.this.selector.wakeup();
                }
                catch (CancelledKeyException e) {}
            }
            catch (MessageSendException e) {
                DefaultPublisherService.this.getLogger().write(DefaultPublisherService.MSG_ID_00004, e);
                try {
                    socketChannel.finishConnect();
                    socketChannel.close();
                }
                catch (IOException e2) {
                    // empty catch block
                }
                key.cancel();
            }
            catch (AnalyzeProcessException e) {
                DefaultPublisherService.this.getLogger().write(DefaultPublisherService.MSG_ID_00005, e);
                try {
                    socketChannel.finishConnect();
                    socketChannel.close();
                }
                catch (IOException e2) {
                    // empty catch block
                }
                key.cancel();
            }
            catch (IOException e) {
                DefaultPublisherService.this.getLogger().write(DefaultPublisherService.MSG_ID_00003, e);
                try {
                    socketChannel.finishConnect();
                    socketChannel.close();
                }
                catch (IOException e2) {
                    // empty catch block
                }
                key.cancel();
            }
            catch (ProtocolMismatchException e) {
                DefaultPublisherService.this.getLogger().write(DefaultPublisherService.MSG_ID_00002, e);
                try {
                    socketChannel.finishConnect();
                    socketChannel.close();
                }
                catch (IOException e2) {
                    // empty catch block
                }
                key.cancel();
            }
            catch (Throwable e) {
                DefaultPublisherService.this.getLogger().write(DefaultPublisherService.MSG_ID_00006, e);
                try {
                    socketChannel.finishConnect();
                    socketChannel.close();
                }
                catch (IOException e2) {
                    // empty catch block
                }
                key.cancel();
            }
        }

        @Override
        public void garbage() {
        }
    }

    protected class ServantGarbager
    implements DaemonRunnable {
        protected ServantGarbager() {
        }

        @Override
        public boolean onStart() {
            return true;
        }

        @Override
        public boolean onStop() {
            return true;
        }

        @Override
        public boolean onSuspend() {
            return true;
        }

        @Override
        public boolean onResume() {
            return true;
        }

        @Override
        public Object provide(DaemonControl ctrl) throws Throwable {
            Thread.sleep(DefaultPublisherService.this.servantGarbageInterval);
            return null;
        }

        @Override
        public void consume(Object paramObj, DaemonControl ctrl) throws Throwable {
            int imax = DefaultPublisherService.this.containerList.size();
            for (int i = 0; i < imax; ++i) {
                PublishContainer container = (PublishContainer)DefaultPublisherService.this.containerList.get(i);
                Set garbage = container.garbage();
                if (garbage == null) continue;
                Iterator itr = garbage.iterator();
                while (itr.hasNext()) {
                    DefaultPublisherService.this.servants.remove(((Servant)itr.next()).getID());
                }
            }
        }

        @Override
        public void garbage() {
        }
    }

    protected class SocketReader
    implements Serializable,
    DaemonRunnable {
        private static final long serialVersionUID = 8199251823294812508L;

        protected SocketReader() {
        }

        @Override
        public boolean onStart() {
            return true;
        }

        @Override
        public boolean onStop() {
            return true;
        }

        @Override
        public boolean onSuspend() {
            return true;
        }

        @Override
        public boolean onResume() {
            return true;
        }

        @Override
        public Object provide(DaemonControl ctrl) throws Throwable {
            try {
                int count = DefaultPublisherService.this.selector.select(1000L);
                if (count > 0) {
                    return DefaultPublisherService.this.selector.selectedKeys();
                }
                return null;
            }
            catch (Throwable e) {
                DefaultPublisherService.this.getLogger().write(DefaultPublisherService.MSG_ID_00009, e);
                DefaultPublisherService.this.closeSelector();
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e2) {
                    // empty catch block
                }
                try {
                    DefaultPublisherService.this.initSelector();
                }
                catch (IOException e2) {
                    DefaultPublisherService.this.closeSelector();
                    DefaultPublisherService.this.getLogger().write(DefaultPublisherService.MSG_ID_00010, e2);
                }
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void consume(Object paramObj, DaemonControl ctrl) throws Throwable {
            if (paramObj == null) {
                return;
            }
            SelectionKey key = null;
            Set selected = (Set)paramObj;
            try {
                Iterator keyIterator = selected.iterator();
                while (keyIterator.hasNext()) {
                    try {
                        key = (SelectionKey)keyIterator.next();
                        if (key.isAcceptable()) {
                            ServerSocketChannel serverSocketChannel = (ServerSocketChannel)key.channel();
                            try {
                                this.accept(serverSocketChannel);
                            }
                            catch (IOException e) {
                                DefaultPublisherService.this.getLogger().write(DefaultPublisherService.MSG_ID_00001, e);
                            }
                            continue;
                        }
                        if (key.isReadable()) {
                            SocketChannel socketChannel = (SocketChannel)key.channel();
                            if (DefaultPublisherService.this.analyzeQueue == null) {
                                try {
                                    this.read(key, socketChannel);
                                }
                                catch (AnalyzeProcessException e) {
                                    DefaultPublisherService.this.getLogger().write(DefaultPublisherService.MSG_ID_00005, e);
                                }
                                catch (IOException e) {
                                    DefaultPublisherService.this.getLogger().write(DefaultPublisherService.MSG_ID_00003, e);
                                }
                                catch (MessageSendException e) {
                                    DefaultPublisherService.this.getLogger().write(DefaultPublisherService.MSG_ID_00004, e);
                                }
                                catch (ProtocolMismatchException e) {
                                    DefaultPublisherService.this.getLogger().write(DefaultPublisherService.MSG_ID_00002, e);
                                }
                                continue;
                            }
                            key.interestOps(key.interestOps() & 0xFFFFFFFE);
                            DefaultPublisherService.this.analyzeQueue.push(new Object[]{key, socketChannel});
                            continue;
                        }
                        if (key.isValid()) continue;
                        key.cancel();
                    }
                    catch (CancelledKeyException e) {}
                    continue;
                    finally {
                        keyIterator.remove();
                    }
                }
            }
            catch (Throwable e) {
                DefaultPublisherService.this.getLogger().write(DefaultPublisherService.MSG_ID_00006, e);
            }
        }

        @Override
        public void garbage() {
        }

        private void accept(ServerSocketChannel serverSocketChannel) throws IOException {
            SocketChannel socketChannel = serverSocketChannel.accept();
            socketChannel.configureBlocking(DefaultPublisherService.this.isSocketChannelBlocking);
            socketChannel.socket().setKeepAlive(DefaultPublisherService.this.isKeepAlive);
            if (DefaultPublisherService.this.socketSoTimeout != -1) {
                socketChannel.socket().setSoTimeout(DefaultPublisherService.this.socketSoTimeout);
            }
            if (DefaultPublisherService.this.socketReceiveBufferSize != -1) {
                socketChannel.socket().setReceiveBufferSize(DefaultPublisherService.this.socketReceiveBufferSize);
            }
            if (DefaultPublisherService.this.socketSendBufferSize != -1) {
                socketChannel.socket().setSendBufferSize(DefaultPublisherService.this.socketSendBufferSize);
            }
            if (DefaultPublisherService.this.socketTcpNoDelay != null) {
                socketChannel.socket().setTcpNoDelay(DefaultPublisherService.this.socketTcpNoDelay);
            }
            if (DefaultPublisherService.this.socketSoLinger != null) {
                socketChannel.socket().setSoLinger(DefaultPublisherService.this.socketSoLinger > 0, DefaultPublisherService.this.socketSoLinger);
            }
            socketChannel.configureBlocking(DefaultPublisherService.this.isServerSocketChannelBlocking);
            socketChannel.register(DefaultPublisherService.this.selector, 1);
        }

        private void read(SelectionKey key, SocketChannel socketChanel) throws IOException, ProtocolMismatchException, MessageSendException, AnalyzeProcessException {
            try {
                DefaultPublisherService.this.protocol.analyze(key, socketChanel, DefaultPublisherService.this);
            }
            catch (MessageSendException e) {
                try {
                    socketChanel.finishConnect();
                    socketChanel.close();
                }
                catch (IOException e2) {
                    // empty catch block
                }
                key.cancel();
                throw e;
            }
            catch (AnalyzeProcessException e) {
                try {
                    socketChanel.finishConnect();
                    socketChanel.close();
                }
                catch (IOException e2) {
                    // empty catch block
                }
                key.cancel();
                throw e;
            }
            catch (IOException e) {
                try {
                    socketChanel.finishConnect();
                    socketChanel.close();
                }
                catch (IOException e2) {
                    // empty catch block
                }
                key.cancel();
                throw e;
            }
            catch (RuntimeException e) {
                try {
                    socketChanel.finishConnect();
                    socketChanel.close();
                }
                catch (IOException e2) {
                    // empty catch block
                }
                key.cancel();
                throw e;
            }
            catch (Error e) {
                try {
                    socketChanel.finishConnect();
                    socketChanel.close();
                }
                catch (IOException e2) {
                    // empty catch block
                }
                key.cancel();
                throw e;
            }
        }
    }

    protected class MessageHandler
    implements Serializable,
    DaemonRunnable {
        private static final long serialVersionUID = 5865323006319211723L;
        protected Queue queue;

        public MessageHandler() {
        }

        public MessageHandler(Queue queue) {
            this.queue = queue;
        }

        @Override
        public boolean onStart() {
            return true;
        }

        @Override
        public boolean onStop() {
            return true;
        }

        @Override
        public boolean onSuspend() {
            return true;
        }

        @Override
        public boolean onResume() {
            return true;
        }

        @Override
        public Object provide(DaemonControl ctrl) throws Throwable {
            if (this.queue == null) {
                return null;
            }
            return this.queue.get(1000L);
        }

        @Override
        public void consume(Object paramObj, DaemonControl ctrl) {
            if (paramObj == null) {
                return;
            }
            DefaultPublisherService.this.handleMessage((Message)paramObj);
        }

        @Override
        public void garbage() {
            if (this.queue != null) {
                while (this.queue.size() > 0) {
                    this.consume(this.queue.get(0L), null);
                }
            }
        }
    }

    protected class JMSMessageListener
    implements MessageListener {
        public long receiveCount;
        protected Queue queue;

        public JMSMessageListener(Queue queue) {
            this.queue = queue;
        }

        public void onMessage(Message msg) {
            if (DefaultPublisherService.this.getState() != 2 && DefaultPublisherService.this.getState() != 3) {
                return;
            }
            if (this.queue == null) {
                ++this.receiveCount;
                DefaultPublisherService.this.handleMessage(msg);
            } else {
                ++this.receiveCount;
                this.queue.push(msg);
            }
        }
    }

    protected class JMSMessageQueueHandler
    implements QueueHandler {
        protected JMSMessageQueueHandler() {
        }

        @Override
        public void handleDequeuedObject(Object obj) throws Throwable {
            if (obj == null) {
                return;
            }
            DefaultPublisherService.this.handleMessage((Message)obj);
        }

        @Override
        public boolean handleError(Object obj, Throwable th) throws Throwable {
            return true;
        }

        @Override
        public void handleRetryOver(Object obj, Throwable th) throws Throwable {
        }
    }
}

