/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.publish;

import java.util.HashSet;
import java.util.Set;
import jp.ossc.nimbus.core.Service;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.core.ServiceStateChangeEvent;
import jp.ossc.nimbus.core.ServiceStateListener;
import jp.ossc.nimbus.service.publish.DefaultPublishContainerFactoryServiceMBean;
import jp.ossc.nimbus.service.publish.DefaultPublishContainerService;
import jp.ossc.nimbus.service.publish.PublishContainer;
import jp.ossc.nimbus.service.publish.PublishContainerFactory;

public class DefaultPublishContainerFactoryService
extends ServiceBase
implements PublishContainerFactory,
DefaultPublishContainerFactoryServiceMBean,
ServiceStateListener {
    private static final long serialVersionUID = 3117051157337762342L;
    private boolean isRegisterContainer;
    private int maxServantNum;
    private Set containers;
    private ServiceName queueServiceName;
    private int threadPriority = -1;

    @Override
    public void setRegisterContainer(boolean isRegistered) {
        this.isRegisterContainer = isRegistered;
    }

    @Override
    public boolean isRegisterContainer() {
        return this.isRegisterContainer;
    }

    @Override
    public void setMaxServantNum(int maxServant) {
        this.maxServantNum = maxServant;
    }

    @Override
    public int getMaxServantNum() {
        return this.maxServantNum;
    }

    @Override
    public void setQueueServiceName(ServiceName name) {
        this.queueServiceName = name;
    }

    @Override
    public ServiceName getQueueServiceName() {
        return this.queueServiceName;
    }

    @Override
    public void setThreadPriority(int priority) {
        this.threadPriority = priority;
    }

    @Override
    public int getThreadPriority() {
        return this.threadPriority;
    }

    @Override
    public void createService() throws Exception {
        this.containers = new HashSet();
    }

    @Override
    public void startService() throws Exception {
        for (ServiceBase container : this.containers) {
            container.start();
            container.addServiceStateListener(this);
        }
    }

    @Override
    public void stopService() throws Exception {
        for (ServiceBase container : this.containers) {
            container.removeServiceStateListener(this);
            container.stop();
        }
    }

    @Override
    public void destroyService() throws Exception {
        for (Service container : this.containers) {
            container.destroy();
        }
        this.containers.clear();
        this.containers = null;
    }

    @Override
    public synchronized PublishContainer createContainer() throws Exception {
        DefaultPublishContainerService container = new DefaultPublishContainerService();
        if (this.isRegisterContainer) {
            container.setServiceManagerName(this.getServiceManagerName());
            container.setServiceName(container.getClass().getName() + this.containers.size());
        } else {
            if (this.getSystemLoggerServiceName() != null) {
                container.setSystemLoggerServiceName(this.getSystemLoggerServiceName());
            }
            if (this.getSystemMessageRecordFactoryServiceName() != null) {
                container.setSystemMessageRecordFactoryServiceName(this.getSystemMessageRecordFactoryServiceName());
            }
        }
        container.create();
        container.setMaxServantNum(this.maxServantNum);
        container.setQueueServiceName(this.queueServiceName);
        if (this.threadPriority > 0) {
            container.setThreadPriority(this.threadPriority);
        }
        container.start();
        container.addServiceStateListener(this);
        this.containers.add(container);
        return container;
    }

    @Override
    public void stateChanged(ServiceStateChangeEvent e) throws Exception {
        if (this.containers == null) {
            return;
        }
        this.containers.remove(e.getService());
    }

    @Override
    public boolean isEnabledState(int state) {
        return state == 7;
    }
}

