/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.loader;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.lang.ServiceException;
import jp.ossc.nimbus.service.loader.CashedClassLoader;
import jp.ossc.nimbus.service.loader.ClassLauncher;
import jp.ossc.nimbus.service.loader.ClassLoaderServiceMBean;
import jp.ossc.nimbus.util.CsvArrayList;

public class ClassLoaderService
extends ServiceBase
implements ClassLauncher,
ClassLoaderServiceMBean {
    private static final long serialVersionUID = -6862375386956303362L;
    protected URL[] mUrlAry;
    protected CashedClassLoader mBlLoder;
    protected String mClassPath;
    protected Date mReshreshedDate = null;
    protected Date mReshreshPlanDate = null;
    private static final String C_SEMICORON = ";";
    private static final String C_JAR_EXT = ".jar";
    private static final String C_UPER_JAR_EXT = ".JAR";
    private static final String C_SLASH = "/";

    @Override
    public void setClassPath(String paths) {
        this.mClassPath = paths;
        CsvArrayList ps = new CsvArrayList();
        ps.split(paths, C_SEMICORON);
        this.mUrlAry = new URL[ps.size()];
        for (int i = 0; i < ps.size(); ++i) {
            String filePath = ps.getStr(i);
            if (!(filePath.endsWith(C_JAR_EXT) || filePath.endsWith(C_UPER_JAR_EXT) || filePath.endsWith(C_SLASH))) {
                filePath = filePath + C_SLASH;
            }
            try {
                this.mUrlAry[i] = new File(filePath).toURL();
                continue;
            }
            catch (MalformedURLException e) {
                throw new ServiceException("CLASSLODER001", "URLERROR " + filePath, e);
            }
        }
    }

    @Override
    public String getClassPath() {
        return this.mClassPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class loadClass(String name) throws ClassNotFoundException {
        ClassLoaderService classLoaderService = this;
        synchronized (classLoaderService) {
            if (this.mReshreshPlanDate.after(this.mReshreshedDate) && this.mReshreshPlanDate.before(new Date())) {
                this.startService();
            }
            return this.mBlLoder.loadClass(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object loadNewInstance(String name) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class cls = null;
        ClassLoaderService classLoaderService = this;
        synchronized (classLoaderService) {
            if (this.mReshreshPlanDate.after(this.mReshreshedDate) && this.mReshreshPlanDate.before(new Date())) {
                this.startService();
            }
            cls = this.mBlLoder.loadClass(name);
        }
        return cls.newInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startService() {
        ClassLoaderService classLoaderService = this;
        synchronized (classLoaderService) {
            this.mReshreshPlanDate = new Date();
            this.mBlLoder = new CashedClassLoader(this.mUrlAry, Thread.currentThread().getContextClassLoader());
            this.mReshreshedDate = new Date();
        }
    }

    @Override
    public void stopService() {
        this.mBlLoder = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRefreshTime(String time) {
        SimpleDateFormat ft = new SimpleDateFormat("yyyy.MM.dd hh:mm:ss");
        ClassLoaderService classLoaderService = this;
        synchronized (classLoaderService) {
            try {
                this.mReshreshPlanDate = ft.parse(time);
            }
            catch (ParseException e) {
                throw new ServiceException("CLASSLODER002", "ParseException time is" + time, e);
            }
        }
    }

    @Override
    public void refreshNow() {
        this.startService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getLastRrefreshTime() {
        SimpleDateFormat ft = new SimpleDateFormat("yyyy.MM.dd hh:mm:ss");
        ClassLoaderService classLoaderService = this;
        synchronized (classLoaderService) {
            return ft.format(this.mReshreshedDate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getNextRefreshTime() {
        SimpleDateFormat ft = new SimpleDateFormat("yyyy.MM.dd hh:mm:ss");
        ClassLoaderService classLoaderService = this;
        synchronized (classLoaderService) {
            return ft.format(this.mReshreshPlanDate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getCashedBlList() {
        Hashtable hash = null;
        ClassLoaderService classLoaderService = this;
        synchronized (classLoaderService) {
            hash = this.mBlLoder.getCashedClass();
        }
        int size = hash.size();
        String[] ret = new String[size];
        int cnt = 0;
        Enumeration enumeration = hash.elements();
        while (enumeration.hasMoreElements()) {
            Class cls = (Class)enumeration.nextElement();
            ret[cnt] = cls.getName();
            ++cnt;
        }
        return ret;
    }
}

