/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.keepalive;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.ossc.nimbus.core.Service;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.daemon.Daemon;
import jp.ossc.nimbus.daemon.DaemonControl;
import jp.ossc.nimbus.daemon.DaemonRunnable;
import jp.ossc.nimbus.service.keepalive.ClusterListener;
import jp.ossc.nimbus.service.keepalive.ClusterServiceMBean;
import jp.ossc.nimbus.service.keepalive.DefaultClusterListenerService;
import jp.ossc.nimbus.service.queue.DefaultQueueService;
import jp.ossc.nimbus.service.queue.Queue;
import jp.ossc.nimbus.util.SynchronizeMonitor;
import jp.ossc.nimbus.util.WaitSynchronizeMonitor;

public class ClusterService
extends ServiceBase
implements ClusterServiceMBean {
    private static final long serialVersionUID = 4503189967951662029L;
    protected static final int MESSAGE_ID_ADD_REQ = 1;
    protected static final int MESSAGE_ID_MEMBER_CHANGE_REQ = 2;
    protected static final int MESSAGE_ID_MEMBER_MERGE_REQ = 3;
    protected static final int MESSAGE_ID_MEMBER_MERGE_RES = 4;
    protected static final int MESSAGE_ID_MAIN_HELLO_REQ = 5;
    protected static final int MESSAGE_ID_MAIN_REQ = 6;
    protected static final int MESSAGE_ID_MAIN_RES = 7;
    protected static final int MESSAGE_ID_HELLO_REQ = 8;
    protected static final int MESSAGE_ID_HELLO_RES = 9;
    protected static final int MESSAGE_ID_BYE_REQ = 10;
    protected static final int MESSAGE_ID_MEMBER_CHANGE_REQ_REQ = 11;
    protected ServiceName targetServiceName;
    protected ServiceName[] clusterListenerServiceNames;
    protected List listeners;
    protected String multicastGroupAddress;
    protected int multicastPort = 1500;
    protected int timeToLive = -1;
    protected String localAddress;
    protected String[] unicastMemberAddresses;
    protected int unicastPort = 1500;
    protected int receiveBufferSize = 1024;
    protected long heartBeatInterval = 1000L;
    protected long heartBeatResponseTimeout = 500L;
    protected int heartBeatRetryCount = 1;
    protected long addMemberResponseTimeout = 500L;
    protected int addMemberRetryCount = 0;
    protected boolean isClient;
    protected long lostTimeout = 500L;
    protected transient GlobalUID uid;
    protected transient InetAddress group;
    protected transient DatagramSocket socket;
    protected transient Daemon clusterMessageReceiver;
    protected transient Daemon heartBeater;
    protected transient Daemon eventHandler;
    protected transient Queue eventQueue;
    protected transient boolean isMain;
    protected transient boolean isMainDoubt;
    protected transient List members;
    protected transient Set clientMembers;
    protected transient List unicastMembers;
    protected final SynchronizeMonitor addMonitor = new WaitSynchronizeMonitor();
    protected transient boolean isMainRequesting;
    protected transient Set mainReqMembers;
    protected final SynchronizeMonitor helloMonitor = new WaitSynchronizeMonitor();
    protected transient GlobalUID helloTarget;
    protected transient Serializable option;
    protected transient boolean isJoinOnStart = true;
    protected transient boolean isJoin;
    protected transient boolean isJoining;
    protected final String sequenceLock = "SEQUENCE";
    protected transient int currentSequence;
    protected transient int maxWindowCount;
    protected int threadPriority = -1;

    @Override
    public void setTargetServiceName(ServiceName name) {
        this.targetServiceName = name;
    }

    @Override
    public ServiceName getTargetServiceName() {
        return this.targetServiceName;
    }

    @Override
    public void setClusterListenerServiceNames(ServiceName[] names) {
        this.clusterListenerServiceNames = names;
    }

    @Override
    public ServiceName[] getClusterListenerServiceNames() {
        return this.clusterListenerServiceNames;
    }

    @Override
    public void setMulticastGroupAddress(String ip) {
        this.multicastGroupAddress = ip;
    }

    @Override
    public String getMulticastGroupAddress() {
        return this.multicastGroupAddress;
    }

    @Override
    public void setMulticastPort(int port) {
        this.multicastPort = port;
    }

    @Override
    public int getMulticastPort() {
        return this.multicastPort;
    }

    @Override
    public void setUnicastMemberAddresses(String[] addresses) {
        this.unicastMemberAddresses = addresses;
    }

    @Override
    public String[] getUnicastMemberAddresses() {
        return this.unicastMemberAddresses;
    }

    @Override
    public void setUnicastPort(int port) {
        this.unicastPort = port;
    }

    @Override
    public int getUnicastPort() {
        return this.unicastPort;
    }

    @Override
    public void setReceiveBufferSize(int size) {
        this.receiveBufferSize = size;
    }

    @Override
    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    @Override
    public void setTimeToLive(int ttl) {
        this.timeToLive = ttl;
    }

    @Override
    public int getTimeToLive() {
        return this.timeToLive;
    }

    @Override
    public void setLocalAddress(String ip) {
        this.localAddress = ip;
    }

    @Override
    public String getLocalAddress() {
        return this.localAddress;
    }

    @Override
    public void setOption(Serializable opt) {
        this.option = opt;
        if (this.uid != null) {
            this.uid.setOption(opt);
        }
    }

    @Override
    public Serializable getOption() {
        return this.option;
    }

    @Override
    public void setHeartBeatInterval(long interval) {
        this.heartBeatInterval = interval;
    }

    @Override
    public long getHeartBeatInterval() {
        return this.heartBeatInterval;
    }

    @Override
    public void setHeartBeatResponseTimeout(long timeout) {
        this.heartBeatResponseTimeout = timeout;
    }

    @Override
    public long getHeartBeatResponseTimeout() {
        return this.heartBeatResponseTimeout;
    }

    @Override
    public void setHeartBeatRetryCount(int count) {
        this.heartBeatRetryCount = count;
    }

    @Override
    public int getHeartBeatRetryCount() {
        return this.heartBeatRetryCount;
    }

    @Override
    public void setAddMemberResponseTimeout(long timeout) {
        this.addMemberResponseTimeout = timeout;
    }

    @Override
    public long getAddMemberResponseTimeout() {
        return this.addMemberResponseTimeout;
    }

    @Override
    public void setAddMemberRetryCount(int count) {
        this.addMemberRetryCount = count;
    }

    @Override
    public int getAddMemberRetryCount() {
        return this.addMemberRetryCount;
    }

    @Override
    public void setLostTimeout(long timeout) {
        this.lostTimeout = timeout;
    }

    @Override
    public long getLostTimeout() {
        return this.lostTimeout;
    }

    @Override
    public void setClient(boolean isClient) {
        this.isClient = isClient;
    }

    @Override
    public boolean isClient() {
        return this.isClient;
    }

    @Override
    public void setJoinOnStart(boolean isJoin) {
        this.isJoinOnStart = isJoin;
    }

    @Override
    public boolean isJoinOnStart() {
        return this.isJoinOnStart;
    }

    @Override
    public void setThreadPriority(int priority) {
        this.threadPriority = priority;
    }

    @Override
    public int getThreadPriority() {
        return this.threadPriority;
    }

    @Override
    public boolean isMain() {
        return this.isMain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getMembers() {
        List list = this.members;
        synchronized (list) {
            return new ArrayList(this.members);
        }
    }

    @Override
    public Object getUID() {
        return this.uid;
    }

    @Override
    public boolean isJoin() {
        return this.isJoin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClusterListener(ClusterListener listener) {
        if (this.getState() == 3) {
            if (this.isJoin()) {
                try {
                    listener.memberInit(this.isClient ? null : this.uid, new ArrayList(this.members));
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (this.isMain) {
                        listener.changeMain();
                    } else {
                        listener.changeSub();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            List list = this.listeners;
            synchronized (list) {
                ArrayList<ClusterListener> tmp = new ArrayList<ClusterListener>(this.listeners);
                tmp.add(listener);
                this.listeners = tmp;
            }
        }
        this.listeners.add(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeClusterListener(ClusterListener listener) {
        if (this.getState() == 3) {
            List list = this.listeners;
            synchronized (list) {
                ArrayList tmp = new ArrayList(this.listeners);
                tmp.remove(listener);
                this.listeners = tmp;
            }
        } else {
            this.listeners.add(listener);
        }
    }

    @Override
    public int getMaxWindowCount() {
        return this.maxWindowCount;
    }

    @Override
    public void createService() throws Exception {
        this.members = Collections.synchronizedList(new ArrayList());
        this.clientMembers = Collections.synchronizedSet(new HashSet());
        this.mainReqMembers = Collections.synchronizedSet(new HashSet());
        this.listeners = new ArrayList();
        this.unicastMembers = Collections.synchronizedList(new ArrayList());
    }

    @Override
    public void startService() throws Exception {
        if (this.clusterListenerServiceNames != null) {
            for (int i = 0; i < this.clusterListenerServiceNames.length; ++i) {
                this.listeners.add((ClusterListener)ServiceManagerFactory.getServiceObject(this.clusterListenerServiceNames[i]));
            }
        }
        if (this.targetServiceName != null) {
            DefaultClusterListenerService listener = new DefaultClusterListenerService();
            listener.setTargetServiceName(this.targetServiceName);
            listener.setClusterService(this);
            listener.create();
            listener.start();
            this.listeners.add(listener);
        }
        this.uid = new GlobalUID(this.localAddress, this.option);
        if (this.multicastGroupAddress == null && (this.unicastMemberAddresses == null || this.unicastMemberAddresses.length == 0)) {
            throw new IllegalArgumentException("MulticastGroupAddress and UnicastMemberAddresses is null.");
        }
        this.eventQueue = new DefaultQueueService();
        ((Service)((Object)this.eventQueue)).create();
        ((Service)((Object)this.eventQueue)).start();
        this.eventQueue.accept();
        this.connect();
        this.eventHandler = new Daemon(new EventHandler());
        this.eventHandler.setName("Nimbus Cluster EventHandler " + this.getServiceNameObject());
        if (this.threadPriority >= 0) {
            this.eventHandler.setPriority(this.threadPriority);
        }
        this.eventHandler.start();
        this.clusterMessageReceiver = new Daemon(new MessageReceiver());
        this.clusterMessageReceiver.setName("Nimbus Cluster MessageReceiver " + this.getServiceNameObject());
        if (this.threadPriority >= 0) {
            this.clusterMessageReceiver.setPriority(this.threadPriority);
        }
        this.clusterMessageReceiver.start();
        this.heartBeater = new Daemon(new HeartBeater());
        if (this.threadPriority >= 0) {
            this.heartBeater.setPriority(this.threadPriority);
        }
        this.heartBeater.setName("Nimbus Cluster HeartBeater " + this.getServiceNameObject());
        this.heartBeater.suspend();
        this.heartBeater.start();
        if (this.isJoinOnStart) {
            this.join();
        }
    }

    @Override
    public void stopService() throws Exception {
        this.heartBeater.stop(100L);
        this.heartBeater = null;
        this.clusterMessageReceiver.stop(100L);
        this.clusterMessageReceiver = null;
        this.eventHandler.stop(100L);
        this.eventHandler = null;
        this.eventQueue.release();
        this.leave();
        if (this.socket != null) {
            if (this.group != null && this.group.isMulticastAddress()) {
                try {
                    ((MulticastSocket)this.socket).leaveGroup(this.group);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.socket.close();
        }
        this.isMain = false;
        this.isMainDoubt = false;
        this.group = null;
        this.members.clear();
        this.clientMembers.clear();
        this.mainReqMembers.clear();
    }

    @Override
    public void destroyService() throws Exception {
        this.uid = null;
        this.members = null;
        this.clientMembers = null;
        this.mainReqMembers = null;
    }

    private synchronized void connect() throws IOException {
        if (this.socket != null) {
            this.socket.close();
        }
        if (this.multicastGroupAddress != null) {
            this.group = InetAddress.getByName(this.multicastGroupAddress);
            InetSocketAddress address = new InetSocketAddress(this.uid.getAddress(), this.multicastPort);
            DatagramSocket datagramSocket = this.socket = this.group.isMulticastAddress() ? new MulticastSocket(address) : new DatagramSocket(address);
            if (this.group.isMulticastAddress() && this.timeToLive >= 0) {
                ((MulticastSocket)this.socket).setTimeToLive(this.timeToLive);
            }
            if (this.group.isMulticastAddress()) {
                ((MulticastSocket)this.socket).joinGroup(this.group);
            }
        } else {
            this.unicastMembers.clear();
            for (int i = 0; i < this.unicastMemberAddresses.length; ++i) {
                InetAddress unicastMemberAddress = InetAddress.getByName(this.unicastMemberAddresses[i]);
                this.unicastMembers.add(unicastMemberAddress);
            }
            this.socket = new DatagramSocket(new InetSocketAddress(this.uid.getAddress(), this.unicastPort));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void join() throws Exception {
        block27: {
            if (this.isJoin) {
                return;
            }
            this.isJoining = true;
            try {
                Object object = this.addMonitor;
                synchronized (object) {
                    for (int i = 0; i <= this.addMemberRetryCount; ++i) {
                        this.addMonitor.initMonitor();
                        this.sendMessage(1);
                        if (this.addMonitor.waitMonitor(this.addMemberResponseTimeout)) break;
                    }
                }
                if (this.members.size() == 0 || this.members.get(0).equals(this.uid)) {
                    if (!this.isClient && !this.members.contains(this.uid)) {
                        object = this.members;
                        synchronized (object) {
                            this.members.add(this.uid);
                        }
                    }
                    this.processMemberInit(this.members);
                    if (this.isClient) break block27;
                    try {
                        object = this.members;
                        synchronized (object) {
                            this.isMain = true;
                            this.isMainDoubt = false;
                            this.isMainRequesting = false;
                            if (this.group == null) {
                                Set i = this.clientMembers;
                                synchronized (i) {
                                    this.clientMembers.clear();
                                }
                            }
                            this.getLogger().write("CLST_00001", this.getServiceNameObject());
                        }
                        this.processChangeMain();
                        break block27;
                    }
                    catch (Exception e) {
                        this.isMain = false;
                        this.processChangeSub();
                        this.sendMessage(10);
                        this.clusterMessageReceiver.stop(100L);
                        if (this.socket != null) {
                            if (this.group != null && this.group.isMulticastAddress()) {
                                try {
                                    ((MulticastSocket)this.socket).leaveGroup(this.group);
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                            this.socket.close();
                        }
                        this.isJoin = false;
                        throw e;
                    }
                }
                this.processMemberInit(this.members);
                if (!this.isClient) {
                    this.getLogger().write("CLST_00002", this.getServiceNameObject());
                }
            }
            finally {
                this.isJoining = false;
            }
        }
        this.isJoin = true;
        this.heartBeater.resume();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void leave() {
        if (!this.isJoin) {
            return;
        }
        this.isJoin = false;
        if (this.heartBeater != null) {
            this.heartBeater.suspend();
        }
        try {
            this.sendMessage(10);
        }
        catch (Exception exception) {
            // empty catch block
        }
        List list = this.members;
        synchronized (list) {
            this.members.clear();
        }
        if (!this.isClient) {
            this.isMain = false;
            this.processChangeSub();
            this.getLogger().write("CLST_00002", this.getServiceNameObject());
        }
    }

    public ClusterService createClient() {
        ClusterService client = new ClusterService();
        client.multicastGroupAddress = this.multicastGroupAddress;
        client.multicastPort = this.multicastPort;
        client.timeToLive = this.timeToLive;
        client.unicastMemberAddresses = this.unicastMemberAddresses;
        client.unicastPort = this.unicastPort;
        client.receiveBufferSize = this.receiveBufferSize;
        client.heartBeatInterval = this.heartBeatInterval;
        client.heartBeatResponseTimeout = this.heartBeatResponseTimeout;
        client.heartBeatRetryCount = this.heartBeatRetryCount;
        client.addMemberResponseTimeout = this.addMemberResponseTimeout;
        client.lostTimeout = this.lostTimeout;
        client.isClient = true;
        return client;
    }

    protected void sendMessage(int messageId) throws IOException {
        this.sendMessage(messageId, null);
    }

    protected void sendMessage(int messageId, GlobalUID toUID) throws IOException {
        this.sendMessage(messageId, this.uid, toUID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendMessage(int messageId, GlobalUID fromUID, GlobalUID toUID) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
            oos.writeInt(messageId);
            switch (messageId) {
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    fromUID = (GlobalUID)fromUID.clone();
                    fromUID.setOption(null);
                    break;
                }
                case 1: {
                    break;
                }
            }
            oos.writeObject(fromUID);
            if (toUID != null) {
                toUID = (GlobalUID)toUID.clone();
                toUID.setOption(null);
            }
            oos.writeObject(toUID);
            switch (messageId) {
                case 5: 
                case 9: 
                case 11: {
                    break;
                }
                case 8: {
                    oos.writeBoolean(this.isClient);
                    oos.writeInt(this.members.size());
                    break;
                }
                case 1: 
                case 10: {
                    oos.writeBoolean(this.isClient);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    oos.writeInt(this.members.size());
                    int imax = this.members.size();
                    for (int i = 0; i < imax; ++i) {
                        oos.writeObject(this.members.get(i));
                    }
                    break;
                }
                case 7: {
                    oos.writeBoolean(!this.isMain);
                    break;
                }
            }
            oos.close();
            byte[] bytes = baos.toByteArray();
            if (bytes.length <= 0) {
                return;
            }
            ArrayList<DatagramPacket> packets = new ArrayList<DatagramPacket>();
            Window window = new Window();
            String string = "SEQUENCE";
            synchronized ("SEQUENCE") {
                byte[] windowData;
                window.sequence = this.currentSequence++;
                // ** MonitorExit[var9_11] (shouldn't be in output)
                window.data = bytes;
                List windows = window.divide(this.receiveBufferSize);
                this.maxWindowCount = Math.max(this.maxWindowCount, windows.size());
                if (this.group == null) {
                    if (toUID == null) {
                        int i;
                        LinkedHashSet<InetAddress> toMembers = new LinkedHashSet<InetAddress>();
                        toMembers.addAll(this.unicastMembers);
                        int imax = this.members.size();
                        for (int i2 = 0; i2 < imax; ++i2) {
                            toMembers.add(((GlobalUID)this.members.get(i2)).getAddress());
                        }
                        switch (messageId) {
                            case 2: 
                            case 4: {
                                Object[] clients = this.clientMembers.toArray();
                                for (i = 0; i < clients.length; ++i) {
                                    toMembers.add(((GlobalUID)clients[i]).getAddress());
                                }
                                break;
                            }
                        }
                        InetAddress[] toAddresses = toMembers.toArray(new InetAddress[toMembers.size()]);
                        for (i = 0; i < windows.size(); ++i) {
                            byte[] windowData2 = (byte[])windows.get(i);
                            for (int j = 0; j < toAddresses.length; ++j) {
                                packets.add(new DatagramPacket(windowData2, windowData2.length, toAddresses[j], this.unicastPort));
                            }
                        }
                    } else {
                        for (int i = 0; i < windows.size(); ++i) {
                            windowData = (byte[])windows.get(i);
                            packets.add(new DatagramPacket(windowData, windowData.length, toUID.getAddress(), this.unicastPort));
                        }
                    }
                } else {
                    for (int i = 0; i < windows.size(); ++i) {
                        windowData = (byte[])windows.get(i);
                        packets.add(new DatagramPacket(windowData, windowData.length, this.group, this.multicastPort));
                    }
                }
                for (int i = 0; i < packets.size(); ++i) {
                    this.socket.send((DatagramPacket)packets.get(i));
                }
            }
        }
        {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected void handleMessage(InputStream is) {
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(is);
            int messageId = ois.readInt();
            GlobalUID fromUID = (GlobalUID)ois.readObject();
            GlobalUID toUID = (GlobalUID)ois.readObject();
            if (this.uid.equals(fromUID)) return;
            if (toUID != null && !this.uid.equals(toUID)) {
                return;
            }
            int memberSize = 0;
            ArrayList<Object> newMembers = null;
            boolean isMemberChange = false;
            ArrayList tmpOldMembers = null;
            ArrayList tmpNewMembers = null;
            switch (messageId) {
                case 1: {
                    if (!this.isMain) {
                        return;
                    }
                    if (ois.readBoolean()) {
                        if (this.group == null) {
                            Set set = this.clientMembers;
                            // MONITORENTER : set
                            this.clientMembers.add(fromUID);
                            // MONITOREXIT : set
                        }
                        this.sendMessage(2, fromUID);
                        return;
                    }
                    List list = this.members;
                    // MONITORENTER : list
                    if (!this.members.contains(fromUID)) {
                        tmpOldMembers = new ArrayList(this.members);
                        this.members.add(fromUID);
                        tmpNewMembers = new ArrayList(this.members);
                        isMemberChange = true;
                    }
                    // MONITOREXIT : list
                    this.sendMessage(2);
                    if (!isMemberChange) return;
                    this.eventQueue.push(new ClusterEvent(4, tmpOldMembers, tmpNewMembers));
                    return;
                }
                case 11: {
                    if (!this.isMain) return;
                    this.sendMessage(2);
                    return;
                }
                case 2: {
                    if (this.isMain) return;
                    if (this.members.size() != 0 && this.members.indexOf(fromUID) != 0) {
                        return;
                    }
                    memberSize = ois.readInt();
                    newMembers = new ArrayList();
                    if (memberSize > 0) {
                        for (int i = 0; i < memberSize; ++i) {
                            newMembers.add(ois.readObject());
                        }
                    }
                    boolean isNotMember = false;
                    Object object = this.members;
                    // MONITORENTER : object
                    if (!this.members.equals(newMembers)) {
                        if (this.isClient || newMembers.contains(this.uid)) {
                            tmpOldMembers = new ArrayList(this.members);
                            tmpNewMembers = new ArrayList(newMembers);
                            this.members = Collections.synchronizedList(newMembers);
                            isMemberChange = true;
                        } else {
                            isNotMember = true;
                        }
                    }
                    // MONITOREXIT : object
                    if (this.addMonitor.isWait() && this.members.contains(this.uid)) {
                        this.addMonitor.notifyAllMonitor();
                        isMemberChange = false;
                    }
                    if (!isNotMember) {
                        if (!isMemberChange) return;
                        if (this.isJoining) return;
                        this.eventQueue.push(new ClusterEvent(4, tmpOldMembers, tmpNewMembers));
                        return;
                    }
                    object = this.addMonitor;
                    // MONITORENTER : object
                    int i2 = 0;
                    while (true) {
                        if (i2 > this.addMemberRetryCount) {
                            // MONITOREXIT : object
                            return;
                        }
                        this.addMonitor.initMonitor();
                        this.sendMessage(1);
                        try {
                            if (this.addMonitor.waitMonitor(this.addMemberResponseTimeout)) {
                                return;
                            }
                        }
                        catch (InterruptedException e) {
                            return;
                        }
                        ++i2;
                    }
                }
                case 3: {
                    if (!this.isMain) {
                        return;
                    }
                    memberSize = ois.readInt();
                    newMembers = new ArrayList();
                    if (memberSize > 0) {
                        for (int i = 0; i < memberSize; ++i) {
                            newMembers.add(ois.readObject());
                        }
                    }
                    List i = this.members;
                    // MONITORENTER : i
                    newMembers.removeAll(this.members);
                    if (newMembers.size() != 0) {
                        tmpOldMembers = new ArrayList(this.members);
                        tmpNewMembers = new ArrayList(newMembers);
                        this.members.addAll(newMembers);
                        isMemberChange = true;
                    }
                    // MONITOREXIT : i
                    this.sendMessage(4);
                    if (!isMemberChange) return;
                    this.eventQueue.push(new ClusterEvent(4, tmpOldMembers, tmpNewMembers));
                    return;
                }
                case 4: {
                    memberSize = ois.readInt();
                    newMembers = new ArrayList<Object>();
                    if (memberSize > 0) {
                        for (int i = 0; i < memberSize; ++i) {
                            newMembers.add(ois.readObject());
                        }
                    }
                    if (!this.isClient && this.isMain && newMembers.indexOf(this.uid) != 0) {
                        this.eventQueue.push(new ClusterEvent(2));
                        this.isMain = false;
                        this.isMainDoubt = false;
                        this.isMainRequesting = false;
                        this.getLogger().write("CLST_00002", this.getServiceNameObject());
                    }
                    List i = this.members;
                    // MONITORENTER : i
                    if (newMembers.contains(this.uid) && !this.members.equals(newMembers)) {
                        tmpOldMembers = new ArrayList(this.members);
                        tmpNewMembers = new ArrayList(newMembers);
                        this.members = Collections.synchronizedList(newMembers);
                        isMemberChange = true;
                    }
                    // MONITOREXIT : i
                    if (!isMemberChange) return;
                    this.eventQueue.push(new ClusterEvent(4, tmpOldMembers, tmpNewMembers));
                    return;
                }
                case 5: {
                    if (!this.isMain) {
                        if (this.members.size() != 1) return;
                        if (this.addMonitor.isWait()) return;
                        this.sendMessage(1, fromUID);
                        return;
                    }
                    if (this.isMainDoubt) return;
                    if (this.uid.compareTo(fromUID) <= 0) return;
                    this.isMainDoubt = true;
                    this.sendMessage(3, fromUID);
                    return;
                }
                case 6: {
                    if (this.isClient) return;
                    this.sendMessage(7, fromUID);
                    return;
                }
                case 7: {
                    if (this.isClient) {
                        return;
                    }
                    if (!this.isMainRequesting) return;
                    if (!ois.readBoolean()) {
                        this.isMainRequesting = false;
                        this.mainReqMembers.clear();
                        return;
                    }
                    Set i = this.mainReqMembers;
                    // MONITORENTER : i
                    this.mainReqMembers.remove(fromUID);
                    if (this.mainReqMembers.size() == 0) {
                        try {
                            this.isMain = true;
                            this.isMainRequesting = false;
                            if (this.group == null) {
                                Set i2 = this.clientMembers;
                                // MONITORENTER : i2
                                this.clientMembers.clear();
                                // MONITOREXIT : i2
                            }
                            this.getLogger().write("CLST_00001", this.getServiceNameObject());
                            this.eventQueue.push(new ClusterEvent(1));
                            return;
                        }
                        catch (Exception e) {
                            this.getLogger().write("CLST_00003", this.getServiceNameObject(), (Throwable)e);
                            this.stop();
                        }
                    }
                    // MONITOREXIT : i
                    return;
                }
                case 8: {
                    int targetIndex;
                    if (ois.readBoolean()) {
                        if (!this.isMain) return;
                        if (!this.clientMembers.contains(fromUID)) {
                            Set i = this.clientMembers;
                            // MONITORENTER : i
                            this.clientMembers.add(fromUID);
                            // MONITOREXIT : i
                        }
                        this.sendMessage(9, fromUID);
                        if (ois.readInt() == this.members.size()) return;
                        this.sendMessage(2, fromUID);
                        return;
                    }
                    if (!this.members.contains(fromUID)) {
                        if (!this.isMain) return;
                        this.sendMessage(9, fromUID);
                        List list = this.members;
                        // MONITORENTER : list
                        tmpOldMembers = new ArrayList(this.members);
                        this.members.add(fromUID);
                        tmpNewMembers = new ArrayList(this.members);
                        isMemberChange = true;
                        // MONITOREXIT : list
                        this.sendMessage(2);
                        if (!isMemberChange) return;
                        this.eventQueue.push(new ClusterEvent(4, tmpOldMembers, tmpNewMembers));
                        return;
                    }
                    this.sendMessage(9, fromUID);
                    int myIndex = this.members.indexOf(this.uid);
                    int n = targetIndex = myIndex == 0 ? this.members.size() - 1 : myIndex - 1;
                    if (this.members.indexOf(fromUID) == targetIndex) {
                        if (ois.readInt() == this.members.size()) return;
                    }
                    if (this.isMain) {
                        this.sendMessage(2, fromUID);
                        return;
                    }
                    this.sendMessage(11, (GlobalUID)this.members.get(0));
                    return;
                }
                case 9: {
                    SynchronizeMonitor synchronizeMonitor = this.helloMonitor;
                    // MONITORENTER : synchronizeMonitor
                    if (this.helloTarget != null && this.helloTarget.equals(fromUID)) {
                        this.helloMonitor.notifyMonitor();
                    }
                    // MONITOREXIT : synchronizeMonitor
                    return;
                }
                case 10: {
                    Collection collection;
                    if (this.isMain) {
                        if (ois.readBoolean()) {
                            if (this.group != null) return;
                            Set set = this.clientMembers;
                            // MONITORENTER : set
                            this.clientMembers.remove(fromUID);
                            // MONITOREXIT : set
                            return;
                        }
                        List list = this.members;
                        // MONITORENTER : list
                        if (this.members.contains(fromUID)) {
                            tmpOldMembers = new ArrayList(this.members);
                            this.members.remove(fromUID);
                            tmpNewMembers = new ArrayList(this.members);
                            isMemberChange = true;
                        }
                        // MONITOREXIT : list
                        if (!isMemberChange) return;
                        this.sendMessage(2);
                        this.eventQueue.push(new ClusterEvent(4, tmpOldMembers, tmpNewMembers));
                        return;
                    }
                    if (ois.readBoolean()) return;
                    if (this.isMainRequesting) {
                        collection = this.mainReqMembers;
                        // MONITORENTER : collection
                        this.mainReqMembers.remove(fromUID);
                        // MONITOREXIT : collection
                    }
                    collection = this.members;
                    // MONITORENTER : collection
                    if (this.members.contains(fromUID)) {
                        tmpOldMembers = new ArrayList(this.members);
                        this.members.remove(fromUID);
                        tmpNewMembers = new ArrayList(this.members);
                        this.eventQueue.push(new ClusterEvent(4, tmpOldMembers, tmpNewMembers));
                    }
                    if (this.members.indexOf(this.uid) == 0) {
                        if (!this.isClient && this.members.size() == 1) {
                            this.isMain = true;
                            this.isMainRequesting = false;
                            if (this.group == null) {
                                Set set = this.clientMembers;
                                // MONITORENTER : set
                                this.clientMembers.clear();
                                // MONITOREXIT : set
                            }
                            this.getLogger().write("CLST_00001", this.getServiceNameObject());
                            this.eventQueue.push(new ClusterEvent(1));
                            return;
                        }
                        if (!this.isMainRequesting) {
                            Set set = this.mainReqMembers;
                            // MONITORENTER : set
                            this.mainReqMembers.clear();
                            this.mainReqMembers.addAll(this.members);
                            this.mainReqMembers.remove(this.uid);
                            this.isMainRequesting = true;
                            // MONITOREXIT : set
                            this.sendMessage(6);
                        }
                    }
                    // MONITOREXIT : collection
                    return;
                }
            }
            return;
        }
        catch (ClassNotFoundException e) {
            this.getLogger().write("CLST_00004", e);
            return;
        }
        catch (IOException e) {
            this.getLogger().write("CLST_00004", e);
            return;
        }
        finally {
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (IOException e2) {}
            }
        }
    }

    protected void processMemberInit(List members) {
        Object[] tmpListeners = this.listeners.toArray();
        for (int i = 0; i < tmpListeners.length; ++i) {
            ClusterListener listener = (ClusterListener)tmpListeners[i];
            try {
                listener.memberInit(this.isClient ? null : this.uid, new ArrayList(members));
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    protected void processMemberChange(List oldMembers, List newMembers) {
        if (oldMembers.equals(newMembers)) {
            return;
        }
        Object[] tmpListeners = this.listeners.toArray();
        for (int i = 0; i < tmpListeners.length; ++i) {
            ClusterListener listener = (ClusterListener)tmpListeners[i];
            try {
                listener.memberChange(new ArrayList(oldMembers), new ArrayList(newMembers));
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    protected void processChangeMain() throws Exception {
        Object[] tmpListeners = this.listeners.toArray();
        for (int i = 0; i < tmpListeners.length; ++i) {
            ClusterListener listener = (ClusterListener)tmpListeners[i];
            listener.changeMain();
        }
    }

    protected void processChangeSub() {
        Object[] tmpListeners = this.listeners.toArray();
        for (int i = 0; i < tmpListeners.length; ++i) {
            ClusterListener listener = (ClusterListener)tmpListeners[i];
            listener.changeSub();
        }
    }

    protected static class Window
    implements Comparable {
        private static final int HEADER_LENGTH = 12;
        public int sequence;
        public short windowCount;
        public short windowNo;
        public long receiveTime;
        public byte[] data;
        private List windows;

        protected Window() {
        }

        public List divide(int windowSize) throws IOException {
            ArrayList<byte[]> result = new ArrayList<byte[]>();
            if (this.data == null || this.data.length <= windowSize - 12) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                DataOutputStream dos = new DataOutputStream(baos);
                dos.writeInt(this.sequence);
                dos.writeShort(1);
                dos.writeShort(0);
                dos.writeInt(this.data == null ? 0 : this.data.length);
                if (this.data != null && this.data.length != 0) {
                    dos.write(this.data);
                }
                dos.flush();
                result.add(baos.toByteArray());
            } else {
                int dataLength;
                int offset = 0;
                int no = 0;
                short tmpWindowCount = (short)Math.ceil((double)this.data.length / (double)(windowSize - 12));
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                DataOutputStream dos = new DataOutputStream(baos);
                do {
                    dos.writeInt(this.sequence);
                    dos.writeShort(tmpWindowCount);
                    dos.writeShort(no);
                    dataLength = Math.min(windowSize - 12, this.data.length - offset);
                    dos.writeInt(dataLength);
                    if (dataLength != 0) {
                        dos.write(this.data, offset, dataLength);
                    }
                    dos.flush();
                    result.add(baos.toByteArray());
                    baos.reset();
                    no = (short)(no + 1);
                } while (this.data.length > (offset += dataLength));
            }
            return result;
        }

        public boolean addWindow(Window window) {
            if (this.isComplete()) {
                return true;
            }
            if (this.windows == null) {
                this.windows = new ArrayList(this.windowCount);
            }
            if (this.windows.size() == 0) {
                this.windows.add(this);
            }
            this.windows.add(window);
            if (this.windowCount <= this.windows.size()) {
                Collections.sort(this.windows);
                return true;
            }
            return false;
        }

        public byte[] getData() throws IOException {
            if (!this.isComplete()) {
                return null;
            }
            if (this.windows == null) {
                return this.data;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int imax = this.windows.size();
            for (int i = 0; i < imax; ++i) {
                Window w = (Window)this.windows.get(i);
                baos.write(w.data);
            }
            return baos.toByteArray();
        }

        public boolean isComplete() {
            return this.windowCount == 1 || this.windows != null && this.windowCount <= this.windows.size();
        }

        public void read(DataInput in) throws IOException {
            this.sequence = in.readInt();
            this.windowCount = in.readShort();
            this.windowNo = in.readShort();
            int length = in.readInt();
            this.data = new byte[length];
            in.readFully(this.data, 0, length);
            this.receiveTime = System.currentTimeMillis();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || !(o instanceof Window)) {
                return false;
            }
            Window cmp = (Window)o;
            return this.sequence == cmp.sequence;
        }

        public int hashCode() {
            return this.sequence;
        }

        public int compareTo(Object o) {
            Window cmp = (Window)o;
            if (this.windowNo == cmp.windowNo) {
                return 0;
            }
            return this.windowNo > cmp.windowNo ? 1 : -1;
        }
    }

    protected static class ClusterEvent {
        public static final int EVENT_CHANGE_MAIN = 1;
        public static final int EVENT_CHANGE_SUB = 2;
        public static final int EVENT_MEMBER_INIT = 3;
        public static final int EVENT_MEMBER_CHANGE = 4;
        public final int event;
        public final List oldMembers;
        public final List newMembers;

        public ClusterEvent(int event) {
            this.event = event;
            this.oldMembers = null;
            this.newMembers = null;
        }

        public ClusterEvent(int event, List members) {
            this.event = event;
            this.oldMembers = null;
            this.newMembers = members;
        }

        public ClusterEvent(int event, List oldMembers, List newMembers) {
            this.event = event;
            this.oldMembers = oldMembers;
            this.newMembers = newMembers;
        }
    }

    protected class EventHandler
    implements DaemonRunnable {
        protected EventHandler() {
        }

        @Override
        public boolean onStart() {
            return true;
        }

        @Override
        public boolean onStop() {
            return true;
        }

        @Override
        public boolean onSuspend() {
            return true;
        }

        @Override
        public boolean onResume() {
            return true;
        }

        @Override
        public Object provide(DaemonControl ctrl) throws Throwable {
            return ClusterService.this.eventQueue.get(1000L);
        }

        @Override
        public void consume(Object event, DaemonControl ctrl) {
            if (event == null) {
                return;
            }
            ClusterEvent clusterEvent = (ClusterEvent)event;
            switch (clusterEvent.event) {
                case 1: {
                    try {
                        ClusterService.this.processChangeMain();
                    }
                    catch (Exception e) {
                        ClusterService.this.getLogger().write("CLST_00003", ClusterService.this.getServiceNameObject(), (Throwable)e);
                    }
                    break;
                }
                case 2: {
                    ClusterService.this.processChangeSub();
                    break;
                }
                case 3: {
                    ClusterService.this.processMemberInit(clusterEvent.newMembers);
                    break;
                }
                case 4: {
                    ClusterService.this.processMemberChange(clusterEvent.oldMembers, clusterEvent.newMembers);
                }
            }
        }

        @Override
        public void garbage() {
        }
    }

    protected class HeartBeater
    implements DaemonRunnable {
        protected long lastSendTime = -1L;
        protected int heartBeatFailedCount;
        protected GlobalUID targetMember;

        protected HeartBeater() {
        }

        @Override
        public boolean onStart() {
            return true;
        }

        @Override
        public boolean onStop() {
            return true;
        }

        @Override
        public boolean onSuspend() {
            return true;
        }

        @Override
        public boolean onResume() {
            return true;
        }

        @Override
        public Object provide(DaemonControl ctrl) throws Throwable {
            long processTime;
            long l = processTime = this.lastSendTime >= 0L ? System.currentTimeMillis() - this.lastSendTime : 0L;
            if (ClusterService.this.heartBeatInterval > processTime) {
                Thread.sleep(ClusterService.this.heartBeatInterval - processTime);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void consume(Object received, DaemonControl ctrl) throws Throwable {
            block49: {
                if (!ClusterService.this.isJoin) {
                    return;
                }
                this.lastSendTime = System.currentTimeMillis();
                if (ClusterService.this.isMain) {
                    ClusterService.this.sendMessage(5);
                }
                GlobalUID member = null;
                Object object = ClusterService.this.members;
                synchronized (object) {
                    if (ClusterService.this.isClient) {
                        if (ClusterService.this.members.size() > 0) {
                            member = (GlobalUID)ClusterService.this.members.get(0);
                        }
                    } else if (ClusterService.this.members.size() > 1) {
                        int index = ClusterService.this.members.indexOf(ClusterService.this.uid);
                        if (index == -1) {
                            return;
                        }
                        index = index == ClusterService.this.members.size() - 1 ? 0 : ++index;
                        member = (GlobalUID)ClusterService.this.members.get(index);
                        if (!member.equals(this.targetMember)) {
                            this.heartBeatFailedCount = 0;
                        }
                    }
                }
                if (ClusterService.this.isClient && member == null) {
                    object = ClusterService.this.addMonitor;
                    synchronized (object) {
                        ClusterService.this.addMonitor.initMonitor();
                        ClusterService.this.sendMessage(1);
                        try {
                            ClusterService.this.addMonitor.waitMonitor(ClusterService.this.addMemberResponseTimeout);
                        }
                        catch (InterruptedException e) {
                            return;
                        }
                    }
                }
                if (member != null && !member.equals(ClusterService.this.uid)) {
                    this.targetMember = member;
                    try {
                        boolean isNotify = false;
                        SynchronizeMonitor e = ClusterService.this.helloMonitor;
                        synchronized (e) {
                            ClusterService.this.helloTarget = member;
                            ClusterService.this.helloMonitor.initMonitor();
                            ClusterService.this.sendMessage(8, ClusterService.this.helloTarget);
                            try {
                                isNotify = ClusterService.this.helloMonitor.waitMonitor(ClusterService.this.heartBeatResponseTimeout);
                            }
                            catch (InterruptedException e2) {
                                return;
                            }
                        }
                        if (isNotify) {
                            this.heartBeatFailedCount = 0;
                            break block49;
                        }
                        ++this.heartBeatFailedCount;
                        if (this.heartBeatFailedCount - 1 < ClusterService.this.heartBeatRetryCount) break block49;
                        if (ClusterService.this.isClient) {
                            isNotify = false;
                            e = ClusterService.this.addMonitor;
                            synchronized (e) {
                                ClusterService.this.addMonitor.initMonitor();
                                ClusterService.this.sendMessage(1);
                                try {
                                    isNotify = ClusterService.this.addMonitor.waitMonitor(ClusterService.this.addMemberResponseTimeout);
                                }
                                catch (InterruptedException e3) {
                                    return;
                                }
                            }
                            if (isNotify) break block49;
                            boolean isMemberChange = false;
                            ArrayList tmpOldMembers = null;
                            ArrayList tmpNewMembers = null;
                            List list = ClusterService.this.members;
                            synchronized (list) {
                                if (ClusterService.this.members.size() != 0) {
                                    tmpOldMembers = new ArrayList(ClusterService.this.members);
                                    ClusterService.this.members.clear();
                                    tmpNewMembers = new ArrayList(ClusterService.this.members);
                                    isMemberChange = true;
                                }
                            }
                            if (isMemberChange) {
                                ClusterService.this.eventQueue.push(new ClusterEvent(4, tmpOldMembers, tmpNewMembers));
                            }
                            break block49;
                        }
                        if (ClusterService.this.isMainRequesting) {
                            Set isMemberChange = ClusterService.this.mainReqMembers;
                            synchronized (isMemberChange) {
                                ClusterService.this.mainReqMembers.remove(member);
                            }
                        }
                        boolean isMemberChange = false;
                        ArrayList tmpOldMembers = null;
                        ArrayList tmpNewMembers = null;
                        List list = ClusterService.this.members;
                        synchronized (list) {
                            if (ClusterService.this.members.contains(member)) {
                                tmpOldMembers = new ArrayList(ClusterService.this.members);
                                ClusterService.this.members.remove(member);
                                tmpNewMembers = new ArrayList(ClusterService.this.members);
                                isMemberChange = true;
                            }
                        }
                        if (ClusterService.this.isMain) {
                            ClusterService.this.sendMessage(2);
                        } else if (!ClusterService.this.isClient) {
                            ClusterService.this.sendMessage(10, member, null);
                        }
                        if (isMemberChange) {
                            ClusterService.this.eventQueue.push(new ClusterEvent(4, tmpOldMembers, tmpNewMembers));
                        }
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
            }
        }

        @Override
        public void garbage() {
        }
    }

    protected class MessageReceiver
    implements DaemonRunnable {
        private Map windowMap = new LinkedHashMap();

        protected MessageReceiver() {
        }

        @Override
        public boolean onStart() {
            return true;
        }

        @Override
        public boolean onStop() {
            return true;
        }

        @Override
        public boolean onSuspend() {
            return true;
        }

        @Override
        public boolean onResume() {
            return true;
        }

        @Override
        public Object provide(DaemonControl ctrl) throws Throwable {
            DatagramPacket packet = new DatagramPacket(new byte[ClusterService.this.receiveBufferSize], ClusterService.this.receiveBufferSize);
            try {
                ClusterService.this.socket.receive(packet);
                if (this.windowMap.size() != 0) {
                    long currentTime = System.currentTimeMillis();
                    Iterator itr = this.windowMap.values().iterator();
                    while (itr.hasNext()) {
                        Window window = (Window)itr.next();
                        if (currentTime - window.receiveTime <= ClusterService.this.lostTimeout) break;
                        itr.remove();
                    }
                }
                ByteArrayInputStream bais = new ByteArrayInputStream(packet.getData(), 0, packet.getLength());
                DataInputStream dis = new DataInputStream(bais);
                Window window = new Window();
                window.read(dis);
                if (window.isComplete()) {
                    return window;
                }
                Window tmp = (Window)this.windowMap.get(window);
                if (tmp == null) {
                    this.windowMap.put(window, window);
                    return null;
                }
                if (tmp.addWindow(window)) {
                    return this.windowMap.remove(tmp);
                }
                return null;
            }
            catch (SocketException e) {
                try {
                    ClusterService.this.connect();
                }
                catch (IOException e2) {
                    // empty catch block
                }
                return null;
            }
            catch (IOException e) {
                ClusterService.this.getLogger().write("CLST_00004", e);
                return null;
            }
        }

        @Override
        public void consume(Object received, DaemonControl ctrl) throws Throwable {
            Window window = (Window)received;
            if (window == null || !ClusterService.this.isJoin && !ClusterService.this.isJoining) {
                return;
            }
            ClusterService.this.handleMessage(new ByteArrayInputStream(window.getData()));
        }

        @Override
        public void garbage() {
        }
    }

    public static class GlobalUID
    extends jp.ossc.nimbus.util.net.GlobalUID {
        private static final long serialVersionUID = 2185113122895103559L;
        protected Serializable option;

        public GlobalUID(String localAddress, Serializable option) throws UnknownHostException {
            super(localAddress);
            this.option = option;
        }

        public Object getOption() {
            return this.option;
        }

        protected void setOption(Object opt) {
            this.option = (Serializable)opt;
        }
    }
}

