/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.keepalive;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import jp.ossc.nimbus.core.Service;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.core.ServiceNotFoundException;
import jp.ossc.nimbus.daemon.Daemon;
import jp.ossc.nimbus.daemon.DaemonControl;
import jp.ossc.nimbus.daemon.DaemonRunnable;
import jp.ossc.nimbus.service.keepalive.AbstractKeepAliveCheckerSelectorServiceMBean;
import jp.ossc.nimbus.service.keepalive.ClusterListener;
import jp.ossc.nimbus.service.keepalive.ClusterService;
import jp.ossc.nimbus.service.keepalive.KeepAliveChecker;
import jp.ossc.nimbus.service.keepalive.KeepAliveCheckerSelector;

public abstract class AbstractKeepAliveCheckerSelectorService
extends ServiceBase
implements KeepAliveCheckerSelector,
DaemonRunnable,
ClusterListener,
AbstractKeepAliveCheckerSelectorServiceMBean {
    private static final long serialVersionUID = 1452664941582086362L;
    protected ServiceName[] selectableCheckerServiceNames;
    protected List selectableCheckers;
    protected long checkInterval = -1L;
    protected List aliveCheckers;
    protected Daemon daemon;
    protected String aliveLogMessageId = "KACS_00001";
    protected String deadLogMessageId = "KACS_00002";
    protected boolean isOutputAliveLogMessage = true;
    protected boolean isOutputDeadLogMessage = true;
    protected boolean isKeepOrder = false;
    protected ServiceName clusterServiceName;
    protected ClusterService cluster;
    protected List clusterMembers;

    @Override
    public void setSelectableCheckerServiceNames(ServiceName[] names) {
        this.selectableCheckerServiceNames = names;
    }

    @Override
    public ServiceName[] getSelectableCheckerServiceNames() {
        return this.selectableCheckerServiceNames;
    }

    @Override
    public void setCheckInterval(long millis) {
        this.checkInterval = millis;
    }

    @Override
    public long getCheckInterval() {
        return this.checkInterval;
    }

    @Override
    public void setAliveLogMessageId(String id) {
        this.aliveLogMessageId = id;
    }

    @Override
    public String getAliveLogMessageId() {
        return this.aliveLogMessageId;
    }

    @Override
    public void setDeadLogMessageId(String id) {
        this.deadLogMessageId = id;
    }

    @Override
    public String getDeadLogMessageId() {
        return this.deadLogMessageId;
    }

    @Override
    public void setOutputAliveLogMessage(boolean isOutput) {
        this.isOutputAliveLogMessage = isOutput;
    }

    @Override
    public boolean isOutputAliveLogMessage() {
        return this.isOutputAliveLogMessage;
    }

    @Override
    public void setOutputDeadLogMessage(boolean isOutput) {
        this.isOutputDeadLogMessage = isOutput;
    }

    @Override
    public boolean isOutputDeadLogMessage() {
        return this.isOutputDeadLogMessage;
    }

    @Override
    public void setKeepOrder(boolean isKeep) {
        this.isKeepOrder = isKeep;
    }

    @Override
    public boolean isKeepOrder() {
        return this.isKeepOrder;
    }

    @Override
    public void setClusterServiceName(ServiceName name) {
        this.clusterServiceName = name;
    }

    @Override
    public ServiceName getClusterServiceName() {
        return this.clusterServiceName;
    }

    @Override
    public void createService() throws Exception {
        this.aliveCheckers = Collections.synchronizedList(new ArrayList());
        this.selectableCheckers = new ArrayList();
    }

    @Override
    public void startService() throws Exception {
        if (this.clusterServiceName != null) {
            this.cluster = (ClusterService)ServiceManagerFactory.getServiceObject(this.clusterServiceName);
            this.cluster.addClusterListener(this);
        } else {
            if (this.checkInterval > 0L) {
                this.daemon = new Daemon(this);
                this.daemon.setName("Nimbus KeepAliveCheckDaemon " + this.getServiceNameObject());
                this.daemon.start();
            }
            if (this.selectableCheckerServiceNames != null) {
                this.selectableCheckers.clear();
                for (int i = 0; i < this.selectableCheckerServiceNames.length; ++i) {
                    this.selectableCheckers.add(this.selectableCheckerServiceNames[i]);
                }
            }
        }
    }

    @Override
    public void stopService() throws Exception {
        if (this.cluster != null) {
            this.cluster.removeClusterListener(this);
            this.cluster = null;
        } else {
            if (this.daemon != null) {
                this.daemon.stop();
            }
            this.aliveCheckers.clear();
        }
    }

    @Override
    public void destroyService() throws Exception {
        this.aliveCheckers = null;
    }

    @Override
    public KeepAliveChecker[] getSelectableCheckers() {
        if (this.cluster != null) {
            List members = this.clusterMembers;
            ArrayList<Object> list = null;
            if (members == null || members.size() == 0) {
                return new KeepAliveChecker[0];
            }
            if (list == null) {
                list = new ArrayList<Object>();
            }
            int imax = members.size();
            for (int i = 0; i < imax; ++i) {
                ClusterService.GlobalUID uid = (ClusterService.GlobalUID)members.get(i);
                Object option = uid.getOption();
                if (option == null || !(option instanceof KeepAliveChecker)) continue;
                list.add(option);
            }
            return list.toArray(new KeepAliveChecker[list.size()]);
        }
        if (this.checkInterval <= 0L) {
            this.updateChekerStates(false);
        }
        ServiceName[] names = this.aliveCheckers.toArray(new ServiceName[this.aliveCheckers.size()]);
        ArrayList<KeepAliveChecker> list = new ArrayList<KeepAliveChecker>();
        KeepAliveChecker checker = null;
        for (int i = 0; i < names.length; ++i) {
            try {
                Service service = ServiceManagerFactory.getService(names[i]);
                if (service.getState() != 3) continue;
                checker = (KeepAliveChecker)ServiceManagerFactory.getServiceObject(names[i]);
                list.add(checker);
                continue;
            }
            catch (ServiceNotFoundException e) {
                // empty catch block
            }
        }
        return list.toArray(new KeepAliveChecker[list.size()]);
    }

    @Override
    public List getAliveCheckers() {
        if (this.cluster != null) {
            return this.clusterMembers;
        }
        return this.aliveCheckers;
    }

    protected void updateChekerStates(boolean init) {
        if (this.aliveCheckers == null) {
            return;
        }
        List<ServiceName> tmpAliveCheckers = Collections.synchronizedList(new ArrayList(this.aliveCheckers));
        for (int i = 0; i < this.selectableCheckerServiceNames.length; ++i) {
            try {
                Service service = ServiceManagerFactory.getService(this.selectableCheckerServiceNames[i]);
                KeepAliveChecker checker = (KeepAliveChecker)ServiceManagerFactory.getServiceObject(this.selectableCheckerServiceNames[i]);
                if (service.getState() == 3 && checker.isAlive()) {
                    if (tmpAliveCheckers.contains(this.selectableCheckerServiceNames[i])) continue;
                    tmpAliveCheckers.add(this.selectableCheckerServiceNames[i]);
                    if (init || !this.isOutputAliveLogMessage) continue;
                    this.getLogger().write(this.aliveLogMessageId, this.selectableCheckerServiceNames[i]);
                    continue;
                }
                if (!tmpAliveCheckers.contains(this.selectableCheckerServiceNames[i])) continue;
                tmpAliveCheckers.remove(this.selectableCheckerServiceNames[i]);
                if (init || !this.isOutputDeadLogMessage) continue;
                this.getLogger().write(this.deadLogMessageId, this.selectableCheckerServiceNames[i]);
                continue;
            }
            catch (ServiceNotFoundException e) {
                tmpAliveCheckers.remove(this.selectableCheckerServiceNames[i]);
            }
        }
        if (this.isKeepOrder) {
            Collections.sort(tmpAliveCheckers, new SelectableCheckerComparator());
        }
        this.aliveCheckers = tmpAliveCheckers;
    }

    @Override
    public void memberInit(Object myId, List members) {
        ArrayList tmpMembers = new ArrayList(members);
        if (this.isKeepOrder) {
            Collections.sort(tmpMembers);
        }
        this.clusterMembers = tmpMembers;
    }

    @Override
    public void memberChange(List oldMembers, List newMembers) {
        ArrayList addedMember = new ArrayList(newMembers);
        addedMember.removeAll(oldMembers);
        if (addedMember.size() != 0 && this.isOutputAliveLogMessage) {
            for (int i = 0; i < addedMember.size(); ++i) {
                this.getLogger().write(this.aliveLogMessageId, addedMember.get(i));
            }
        }
        ArrayList removedMember = new ArrayList(oldMembers);
        removedMember.removeAll(newMembers);
        if (removedMember.size() != 0 && this.isOutputDeadLogMessage) {
            int imax = removedMember.size();
            for (int i = 0; i < imax; ++i) {
                this.getLogger().write(this.deadLogMessageId, removedMember.get(i));
            }
        }
        ArrayList tmpMembers = new ArrayList(newMembers);
        if (this.isKeepOrder) {
            Collections.sort(tmpMembers);
        }
        this.clusterMembers = tmpMembers;
    }

    @Override
    public void changeMain() throws Exception {
    }

    @Override
    public void changeSub() {
    }

    @Override
    public boolean onStart() {
        this.updateChekerStates(true);
        return true;
    }

    @Override
    public boolean onStop() {
        return true;
    }

    @Override
    public boolean onSuspend() {
        return true;
    }

    @Override
    public boolean onResume() {
        return true;
    }

    @Override
    public Object provide(DaemonControl ctrl) throws Exception {
        if (this.checkInterval >= 0L) {
            Thread.sleep(this.checkInterval);
        } else {
            ctrl.setRunning(false);
        }
        return null;
    }

    @Override
    public void consume(Object paramObj, DaemonControl ctrl) throws Exception {
        this.updateChekerStates(false);
    }

    @Override
    public void garbage() {
    }

    protected class SelectableCheckerComparator
    implements Comparator {
        protected SelectableCheckerComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 == o2) {
                return 0;
            }
            if (AbstractKeepAliveCheckerSelectorService.this.selectableCheckers == null || AbstractKeepAliveCheckerSelectorService.this.selectableCheckers.size() == 0) {
                if (o1 != null && o1 instanceof Comparable) {
                    return ((Comparable)o1).compareTo(o2);
                }
                return 0;
            }
            int index1 = AbstractKeepAliveCheckerSelectorService.this.selectableCheckers.indexOf(o1);
            int index2 = AbstractKeepAliveCheckerSelectorService.this.selectableCheckers.indexOf(o2);
            return index1 - index2;
        }
    }
}

