/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.journal.editor;

import java.io.Serializable;
import jp.ossc.nimbus.beans.dataset.Record;
import jp.ossc.nimbus.beans.dataset.RecordList;
import jp.ossc.nimbus.service.journal.editor.BlockJournalEditorServiceBase;
import jp.ossc.nimbus.service.journal.editor.RecordListJournalEditorServiceMBean;
import jp.ossc.nimbus.service.journal.editorfinder.EditorFinder;

public class RecordListJournalEditorService
extends BlockJournalEditorServiceBase
implements RecordListJournalEditorServiceMBean,
Serializable {
    private static final long serialVersionUID = 5421734894920868194L;
    protected static final String RECORD_SCHEMA_HEADER = "RecordSchema : ";
    protected static final String RECORDS_HEADER = "Records : ";
    protected static final String NAME_HEADER = "Name : ";
    protected static final String MAX_SIZE_OVER = "...";
    protected static final String HEADER = "[RecordList]";
    protected boolean isOutputRecordListName = true;
    protected boolean isOutputRecordSchema = false;
    protected int maxSize = -1;

    public RecordListJournalEditorService() {
        this.setHeader(HEADER);
    }

    @Override
    public void setOutputRecordListName(boolean isOutput) {
        this.isOutputRecordListName = isOutput;
    }

    @Override
    public boolean isOutputRecordListName() {
        return this.isOutputRecordListName;
    }

    @Override
    public void setOutputRecordSchema(boolean isOutput) {
        this.isOutputRecordSchema = isOutput;
    }

    @Override
    public boolean isOutputRecordSchema() {
        return this.isOutputRecordSchema;
    }

    @Override
    public void setMaxSize(int max) {
        this.maxSize = max;
    }

    @Override
    public int getMaxSize() {
        return this.maxSize;
    }

    @Override
    protected boolean processBlock(EditorFinder finder, Object key, Object value, StringBuffer buf) {
        RecordList bean = (RecordList)value;
        boolean isMake = false;
        if (this.isOutputRecordListName()) {
            this.makeRecordListNameFormat(finder, key, bean, buf);
            isMake = true;
        }
        if (this.isOutputRecordSchema()) {
            if (isMake) {
                buf.append(this.getLineSeparator());
            }
            this.makeRecordSchemaFormat(finder, key, bean, buf);
            isMake = true;
        }
        if (isMake) {
            buf.append(this.getLineSeparator());
        }
        this.makeRecordsFormat(finder, key, bean, buf);
        isMake = true;
        return isMake;
    }

    protected StringBuffer makeRecordListNameFormat(EditorFinder finder, Object key, RecordList list, StringBuffer buf) {
        buf.append(NAME_HEADER).append(list.getName());
        return buf;
    }

    protected StringBuffer makeRecordSchemaFormat(EditorFinder finder, Object key, RecordList list, StringBuffer buf) {
        buf.append(RECORD_SCHEMA_HEADER);
        this.makeObjectFormat(finder, null, list.getRecordSchema(), buf);
        return buf;
    }

    protected StringBuffer makeRecordsFormat(EditorFinder finder, Object key, RecordList list, StringBuffer buf) {
        int max;
        buf.append(RECORDS_HEADER);
        int size = list.size();
        if (size == 0) {
            buf.append("null");
            return buf;
        }
        buf.append(this.getLineSeparator());
        StringBuffer subBuf = new StringBuffer();
        int n = max = this.maxSize > 0 && this.maxSize < size ? this.maxSize : size;
        for (int i = 0; i <= max; ++i) {
            if (i != max) {
                Record record = (Record)list.get(i);
                this.makeObjectFormat(finder, null, record, subBuf);
                subBuf.append(this.getLineSeparator());
                continue;
            }
            if (list.size() <= max) continue;
            subBuf.append(MAX_SIZE_OVER);
        }
        this.addIndent(subBuf);
        return buf.append(subBuf);
    }
}

