/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.journal.editor;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.Cookie;
import jp.ossc.nimbus.service.journal.editor.HttpServletResponseWrapperMapJournalEditorServiceMBean;
import jp.ossc.nimbus.service.journal.editor.JournalHttpServletResponseWrapper;
import jp.ossc.nimbus.service.journal.editor.ServletResponseMapJournalEditorService;
import jp.ossc.nimbus.service.journal.editorfinder.EditorFinder;

public class HttpServletResponseWrapperMapJournalEditorService
extends ServletResponseMapJournalEditorService
implements HttpServletResponseWrapperMapJournalEditorServiceMBean,
Serializable {
    private static final long serialVersionUID = -5062156173243815339L;
    private boolean isOutputContentLength = true;
    private boolean isOutputContent = true;
    private boolean isOutputHeaders = true;
    private boolean isOutputCookies = true;
    private boolean isOutputStatus = true;
    private boolean isOutputStatusMessage = true;
    private boolean isOutputIsSentError = true;
    private boolean isOutputRedirectLocation = true;
    private String[] secretHeaders;
    protected Set secretHeaderSet;
    private String[] enabledHeaders;
    protected Set enabledHeaderSet;
    private String[] secretCookies;
    protected Set secretCookieSet;
    private String[] enabledCookies;
    protected Set enabledCookieSet;

    @Override
    public void setOutputContentLength(boolean isOutput) {
        this.isOutputContentLength = isOutput;
    }

    @Override
    public boolean isOutputContentLength() {
        return this.isOutputContentLength;
    }

    @Override
    public void setOutputContent(boolean isOutput) {
        this.isOutputContent = isOutput;
    }

    @Override
    public boolean isOutputContent() {
        return this.isOutputContent;
    }

    @Override
    public void setOutputHeaders(boolean isOutput) {
        this.isOutputHeaders = isOutput;
    }

    @Override
    public boolean isOutputHeaders() {
        return this.isOutputHeaders;
    }

    @Override
    public void setOutputCookies(boolean isOutput) {
        this.isOutputCookies = isOutput;
    }

    @Override
    public boolean isOutputCookies() {
        return this.isOutputCookies;
    }

    @Override
    public void setOutputStatus(boolean isOutput) {
        this.isOutputStatus = isOutput;
    }

    @Override
    public boolean isOutputStatus() {
        return this.isOutputStatus;
    }

    @Override
    public void setOutputStatusMessage(boolean isOutput) {
        this.isOutputStatusMessage = isOutput;
    }

    @Override
    public boolean isOutputStatusMessage() {
        return this.isOutputStatusMessage;
    }

    @Override
    public void setOutputIsSentError(boolean isOutput) {
        this.isOutputIsSentError = isOutput;
    }

    @Override
    public boolean isOutputIsSentError() {
        return this.isOutputIsSentError;
    }

    @Override
    public void setOutputRedirectLocation(boolean isOutput) {
        this.isOutputRedirectLocation = isOutput;
    }

    @Override
    public boolean isOutputRedirectLocation() {
        return this.isOutputRedirectLocation;
    }

    @Override
    public void setSecretHeaders(String[] names) {
        this.secretHeaders = names;
    }

    @Override
    public String[] getSecretHeaders() {
        return this.secretHeaders;
    }

    @Override
    public void setEnabledHeaders(String[] names) {
        this.enabledHeaders = names;
    }

    @Override
    public String[] getEnabledHeaders() {
        return this.enabledHeaders;
    }

    @Override
    public void setSecretCookies(String[] names) {
        this.secretCookies = names;
    }

    @Override
    public String[] getSecretCookies() {
        return this.secretCookies;
    }

    @Override
    public void setEnabledCookies(String[] names) {
        this.enabledCookies = names;
    }

    @Override
    public String[] getEnabledCookies() {
        return this.enabledCookies;
    }

    @Override
    public void createService() throws Exception {
        super.createService();
        this.secretHeaderSet = new HashSet();
        this.enabledHeaderSet = new HashSet();
        this.secretCookieSet = new HashSet();
        this.enabledCookieSet = new HashSet();
    }

    @Override
    public void startService() throws Exception {
        int i;
        super.startService();
        if (this.secretHeaders != null) {
            for (i = 0; i < this.secretHeaders.length; ++i) {
                this.secretHeaderSet.add(this.secretHeaders[i]);
            }
        }
        if (this.enabledHeaders != null) {
            for (i = 0; i < this.enabledHeaders.length; ++i) {
                this.enabledHeaderSet.add(this.enabledHeaders[i]);
            }
        }
        if (this.secretCookies != null) {
            for (i = 0; i < this.secretCookies.length; ++i) {
                this.secretCookieSet.add(this.secretCookies[i]);
            }
        }
        if (this.enabledCookies != null) {
            for (i = 0; i < this.enabledCookies.length; ++i) {
                this.enabledCookieSet.add(this.enabledCookies[i]);
            }
        }
    }

    @Override
    public void stopService() throws Exception {
        super.stopService();
        this.secretHeaderSet.clear();
        this.enabledHeaderSet.clear();
        this.secretCookieSet.clear();
        this.enabledCookieSet.clear();
    }

    @Override
    public void destroyService() throws Exception {
        super.destroyService();
        this.secretHeaderSet = null;
        this.enabledHeaderSet = null;
        this.secretCookieSet = null;
        this.enabledCookieSet = null;
    }

    @Override
    public Map toMap(EditorFinder finder, Object key, Object value) {
        Map result = super.toMap(finder, key, value);
        JournalHttpServletResponseWrapper response = (JournalHttpServletResponseWrapper)value;
        if (this.isOutputContentLength()) {
            this.makeContentLengthFormat(finder, key, response, result);
        }
        if (this.isOutputContent()) {
            this.makeContentFormat(finder, key, response, result);
        }
        if (this.isOutputHeaders()) {
            this.makeHeadersFormat(finder, key, response, result);
        }
        if (this.isOutputCookies()) {
            this.makeCookiesFormat(finder, key, response, result);
        }
        if (this.isOutputStatus()) {
            this.makeStatusFormat(finder, key, response, result);
        }
        if (this.isOutputStatusMessage()) {
            this.makeStatusMessageFormat(finder, key, response, result);
        }
        if (this.isOutputIsSentError()) {
            this.makeIsSentErrorFormat(finder, key, response, result);
        }
        if (this.isOutputRedirectLocation()) {
            this.makeRedirectLocationFormat(finder, key, response, result);
        }
        return result;
    }

    protected Map makeContentLengthFormat(EditorFinder finder, Object key, JournalHttpServletResponseWrapper response, Map map) {
        map.put("ContentLength", new Integer(response.getContentLength()));
        return map;
    }

    protected Map makeContentFormat(EditorFinder finder, Object key, JournalHttpServletResponseWrapper response, Map map) {
        map.put("Content", response.getContent());
        return map;
    }

    protected Map makeHeadersFormat(EditorFinder finder, Object key, JournalHttpServletResponseWrapper response, Map map) {
        Iterator headerNames = response.getHeaderNames();
        if (!headerNames.hasNext()) {
            return map;
        }
        HashMap<String, Object> subMap = new HashMap<String, Object>();
        while (headerNames.hasNext()) {
            String name = (String)headerNames.next();
            if (!this.enabledHeaderSet.isEmpty() && !this.enabledHeaderSet.contains(name)) continue;
            if (this.secretHeaderSet.contains(name)) {
                subMap.put(name, null);
                continue;
            }
            subMap.put(name, this.makeObjectFormat(finder, key, response.getHeaders(name)));
        }
        map.put("HTTPHeader", this.makeObjectFormat(finder, key, subMap));
        return map;
    }

    protected Map makeCookiesFormat(EditorFinder finder, Object key, JournalHttpServletResponseWrapper response, Map map) {
        Cookie[] cookies = response.getCookies();
        if (cookies == null || cookies.length == 0) {
            return map;
        }
        HashMap<String, Object> subMap = new HashMap<String, Object>();
        for (int i = 0; i < cookies.length; ++i) {
            String name = cookies[i].getName();
            if (!this.enabledCookieSet.isEmpty() && !this.enabledCookieSet.contains(name)) continue;
            if (this.secretCookieSet.contains(name)) {
                subMap.put(name, null);
                continue;
            }
            subMap.put(name, this.makeObjectFormat(finder, key, cookies[i].getValue()));
        }
        map.put("Cookie", this.makeObjectFormat(finder, key, subMap));
        return map;
    }

    protected Map makeStatusFormat(EditorFinder finder, Object key, JournalHttpServletResponseWrapper response, Map map) {
        map.put("Status", new Integer(response.getStatus()));
        return map;
    }

    protected Map makeStatusMessageFormat(EditorFinder finder, Object key, JournalHttpServletResponseWrapper response, Map map) {
        map.put("StatusMessage", response.getStatusMessage());
        return map;
    }

    protected Map makeIsSentErrorFormat(EditorFinder finder, Object key, JournalHttpServletResponseWrapper response, Map map) {
        map.put("IsSentError", response.isSentError());
        return map;
    }

    protected Map makeRedirectLocationFormat(EditorFinder finder, Object key, JournalHttpServletResponseWrapper response, Map map) {
        map.put("RedirectLocation", response.getRedirectLocation());
        return map;
    }
}

