/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.journal.editor;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.servlet.http.Cookie;
import jp.ossc.nimbus.service.journal.editor.HttpServletResponseWrapperJournalEditorServiceMBean;
import jp.ossc.nimbus.service.journal.editor.JournalHttpServletResponseWrapper;
import jp.ossc.nimbus.service.journal.editor.ServletResponseJournalEditorService;
import jp.ossc.nimbus.service.journal.editorfinder.EditorFinder;

public class HttpServletResponseWrapperJournalEditorService
extends ServletResponseJournalEditorService
implements HttpServletResponseWrapperJournalEditorServiceMBean,
Serializable {
    private static final long serialVersionUID = 308252305061474467L;
    private static final String CONTENT_LENGTH_HEADER = "Content Length : ";
    private static final String CONTENT_HEADER = "Content : ";
    private static final String HTTP_HEADER_HEADER = "HTTP Header : ";
    private static final String COOKIE_HEADER = "Cookie : ";
    private static final String STATUS_HEADER = "Status : ";
    private static final String STATUS_MESSAGE_HEADER = "Status Message : ";
    private static final String IS_SENT_ERROR_HEADER = "Is Sent Error : ";
    private static final String REDIRECT_LOCATION_HEADER = "Redirect Location : ";
    private static final String HEADER = "[HttpServletResponse]";
    private static final String HEADER_SEPARATOR = " = ";
    private static final String HEADER_VALUE_SEPARATOR = ", ";
    private static final String COOKIE_SEPARATOR = " = ";
    private static final String COOKIE_ATTR_SEPARATOR = "; ";
    private static final String COOKIE_COMMENT = "Comment";
    private static final String COOKIE_DOMAIN = "Domain";
    private static final String COOKIE_MAX_AGE = "MaxAge";
    private static final String COOKIE_PATH = "Path";
    private static final String COOKIE_SECURE = "Secure";
    private static final String COOKIE_VERSION = "Version";
    private static final String DEFAULT_SECRET_STRING = "******";
    private boolean isOutputContentLength = true;
    private boolean isOutputContent = true;
    private boolean isOutputHeaders = true;
    private boolean isOutputCookies = true;
    private boolean isOutputStatus = true;
    private boolean isOutputStatusMessage = true;
    private boolean isOutputIsSentError = true;
    private boolean isOutputRedirectLocation = true;
    private String secretString = "******";
    private String[] secretHeaders;
    protected Set secretHeaderSet;
    private String[] enabledHeaders;
    protected Set enabledHeaderSet;
    private String[] secretCookies;
    protected Set secretCookieSet;
    private String[] enabledCookies;
    protected Set enabledCookieSet;

    public HttpServletResponseWrapperJournalEditorService() {
        this.setHeader(HEADER);
    }

    @Override
    public void setOutputContentLength(boolean isOutput) {
        this.isOutputContentLength = isOutput;
    }

    @Override
    public boolean isOutputContentLength() {
        return this.isOutputContentLength;
    }

    @Override
    public void setOutputContent(boolean isOutput) {
        this.isOutputContent = isOutput;
    }

    @Override
    public boolean isOutputContent() {
        return this.isOutputContent;
    }

    @Override
    public void setOutputHeaders(boolean isOutput) {
        this.isOutputHeaders = isOutput;
    }

    @Override
    public boolean isOutputHeaders() {
        return this.isOutputHeaders;
    }

    @Override
    public void setOutputCookies(boolean isOutput) {
        this.isOutputCookies = isOutput;
    }

    @Override
    public boolean isOutputCookies() {
        return this.isOutputCookies;
    }

    @Override
    public void setOutputStatus(boolean isOutput) {
        this.isOutputStatus = isOutput;
    }

    @Override
    public boolean isOutputStatus() {
        return this.isOutputStatus;
    }

    @Override
    public void setOutputStatusMessage(boolean isOutput) {
        this.isOutputStatusMessage = isOutput;
    }

    @Override
    public boolean isOutputStatusMessage() {
        return this.isOutputStatusMessage;
    }

    @Override
    public void setOutputIsSentError(boolean isOutput) {
        this.isOutputIsSentError = isOutput;
    }

    @Override
    public boolean isOutputIsSentError() {
        return this.isOutputIsSentError;
    }

    @Override
    public void setOutputRedirectLocation(boolean isOutput) {
        this.isOutputRedirectLocation = isOutput;
    }

    @Override
    public boolean isOutputRedirectLocation() {
        return this.isOutputRedirectLocation;
    }

    @Override
    public void setSecretString(String str) {
        this.secretString = str;
    }

    @Override
    public String getSecretString() {
        return this.secretString;
    }

    @Override
    public void setSecretHeaders(String[] names) {
        this.secretHeaders = names;
    }

    @Override
    public String[] getSecretHeaders() {
        return this.secretHeaders;
    }

    @Override
    public void setEnabledHeaders(String[] names) {
        this.enabledHeaders = names;
    }

    @Override
    public String[] getEnabledHeaders() {
        return this.enabledHeaders;
    }

    @Override
    public void setSecretCookies(String[] names) {
        this.secretCookies = names;
    }

    @Override
    public String[] getSecretCookies() {
        return this.secretCookies;
    }

    @Override
    public void setEnabledCookies(String[] names) {
        this.enabledCookies = names;
    }

    @Override
    public String[] getEnabledCookies() {
        return this.enabledCookies;
    }

    @Override
    public void createService() throws Exception {
        super.createService();
        this.secretHeaderSet = new HashSet();
        this.enabledHeaderSet = new HashSet();
        this.secretCookieSet = new HashSet();
        this.enabledCookieSet = new HashSet();
    }

    @Override
    public void startService() throws Exception {
        int i;
        super.startService();
        if (this.secretHeaders != null) {
            for (i = 0; i < this.secretHeaders.length; ++i) {
                this.secretHeaderSet.add(this.secretHeaders[i]);
            }
        }
        if (this.enabledHeaders != null) {
            for (i = 0; i < this.enabledHeaders.length; ++i) {
                this.enabledHeaderSet.add(this.enabledHeaders[i]);
            }
        }
        if (this.secretCookies != null) {
            for (i = 0; i < this.secretCookies.length; ++i) {
                this.secretCookieSet.add(this.secretCookies[i]);
            }
        }
        if (this.enabledCookies != null) {
            for (i = 0; i < this.enabledCookies.length; ++i) {
                this.enabledCookieSet.add(this.enabledCookies[i]);
            }
        }
    }

    @Override
    public void stopService() throws Exception {
        super.stopService();
        this.secretHeaderSet.clear();
        this.enabledHeaderSet.clear();
        this.secretCookieSet.clear();
        this.enabledCookieSet.clear();
    }

    @Override
    public void destroyService() throws Exception {
        super.destroyService();
        this.secretHeaderSet = null;
        this.enabledHeaderSet = null;
        this.secretCookieSet = null;
        this.enabledCookieSet = null;
    }

    @Override
    protected boolean processBlock(EditorFinder finder, Object key, Object value, StringBuffer buf) {
        boolean isMake = super.processBlock(finder, key, value, buf);
        JournalHttpServletResponseWrapper response = (JournalHttpServletResponseWrapper)value;
        if (this.isOutputContentLength()) {
            if (isMake) {
                buf.append(this.getLineSeparator());
            }
            this.makeContentLengthFormat(finder, key, response, buf);
            isMake = true;
        }
        if (this.isOutputContent()) {
            if (isMake) {
                buf.append(this.getLineSeparator());
            }
            this.makeContentFormat(finder, key, response, buf);
            isMake = true;
        }
        if (this.isOutputHeaders()) {
            if (isMake) {
                buf.append(this.getLineSeparator());
            }
            this.makeHeadersFormat(finder, key, response, buf);
            isMake = true;
        }
        if (this.isOutputCookies()) {
            if (isMake) {
                buf.append(this.getLineSeparator());
            }
            this.makeCookiesFormat(finder, key, response, buf);
            isMake = true;
        }
        if (this.isOutputStatus()) {
            if (isMake) {
                buf.append(this.getLineSeparator());
            }
            this.makeStatusFormat(finder, key, response, buf);
            isMake = true;
        }
        if (this.isOutputStatusMessage()) {
            if (isMake) {
                buf.append(this.getLineSeparator());
            }
            this.makeStatusMessageFormat(finder, key, response, buf);
            isMake = true;
        }
        if (this.isOutputIsSentError()) {
            if (isMake) {
                buf.append(this.getLineSeparator());
            }
            this.makeIsSentErrorFormat(finder, key, response, buf);
            isMake = true;
        }
        if (this.isOutputRedirectLocation()) {
            if (isMake) {
                buf.append(this.getLineSeparator());
            }
            this.makeRedirectLocationFormat(finder, key, response, buf);
            isMake = true;
        }
        return isMake;
    }

    protected StringBuffer makeContentLengthFormat(EditorFinder finder, Object key, JournalHttpServletResponseWrapper response, StringBuffer buf) {
        return buf.append(CONTENT_LENGTH_HEADER).append(response.getContentLength());
    }

    protected StringBuffer makeContentFormat(EditorFinder finder, Object key, JournalHttpServletResponseWrapper response, StringBuffer buf) {
        buf.append(CONTENT_HEADER);
        String content = response.getContent();
        if (content == null) {
            buf.append("null");
            return buf;
        }
        buf.append(this.getLineSeparator());
        StringBuffer subBuf = new StringBuffer(content);
        this.addIndent(subBuf);
        return buf.append(subBuf);
    }

    protected StringBuffer makeHeadersFormat(EditorFinder finder, Object key, JournalHttpServletResponseWrapper response, StringBuffer buf) {
        buf.append(HTTP_HEADER_HEADER);
        Iterator headerNames = response.getHeaderNames();
        if (!headerNames.hasNext()) {
            buf.append("null");
            return buf;
        }
        buf.append(this.getLineSeparator());
        StringBuffer subBuf = new StringBuffer();
        while (headerNames.hasNext()) {
            String name = (String)headerNames.next();
            if (!this.enabledHeaderSet.isEmpty() && !this.enabledHeaderSet.contains(name)) continue;
            subBuf.append(name);
            subBuf.append(" = ");
            if (this.secretHeaderSet.contains(name)) {
                subBuf.append(this.getSecretString());
            } else {
                String[] values = response.getHeaders(name);
                int max = values.length;
                for (int i = 0; i < max; ++i) {
                    subBuf.append(values[i]);
                    if (i == max - 1) continue;
                    subBuf.append(HEADER_VALUE_SEPARATOR);
                }
            }
            if (!headerNames.hasNext()) continue;
            subBuf.append(this.getLineSeparator());
        }
        this.addIndent(subBuf);
        return buf.append(subBuf);
    }

    protected StringBuffer makeCookiesFormat(EditorFinder finder, Object key, JournalHttpServletResponseWrapper response, StringBuffer buf) {
        buf.append(COOKIE_HEADER);
        Cookie[] cookies = response.getCookies();
        if (cookies == null || cookies.length == 0) {
            buf.append("null");
            return buf;
        }
        buf.append(this.getLineSeparator());
        StringBuffer subBuf = new StringBuffer();
        for (int i = 0; i < cookies.length; ++i) {
            if (!this.enabledCookieSet.isEmpty() && !this.enabledCookieSet.contains(this.name)) continue;
            subBuf.append(cookies[i].getName());
            subBuf.append(" = ");
            if (this.secretCookieSet.contains(cookies[i].getName())) {
                subBuf.append(this.getSecretString());
            } else {
                subBuf.append(cookies[i].getValue());
            }
            subBuf.append(COOKIE_ATTR_SEPARATOR).append(COOKIE_COMMENT).append(" = ").append(cookies[i].getComment());
            subBuf.append(COOKIE_ATTR_SEPARATOR).append(COOKIE_DOMAIN).append(" = ").append(cookies[i].getDomain());
            subBuf.append(COOKIE_ATTR_SEPARATOR).append(COOKIE_MAX_AGE).append(" = ").append(cookies[i].getMaxAge());
            subBuf.append(COOKIE_ATTR_SEPARATOR).append(COOKIE_PATH).append(" = ").append(cookies[i].getPath());
            subBuf.append(COOKIE_ATTR_SEPARATOR).append(COOKIE_SECURE).append(" = ").append(cookies[i].getSecure());
            subBuf.append(COOKIE_ATTR_SEPARATOR).append(COOKIE_VERSION).append(" = ").append(cookies[i].getVersion());
            if (i == cookies.length - 1) continue;
            subBuf.append(this.getLineSeparator());
        }
        this.addIndent(subBuf);
        return buf.append(subBuf);
    }

    protected StringBuffer makeStatusFormat(EditorFinder finder, Object key, JournalHttpServletResponseWrapper response, StringBuffer buf) {
        return buf.append(STATUS_HEADER).append(response.getStatus());
    }

    protected StringBuffer makeStatusMessageFormat(EditorFinder finder, Object key, JournalHttpServletResponseWrapper response, StringBuffer buf) {
        return buf.append(STATUS_MESSAGE_HEADER).append(response.getStatusMessage());
    }

    protected StringBuffer makeIsSentErrorFormat(EditorFinder finder, Object key, JournalHttpServletResponseWrapper response, StringBuffer buf) {
        return buf.append(IS_SENT_ERROR_HEADER).append(response.isSentError());
    }

    protected StringBuffer makeRedirectLocationFormat(EditorFinder finder, Object key, JournalHttpServletResponseWrapper response, StringBuffer buf) {
        return buf.append(REDIRECT_LOCATION_HEADER).append(response.getRedirectLocation());
    }
}

