/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.graph;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jp.ossc.nimbus.service.graph.ChartCondition;
import jp.ossc.nimbus.service.graph.PlotCondition;

public class ChartConditionImpl
implements ChartCondition,
Serializable {
    private static final long serialVersionUID = 3418497509927014515L;
    private Map plotConditionMap;
    private List plotConditionList;
    private String title;
    private String titleFontName;
    private int titleFontStyle = -1;
    private int titleFontSize = -1;
    private String defaultSubtitleFontName;
    private int defaultSubtitleFontStyle = Integer.MIN_VALUE;
    private int defaultSubtitleFontSize = Integer.MIN_VALUE;
    private Map subtitleFontNameMap;
    private Map subtitleFontStyleMap;
    private Map subtitleFontSizeMap;

    @Override
    public void addPlotCondition(PlotCondition plotCondition) {
        if (this.plotConditionMap == null) {
            this.plotConditionMap = new HashMap();
        }
        if (this.plotConditionList == null) {
            this.plotConditionList = new ArrayList();
        }
        List<PlotCondition> conds = null;
        if (this.plotConditionMap.containsKey(plotCondition.getName())) {
            conds = (List)this.plotConditionMap.get(plotCondition.getName());
        } else {
            conds = new ArrayList();
            this.plotConditionMap.put(plotCondition.getName(), conds);
        }
        conds.add(plotCondition);
        this.plotConditionList.add(plotCondition);
    }

    @Override
    public PlotCondition[] getPlotConditions(String plotName) {
        if (this.plotConditionMap == null) {
            return new PlotCondition[0];
        }
        if (this.plotConditionMap.containsKey(plotName)) {
            List conds = (List)this.plotConditionMap.get(plotName);
            return conds.toArray(new PlotCondition[conds.size()]);
        }
        return new PlotCondition[0];
    }

    @Override
    public PlotCondition[] getPlotConditions() {
        if (this.plotConditionList == null) {
            return new PlotCondition[0];
        }
        return this.plotConditionList.toArray(new PlotCondition[this.plotConditionList.size()]);
    }

    @Override
    public Iterator getPlotNames() {
        return this.plotConditionMap.keySet().iterator();
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitleFontName(String name) {
        this.titleFontName = name;
    }

    @Override
    public String getTitleFontName() {
        return this.titleFontName;
    }

    @Override
    public void setTitleFontStyle(int style) {
        this.titleFontStyle = style;
    }

    @Override
    public int getTitleFontStyle() {
        return this.titleFontStyle;
    }

    @Override
    public void setTitleFontSize(int size) {
        this.titleFontSize = size;
    }

    @Override
    public int getTitleFontSize() {
        return this.titleFontSize;
    }

    @Override
    public void setDefaultSubtitleFontName(String name) {
        this.defaultSubtitleFontName = name;
    }

    @Override
    public String getDefaultSubtitleFontName() {
        return this.defaultSubtitleFontName;
    }

    @Override
    public void setDefaultSubtitleFontStyle(int style) {
        this.defaultSubtitleFontStyle = style;
    }

    @Override
    public int getDefaultSubtitleFontStyle() {
        return this.defaultSubtitleFontStyle;
    }

    @Override
    public void setDefaultSubtitleFontSize(int size) {
        this.defaultSubtitleFontSize = size;
    }

    @Override
    public int getDefaultSubtitleFontSize() {
        return this.defaultSubtitleFontSize;
    }

    @Override
    public void setSubtitleFontName(int index, String name) {
        if (this.subtitleFontNameMap == null) {
            this.subtitleFontNameMap = new HashMap();
        }
        this.subtitleFontNameMap.put(new Integer(index), name);
    }

    @Override
    public String getSubtitleFontName(int index) {
        if (this.subtitleFontNameMap == null) {
            return null;
        }
        Integer key = new Integer(index);
        if (this.subtitleFontNameMap.containsKey(key)) {
            return (String)this.subtitleFontNameMap.get(key);
        }
        return null;
    }

    @Override
    public void setSubtitleFontStyle(int index, int style) {
        if (this.subtitleFontStyleMap == null) {
            this.subtitleFontStyleMap = new HashMap();
        }
        this.subtitleFontStyleMap.put(new Integer(index), new Integer(style));
    }

    @Override
    public int getSubtitleFontStyle(int index) {
        if (this.subtitleFontStyleMap == null) {
            return Integer.MIN_VALUE;
        }
        Integer key = new Integer(index);
        if (this.subtitleFontStyleMap.containsKey(key)) {
            return (Integer)this.subtitleFontStyleMap.get(key);
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public void setSubtitleFontSize(int index, int size) {
        if (this.subtitleFontSizeMap == null) {
            this.subtitleFontSizeMap = new HashMap();
        }
        this.subtitleFontSizeMap.put(new Integer(index), new Integer(size));
    }

    @Override
    public int getSubtitleFontSize(int index) {
        if (this.subtitleFontSizeMap == null) {
            return Integer.MIN_VALUE;
        }
        Integer key = new Integer(index);
        if (this.subtitleFontSizeMap.containsKey(key)) {
            return (Integer)this.subtitleFontSizeMap.get(key);
        }
        return Integer.MIN_VALUE;
    }
}

