/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.ga;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.math.BigDecimal;
import java.util.Random;
import jp.ossc.nimbus.service.ga.AbstractGene;
import jp.ossc.nimbus.service.ga.Gene;

public class DoubleGene
extends AbstractGene {
    public static final int CROSSOVER_SINGLE_POINT = 1;
    public static final int CROSSOVER_TWO_POINT = 2;
    public static final int CROSSOVER_UNIFORM_POINT = 3;
    public static final int CROSSOVER_ALL_POINT = 4;
    public static final int CROSSOVER_AVERAGE = 5;
    public static final int CROSSOVER_RANDOM_RANGE = 6;
    public static final int MUTATE_SINGLE = 1;
    public static final int MUTATE_UNIFORM = 2;
    protected double maxValue = Double.MAX_VALUE;
    protected double minValue = -1.7976931348623157E308;
    protected float randomRangeMargin = 0.0f;

    public DoubleGene() {
        this.crossoverType = 6;
        this.mutateType = 2;
    }

    public void setMaxValue(double max) {
        this.maxValue = max;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public void setMinValue(double min) {
        this.minValue = min;
    }

    public double getMinValue() {
        return this.minValue;
    }

    public void setRandomRangeMargin(float margin) {
        this.randomRangeMargin = margin;
    }

    public float getRandomRangeMargin() {
        return this.randomRangeMargin;
    }

    @Override
    public void random(Random random) {
        this.setValue(new Double(this.randomValue(random)));
    }

    protected double randomValue(Random random) {
        double result = 0.0;
        if (this.maxValue == this.minValue) {
            result = this.maxValue;
        } else if (this.maxValue >= 0.0 && this.minValue >= 0.0) {
            double range = this.maxValue - this.minValue;
            result = random.nextDouble() * range + this.minValue;
        } else if (this.maxValue < 0.0 && this.minValue < 0.0) {
            double range = Math.abs(this.maxValue - this.minValue);
            result = -(random.nextDouble() * range) + this.maxValue;
        } else {
            boolean isPlus = random.nextBoolean();
            result = isPlus ? random.nextDouble() * this.maxValue : random.nextDouble() * this.minValue;
        }
        return result;
    }

    @Override
    public void crossover(Random random, Gene gene) {
        double result = 0.0;
        switch (this.crossoverType) {
            case 1: {
                result = this.crossoverBySinglePoint(random, gene);
                break;
            }
            case 2: {
                result = this.crossoverByTwoPoint(random, gene);
                break;
            }
            case 4: {
                result = this.crossoverByAllPoint(random, gene);
                break;
            }
            case 5: {
                result = this.crossoverByAverage(random, gene);
                break;
            }
            case 3: {
                result = this.crossoverByUniformPoint(random, gene);
                break;
            }
            default: {
                result = this.crossoverByRandomRange(random, gene);
            }
        }
        this.setValue(new Double(this.mutate(random, result)));
        this.setCrossover(true);
    }

    protected int getMaxBitIndex(double val1, double val2) {
        double val = Math.max(Math.abs(val1), Math.abs(val2));
        long tmpValue = Double.doubleToLongBits(val);
        for (int i = 0; i < 63; ++i) {
            tmpValue <<= i + 1;
            if ((double)(tmpValue >>= i + 1) == val) continue;
            return i + 1;
        }
        return 32;
    }

    protected double crossoverBySinglePoint(Random random, Gene gene) {
        double result;
        double doubleVal1 = (Double)this.value;
        double doubleVal2 = (Double)gene.getValue();
        int maxBitIndex = this.getMaxBitIndex(doubleVal1, doubleVal2);
        int crossoverPoint = 0;
        if (maxBitIndex >= 63) {
            return (Double)gene.getValue();
        }
        crossoverPoint = maxBitIndex == 62 ? 63 : random.nextInt(64 - maxBitIndex - 1) + 1;
        long val1 = Double.doubleToLongBits(doubleVal1);
        long val2 = Double.doubleToLongBits(doubleVal2);
        val1 >>= crossoverPoint;
        val1 <<= crossoverPoint;
        boolean isMinus = Math.abs(val2) != val2;
        val2 <<= 31 - crossoverPoint;
        val2 >>>= 31 - crossoverPoint;
        if (isMinus) {
            val2 = -val2;
        }
        if ((result = Double.longBitsToDouble(val1 | val2)) > this.maxValue || result < this.minValue) {
            result = this.crossoverBySinglePoint(random, gene);
        }
        return result;
    }

    protected double crossoverByTwoPoint(Random random, Gene gene) {
        double doubleVal1 = (Double)this.value;
        double doubleVal2 = (Double)gene.getValue();
        int maxBitIndex = this.getMaxBitIndex(doubleVal1, doubleVal2);
        int crossoverPoint1 = 0;
        int crossoverPoint2 = 0;
        if (maxBitIndex >= 63) {
            return (Double)gene.getValue();
        }
        if (maxBitIndex == 62) {
            return this.crossoverBySinglePoint(random, gene);
        }
        if (maxBitIndex == 61) {
            crossoverPoint1 = 2;
            crossoverPoint2 = 1;
        } else {
            crossoverPoint1 = random.nextInt(64 - maxBitIndex - 2) + 2;
            crossoverPoint2 = random.nextInt(crossoverPoint1 - 1) + 1;
        }
        long mask = 0L;
        for (int i = 64; i >= 1; --i) {
            if (i > crossoverPoint1 || i <= crossoverPoint2) {
                mask |= 1L;
            }
            if (i == 1) continue;
            mask <<= 1;
        }
        long val1 = Double.doubleToLongBits(doubleVal1);
        long val2 = Double.doubleToLongBits(doubleVal2);
        double result = Double.longBitsToDouble((val1 &= mask) | (val2 &= mask ^ 0xFFFFFFFFFFFFFFFFL));
        if (result > this.maxValue || result < this.minValue) {
            result = this.crossoverByTwoPoint(random, gene);
        }
        return result;
    }

    protected double crossoverByUniformPoint(Random random, Gene gene) {
        long val2;
        double doubleVal2;
        double doubleVal1 = (Double)this.value;
        int maxBitIndex = this.getMaxBitIndex(doubleVal1, doubleVal2 = ((Double)gene.getValue()).doubleValue());
        if (maxBitIndex >= 63) {
            return (Double)gene.getValue();
        }
        long mask = 0L;
        for (int i = 64; i >= 1; --i) {
            if (i <= 64 - maxBitIndex && random.nextBoolean()) {
                mask |= 1L;
            }
            if (i == 1) continue;
            mask <<= 1;
        }
        long val1 = Double.doubleToLongBits(doubleVal1);
        double result = Double.longBitsToDouble(val1 & (mask ^ 0xFFFFFFFFFFFFFFFFL) | (val2 = Double.doubleToLongBits(doubleVal2)) & mask);
        if (result > this.maxValue || result < this.minValue) {
            result = this.crossoverByUniformPoint(random, gene);
        }
        return result;
    }

    protected double crossoverByAllPoint(Random random, Gene gene) {
        return (Double)gene.getValue();
    }

    protected double crossoverByAverage(Random random, Gene gene) {
        BigDecimal val1 = new BigDecimal((Double)this.value);
        BigDecimal val2 = new BigDecimal((Double)gene.getValue());
        BigDecimal sum = val1.add(val2);
        BigDecimal result = sum.divide(new BigDecimal(2.0), 6);
        return result.doubleValue();
    }

    protected double crossoverByRandomRange(Random random, Gene gene) {
        double val1 = (Double)this.value;
        double val2 = (Double)gene.getValue();
        double range = Math.abs(val1 - val2);
        double margin = this.randomRangeMargin == 0.0f ? 0.0 : range * (double)this.randomRangeMargin;
        double result = random.nextDouble() * (range + margin) + Math.min(val1, val2) - margin / 2.0;
        if (result > this.maxValue) {
            result = this.maxValue;
        } else if (result < this.minValue) {
            result = this.minValue;
        }
        return result;
    }

    protected double mutate(Random random, double val) {
        double result = val;
        if (this.isMutate(random)) {
            switch (this.mutateType) {
                case 2: {
                    result = this.mutateByUniform(random, val);
                    break;
                }
                default: {
                    result = this.mutateBySingle(random, val);
                }
            }
            this.setMutate(true);
        }
        return result;
    }

    protected double mutateBySingle(Random random, double val) {
        long longBits;
        double result = val;
        int maxBitIndex = this.getMaxBitIndex(this.maxValue, this.minValue);
        do {
            int index = random.nextInt(64 - maxBitIndex);
            long mask = 1L;
            if (index > 0) {
                mask <<= index;
            }
            if (((longBits = Double.doubleToLongBits(val)) & mask) == 0L) {
                longBits |= mask;
                continue;
            }
            longBits &= mask ^ 0xFFFFFFFFFFFFFFFFL;
        } while ((result = Double.longBitsToDouble(longBits)) > this.maxValue || result < this.minValue);
        return result;
    }

    protected double mutateByUniform(Random random, double val) {
        return this.randomValue(random);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeDouble(this.maxValue);
        out.writeDouble(this.minValue);
        out.writeFloat(this.randomRangeMargin);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.maxValue = in.readDouble();
        this.minValue = in.readDouble();
        this.randomRangeMargin = in.readFloat();
    }
}

