/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.ftp;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.ftp.ClusterFTPClientFactoryServiceMBean;
import jp.ossc.nimbus.service.ftp.FTPClient;
import jp.ossc.nimbus.service.ftp.FTPClientFactory;
import jp.ossc.nimbus.service.ftp.FTPException;

public class ClusterFTPClientFactoryService
extends ServiceBase
implements FTPClientFactory,
ClusterFTPClientFactoryServiceMBean {
    private static final long serialVersionUID = -8852749736373814643L;
    private ServiceName[] ftpClientFactoryServiceNames;
    private FTPClientFactory[] ftpClientFactories;
    private int clusterMode = 1;
    private String connectErrorMessageId = "CFTP_00001";
    private String skipMessageId = "CFTP_00002";

    @Override
    public void setFTPClientFactoryServiceNames(ServiceName[] names) {
        this.ftpClientFactoryServiceNames = names;
    }

    @Override
    public ServiceName[] getFTPClientFactoryServiceNames() {
        return this.ftpClientFactoryServiceNames;
    }

    @Override
    public void setClusterMode(int mode) throws IllegalArgumentException {
        switch (this.clusterMode) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown mode : " + mode);
            }
        }
        this.clusterMode = mode;
    }

    @Override
    public int getClusterMode() {
        return this.clusterMode;
    }

    @Override
    public void setConnectErrorMessageId(String id) {
        this.connectErrorMessageId = id;
    }

    @Override
    public String getConnectErrorMessageId() {
        return this.connectErrorMessageId;
    }

    @Override
    public void setSkipMessageId(String id) {
        this.skipMessageId = id;
    }

    @Override
    public String getSkipMessageId() {
        return this.skipMessageId;
    }

    @Override
    public void startService() throws Exception {
        if (this.ftpClientFactoryServiceNames == null || this.ftpClientFactoryServiceNames.length == 0) {
            throw new IllegalArgumentException("FTPClientFactoryServiceNames is null.");
        }
        this.ftpClientFactories = new FTPClientFactory[this.ftpClientFactoryServiceNames.length];
        for (int i = 0; i < this.ftpClientFactoryServiceNames.length; ++i) {
            this.ftpClientFactories[i] = (FTPClientFactory)ServiceManagerFactory.getServiceObject(this.ftpClientFactoryServiceNames[i]);
        }
    }

    @Override
    public FTPClient createFTPClient() throws FTPException {
        return new ClusterFTPClient(this.clusterMode);
    }

    private class ClusterFTPClient
    implements FTPClient {
        private final int clusterMode;
        private FTPClient client;
        private List clients;
        private List noConnectedClients;

        public ClusterFTPClient(int mode) throws FTPException {
            this.clusterMode = mode;
            block2 : switch (this.clusterMode) {
                case 1: {
                    int imax = ClusterFTPClientFactoryService.this.ftpClientFactories.length;
                    for (int i = 0; i < imax; ++i) {
                        try {
                            this.client = ClusterFTPClientFactoryService.this.ftpClientFactories[i].createFTPClient();
                            break block2;
                        }
                        catch (FTPException e) {
                            if (i == imax - 1) {
                                throw e;
                            }
                            if (ClusterFTPClientFactoryService.this.connectErrorMessageId == null) continue;
                            ClusterFTPClientFactoryService.this.getLogger().write(ClusterFTPClientFactoryService.this.connectErrorMessageId, ClusterFTPClientFactoryService.this.ftpClientFactories[i], (Throwable)e);
                            continue;
                        }
                    }
                    break;
                }
                case 2: {
                    this.clients = new ArrayList();
                    this.noConnectedClients = new ArrayList();
                    int imax = ClusterFTPClientFactoryService.this.ftpClientFactories.length;
                    for (int i = 0; i < imax; ++i) {
                        try {
                            this.clients.add(ClusterFTPClientFactoryService.this.ftpClientFactories[i].createFTPClient());
                            continue;
                        }
                        catch (FTPException e) {
                            ClusterFTPClientFactoryService.this.getLogger().write(ClusterFTPClientFactoryService.this.connectErrorMessageId, ClusterFTPClientFactoryService.this.ftpClientFactories[i], (Throwable)e);
                            this.noConnectedClients.add(ClusterFTPClientFactoryService.this.ftpClientFactories[i]);
                        }
                    }
                    if (this.clients.size() != 0) break;
                    throw new FTPException("I could not connect all the cluster members.");
                }
            }
        }

        @Override
        public void connect(String host) throws FTPException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void connect(String host, int port) throws FTPException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void connect(String host, int port, String localAddr, int localPort) throws FTPException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void login(String user, String password) throws FTPException {
            switch (this.clusterMode) {
                case 1: {
                    this.client.login(user, password);
                    break;
                }
                case 2: {
                    int imax = this.clients.size();
                    for (int i = 0; i < imax; ++i) {
                        FTPClient client = (FTPClient)this.clients.get(i);
                        client.login(user, password);
                    }
                    break;
                }
            }
        }

        @Override
        public void logout() throws FTPException {
            switch (this.clusterMode) {
                case 1: {
                    this.client.logout();
                    break;
                }
                case 2: {
                    FTPException ex = null;
                    int imax = this.clients.size();
                    for (int i = 0; i < imax; ++i) {
                        FTPClient client = (FTPClient)this.clients.get(i);
                        try {
                            client.logout();
                            continue;
                        }
                        catch (FTPException e) {
                            ex = e;
                        }
                    }
                    if (ex == null) break;
                    throw ex;
                }
            }
        }

        @Override
        public String[] ls() throws FTPException {
            switch (this.clusterMode) {
                case 1: {
                    return this.client.ls();
                }
            }
            int imax = this.clients.size();
            for (int i = 0; i < imax; ++i) {
                FTPClient client = (FTPClient)this.clients.get(i);
                try {
                    return client.ls();
                }
                catch (FTPException e) {
                    if (i != imax - 1) continue;
                    throw e;
                }
            }
            return null;
        }

        @Override
        public String[] ls(String path) throws FTPException {
            switch (this.clusterMode) {
                case 1: {
                    return this.client.ls(path);
                }
            }
            int imax = this.clients.size();
            for (int i = 0; i < imax; ++i) {
                FTPClient client = (FTPClient)this.clients.get(i);
                try {
                    return client.ls(path);
                }
                catch (FTPException e) {
                    if (i != imax - 1) continue;
                    throw e;
                }
            }
            return null;
        }

        @Override
        public String pwd() throws FTPException {
            switch (this.clusterMode) {
                case 1: {
                    return this.client.pwd();
                }
            }
            int imax = this.clients.size();
            for (int i = 0; i < imax; ++i) {
                FTPClient client = (FTPClient)this.clients.get(i);
                try {
                    return client.pwd();
                }
                catch (FTPException e) {
                    if (i != imax - 1) continue;
                    throw e;
                }
            }
            return null;
        }

        @Override
        public File lpwd() throws FTPException {
            switch (this.clusterMode) {
                case 1: {
                    return this.client.lpwd();
                }
            }
            return ((FTPClient)this.clients.get(0)).lpwd();
        }

        @Override
        public void cd(String path) throws FTPException {
            switch (this.clusterMode) {
                case 1: {
                    this.client.cd(path);
                    break;
                }
                case 2: {
                    FTPException ex = null;
                    int imax = this.clients.size();
                    for (int i = 0; i < imax; ++i) {
                        FTPClient client = (FTPClient)this.clients.get(i);
                        try {
                            client.cd(path);
                            continue;
                        }
                        catch (FTPException e) {
                            ex = e;
                        }
                    }
                    if (ex == null) break;
                    throw ex;
                }
            }
        }

        @Override
        public void lcd(String path) throws FTPException {
            switch (this.clusterMode) {
                case 1: {
                    this.client.lcd(path);
                    break;
                }
                case 2: {
                    FTPException ex = null;
                    int imax = this.clients.size();
                    for (int i = 0; i < imax; ++i) {
                        FTPClient client = (FTPClient)this.clients.get(i);
                        try {
                            client.lcd(path);
                            continue;
                        }
                        catch (FTPException e) {
                            ex = e;
                        }
                    }
                    if (ex == null) break;
                    throw ex;
                }
            }
        }

        @Override
        public void mkdir(String dir) throws FTPException {
            switch (this.clusterMode) {
                case 1: {
                    this.client.mkdir(dir);
                    break;
                }
                case 2: {
                    FTPException ex = null;
                    int imax = this.clients.size();
                    for (int i = 0; i < imax; ++i) {
                        FTPClient client = (FTPClient)this.clients.get(i);
                        try {
                            client.mkdir(dir);
                            continue;
                        }
                        catch (FTPException e) {
                            ex = e;
                        }
                    }
                    if (ex == null) break;
                    throw ex;
                }
            }
        }

        @Override
        public void rename(String from, String to) throws FTPException {
            switch (this.clusterMode) {
                case 1: {
                    this.client.rename(from, to);
                    break;
                }
                case 2: {
                    FTPException ex = null;
                    int imax = this.clients.size();
                    for (int i = 0; i < imax; ++i) {
                        FTPClient client = (FTPClient)this.clients.get(i);
                        try {
                            client.rename(from, to);
                            continue;
                        }
                        catch (FTPException e) {
                            ex = e;
                        }
                    }
                    if (ex == null) break;
                    throw ex;
                }
            }
        }

        @Override
        public File get(String path) throws FTPException {
            switch (this.clusterMode) {
                case 1: {
                    return this.client.get(path);
                }
            }
            int imax = this.clients.size();
            for (int i = 0; i < imax; ++i) {
                FTPClient client = (FTPClient)this.clients.get(i);
                try {
                    return client.get(path);
                }
                catch (FTPException e) {
                    if (i != imax - 1) continue;
                    throw e;
                }
            }
            return null;
        }

        @Override
        public File get(String remote, String local) throws FTPException {
            switch (this.clusterMode) {
                case 1: {
                    return this.client.get(remote, local);
                }
            }
            int imax = this.clients.size();
            for (int i = 0; i < imax; ++i) {
                FTPClient client = (FTPClient)this.clients.get(i);
                try {
                    return client.get(remote, local);
                }
                catch (FTPException e) {
                    if (i != imax - 1) continue;
                    throw e;
                }
            }
            return null;
        }

        @Override
        public File[] mget(String path) throws FTPException {
            switch (this.clusterMode) {
                case 1: {
                    return this.client.mget(path);
                }
            }
            int imax = this.clients.size();
            for (int i = 0; i < imax; ++i) {
                FTPClient client = (FTPClient)this.clients.get(i);
                try {
                    return client.mget(path);
                }
                catch (FTPException e) {
                    if (i != imax - 1) continue;
                    throw e;
                }
            }
            return null;
        }

        @Override
        public void put(String path) throws FTPException {
            switch (this.clusterMode) {
                case 1: {
                    this.client.put(path);
                    break;
                }
                case 2: {
                    FTPException ex = null;
                    boolean isSuccess = false;
                    int imax = this.clients.size();
                    for (int i = 0; i < imax; ++i) {
                        FTPClient client = (FTPClient)this.clients.get(i);
                        try {
                            client.put(path);
                            isSuccess = true;
                            continue;
                        }
                        catch (FTPException e) {
                            if (ClusterFTPClientFactoryService.this.skipMessageId != null) {
                                ClusterFTPClientFactoryService.this.getLogger().write(ClusterFTPClientFactoryService.this.skipMessageId, new Object[]{client, "put"}, (Throwable)e);
                            }
                            ex = e;
                        }
                    }
                    if (ClusterFTPClientFactoryService.this.skipMessageId != null && this.noConnectedClients.size() > 0) {
                        ClusterFTPClientFactoryService.this.getLogger().write(ClusterFTPClientFactoryService.this.skipMessageId, new Object[]{this.noConnectedClients, "put"});
                    }
                    if (isSuccess) break;
                    throw ex;
                }
            }
        }

        @Override
        public void put(String local, String remote) throws FTPException {
            switch (this.clusterMode) {
                case 1: {
                    this.client.put(local, remote);
                    break;
                }
                case 2: {
                    FTPException ex = null;
                    boolean isSuccess = false;
                    int imax = this.clients.size();
                    for (int i = 0; i < imax; ++i) {
                        FTPClient client = (FTPClient)this.clients.get(i);
                        try {
                            client.put(local, remote);
                            isSuccess = true;
                            continue;
                        }
                        catch (FTPException e) {
                            if (ClusterFTPClientFactoryService.this.skipMessageId != null) {
                                ClusterFTPClientFactoryService.this.getLogger().write(ClusterFTPClientFactoryService.this.skipMessageId, new Object[]{client, "put"}, (Throwable)e);
                            }
                            ex = e;
                        }
                    }
                    if (ClusterFTPClientFactoryService.this.skipMessageId != null && this.noConnectedClients.size() > 0) {
                        ClusterFTPClientFactoryService.this.getLogger().write(ClusterFTPClientFactoryService.this.skipMessageId, new Object[]{this.noConnectedClients, "put"});
                    }
                    if (isSuccess) break;
                    throw ex;
                }
            }
        }

        @Override
        public void mput(String path) throws FTPException {
            switch (this.clusterMode) {
                case 1: {
                    this.client.mput(path);
                    break;
                }
                case 2: {
                    FTPException ex = null;
                    boolean isSuccess = false;
                    int imax = this.clients.size();
                    for (int i = 0; i < imax; ++i) {
                        FTPClient client = (FTPClient)this.clients.get(i);
                        try {
                            client.mput(path);
                            isSuccess = true;
                            continue;
                        }
                        catch (FTPException e) {
                            if (ClusterFTPClientFactoryService.this.skipMessageId != null) {
                                ClusterFTPClientFactoryService.this.getLogger().write(ClusterFTPClientFactoryService.this.skipMessageId, new Object[]{client, "mput"}, (Throwable)e);
                            }
                            ex = e;
                        }
                    }
                    if (ClusterFTPClientFactoryService.this.skipMessageId != null && this.noConnectedClients.size() > 0) {
                        ClusterFTPClientFactoryService.this.getLogger().write(ClusterFTPClientFactoryService.this.skipMessageId, new Object[]{this.noConnectedClients, "mput"});
                    }
                    if (isSuccess) break;
                    throw ex;
                }
            }
        }

        @Override
        public void delete(String path) throws FTPException {
            switch (this.clusterMode) {
                case 1: {
                    this.client.delete(path);
                    break;
                }
                case 2: {
                    FTPException ex = null;
                    boolean isSuccess = false;
                    int imax = this.clients.size();
                    for (int i = 0; i < imax; ++i) {
                        FTPClient client = (FTPClient)this.clients.get(i);
                        try {
                            client.delete(path);
                            isSuccess = true;
                            continue;
                        }
                        catch (FTPException e) {
                            if (ClusterFTPClientFactoryService.this.skipMessageId != null) {
                                ClusterFTPClientFactoryService.this.getLogger().write(ClusterFTPClientFactoryService.this.skipMessageId, new Object[]{client, "delete"}, (Throwable)e);
                            }
                            ex = e;
                        }
                    }
                    if (ClusterFTPClientFactoryService.this.skipMessageId != null && this.noConnectedClients.size() > 0) {
                        ClusterFTPClientFactoryService.this.getLogger().write(ClusterFTPClientFactoryService.this.skipMessageId, new Object[]{this.noConnectedClients, "delete"});
                    }
                    if (isSuccess) break;
                    throw ex;
                }
            }
        }

        @Override
        public void mdelete(String path) throws FTPException {
            switch (this.clusterMode) {
                case 1: {
                    this.client.mdelete(path);
                    break;
                }
                case 2: {
                    FTPException ex = null;
                    boolean isSuccess = false;
                    int imax = this.clients.size();
                    for (int i = 0; i < imax; ++i) {
                        FTPClient client = (FTPClient)this.clients.get(i);
                        try {
                            client.mdelete(path);
                            isSuccess = true;
                            continue;
                        }
                        catch (FTPException e) {
                            if (ClusterFTPClientFactoryService.this.skipMessageId != null) {
                                ClusterFTPClientFactoryService.this.getLogger().write(ClusterFTPClientFactoryService.this.skipMessageId, new Object[]{client, "mdelete"}, (Throwable)e);
                            }
                            ex = e;
                        }
                    }
                    if (ClusterFTPClientFactoryService.this.skipMessageId != null && this.noConnectedClients.size() > 0) {
                        ClusterFTPClientFactoryService.this.getLogger().write(ClusterFTPClientFactoryService.this.skipMessageId, new Object[]{this.noConnectedClients, "mdelete"});
                    }
                    if (isSuccess) break;
                    throw ex;
                }
            }
        }

        @Override
        public void ascii() throws FTPException {
            switch (this.clusterMode) {
                case 1: {
                    this.client.ascii();
                    break;
                }
                case 2: {
                    int imax = this.clients.size();
                    for (int i = 0; i < imax; ++i) {
                        FTPClient client = (FTPClient)this.clients.get(i);
                        client.ascii();
                    }
                    break;
                }
            }
        }

        @Override
        public void binary() throws FTPException {
            switch (this.clusterMode) {
                case 1: {
                    this.client.binary();
                    break;
                }
                case 2: {
                    int imax = this.clients.size();
                    for (int i = 0; i < imax; ++i) {
                        FTPClient client = (FTPClient)this.clients.get(i);
                        client.binary();
                    }
                    break;
                }
            }
        }

        @Override
        public void setTransferType(int type) throws FTPException {
            switch (this.clusterMode) {
                case 1: {
                    this.client.setTransferType(type);
                    break;
                }
                case 2: {
                    int imax = this.clients.size();
                    for (int i = 0; i < imax; ++i) {
                        FTPClient client = (FTPClient)this.clients.get(i);
                        client.setTransferType(type);
                    }
                    break;
                }
            }
        }

        @Override
        public int getTransferType() throws FTPException {
            switch (this.clusterMode) {
                case 1: {
                    return this.client.getTransferType();
                }
            }
            return ((FTPClient)this.clients.get(0)).getTransferType();
        }

        @Override
        public void active() throws FTPException {
            switch (this.clusterMode) {
                case 1: {
                    this.client.active();
                    break;
                }
                case 2: {
                    int imax = this.clients.size();
                    for (int i = 0; i < imax; ++i) {
                        FTPClient client = (FTPClient)this.clients.get(i);
                        client.active();
                    }
                    break;
                }
            }
        }

        @Override
        public void passive() throws FTPException {
            switch (this.clusterMode) {
                case 1: {
                    this.client.passive();
                    break;
                }
                case 2: {
                    int imax = this.clients.size();
                    for (int i = 0; i < imax; ++i) {
                        FTPClient client = (FTPClient)this.clients.get(i);
                        client.passive();
                    }
                    break;
                }
            }
        }

        @Override
        public void close() throws FTPException {
            switch (this.clusterMode) {
                case 1: {
                    this.client.close();
                    break;
                }
                case 2: {
                    FTPException ex = null;
                    int imax = this.clients.size();
                    for (int i = 0; i < imax; ++i) {
                        FTPClient client = (FTPClient)this.clients.get(i);
                        try {
                            client.close();
                            continue;
                        }
                        catch (FTPException e) {
                            ex = e;
                        }
                    }
                    if (ex == null) break;
                    throw ex;
                }
            }
        }
    }
}

