/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.cui;

import java.io.File;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import jp.ossc.nimbus.beans.ServiceNameEditor;
import jp.ossc.nimbus.core.NimbusClassLoader;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.io.ExtentionFileFilter;
import jp.ossc.nimbus.lang.ServiceException;
import jp.ossc.nimbus.service.cui.AnyValueOkChecker;
import jp.ossc.nimbus.service.cui.Cui;
import jp.ossc.nimbus.service.cui.CuiFactory;
import jp.ossc.nimbus.service.cui.CuiFactoryServiceMBean;
import jp.ossc.nimbus.service.cui.CuiOperator;
import jp.ossc.nimbus.service.cui.CuiTagDefine;
import jp.ossc.nimbus.service.cui.DataInputStep;
import jp.ossc.nimbus.service.cui.DisplayConstructer;
import jp.ossc.nimbus.service.cui.InputChecker;
import jp.ossc.nimbus.service.cui.TextDisplay;
import jp.ossc.nimbus.service.cui.TextInputChecker;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CuiFactoryService
extends ServiceBase
implements CuiFactoryServiceMBean,
CuiTagDefine,
CuiFactory {
    private static final long serialVersionUID = -3162235897050844253L;
    private String mDefFileDir = null;
    private String mDefFileExt = null;
    private HashMap mCuiHash = null;
    private String mImplementClassName = null;

    @Override
    public void setImplementClassName(String name) {
        this.mImplementClassName = name;
    }

    @Override
    public String getImplementClassName() {
        return this.mImplementClassName;
    }

    @Override
    public void createService() {
        this.mCuiHash = new HashMap();
    }

    @Override
    public void startService() {
        File DefDir = new File(this.mDefFileDir);
        ExtentionFileFilter filter = new ExtentionFileFilter(this.mDefFileExt);
        File[] defFileList = DefDir.listFiles(filter);
        if (defFileList != null) {
            for (int rCnt = 0; rCnt < defFileList.length; ++rCnt) {
                this.parse(defFileList[rCnt]);
            }
        }
    }

    @Override
    public void stopService() {
    }

    @Override
    public void destroy() {
        this.mCuiHash = null;
    }

    @Override
    public Cui findInstance(String key) {
        return (Cui)this.mCuiHash.get(key);
    }

    @Override
    public void setDefFileDir(String dir) {
        this.mDefFileDir = dir;
    }

    @Override
    public void setDefFileExtention(String ext) {
        this.mDefFileExt = ext;
    }

    @Override
    public String getDefFileDir() {
        return this.mDefFileDir;
    }

    @Override
    public String getDefFileExtention() {
        return this.mDefFileExt;
    }

    public void parse(File xmlFile) {
        Element root = this.getRoot(xmlFile);
        NodeList dataInputList = root.getElementsByTagName("dataInput");
        for (int rCnt = 0; rCnt < dataInputList.getLength(); ++rCnt) {
            Element dataInputElement = (Element)dataInputList.item(rCnt);
            String key = dataInputElement.getAttribute("key");
            if (key.length() < 1) {
                throw new ServiceException("CUIFACTORY001", "attribute name is none. tag name is" + dataInputElement.getTagName());
            }
            CuiOperator cuiObj = this.createCuiOperator();
            NodeList steps = dataInputElement.getElementsByTagName("step");
            for (int rCount = 0; rCount < steps.getLength(); ++rCount) {
                Element stepElement = (Element)steps.item(rCount);
                String stepName = stepElement.getAttribute("name");
                if (stepName == null) {
                    throw new ServiceException("CUIFACTORY002", "Tag name is " + stepElement.getTagName());
                }
                DataInputStep dataInputStep = new DataInputStep(stepName);
                this.setDisplayObject(dataInputStep, stepElement);
                this.setInputChecker(dataInputStep, stepElement);
                this.setWhereToGoHash(dataInputStep, stepElement);
                NodeList ends = stepElement.getElementsByTagName("end");
                if (ends.getLength() > 1) {
                    throw new ServiceException("CUIFACTORY003", "end multi defined (in a step) errTag name is " + stepElement.getTagName());
                }
                if (ends.getLength() == 1) {
                    Element endElem = (Element)ends.item(0);
                    String type_att = endElem.getAttribute("type");
                    String endMsg = this.getValueIfSpecified(endElem);
                    if (type_att.equals("force")) {
                        dataInputStep.setNextStepName("Interrupt");
                    } else {
                        dataInputStep.setNextStepName("End");
                    }
                    dataInputStep.setEndMessage(endMsg);
                } else if (dataInputStep.getNextStepName() == null) {
                    if (rCount != steps.getLength() - 1) {
                        Element nextStepElem = (Element)steps.item(rCount + 1);
                        String name_att = nextStepElem.getAttribute("name");
                        dataInputStep.setNextStepName(name_att);
                    } else {
                        dataInputStep.setNextStepName("End");
                    }
                }
                cuiObj.addStep(stepName, dataInputStep);
            }
            this.mCuiHash.put(key, cuiObj);
        }
    }

    protected Element getRoot(File xmlFile) {
        Element root;
        try {
            DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = dbfactory.newDocumentBuilder();
            Document doc = builder.parse(xmlFile);
            root = doc.getDocumentElement();
        }
        catch (Exception e) {
            throw new ServiceException("CUIFACTORY021", "Fail to get Document Root", e);
        }
        return root;
    }

    protected void setDisplayObject(DataInputStep step, Element stepElem) {
        NodeList displays = stepElem.getElementsByTagName("display");
        for (int rCnt = 0; rCnt < displays.getLength(); ++rCnt) {
            Element display = (Element)displays.item(rCnt);
            String type = display.getAttribute("type");
            if (type.equals("service")) {
                String name = this.getValueMustSpecified(display);
                ServiceNameEditor edit = new ServiceNameEditor();
                edit.setAsText(name);
                ServiceName serviceName = (ServiceName)edit.getValue();
                DisplayConstructer displayObject = (DisplayConstructer)ServiceManagerFactory.getServiceObject(serviceName);
                if (displayObject == null) {
                    throw new ServiceException("CUIFACTORY022", "Service not found. servicename is " + name);
                }
                step.addDisplay(displayObject);
                continue;
            }
            TextDisplay textDisplay = new TextDisplay();
            textDisplay.setDisplayMenu(this.getValueIfSpecified(display));
            step.addDisplay(textDisplay);
        }
    }

    protected void setInputChecker(DataInputStep step, Element stepElem) {
        NodeList checkList = stepElem.getElementsByTagName("input");
        if (checkList.getLength() > 1) {
            throw new ServiceException("CUIFACTORY023", "input tag dupulicate define");
        }
        for (int rCnt = 0; rCnt < checkList.getLength(); ++rCnt) {
            Element inputElem = (Element)checkList.item(rCnt);
            String type = inputElem.getAttribute("type");
            InputChecker checker = null;
            if (type.equals("service")) {
                String name = this.getValueMustSpecified(inputElem);
                ServiceNameEditor edit = new ServiceNameEditor();
                edit.setAsText(name);
                ServiceName serviceName = (ServiceName)edit.getValue();
                checker = (InputChecker)ServiceManagerFactory.getServiceObject(serviceName);
                if (checker == null) {
                    throw new ServiceException("CUIFACTORY024", "Service not found. servicename is " + name);
                }
            } else {
                String inputDefStr = this.getValueMustSpecified(inputElem);
                checker = new TextInputChecker();
                checker.setValidInput(inputDefStr);
            }
            step.setChecker(checker);
        }
        if (step.getChecker() == null) {
            step.setChecker(new AnyValueOkChecker());
        }
    }

    protected void setWhereToGoHash(DataInputStep step, Element stepElem) {
        NodeList gotolist = stepElem.getElementsByTagName("goto");
        for (int rCnt = 0; rCnt < gotolist.getLength(); ++rCnt) {
            String distination;
            Element gotoElem = (Element)gotolist.item(rCnt);
            String value_att = gotoElem.getAttribute("value");
            if (value_att.length() < 1) {
                distination = this.getValueMustSpecified(gotoElem);
                step.setNextStepName(distination);
                continue;
            }
            distination = this.getValueMustSpecified(gotoElem);
            step.addWhereToGo(value_att, distination);
        }
    }

    protected String getValueMustSpecified(Element elem) {
        Node node = elem.getFirstChild();
        if (node == null) {
            throw new ServiceException("CUIFACTORY030", "must be specified value tag is " + elem.getTagName());
        }
        return node.getNodeValue();
    }

    protected String getValueIfSpecified(Element elem) {
        Node node = elem.getFirstChild();
        if (node == null) {
            return "";
        }
        return node.getNodeValue();
    }

    protected CuiOperator createCuiOperator() {
        CuiOperator cuiOperator = null;
        try {
            cuiOperator = (CuiOperator)Class.forName(this.mImplementClassName, true, NimbusClassLoader.getInstance()).newInstance();
        }
        catch (IllegalAccessException e) {
            throw new ServiceException("CUIFACTORY025", "IllegalAccess When creatCuiOperator() ", e);
        }
        catch (InstantiationException e) {
            throw new ServiceException("CUIFACTORY026", "Instanting failed", e);
        }
        catch (ClassNotFoundException e) {
            throw new ServiceException("CUIFACTORY027", "Class not found. name is " + this.mImplementClassName);
        }
        return cuiOperator;
    }
}

