/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.context;

import jp.ossc.nimbus.service.context.SharedContextException;

public class SharedContextTransactionException
extends SharedContextException {
    private static final long serialVersionUID = 3114683838194045542L;
    private static final String LABEL_STATE_BEGIN = "BEGIN";
    private static final String LABEL_STATE_COMMIT = "COMMIT";
    private static final String LABEL_STATE_ROLLBACK = "ROLLBACK";
    private static final String LABEL_STATE_COMMITTED = "COMMITTED";
    private static final String LABEL_STATE_ROLLBACKED = "ROLLBACKED";
    private static final String LABEL_STATE_ROLLBACK_FAILED = "ROLLBACK_FAILED";
    private static final String LABEL_STATE_UNKNOWN = "UNKNOWN";
    private int transactionState;

    public SharedContextTransactionException(int state) {
        super("state=" + SharedContextTransactionException.toStateLabel(state));
        this.transactionState = state;
    }

    public SharedContextTransactionException(String message, int state) {
        super(message + " : state=" + SharedContextTransactionException.toStateLabel(state));
        this.transactionState = state;
    }

    public SharedContextTransactionException(String message, Throwable cause, int state) {
        super(message + " : state=" + SharedContextTransactionException.toStateLabel(state), cause);
        this.transactionState = state;
    }

    public SharedContextTransactionException(Throwable cause, int state) {
        super("state=" + SharedContextTransactionException.toStateLabel(state), cause);
        this.transactionState = state;
    }

    public int getTransactionState() {
        return this.transactionState;
    }

    private static final String toStateLabel(int state) {
        switch (state) {
            case 1: {
                return LABEL_STATE_BEGIN;
            }
            case 2: {
                return LABEL_STATE_COMMIT;
            }
            case 3: {
                return LABEL_STATE_ROLLBACK;
            }
            case 5: {
                return LABEL_STATE_COMMITTED;
            }
            case 6: {
                return LABEL_STATE_ROLLBACKED;
            }
            case 7: {
                return LABEL_STATE_ROLLBACK_FAILED;
            }
        }
        return LABEL_STATE_UNKNOWN;
    }
}

