/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.cache;

import java.io.Serializable;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.daemon.Daemon;
import jp.ossc.nimbus.daemon.DaemonControl;
import jp.ossc.nimbus.daemon.DaemonRunnable;
import jp.ossc.nimbus.service.cache.Cache;
import jp.ossc.nimbus.service.cache.CacheChangeListener;
import jp.ossc.nimbus.service.cache.CacheMap;
import jp.ossc.nimbus.service.cache.CacheRemoveListener;
import jp.ossc.nimbus.service.cache.CachedReference;
import jp.ossc.nimbus.service.cache.DefaultCachedReference;
import jp.ossc.nimbus.service.cache.IllegalCachedReferenceException;
import jp.ossc.nimbus.service.cache.KeyCachedReference;
import jp.ossc.nimbus.service.cache.LinkedReference;
import jp.ossc.nimbus.service.cache.OverflowAction;
import jp.ossc.nimbus.service.cache.OverflowAlgorithm;
import jp.ossc.nimbus.service.cache.OverflowController;
import jp.ossc.nimbus.service.cache.OverflowValidator;
import jp.ossc.nimbus.service.cache.SoftReferenceOverflowActionServiceMBean;

public class SoftReferenceOverflowActionService
extends ServiceBase
implements OverflowAction,
LinkedReference,
CacheRemoveListener,
CacheChangeListener,
DaemonRunnable,
Serializable,
SoftReferenceOverflowActionServiceMBean {
    private static final long serialVersionUID = 6278424846147595060L;
    private static final String SROA_ = "SROA_";
    private static final String SROA_0 = "SROA_0";
    private static final String SROA_00 = "SROA_00";
    private static final String SROA_000 = "SROA_000";
    private static final String SROA_0000 = "SROA_0000";
    private static final String SROA_00001 = "SROA_00001";
    private static final String SROA_00002 = "SROA_00002";
    private ServiceName cacheServiceName;
    private Cache cache;
    private ServiceName cacheMapServiceName;
    private CacheMap cacheMap;
    private OverflowController controller;
    private Map references;
    private ReferenceQueue refQueue;
    protected Daemon daemon;

    @Override
    public void setPersistCacheServiceName(ServiceName name) {
        this.cacheServiceName = name;
    }

    @Override
    public ServiceName getPersistCacheServiceName() {
        return this.cacheServiceName;
    }

    @Override
    public void setPersistCacheMapServiceName(ServiceName name) {
        this.cacheMapServiceName = name;
    }

    @Override
    public ServiceName getPersistCacheMapServiceName() {
        return this.cacheMapServiceName;
    }

    public void setCache(Cache cache) {
        this.cache = cache;
    }

    public void setCacheMap(CacheMap cacheMap) {
        this.cacheMap = cacheMap;
    }

    @Override
    public void createService() throws Exception {
        this.references = Collections.synchronizedMap(new HashMap());
        this.refQueue = new ReferenceQueue();
        this.daemon = new Daemon(this);
        this.daemon.setName("Nimbus SoftReferenceOverflowActionDaemon " + this.getServiceNameObject());
    }

    @Override
    public void startService() throws Exception {
        if (this.cacheServiceName != null) {
            this.cache = (Cache)ServiceManagerFactory.getServiceObject(this.cacheServiceName);
        }
        if (this.cacheMapServiceName != null) {
            this.cacheMap = (CacheMap)ServiceManagerFactory.getServiceObject(this.cacheMapServiceName);
        }
        this.daemon.start();
    }

    @Override
    public void stopService() throws Exception {
        this.daemon.stop();
        this.cache = null;
        this.cacheMap = null;
    }

    @Override
    public void destroyService() throws Exception {
        this.references = null;
        this.refQueue = null;
        this.daemon = null;
    }

    @Override
    public void setOverflowController(OverflowController controller) {
        this.controller = controller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void action(OverflowValidator validator, OverflowAlgorithm algorithm, CachedReference ref) {
        if (ref == null || this.references == null) {
            return;
        }
        Map map = this.references;
        synchronized (map) {
            Object obj = ref.get(this, false);
            if (obj == null) {
                return;
            }
            CachedReference persistRef = null;
            if (ref instanceof KeyCachedReference && this.cacheMap != null) {
                KeyCachedReference keyRef = (KeyCachedReference)ref;
                Object key = keyRef.getKey();
                if (key != null && obj != null) {
                    this.cacheMap.put(key, obj);
                    persistRef = this.cacheMap.getCachedReference(key);
                }
            } else if (this.cache != null && obj != null) {
                persistRef = this.cache.add(obj);
            }
            try {
                SoftCachedReference newRef = new SoftCachedReference(obj, ref, persistRef, this.refQueue);
                this.references.put(ref, newRef);
                ref.addLinkedReference(this);
                ref.addCacheRemoveListener(this);
                ref.addCacheChangeListener(this);
                ref.set(this, null);
                if (validator != null) {
                    validator.remove(ref);
                }
                if (algorithm != null) {
                    algorithm.remove(ref);
                }
            }
            catch (IllegalCachedReferenceException e) {
                this.getLogger().write(SROA_00001, e);
                if (persistRef != null) {
                    persistRef.remove(this);
                }
                return;
            }
            if (persistRef != null && ref.isRemoved()) {
                persistRef.remove(this);
            }
        }
    }

    @Override
    public void reset() {
        if (this.references != null) {
            this.references.clear();
        }
    }

    @Override
    public int size() {
        return this.references == null ? 0 : this.references.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get(CachedReference ref) {
        if (ref == null || this.references == null) {
            return null;
        }
        Map map = this.references;
        synchronized (map) {
            CachedReference newRef = (CachedReference)this.references.get(ref);
            Object obj = null;
            if (newRef != null) {
                obj = newRef.get(this);
                try {
                    ref.set(this, obj);
                    newRef.remove(this);
                    this.references.remove(ref);
                    ref.removeLinkedReference(this);
                    ref.removeCacheRemoveListener(this);
                    ref.removeCacheChangeListener(this);
                    if (this.controller != null) {
                        this.controller.control(ref);
                    }
                }
                catch (IllegalCachedReferenceException e) {
                    this.getLogger().write(SROA_00002, obj, (Throwable)e);
                }
            }
            return obj;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removed(CachedReference ref) {
        if (this.references == null) {
            return;
        }
        Map map = this.references;
        synchronized (map) {
            if (this.references.containsKey(ref)) {
                CachedReference newRef = (CachedReference)this.references.remove(ref);
                newRef.remove(this);
                ref.removeLinkedReference(this);
                ref.removeCacheRemoveListener(this);
                ref.removeCacheChangeListener(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changed(CachedReference ref, Object obj) {
        if (this.references == null) {
            return;
        }
        Map map = this.references;
        synchronized (map) {
            if (this.references != null && this.references.containsKey(ref)) {
                CachedReference newRef = (CachedReference)this.references.remove(ref);
                newRef.remove(this);
                ref.removeLinkedReference(this);
                ref.removeCacheRemoveListener(this);
                ref.removeCacheChangeListener(this);
            }
        }
    }

    @Override
    public boolean onStart() {
        return true;
    }

    @Override
    public boolean onStop() {
        return true;
    }

    @Override
    public boolean onSuspend() {
        return true;
    }

    @Override
    public boolean onResume() {
        return true;
    }

    @Override
    public Object provide(DaemonControl ctrl) {
        if (this.refQueue == null) {
            return null;
        }
        try {
            return this.refQueue.remove();
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    @Override
    public void consume(Object dequeued, DaemonControl ctrl) {
        if (dequeued == null || this.controller == null) {
            return;
        }
        CachedSoftReference ref = (CachedSoftReference)dequeued;
        if (ref.getPersistCachedReference() == null) {
            ref.getSourceCachedReference().remove(this);
        }
        this.controller.control(null);
    }

    @Override
    public void garbage() {
    }

    protected static class CachedSoftReference
    extends SoftReference {
        protected CachedReference sourceRef;
        protected CachedReference persistRef;

        public CachedSoftReference(CachedReference source, CachedReference persist, Object obj, ReferenceQueue refQueue) {
            super(obj, refQueue);
            this.sourceRef = source;
            this.persistRef = persist;
        }

        public CachedReference getSourceCachedReference() {
            return this.sourceRef;
        }

        public CachedReference getPersistCachedReference() {
            return this.persistRef;
        }
    }

    protected static class SoftCachedReference
    extends DefaultCachedReference
    implements Serializable {
        private static final long serialVersionUID = -6567323403396424209L;
        protected CachedReference persistRef;

        public SoftCachedReference(Object obj, CachedReference source, CachedReference persist, ReferenceQueue refQueue) {
            super(new CachedSoftReference(source, persist, obj, refQueue));
            this.persistRef = persist;
        }

        @Override
        public Object get(Object source, boolean notify) {
            Object obj = ((SoftReference)this.cacheObj).get();
            if (obj == null && this.persistRef != null) {
                obj = this.persistRef.get(this, notify);
            }
            if (obj == null) {
                obj = this.getLinkedObject();
            }
            return obj;
        }

        @Override
        public void set(Object source, Object obj) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void remove(Object source) {
            super.remove(source);
            if (this.persistRef != null) {
                this.persistRef.remove(this);
                this.persistRef = null;
            }
        }
    }
}

